/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.monitor.profile;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.opensearch.sql.monitor.profile.DefaultMetricImpl;
import org.opensearch.sql.monitor.profile.MetricName;
import org.opensearch.sql.monitor.profile.ProfileContext;
import org.opensearch.sql.monitor.profile.ProfileMetric;
import org.opensearch.sql.monitor.profile.ProfilePlanNode;
import org.opensearch.sql.monitor.profile.ProfileUtils;
import org.opensearch.sql.monitor.profile.QueryProfile;

public class DefaultProfileContext
implements ProfileContext {
    private final long startNanos = System.nanoTime();
    private boolean finished;
    private final Map<MetricName, DefaultMetricImpl> metrics = new ConcurrentHashMap<MetricName, DefaultMetricImpl>();
    private ProfilePlanNode planRoot;
    private QueryProfile profile;

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public ProfileMetric getOrCreateMetric(MetricName name) {
        Objects.requireNonNull(name, "name");
        return this.metrics.computeIfAbsent(name, key -> new DefaultMetricImpl(key.name()));
    }

    @Override
    public synchronized void setPlanRoot(ProfilePlanNode planRoot) {
        if (this.planRoot == null) {
            this.planRoot = planRoot;
        }
    }

    @Override
    public synchronized QueryProfile finish() {
        if (this.finished) {
            return this.profile;
        }
        this.finished = true;
        long endNanos = System.nanoTime();
        LinkedHashMap<MetricName, Double> snapshot = new LinkedHashMap<MetricName, Double>(MetricName.values().length);
        for (MetricName metricName : MetricName.values()) {
            DefaultMetricImpl metric = this.metrics.get((Object)metricName);
            double millis = metric == null ? 0.0 : ProfileUtils.roundToMillis(metric.value());
            snapshot.put(metricName, millis);
        }
        double totalMillis = ProfileUtils.roundToMillis(endNanos - this.startNanos);
        QueryProfile.PlanNode planSnapshot = this.planRoot == null ? null : this.planRoot.snapshot();
        this.profile = new QueryProfile(totalMillis, snapshot, planSnapshot);
        return this.profile;
    }
}

