/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.model;

import java.util.Collection;
import java.util.Set;
import org.opensearch.timeseries.Name;

public enum ProfileName implements Name
{
    STATE("state"),
    ERROR("error"),
    COORDINATING_NODE("coordinating_node"),
    TOTAL_SIZE_IN_BYTES("total_size_in_bytes"),
    MODELS("models"),
    INIT_PROGRESS("init_progress"),
    TOTAL_ENTITIES("total_entities"),
    ACTIVE_ENTITIES("active_entities"),
    AD_TASK("ad_task"),
    FORECAST_TASK("forecast_task");

    private String name;

    private ProfileName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static ProfileName getName(String name) {
        switch (name) {
            case "state": {
                return STATE;
            }
            case "error": {
                return ERROR;
            }
            case "coordinating_node": {
                return COORDINATING_NODE;
            }
            case "total_size_in_bytes": {
                return TOTAL_SIZE_IN_BYTES;
            }
            case "models": {
                return MODELS;
            }
            case "init_progress": {
                return INIT_PROGRESS;
            }
            case "total_entities": {
                return TOTAL_ENTITIES;
            }
            case "active_entities": {
                return ACTIVE_ENTITIES;
            }
            case "ad_task": {
                return AD_TASK;
            }
            case "forecast_task": {
                return FORECAST_TASK;
            }
        }
        throw new IllegalArgumentException("Unsupported profile types");
    }

    public static Set<ProfileName> getNames(Collection<String> names) {
        return Name.getNameFromCollection(names, ProfileName::getName);
    }
}

