/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.action.status;

import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.replication.ReplicationException;
import org.opensearch.replication.action.status.ReplayDetails;
import org.opensearch.replication.action.status.ReplicationStatusResponse;
import org.opensearch.replication.action.status.RestoreDetails;
import org.opensearch.replication.action.status.ShardInfoRequest;
import org.opensearch.replication.action.status.ShardInfoResponse;
import org.opensearch.replication.action.status.ShardsInfoAction;
import org.opensearch.replication.metadata.ReplicationMetadataManager;
import org.opensearch.replication.metadata.store.ReplicationMetadata;
import org.opensearch.replication.util.CoroutinesKt;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000  2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0001 B1\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J&\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00022\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0003H\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001c\u001a\u00020\u001dX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006!"}, d2={"Lorg/opensearch/replication/action/status/TransportReplicationStatusAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/replication/action/status/ShardInfoRequest;", "Lorg/opensearch/replication/action/status/ReplicationStatusResponse;", "Lkotlinx/coroutines/CoroutineScope;", "transportService", "Lorg/opensearch/transport/TransportService;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "client", "Lorg/opensearch/transport/client/Client;", "replicationMetadataManager", "Lorg/opensearch/replication/metadata/ReplicationMetadataManager;", "<init>", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/threadpool/ThreadPool;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/transport/client/Client;Lorg/opensearch/replication/metadata/ReplicationMetadataManager;)V", "getThreadPool", "()Lorg/opensearch/threadpool/ThreadPool;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "listener", "Lorg/opensearch/core/action/ActionListener;", "populateAggregatedResponse", "followerResponse", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "Companion", "opensearch-cross-cluster-replication"})
@SourceDebugExtension(value={"SMAP\nTransportReplicationStatusAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportReplicationStatusAction.kt\norg/opensearch/replication/action/status/TransportReplicationStatusAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,157:1\n1869#2,2:158\n*S KotlinDebug\n*F\n+ 1 TransportReplicationStatusAction.kt\norg/opensearch/replication/action/status/TransportReplicationStatusAction\n*L\n127#1:158,2\n*E\n"})
public final class TransportReplicationStatusAction
extends HandledTransportAction<ShardInfoRequest, ReplicationStatusResponse>
implements CoroutineScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final /* synthetic */ GlobalScope $$delegate_0;
    @NotNull
    private final ThreadPool threadPool;
    @NotNull
    private final Client client;
    @NotNull
    private final ReplicationMetadataManager replicationMetadataManager;
    private static final Logger log = LogManager.getLogger(TransportReplicationStatusAction.class);

    @Inject
    public TransportReplicationStatusAction(@NotNull TransportService transportService, @NotNull ThreadPool threadPool, @NotNull ActionFilters actionFilters, @NotNull Client client, @NotNull ReplicationMetadataManager replicationMetadataManager) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)replicationMetadataManager, (String)"replicationMetadataManager");
        super("indices:admin/plugins/replication/index/status_check", transportService, actionFilters, ShardInfoRequest::new);
        this.$$delegate_0 = GlobalScope.INSTANCE;
        this.threadPool = threadPool;
        this.client = client;
        this.replicationMetadataManager = replicationMetadataManager;
    }

    @NotNull
    public final ThreadPool getThreadPool() {
        return this.threadPool;
    }

    protected void doExecute(@NotNull Task task, @NotNull ShardInfoRequest request, @NotNull ActionListener<ReplicationStatusResponse> listener2) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        BuildersKt.launch$default((CoroutineScope)this, (CoroutineContext)CoroutinesKt.coroutineContext(this.threadPool), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(listener2, this, request, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            Object L$7;
            Object L$8;
            int I$0;
            int I$1;
            int label;
            final /* synthetic */ ActionListener<ReplicationStatusResponse> $listener;
            final /* synthetic */ TransportReplicationStatusAction this$0;
            final /* synthetic */ ShardInfoRequest $request;
            {
                this.$listener = $listener;
                this.this$0 = $receiver;
                this.$request = $request;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var32_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var2_3 = this.$listener;
                        var3_4 = this.this$0;
                        var4_5 = this.$request;
                        $i$f$completeWith = 0;
                        var31_7 = $this$completeWith$iv;
                        $i$a$-completeWith-TransportReplicationStatusAction$doExecute$1$1 = 0;
                        this.L$0 = $this$completeWith$iv;
                        this.L$1 = var3_4;
                        this.L$2 = var4_5;
                        this.L$3 = var31_7;
                        this.I$0 = $i$f$completeWith;
                        this.I$1 = $i$a$-completeWith-TransportReplicationStatusAction$doExecute$1$1;
                        this.label = 1;
                        v0 = ReplicationMetadataManager.getIndexReplicationMetadata$default(TransportReplicationStatusAction.access$getReplicationMetadataManager$p(var3_4), var4_5.indices()[0], false, (Continuation)this, 2, null);
                        ** if (v0 != var32_2) goto lbl25
lbl24:
                        // 1 sources

                        return var32_2;
lbl25:
                        // 1 sources

                        ** GOTO lbl37
                    }
                    case 1: {
                        $i$a$-completeWith-TransportReplicationStatusAction$doExecute$1$1 = this.I$1;
                        $i$f$completeWith = this.I$0;
                        var31_7 = (ActionListener)this.L$3;
                        var4_5 = (ShardInfoRequest)this.L$2;
                        var3_4 = (TransportReplicationStatusAction)this.L$1;
                        $this$completeWith$iv = (ActionListener)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl37:
                        // 2 sources

                        status = ((var8_10 = (CharSequence)(metadata = (ReplicationMetadata)v0).getOverallState()) == null || var8_10.length() == 0) != false ? "STOPPED" : metadata.getOverallState();
                        reason = metadata.getReason();
                        if (status.equals("RUNNING")) ** GOTO lbl48
                        replicationStatusResponse = new ReplicationStatusResponse(status);
                        replicationStatusResponse.setConnectionAlias(metadata.getConnectionName());
                        replicationStatusResponse.setFollowerIndexName(metadata.getFollowerContext().getResource());
                        replicationStatusResponse.setLeaderIndexName(metadata.getLeaderContext().getResource());
                        replicationStatusResponse.setStatus(status);
                        replicationStatusResponse.setReason(reason);
                        v1 = replicationStatusResponse;
                        ** GOTO lbl169
lbl48:
                        // 1 sources

                        var11_16 = followerResponse = new Ref.ObjectRef();
                        this.L$0 = $this$completeWith$iv;
                        this.L$1 = var3_4;
                        this.L$2 = var4_5;
                        this.L$3 = metadata;
                        this.L$4 = reason;
                        this.L$5 = status;
                        this.L$6 = followerResponse;
                        this.L$7 = var11_16;
                        this.L$8 = var31_7;
                        this.I$0 = $i$f$completeWith;
                        this.I$1 = $i$a$-completeWith-TransportReplicationStatusAction$doExecute$1$1;
                        this.label = 2;
                        v2 = CoroutinesKt.suspendExecute$default((OpenSearchClient)TransportReplicationStatusAction.access$getClient$p(var3_4), ShardsInfoAction.Companion.getINSTANCE(), (ActionRequest)new ShardInfoRequest(metadata.getFollowerContext().getResource()), true, false, (Continuation)this, 8, null);
                        ** if (v2 != var32_2) goto lbl64
lbl63:
                        // 1 sources

                        return var32_2;
lbl64:
                        // 1 sources

                        ** GOTO lbl81
                    }
                    case 2: {
                        $i$a$-completeWith-TransportReplicationStatusAction$doExecute$1$1 = this.I$1;
                        $i$f$completeWith = this.I$0;
                        var31_7 = (ActionListener)this.L$8;
                        var11_16 = (Ref.ObjectRef)this.L$7;
                        followerResponse = (Ref.ObjectRef)this.L$6;
                        status = (String)this.L$5;
                        reason = (String)this.L$4;
                        metadata = (ReplicationMetadata)this.L$3;
                        var4_5 = (ShardInfoRequest)this.L$2;
                        var3_4 = (TransportReplicationStatusAction)this.L$1;
                        $this$completeWith$iv = (ActionListener)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl81:
                        // 2 sources

                        var11_16.element = v2;
                        remoteClient = TransportReplicationStatusAction.access$getClient$p(var3_4).getRemoteClusterClient(metadata.getConnectionName());
                        Intrinsics.checkNotNull((Object)remoteClient);
                        this.L$0 = $this$completeWith$iv;
                        this.L$1 = var3_4;
                        this.L$2 = var4_5;
                        this.L$3 = metadata;
                        this.L$4 = reason;
                        this.L$5 = status;
                        this.L$6 = followerResponse;
                        this.L$7 = SpillingKt.nullOutSpilledVariable((Object)remoteClient);
                        this.L$8 = var31_7;
                        this.I$0 = $i$f$completeWith;
                        this.I$1 = $i$a$-completeWith-TransportReplicationStatusAction$doExecute$1$1;
                        this.label = 3;
                        v3 = CoroutinesKt.suspendExecute$default((OpenSearchClient)remoteClient, ShardsInfoAction.Companion.getINSTANCE(), (ActionRequest)new ShardInfoRequest(metadata.getLeaderContext().getResource()), true, false, (Continuation)this, 8, null);
                        ** if (v3 != var32_2) goto lbl99
lbl98:
                        // 1 sources

                        return var32_2;
lbl99:
                        // 1 sources

                        ** GOTO lbl117
                    }
                    case 3: {
                        $i$a$-completeWith-TransportReplicationStatusAction$doExecute$1$1 = this.I$1;
                        $i$f$completeWith = this.I$0;
                        var31_7 = (ActionListener)this.L$8;
                        remoteClient = (Client)this.L$7;
                        followerResponse = (Ref.ObjectRef)this.L$6;
                        status = (String)this.L$5;
                        reason = (String)this.L$4;
                        metadata = (ReplicationMetadata)this.L$3;
                        var4_5 = (ShardInfoRequest)this.L$2;
                        var3_4 = (TransportReplicationStatusAction)this.L$1;
                        $this$completeWith$iv = (ActionListener)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl117:
                            // 2 sources

                            leaderResponse = (ReplicationStatusResponse)v3;
                            if (((ReplicationStatusResponse)followerResponse.element).getShardInfoResponse().size() > 0) {
                                status = ((ReplicationStatusResponse)followerResponse.element).getShardInfoResponse().get(0).getStatus();
                            }
                            if (!status.equals("BOOTSTRAPPING")) {
                                shardResponses = null;
                                shardResponses = ((ReplicationStatusResponse)followerResponse.element).getShardInfoResponse();
                                $this$forEach$iv = leaderResponse.getShardInfoResponse().listIterator();
                                $i$f$forEach = false;
                                var17_22 = $this$forEach$iv;
                                while (var17_22.hasNext()) {
                                    element$iv = var17_22.next();
                                    it = (ShardInfoResponse)element$iv;
                                    $i$a$-forEach-TransportReplicationStatusAction$doExecute$1$1$1 = false;
                                    Intrinsics.checkNotNullExpressionValue((Object)it.getShardId().toString(), (String)"toString(...)");
                                    if (!it.isReplayDetailsInitialized()) continue;
                                    remoteCheckPoint = it.getReplayDetails().getRemoteCheckpoint();
                                    $this$forEach$iv = shardResponses.listIterator();
                                    $i$f$forEach = false;
                                    var26_30 = $this$forEach$iv;
                                    while (var26_30.hasNext()) {
                                        element$iv = var26_30.next();
                                        it = (ShardInfoResponse)element$iv;
                                        $i$a$-forEach-TransportReplicationStatusAction$doExecute$1$1$1$1 = false;
                                        if (!it.isReplayDetailsInitialized()) continue;
                                        v4 = it.getShardId().toString();
                                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"toString(...)");
                                        if (!leaderShardName.equals(StringsKt.replace$default((String)v4, (String)metadata.getFollowerContext().getResource(), (String)metadata.getLeaderContext().getResource(), (boolean)false, (int)4, null))) continue;
                                        it.getReplayDetails().setRemoteCheckpoint(remoteCheckPoint);
                                    }
                                    ((ReplicationStatusResponse)followerResponse.element).setShardInfoResponse(shardResponses);
                                }
                            }
                            ((ReplicationStatusResponse)followerResponse.element).setConnectionAlias(metadata.getConnectionName());
                            ((ReplicationStatusResponse)followerResponse.element).setFollowerIndexName(metadata.getFollowerContext().getResource());
                            ((ReplicationStatusResponse)followerResponse.element).setLeaderIndexName(metadata.getLeaderContext().getResource());
                            ((ReplicationStatusResponse)followerResponse.element).setStatus(status);
                            ((ReplicationStatusResponse)followerResponse.element).setReason(reason);
                            TransportReplicationStatusAction.access$populateAggregatedResponse(var3_4, (ReplicationStatusResponse)followerResponse.element);
                            if (!var4_5.getVerbose()) {
                                ((ReplicationStatusResponse)followerResponse.element).setVerbose(false);
                            }
                            var7_9 = (ReplicationStatusResponse)followerResponse.element;
                            {
                                catch (ResourceNotFoundException e) {
                                    TransportReplicationStatusAction.access$getLog$cp().error("got ResourceNotFoundException while querying for status ", (Throwable)e);
                                    var7_9 = new ReplicationStatusResponse("REPLICATION NOT IN PROGRESS");
                                    ** GOTO lbl167
                                }
                                catch (Exception e) {
                                    TransportReplicationStatusAction.access$getLog$cp().error("got Exception while querying for status ", (Throwable)e);
                                    throw new ReplicationException("failed to fetch replication status", new Object[0]);
                                }
                            }
lbl167:
                            // 2 sources

                            v1 = var7_9;
lbl169:
                            // 2 sources

                            var31_7.onResponse((Object)v1);
                        }
                        catch (Exception e$iv) {
                            $this$completeWith$iv.onFailure(e$iv);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void populateAggregatedResponse(ReplicationStatusResponse followerResponse) {
        long aggregatedRemoteCheckpoint = 0L;
        long aggregatedLocalCheckpoint = 0L;
        long aggregatedSeqNo = 0L;
        boolean anyShardInReplay = false;
        boolean anyShardInRestore = false;
        long aggregateTotalBytes = 0L;
        long aggregateRecoveredBytes = 0L;
        float aggregateRecovereyPercentage = 0.0f;
        int aggregateTotalFiles = 0;
        int aggregateRecoveredFiles = 0;
        float aggregateFileRecovereyPercentage = 0.0f;
        long startTime = 0L;
        startTime = Long.MAX_VALUE;
        long time = 0L;
        int numberOfShardsiInRestore = 0;
        Iterable $this$forEach$iv = followerResponse.getShardInfoResponse();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShardInfoResponse it = (ShardInfoResponse)((Object)element$iv);
            boolean bl = false;
            if (it.isReplayDetailsInitialized()) {
                aggregatedRemoteCheckpoint += it.getReplayDetails().remoteCheckpoint();
                aggregatedLocalCheckpoint += it.getReplayDetails().localCheckpoint();
                aggregatedSeqNo += it.getReplayDetails().seqNo();
                anyShardInReplay = true;
            }
            if (!it.isRestoreDetailsInitialized()) continue;
            anyShardInRestore = true;
            aggregateTotalBytes += it.getRestoreDetails().getTotalBytes();
            aggregateRecoveredBytes += it.getRestoreDetails().getRecoveredBytes();
            aggregateRecovereyPercentage = ((float)numberOfShardsiInRestore * aggregateRecovereyPercentage + it.getRestoreDetails().getRecovereyPercentage()) / (float)(numberOfShardsiInRestore + 1);
            aggregateFileRecovereyPercentage = ((float)numberOfShardsiInRestore * aggregateFileRecovereyPercentage + it.getRestoreDetails().getFileRecovereyPercentage()) / (float)(numberOfShardsiInRestore + 1);
            ++numberOfShardsiInRestore;
            aggregateTotalFiles += it.getRestoreDetails().getTotalFiles();
            aggregateRecoveredFiles += it.getRestoreDetails().getRecoveredFiles();
            startTime = Math.min(startTime, it.getRestoreDetails().getStartTime());
            time = Math.max(time, it.getRestoreDetails().getTime());
        }
        if (anyShardInReplay) {
            followerResponse.setAggregatedReplayDetails(new ReplayDetails(aggregatedRemoteCheckpoint, aggregatedLocalCheckpoint, aggregatedSeqNo));
        }
        if (anyShardInRestore) {
            followerResponse.setAggregatedRestoreDetails(new RestoreDetails(aggregateTotalBytes, aggregateRecoveredBytes, aggregateRecovereyPercentage, aggregateTotalFiles, aggregateRecoveredFiles, aggregateFileRecovereyPercentage, startTime, time));
        }
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.$$delegate_0.getCoroutineContext();
    }

    public static final /* synthetic */ ReplicationMetadataManager access$getReplicationMetadataManager$p(TransportReplicationStatusAction $this) {
        return $this.replicationMetadataManager;
    }

    public static final /* synthetic */ Client access$getClient$p(TransportReplicationStatusAction $this) {
        return $this.client;
    }

    public static final /* synthetic */ void access$populateAggregatedResponse(TransportReplicationStatusAction $this, ReplicationStatusResponse followerResponse) {
        $this.populateAggregatedResponse(followerResponse);
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/opensearch/replication/action/status/TransportReplicationStatusAction$Companion;", "", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

