/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeTrunkInterfaceAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTrunkInterfaceAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.TrunkInterfaceAssociation;

public class DescribeTrunkInterfaceAssociationsPublisher
implements SdkPublisher<DescribeTrunkInterfaceAssociationsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeTrunkInterfaceAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeTrunkInterfaceAssociationsPublisher(Ec2AsyncClient client, DescribeTrunkInterfaceAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeTrunkInterfaceAssociationsPublisher(Ec2AsyncClient client, DescribeTrunkInterfaceAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeTrunkInterfaceAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeTrunkInterfaceAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TrunkInterfaceAssociation> interfaceAssociations() {
        Function<DescribeTrunkInterfaceAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.interfaceAssociations() != null) {
                return response.interfaceAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeTrunkInterfaceAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeTrunkInterfaceAssociationsResponseFetcher
    implements AsyncPageFetcher<DescribeTrunkInterfaceAssociationsResponse> {
        private DescribeTrunkInterfaceAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTrunkInterfaceAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeTrunkInterfaceAssociationsResponse> nextPage(DescribeTrunkInterfaceAssociationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTrunkInterfaceAssociationsPublisher.this.client.describeTrunkInterfaceAssociations(DescribeTrunkInterfaceAssociationsPublisher.this.firstRequest);
            }
            return DescribeTrunkInterfaceAssociationsPublisher.this.client.describeTrunkInterfaceAssociations((DescribeTrunkInterfaceAssociationsRequest)((Object)DescribeTrunkInterfaceAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

