/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.tools;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.text.StringSubstitutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.cluster.storedscripts.GetStoredScriptRequest;
import org.opensearch.action.admin.indices.get.GetIndexRequest;
import org.opensearch.action.admin.indices.get.GetIndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.clustermanager.ClusterManagerNodeRequest;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.ml.common.spi.tools.Parser;
import org.opensearch.ml.common.spi.tools.ToolAnnotation;
import org.opensearch.ml.common.spi.tools.WithModelTool;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.common.utils.ToolUtils;
import org.opensearch.ml.engine.algorithms.agent.AgentUtils;
import org.opensearch.ml.engine.processor.ProcessorChain;
import org.opensearch.ml.engine.tools.MLModelTool;
import org.opensearch.ml.engine.tools.parser.ToolParser;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.transport.client.Client;

@ToolAnnotation(value="QueryPlanningTool")
public class QueryPlanningTool
implements WithModelTool {
    @Generated
    private static final Logger log = LogManager.getLogger(QueryPlanningTool.class);
    public static final String TYPE = "QueryPlanningTool";
    public static final String MODEL_ID_FIELD = "model_id";
    private final MLModelTool queryGenerationTool;
    public static final String SYSTEM_PROMPT_FIELD = "system_prompt";
    public static final String USER_PROMPT_FIELD = "user_prompt";
    public static final String QUERY_PLANNER_SYSTEM_PROMPT_FIELD = "query_planner_system_prompt";
    public static final String QUERY_PLANNER_USER_PROMPT_FIELD = "query_planner_user_prompt";
    public static final String TEMPLATE_SELECTION_SYSTEM_PROMPT_FIELD = "template_selection_system_prompt";
    public static final String TEMPLATE_SELECTION_USER_PROMPT_FIELD = "template_selection_user_prompt";
    public static final String INDEX_MAPPING_FIELD = "index_mapping";
    public static final String QUERY_FIELDS_FIELD = "query_fields";
    public static final String GENERATION_TYPE_FIELD = "generation_type";
    public static final String LLM_GENERATED_TYPE_FIELD = "llmGenerated";
    public static final String USER_SEARCH_TEMPLATES_TYPE_FIELD = "user_templates";
    public static final String SEARCH_TEMPLATES_FIELD = "search_templates";
    public static final String SAMPLE_DOCUMENT_FIELD = "sample_document";
    private static final String CURRENT_TIME_FIELD = "current_time";
    public static final String TEMPLATE_FIELD = "template";
    public static final String STRICT_FIELD = "strict";
    public static final String QUESTION_FIELD = "question";
    private static final String TEMPLATE_ID_FIELD = "template_id";
    private static final String TEMPLATE_DESCRIPTION_FIELD = "template_description";
    public static final String INDEX_NAME_FIELD = "index_name";
    private static final int MAX_TRUNCATE_CHARS = 250;
    private static final String TRUNC_PREFIX = "[truncated]";
    private static final String CHAT_HISTORY_FIELD = "_chat_history";
    private static final String TOOLS_FIELD = "_tools";
    private static final String INTERACTIONS_FIELD = "_interactions";
    private static final String TOOL_CONFIGS_FIELD = "tool_configs";
    private static final Set<String> AGENT_CONTEXT_EXCLUDED_PARAMS = Set.of("_chat_history", "_tools", "_interactions", "tool_configs");
    private final String generationType;
    private final String searchTemplates;
    private String name = "QueryPlanningTool";
    private Map<String, Object> attributes;
    static String DEFAULT_DESCRIPTION = "Use this tool to generate OpenSearch Query DSL from natural language queries.Provide a 'question' parameter containing the complete natural language query with all necessary context, requirements, filters, and constraints.The question should be self-contained with all information needed to generate the OpenSearch DSL.Provide 'index_name' to help generate more accurate queries based on the index structure.Optionally provide embedding model ID to be used for neural search The tool will return a valid OpenSearch query that can be used to search your data.";
    public static final String DEFAULT_INPUT_SCHEMA = "{\"type\":\"object\",\"properties\":{\"question\":{\"type\":\"string\",\"description\":\"Complete natural language query with all necessary context to generate OpenSearch DSL. Include the question, any specific requirements, filters, or constraints. Examples: 'Find all products with price greater than 100 dollars', 'Show me documents about machine learning published in 2023', 'Search for users with status active and age between 25 and 35'\"},\"index_name\":{\"type\":\"string\",\"description\":\"the name of the index against which the query needs to be generated.\"},\"embedding_model_id\":{\"type\":\"string\",\"description\":\"the model id to perform neural search.\"}},\"required\":[\"question\", \"index_name\"],\"additionalProperties\":false}";
    public static final Map<String, Object> DEFAULT_ATTRIBUTES = Map.of("input_schema", "{\"type\":\"object\",\"properties\":{\"question\":{\"type\":\"string\",\"description\":\"Complete natural language query with all necessary context to generate OpenSearch DSL. Include the question, any specific requirements, filters, or constraints. Examples: 'Find all products with price greater than 100 dollars', 'Show me documents about machine learning published in 2023', 'Search for users with status active and age between 25 and 35'\"},\"index_name\":{\"type\":\"string\",\"description\":\"the name of the index against which the query needs to be generated.\"},\"embedding_model_id\":{\"type\":\"string\",\"description\":\"the model id to perform neural search.\"}},\"required\":[\"question\", \"index_name\"],\"additionalProperties\":false}", "strict", false);
    private String description = DEFAULT_DESCRIPTION;
    private final Client client;
    private Parser outputParser;

    public QueryPlanningTool(String generationType, MLModelTool queryGenerationTool, Client client, String searchTemplates) {
        this.generationType = generationType;
        this.queryGenerationTool = queryGenerationTool;
        this.client = client;
        this.searchTemplates = searchTemplates;
        this.attributes = new HashMap<String, Object>(DEFAULT_ATTRIBUTES);
    }

    private Map<String, String> stripAgentContextParameters(Map<String, String> originalParameters) {
        return originalParameters.entrySet().stream().filter(entry -> entry.getValue() != null && !AGENT_CONTEXT_EXCLUDED_PARAMS.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public <T> void run(Map<String, String> originalParameters, ActionListener<T> listener) {
        try {
            Map<String, String> parameters = this.stripAgentContextParameters(ToolUtils.extractInputParameters(originalParameters, this.attributes));
            if (!this.validate(parameters)) {
                listener.onFailure((Exception)new IllegalArgumentException(String.format("Validation error: missing or empty required parameters \u2014 %s, %s.", INDEX_NAME_FIELD, QUESTION_FIELD)));
                return;
            }
            if (!this.generationType.equals(USER_SEARCH_TEMPLATES_TYPE_FIELD)) {
                parameters.put(TEMPLATE_FIELD, "{\"from\": {{from}}{{^from}}0{{/from}},\"size\": {{size}}{{^size}}10{{/size}},\n\"query\": {  \"bool\": {    \"should\": [      {        \"multi_match\": {          \"query\": \"{{lex_query}}\",          \"fields\": {{#lex_fields}}{{{lex_fields}}}{{/lex_fields}}{{^lex_fields}}[\"*^1.0\"]{{/lex_fields}},          \"type\": \"{{#lex_type}}{{lex_type}}{{/lex_type}}{{^lex_type}}best_fields{{/lex_type}}\",          \"operator\": \"{{#lex_operator}}{{lex_operator}}{{/lex_operator}}{{^lex_operator}}or{{/lex_operator}}\",          \"boost\": {{#lex_boost}}{{lex_boost}}{{/lex_boost}}{{^lex_boost}}1.0{{/lex_boost}}        }      }{{#sem_enabled}},      {        \"neural\": {          \"{{sem_field}}\": {            \"query_text\": \"{{sem_query_text}}\",            \"model_id\": \"{{sem_model_id}}\",            \"k\": {{#sem_k}}{{sem_k}}{{/sem_k}}{{^sem_k}}150{{/sem_k}},            \"boost\": {{#sem_boost}}{{sem_boost}}{{/sem_boost}}{{^sem_boost}}1.5{{/sem_boost}}          }        }      }{{/sem_enabled}}    ],    \"filter\": {{#filters}}{{{filters}}}{{/filters}}{{^filters}}[]{{/filters}},    \"minimum_should_match\": 1  }},\n\"sort\": {{#sort}}{{{sort}}}{{/sort}}{{^sort}}[{ \"_score\": { \"order\": \"desc\" } }]{{/sort}},\n\"track_total_hits\": {{#track_total_hits}}{{track_total_hits}}{{/track_total_hits}}{{^track_total_hits}}false{{/track_total_hits}}}");
                this.executeQueryPlanning(parameters, listener);
                return;
            }
            HashMap<String, String> templateSelectionParameters = new HashMap<String, String>(parameters);
            templateSelectionParameters.put(SYSTEM_PROMPT_FIELD, templateSelectionParameters.getOrDefault(TEMPLATE_SELECTION_SYSTEM_PROMPT_FIELD, "==== PURPOSE ====\nYou are an OpenSearch Search Template selector. Given a natural language question, a list of search template IDs and search template descriptions, choose the search template ID which is most related to the given question.\n\n==== GOAL ====\nGiven:\n1) A natural-language question from the user.\n2) A catalog of OpenSearch templates, each with:\n    - id (string, case-sensitive)\n    - description (1\u20133 sentences)\nReturn: the SINGLE id of the best-matching template.\n==== OUTPUT RULES ====\n- Output ONLY the template id.\n- No quotes, no backticks, no punctuation, no prefix/suffix, no extra words.\n- No spaces or newlines before/after. Output must be exactly one of the provided ids.\n- Do not ask questions or explain.\n- Think internally; do NOT reveal your reasoning.\n==== SELECTION CRITERIA ====\n(apply in order)\n1) INTENT MATCH: Identify the user\u2019s primary intent (e.g., product search/browse, analytical reporting, trend/sales analysis, inventory, support lookup). Prefer templates whose descriptions explicitly support that intent.\n2) SIGNAL ALIGNMENT: Count strong lexical/semantic matches between the question and each template\u2019s description/placeholders.\n   - Attribute filters (brand, category, size, color, price, rating, etc.) \u2192 favor product/item search templates.\n   - Metrics (sales value, revenue, units sold, conversion, time windows) \u2192 favor analytics/aggregation templates.\n   - Temporal phrases (\u201clast week\u201d, \u201cby month\u201d, \u201ctrending\u201d, \u201ctop sellers\u201d) \u2192 favor templates with date/time and aggregations.\n   - Opinion/quality words (\u201chighly rated\u201d, \u201cbest\u201d, \u201ctop reviewed\u201d) \u2192 favor templates with rating/review placeholders.\n3) SPECIFICITY: If multiple templates match, prefer the one whose description/placeholders are the most specific to the question\u2019s entities and constraints.\n4) TIE-BREAK:\n   - Prefer templates intended for the user\u2019s domain (e.g., \u201cproducts\u201d vs \u201csales analytics\u201d).\n   - Prefer general-purpose search over analytics if the question asks to \u201cfind/search/browse\u201d items; prefer analytics if it asks for \u201cmost sold/revenue/total/average\u201d.\n==== VALIDATION ====\n- Your output MUST be exactly one of the provided template ids (regex: ^[A-Za-z0-9_-]+$).\n- If no perfect match exists, pick the closest by the criteria above. Never output \u201cnone\u201d or invent an id.\n==== EXAMPLES ====\nExample A: \nquestion: 'what shoes are highly rated'\nsearch_templates :\n[\n{'template_id':'product-search-template','template_description':'Searches products in an e-commerce store.'},\n{'template_id':'sales-value-analysis-template','template_description':'Aggregates sales value for top-selling products.'}\n]\nExample output : 'product-search-template'"));
            templateSelectionParameters.put(USER_PROMPT_FIELD, templateSelectionParameters.getOrDefault(TEMPLATE_SELECTION_USER_PROMPT_FIELD, "==== INPUTS ====\nquestion: ${parameters.question}\nsearch_templates: ${parameters.search_templates}"));
            templateSelectionParameters.put(SEARCH_TEMPLATES_FIELD, this.searchTemplates);
            ActionListener templateSelectionListener = ActionListener.wrap(r -> {
                parameters.put(TEMPLATE_FIELD, "{\"from\": {{from}}{{^from}}0{{/from}},\"size\": {{size}}{{^size}}10{{/size}},\n\"query\": {  \"bool\": {    \"should\": [      {        \"multi_match\": {          \"query\": \"{{lex_query}}\",          \"fields\": {{#lex_fields}}{{{lex_fields}}}{{/lex_fields}}{{^lex_fields}}[\"*^1.0\"]{{/lex_fields}},          \"type\": \"{{#lex_type}}{{lex_type}}{{/lex_type}}{{^lex_type}}best_fields{{/lex_type}}\",          \"operator\": \"{{#lex_operator}}{{lex_operator}}{{/lex_operator}}{{^lex_operator}}or{{/lex_operator}}\",          \"boost\": {{#lex_boost}}{{lex_boost}}{{/lex_boost}}{{^lex_boost}}1.0{{/lex_boost}}        }      }{{#sem_enabled}},      {        \"neural\": {          \"{{sem_field}}\": {            \"query_text\": \"{{sem_query_text}}\",            \"model_id\": \"{{sem_model_id}}\",            \"k\": {{#sem_k}}{{sem_k}}{{/sem_k}}{{^sem_k}}150{{/sem_k}},            \"boost\": {{#sem_boost}}{{sem_boost}}{{/sem_boost}}{{^sem_boost}}1.5{{/sem_boost}}          }        }      }{{/sem_enabled}}    ],    \"filter\": {{#filters}}{{{filters}}}{{/filters}}{{^filters}}[]{{/filters}},    \"minimum_should_match\": 1  }},\n\"sort\": {{#sort}}{{{sort}}}{{/sort}}{{^sort}}[{ \"_score\": { \"order\": \"desc\" } }]{{/sort}},\n\"track_total_hits\": {{#track_total_hits}}{{track_total_hits}}{{/track_total_hits}}{{^track_total_hits}}false{{/track_total_hits}}}");
                try {
                    String templateId = (String)r;
                    if (templateId == null || templateId.isBlank() || templateId.equals("null")) {
                        this.executeQueryPlanning(parameters, listener);
                    } else {
                        GetStoredScriptRequest getStoredScriptRequest = new GetStoredScriptRequest(templateId);
                        this.client.admin().cluster().getStoredScript(getStoredScriptRequest, ActionListener.wrap(getStoredScriptResponse -> {
                            if (getStoredScriptResponse.getSource() != null) {
                                parameters.put(TEMPLATE_FIELD, StringUtils.gson.toJson((Object)getStoredScriptResponse.getSource().getSource()));
                            }
                            this.executeQueryPlanning(parameters, listener);
                        }, e -> listener.onFailure(e)));
                    }
                }
                catch (Exception e2) {
                    IllegalArgumentException parsingException = new IllegalArgumentException("Error processing search template: " + String.valueOf(r) + ". Try using response_filter in agent registration if needed.", e2);
                    listener.onFailure((Exception)parsingException);
                }
            }, arg_0 -> listener.onFailure(arg_0));
            this.queryGenerationTool.run(templateSelectionParameters, templateSelectionListener);
        }
        catch (Exception e) {
            log.error("Failed to run QueryPlannerTool", (Throwable)e);
            listener.onFailure(e);
        }
    }

    private <T> void executeQueryPlanning(Map<String, String> parameters, ActionListener<T> listener) {
        try {
            parameters.put(SYSTEM_PROMPT_FIELD, parameters.getOrDefault(QUERY_PLANNER_SYSTEM_PROMPT_FIELD, "==== PURPOSE ====\nYou are an OpenSearch DSL expert. Convert a natural-language question into a strict JSON OpenSearch query body.\n\n==== RULES ====\nUse only fields present in the provided mapping; never invent names.\nChoose query types based on user intent and field types:\n- match: single-token full-text on analyzed text fields.\n- match_phrase: multi-token phrases on analyzed text fields (search string contains spaces, hyphens, commas, etc.).\n- multi_match: when multiple analyzed text fields are equally relevant.\n- term / terms: exact match on keyword, numeric, boolean.\n- range: numeric/date comparisons (gt, lt, gte, lte).\n- bool with must, should, must_not, filter: AND/OR/NOT logic.\n- wildcard / prefix on keyword: \"starts with\" / pattern matching.\n- exists: field presence/absence.\n- nested query / nested agg: ONLY if the mapping for that exact path (or a parent) has \"type\":\"nested\".\n- neural: semantic similarity on a 'semantic' or 'knn_vector' field (dense). Use \"query_text\" and \"k\"; include \"model_id\" unless bound in mapping.\n- neural (top-level): allowed when it's the only relevance clause needed; otherwise wrap in a bool when combining with filters/other queries.\n\nMechanics:\n- Put exact constraints (term, terms, range, exists, prefix, wildcard) in bool.filter (non-scoring). Put full-text relevance (match, match_phrase, multi_match) in bool.must.\n- Top N items/products/documents: return top hits (set \"size\": N as an integer) and sort by the relevant metric(s). Do not use aggregations for item lists.\n- Neural retrieval size: set \"k\" \u2265 \"size\" (e.g. heuristic, k = max(size*5, 100) and k<=ef_search).\n- Spelling tolerance: match_phrase does NOT support fuzziness; use match or multi_match with \"fuzziness\": \"AUTO\" when tolerant matching is needed.\n- Text operators (OR vs AND): default to OR for natural-language queries; to tighten, use minimum_should_match (e.g., \"75%\" requires ~75% of terms). Use AND only when every token is essential; if order/adjacency matters, use match_phrase. (Applies to match/multi_match.)\n- Numeric note: use ONLY integers for size and k (e.g., \"size\": 5), not floats (wrong e.g., \"size\": 5.0).\n\nAggregations (counts, averages, grouped summaries, distributions):\n- Use aggregations when the user asks for grouped summaries (e.g., counts by category, averages by brand, or top N categories/brands).\n- terms on field.keyword or numeric for grouping / top N groups (not items).\n- Metric aggs (avg, min, max, sum, stats, cardinality) on numeric fields.\n- date_histogram, histogram, range for distributions.\n- Always set \"size\": 0 when only aggregations are needed.\n- Use sub-aggregations + order for \"top N groups by metric\".\n- If grouping/filtering exactly on a text field, use its .keyword sub-field when present.\n\nDATE RULES\n- Use range on date/date_nanos in bool.filter.\n- Emit ISO 8601 UTC ('Z') bounds; don't set time_zone for explicit UTC. (now is UTC)\n- Date math: now\u00b1N{y|M|w|d|h|m|s} (M=month, m=minute; e.g., now-7d .. now = last 7 days).\n- Rounding: \"/UNIT\" floors to start (now/d, now/w, now/M, now/y). Examples: last full day \u2192 now-1d/d .. now/d; last full month \u2192 now-1M/M .. now/M.\n- End boundaries: prefer the next unit\u2019s start (avoid 23:59:59).\n- Formats: only add \"format\" when inputs aren\u2019t default; epoch_millis allowed.\n- Buckets: use date_histogram (set calendar_interval or fixed_interval); add time_zone only when local day/week/month buckets are required.\n\nNEURAL / SEMANTIC SEARCH\nWhen to use:\n- The intent is conceptual/semantic (\u201cabout\u201d, \u201csimilar to\u201d, long phrases, synonyms, multilingual, ambiguous), and the mapping has:\n  \u2022 type: \"semantic\", or\n  \u2022 type: \"knn_vector\".\n- You also have exact filters (term/range/etc.) but text relevance still matters \u2192 add neural on that text field.\n- The user explicitly asks for semantic/neural/vector/embedding search.\nWhen NOT to use:\n- The request is purely structured/exact (IDs, codes, only term/range).\n- No suitable \"semantic\" or \"knn_vector\" field exists.\n- No Model ID found for neural search.\nHow to query:\n- Use the \"neural\" clause against the chosen field.\n- Required: \"query_text\" and \"k\".\n- \"model_id\" rules:\n  \u2022 For \"semantic\" fields, model usually bound in mapping \u2192 omit unless overriding.\n  \u2022 For \"knn_vector\", include \"model_id\" unless a default is bound elsewhere.\n  \u2022 If model ID is not found, do not generate query with Neural clause.\nTop-level usage:\n- If there are no filters/other clauses, \"neural\" MAY be the root query (no bool).\n- Use a bool wrapper only when combining with filters or additional queries; keep exact filters in bool.filter.\nSizing:\n- \"size\": N is the returned hits.\n- Set \"k\" \u2265 \"size\" (heuristic: k (int) = max(size*5, 100), reasonable cap \u2248 1000).\nField choice:\n- Prefer a field that semantically represents intent (e.g., description/title/content).\n- If multiple candidates exist, pick the single best; add more only if clearly beneficial.\nFallback:\n- If no suitable neural field exists or if no model id is found, do NOT add a neural clause; proceed with classic DSL or fall back to DEFAULT_QUERY if nothing relevant exists.\n\n==== FIELD SELECTION & PROXYING ====\nGoal: pick the smallest set of mapping fields that best capture the user's intent.\nQuery Fields: when provided, and present in the mapping, prioritize using them; ignore any that are not in the mapping.\nProxy Rule (mandatory): If at least one field is even loosely related to the intent, you MUST proceed using the best available proxy fields. Do NOT fall back to the default query due to ambiguity.\nSelection steps:\n- Harvest candidates from the question (entities, attributes, constraints).\n- From query_fields (that exist) and the index mapping, choose fields that map to those candidates and the user intent\u2014even if only loosely (use reasonable proxies).\n- Ignore other fields that don\u2019t help answer the question.\n- Micro Self-Check (silent): verify chosen fields exist; if any don\u2019t, swap to the closest mapped proxy and continue. Only if no remotely relevant fields exist at all, use the default match_all query.\n\n\n==== OUTPUT FORMAT ====\n- Return EXACTLY ONE JSON object representing the OpenSearch request body (not an escaped string).\n- Output NOTHING else before or after it.\n- Do NOT use code fences or markdown: no backticks (`), no ```json, no ```.\n- Do NOT wrap in quotes or prose: no single quotes ('), no smart quotes (\u2019 \u201c \u201d), no angle brackets (< >), no XML/HTML, no lists, no headers, no ellipses.\n- Use valid JSON only: standard double quotes (\") for all keys/strings; no comments; no trailing commas.\n- If the request truly cannot be fulfilled because no remotely relevant fields exist, return EXACTLY:\n{\"size\":10,\"query\":{\"match_all\":{}}}\n\n==== EXAMPLES ====\nExample 1 \u2014 numeric + date range (merged)\nInput: Show all products that cost more than 50 dollars in the last 30 days.\nMapping: { \"properties\": { \"price\": { \"type\": \"float\" }, \"created_at\": { \"type\": \"date\" }, \"color\": { \"type\": \"keyword\" } } }\nQuery Fields: [price, created_at]\nField selection: relevant=[price(float), created_at(date)]; ignored=[color]\nOutput: { \"query\": { \"bool\": { \"filter\": [{ \"range\": { \"price\": { \"gt\": 50 } } }, { \"range\": { \"created_at\": { \"gte\": \"now-30d/d\", \"lte\": \"now\" } } } ] } } }\nExample 2 \u2014 text match + exact filter (spelling tolerant)\nInput: Find employees in London who are active.\nMapping: { \"properties\": { \"city\": { \"type\": \"text\", \"fields\": { \"keyword\": { \"type\": \"keyword\" } } }, \"status\": { \"type\": \"keyword\" }, \"notes\": { \"type\": \"text\" } } }\nQuery Fields: [city, status]\nField selection: relevant=[city(text), status(keyword)]; ignored=[notes]\nOutput: { \"query\": { \"bool\": { \"must\": [ { \"match\": { \"city\": { \"query\": \"London\", \"fuzziness\": \"AUTO\" } } } ], \"filter\": [ { \"term\": { \"status\": \"active\" } } ] } } }\nExample 3 \u2014 match_phrase for multi-token\nInput: Find employees located in New York City.\nMapping: { \"properties\": { \"city\": { \"type\": \"text\", \"fields\": { \"keyword\": { \"type\": \"keyword\" } } }, \"department\": { \"type\": \"keyword\" } } }\nOutput: { \"query\": { \"match_phrase\": { \"city\": \"New York City\" } } }\nExample 4 \u2014 multi_match across fields + SHOULD filters\nInput: Find profiles mentioning \\\"data engineering\\\" in the title or summary that are research papers or blogs.\nMapping: { \"properties\": { \"title\": { \"type\": \"text\" }, \"summary\": { \"type\": \"text\" }, \"type\": { \"type\": \"keyword\" } } }\nOutput: { \"query\": { \"bool\": { \"must\": [ { \"multi_match\": { \"query\": \"data engineering\", \"fields\": [\"title\", \"summary\"], \"fuzziness\": \"AUTO\" } } ], \"should\": [ { \"term\": { \"type\": \"research paper\" } }, { \"term\": { \"type\": \"blog\" } } ], \"minimum_should_match\": 1 } } }\nExample 5 \u2014 wildcard + exists (exact filters in bool.filter)\nInput: Find users whose email starts with \"sam\" and who have a phone number on file.\nMapping: { \"properties\": { \"email\": { \"type\": \"keyword\" }, \"phone\": { \"type\": \"keyword\" }, \"avatar_url\": { \"type\": \"keyword\" } } }\nField selection: relevant=[email(prefix), phone(exists)]; ignored=[avatar_url]\nOutput: { \"query\": { \"bool\": { \"filter\": [ { \"prefix\": { \"email\": \"sam\" } }, { \"exists\": { \"field\": \"phone\" } } ] } } }\nExample 6 \u2014 nested query (only when mapping says nested)\nInput: Find books where an author's first_name is John AND last_name is Doe.\nMapping: { \"properties\": { \"author\": { \"type\": \"nested\", \"properties\": { \"first_name\": { \"type\": \"text\", \"fields\": { \"keyword\": { \"type\": \"keyword\" } } }, \"last_name\": { \"type\": \"text\", \"fields\": { \"keyword\": { \"type\": \"keyword\" } } } } }, \"title\": { \"type\": \"text\" } } }\nOutput: { \"query\": { \"nested\": { \"path\": \"author\", \"query\": { \"bool\": { \"must\": [ { \"term\": { \"author.first_name.keyword\": \"John\" } }, { \"term\": { \"author.last_name.keyword\": \"Doe\" } } ] } } } } }\nExample 7 \u2014 terms aggregation\nInput: Show the number of orders per status.\nMapping: { \"properties\": { \"status\": { \"type\": \"keyword\" }, \"order_id\": { \"type\": \"keyword\" } } }\nOutput: { \"size\": 0, \"aggs\": { \"orders_by_status\": { \"terms\": { \"field\": \"status\" } } } }\nExample 8 \u2014 top N items by metric (hits + sort, no aggs)\nInput: Show the 5 highest-rated electronics products.\nMapping: { \"properties\": { \"category\": { \"type\": \"keyword\" }, \"rating\": { \"type\": \"float\" }, \"reviews_count\": { \"type\": \"integer\" }, \"product_name\": { \"type\": \"text\" }, \"description\": { \"type\": \"text\" } } }\nField selection: relevant=[category(keyword), rating(float), reviews_count(integer), product_name(text), description(text)]\nOutput: { \"size\": 5, \"query\": { \"bool\": { \"filter\": [ { \"term\": { \"category\": \"electronics\" } } ] } }, \"sort\": [ { \"rating\": { \"order\": \"desc\" } }, { \"reviews_count\": { \"order\": \"desc\" } } ] }\nExample 9 \u2014 top N categories (grouping via aggs; not for item lists)\nInput: List the top 3 categories by total sales volume.\nMapping: { \"properties\": { \"category\": { \"type\": \"text\", \"fields\": { \"keyword\": { \"type\": \"keyword\" } } }, \"sales\": { \"type\": \"float\" }, \"region\": { \"type\": \"keyword\" } } }\nField selection: relevant=[category.keyword, sales]; ignored=[region]\nOutput: { \"size\": 0, \"aggs\": { \"top_categories\": { \"terms\": { \"field\": \"category.keyword\", \"size\": 3, \"order\": { \"total_sales\": \"desc\" } }, \"aggs\": { \"total_sales\": { \"sum\": { \"field\": \"sales\" } } } } } }\nExample 10 \u2014 ambiguous mapping, proxy success\nInput: Give medicines shipped from Vietnam.\nMapping: { \"properties\": { \"item_name\": { \"type\": \"text\" }, \"product_category\": { \"type\": \"keyword\" }, \"country\": { \"type\": \"keyword\" }, \"ship_status\": { \"type\": \"keyword\" }, \"notes\": { \"type\": \"text\" } } }\nQuery Fields: [product_category, origin_country]\nField selection: relevant=[product_category, country(proxy for origin), ship_status(proxy for shipped)]; ignored=[notes, item_name]\nOutput: { \"query\": { \"bool\": { \"filter\": [ { \"term\": { \"product_category\": \"medicines\" } }, { \"term\": { \"country\": \"Vietnam\" } }, { \"term\": { \"ship_status\": \"shipped\" } } ] } } }\nExample 11 \u2014 true fallback (no remotely relevant fields)\nInput: List satellites with periapsis above 400km.\nMapping: { \"properties\": { \"name\": { \"type\": \"text\" }, \"color\": { \"type\": \"keyword\" } } }\nOutput: {\"size\":10,\"query\":{\"match_all\":{}}}\nExample 12 \u2014 neural preferred with safe fallback (merged)\nInput: Find articles about \\\"LLM hallucinations\\\". Model Id may or may not be provided.\nMapping: { \"properties\": { \"content\": {\"type\":\"text\"}, \"content_vector\": {\"type\":\"knn_vector\",\"dimension\":768}, \"tags\": {\"type\":\"keyword\"}, \"published_at\": {\"type\":\"date\"} } }\nOutput (with model_id): { \"size\": 10, \"query\": { \"neural\": { \"content_vector\": { \"query_text\": \"LLM hallucinations\", \"model_id\": \"m-dense-001\", \"k\": 200 } } } }\nOutput (fallback without model_id): { \"size\": 10, \"query\": { \"match\": { \"content\": { \"query\": \"LLM hallucinations\" } } } }\nExample 13 \u2014 neural on semantic field + exact filters (mapping includes non-semantic fields)\nInput: Find \\\"wireless noise cancelling headphones with multipoint\\\" under $200; brand Sony.\nMapping: { \"properties\": { \"price\": {\"type\":\"float\"}, \"brand\": {\"type\":\"keyword\"}, \"title\": {\"type\":\"text\"}, \"description\": {\"type\":\"semantic\", \"model_id\":\"m-sem-123\"} } }\nOutput: { \"size\": 10, \"query\": { \"bool\": { \"must\": [ { \"neural\": { \"description\": { \"query_text\": \"wireless noise cancelling headphones with multipoint\", \"k\": 120 } } } ], \"filter\": [ { \"range\": { \"price\": { \"lte\": 200 } } }, { \"term\": { \"brand\": \"Sony\" } } ] } } }\n\nUse this search template provided by the user as reference to generate the query: ${parameters.template}\n\nNote that this template might contain terms that are not relevant to the question at hand, in that case ignore the template"));
            parameters.put(USER_PROMPT_FIELD, parameters.getOrDefault(QUERY_PLANNER_USER_PROMPT_FIELD, "Question: ${parameters.question}\nMapping: ${parameters.index_mapping:-}\nQuery Fields: ${parameters.query_fields:-}\nSample Document from index:${parameters.sample_document:-}\nIn UTC:${parameters.current_time:-} format: yyyy-MM-dd'T'HH:mm:ss'Z'\nEmbedding Model ID for Neural Search:${parameters.embedding_model_id:- not provided} \n==== OUTPUT ====\nGIVE THE OUTPUT PART ONLY IN YOUR RESPONSE (a single JSON object)\nOutput:"));
            if (parameters.containsKey(QUERY_FIELDS_FIELD)) {
                parameters.put(QUERY_FIELDS_FIELD, StringUtils.gson.toJson((Object)parameters.get(QUERY_FIELDS_FIELD)));
            }
            String currentDateTime = AgentUtils.getCurrentDateTime("yyyy-MM-dd'T'HH:mm:ss'Z'");
            parameters.put(CURRENT_TIME_FIELD, StringUtils.gson.toJson((Object)currentDateTime));
            this.getIndexMappingAsync(parameters.get(INDEX_NAME_FIELD), (ActionListener<String>)ActionListener.wrap(indexMapping -> {
                parameters.put(INDEX_MAPPING_FIELD, StringUtils.gson.toJson(indexMapping));
                this.getSampleDocAsync((String)parameters.get(INDEX_NAME_FIELD), (ActionListener<String>)ActionListener.wrap(sampleDoc -> {
                    parameters.put(SAMPLE_DOCUMENT_FIELD, StringUtils.gson.toJson(sampleDoc));
                    ActionListener modelListener = ActionListener.wrap(r -> {
                        try {
                            String queryString = (String)r;
                            if (queryString == null || queryString.isBlank() || queryString.equals("null")) {
                                log.debug("Model failed to generate the DSL query, returning the Default match all query");
                                StringSubstitutor substitutor = new StringSubstitutor(parameters, "${parameters.", "}");
                                String defaultQueryString = substitutor.replace("{\"size\":10,\"query\":{\"match_all\":{}}}");
                                listener.onResponse((Object)defaultQueryString);
                            } else {
                                listener.onResponse(this.outputParser != null ? this.outputParser.parse((Object)queryString) : queryString);
                            }
                        }
                        catch (Exception e) {
                            IllegalArgumentException parsingException = new IllegalArgumentException("Error processing query string: " + String.valueOf(r) + ". Try using response_filter in agent registration if needed.", e);
                            listener.onFailure((Exception)parsingException);
                        }
                    }, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
                    this.queryGenerationTool.run(parameters, modelListener);
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            }, arg_0 -> listener.onFailure(arg_0)));
        }
        catch (Exception e) {
            log.error("Failed to run QueryPlannerTool", (Throwable)e);
            listener.onFailure(e);
        }
    }

    private void getSampleDocAsync(String indexName, final ActionListener<String> listener) {
        try {
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(1).query((QueryBuilder)QueryBuilders.matchAllQuery()).trackTotalHits(false).fetchSource(true).explain(Boolean.valueOf(false)).profile(false).sort("_doc");
            SearchRequest searchRequest = new SearchRequest().source(searchSourceBuilder).indices(new String[]{indexName});
            ActionListener<SearchResponse> searchListener = new ActionListener<SearchResponse>(this){

                public void onResponse(SearchResponse searchResponse) {
                    try {
                        SearchHit[] hits = searchResponse.getHits().getHits();
                        if (hits == null || hits.length == 0) {
                            listener.onResponse(null);
                            return;
                        }
                        Map sourceMap = hits[0].getSourceAsMap();
                        if (sourceMap == null || sourceMap.isEmpty()) {
                            listener.onResponse(null);
                            return;
                        }
                        HashMap<String, Object> truncatedSourceMap = new HashMap<String, Object>();
                        for (Map.Entry entry : sourceMap.entrySet()) {
                            String key = (String)entry.getKey();
                            String value = String.valueOf(entry.getValue());
                            int cpCount = value.codePointCount(0, value.length());
                            if (cpCount > 250) {
                                int end = value.offsetByCodePoints(0, 250);
                                truncatedSourceMap.put(key, QueryPlanningTool.TRUNC_PREFIX + value.substring(0, end));
                                continue;
                            }
                            truncatedSourceMap.put(key, value);
                        }
                        listener.onResponse((Object)StringUtils.gson.toJson(truncatedSourceMap));
                    }
                    catch (Exception e) {
                        log.error("Failed to process sample document");
                        listener.onFailure((Exception)new IOException("Failed to process sample document", e));
                    }
                }

                public void onFailure(Exception e) {
                    log.error("Failed to get sample document");
                    listener.onFailure((Exception)new IOException("Failed to get sample document", e));
                }
            };
            this.client.search(searchRequest, (ActionListener)searchListener);
        }
        catch (Exception e) {
            log.error("Failed to get sample document");
            listener.onFailure((Exception)new IOException("Failed to get sample document", e));
        }
    }

    private void getIndexMappingAsync(final String indexName, final ActionListener<String> listener) {
        try {
            GetIndexRequest getIndexRequest = (GetIndexRequest)((GetIndexRequest)((GetIndexRequest)((GetIndexRequest)new GetIndexRequest().indices(new String[]{indexName})).indicesOptions(IndicesOptions.strictExpand())).local(false)).clusterManagerNodeTimeout(ClusterManagerNodeRequest.DEFAULT_CLUSTER_MANAGER_NODE_TIMEOUT);
            this.client.admin().indices().getIndex(getIndexRequest, (ActionListener)new ActionListener<GetIndexResponse>(){

                public void onResponse(GetIndexResponse getIndexResponse) {
                    try {
                        MappingMetadata mapping = (MappingMetadata)getIndexResponse.mappings().get(indexName);
                        listener.onResponse((Object)mapping.source().toString());
                    }
                    catch (Exception e) {
                        listener.onFailure((Exception)new IllegalStateException("Failed to extract index mapping", e));
                    }
                }

                public void onFailure(Exception e) {
                    if (e instanceof IndexNotFoundException) {
                        log.warn("Index does not exist or is not available");
                        listener.onFailure((Exception)new IllegalArgumentException("Index does not exist or is not available", e));
                    } else {
                        log.warn("Failed to extract index mapping");
                        listener.onFailure((Exception)new IllegalStateException("Failed to extract index mapping", e));
                    }
                }
            });
        }
        catch (Exception e) {
            log.warn("Failed to extract index mapping");
            listener.onFailure((Exception)new IllegalStateException("Failed to extract index mapping", e));
        }
    }

    public String getType() {
        return TYPE;
    }

    public String getVersion() {
        return null;
    }

    public boolean validate(Map<String, String> parameters) {
        return parameters != null && parameters.size() != 0 && parameters.containsKey(QUESTION_FIELD) && parameters.containsKey(INDEX_NAME_FIELD);
    }

    @Generated
    public String getGenerationType() {
        return this.generationType;
    }

    @Generated
    public String getSearchTemplates() {
        return this.searchTemplates;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setOutputParser(Parser outputParser) {
        this.outputParser = outputParser;
    }

    @Generated
    public Parser getOutputParser() {
        return this.outputParser;
    }

    public static class Factory
    implements WithModelTool.Factory<QueryPlanningTool> {
        private Client client;
        private static volatile Factory INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<QueryPlanningTool> clazz = QueryPlanningTool.class;
            synchronized (QueryPlanningTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public void init(Client client) {
            this.client = client;
        }

        public QueryPlanningTool create(Map<String, Object> params) {
            if (!params.containsKey(QueryPlanningTool.MODEL_ID_FIELD) && params.containsKey("agent_llm_model_id")) {
                params.put(QueryPlanningTool.MODEL_ID_FIELD, params.get("agent_llm_model_id"));
            }
            MLModelTool queryGenerationTool = MLModelTool.Factory.getInstance().create(params);
            String type = (String)params.get(QueryPlanningTool.GENERATION_TYPE_FIELD);
            if (type == null || type.isEmpty()) {
                type = QueryPlanningTool.LLM_GENERATED_TYPE_FIELD;
            }
            if (!QueryPlanningTool.LLM_GENERATED_TYPE_FIELD.equals(type) && !QueryPlanningTool.USER_SEARCH_TEMPLATES_TYPE_FIELD.equals(type)) {
                throw new IllegalArgumentException("Invalid generation type: " + type + ". The current supported types are llmGenerated and user_templates.");
            }
            String searchTemplates = null;
            if (QueryPlanningTool.USER_SEARCH_TEMPLATES_TYPE_FIELD.equals(type)) {
                if (!params.containsKey(QueryPlanningTool.SEARCH_TEMPLATES_FIELD)) {
                    throw new IllegalArgumentException("search_templates field is required when generation_type is 'user_templates'");
                }
                String searchTemplatesJson = (String)params.get(QueryPlanningTool.SEARCH_TEMPLATES_FIELD);
                this.validateSearchTemplates(searchTemplatesJson);
                searchTemplates = StringUtils.gson.toJson((Object)searchTemplatesJson);
            }
            QueryPlanningTool queryPlanningTool = new QueryPlanningTool(type, queryGenerationTool, this.client, searchTemplates);
            queryPlanningTool.setOutputParser(this.createParserWithDefaultExtractJson(params));
            return queryPlanningTool;
        }

        private Parser createParserWithDefaultExtractJson(Map<String, Object> params) {
            List<Map<String, Object>> customProcessorConfigs = ProcessorChain.extractProcessorConfigs(params);
            HashMap<String, String> extractJsonConfig = new HashMap<String, String>();
            extractJsonConfig.put("type", "extract_json");
            extractJsonConfig.put("extract_type", "object");
            extractJsonConfig.put("default", "{\"size\":10,\"query\":{\"match_all\":{}}}");
            ArrayList<Map<String, Object>> combinedProcessorConfigs = new ArrayList<Map<String, Object>>();
            combinedProcessorConfigs.add(extractJsonConfig);
            combinedProcessorConfigs.addAll(customProcessorConfigs);
            return ToolParser.createProcessingParser(null, combinedProcessorConfigs);
        }

        private void validateSearchTemplates(Object searchTemplatesObj) {
            List templates = (List)StringUtils.gson.fromJson(searchTemplatesObj.toString(), new TypeToken<List<Map<String, String>>>(this){}.getType());
            for (Map template : templates) {
                this.validateTemplateFields(template);
            }
        }

        private void validateTemplateFields(Map<String, String> template) {
            String templateId = template.get(QueryPlanningTool.TEMPLATE_ID_FIELD);
            if (templateId == null || templateId.isBlank()) {
                throw new IllegalArgumentException("search_templates field entries must have a template_id");
            }
            String templateDescription = template.get(QueryPlanningTool.TEMPLATE_DESCRIPTION_FIELD);
            if (templateDescription == null || templateDescription.isBlank()) {
                throw new IllegalArgumentException("search_templates field entries must have a template_description");
            }
        }

        public String getDefaultDescription() {
            return DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return QueryPlanningTool.TYPE;
        }

        public String getDefaultVersion() {
            return null;
        }

        public List<String> getAllModelKeys() {
            return List.of(QueryPlanningTool.MODEL_ID_FIELD);
        }
    }
}

