/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.structuredencryption.model;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.CryptoItem;
import software.amazon.cryptography.materialproviders.CryptographicMaterialsManager;
import software.amazon.cryptography.materialproviders.ICryptographicMaterialsManager;
import software.amazon.cryptography.materialproviders.model.DBEAlgorithmSuiteId;

public class EncryptPathStructureInput {
    private final String tableName;
    private final List<CryptoItem> plaintextStructure;
    private final ICryptographicMaterialsManager cmm;
    private final DBEAlgorithmSuiteId algorithmSuiteId;
    private final Map<String, String> encryptionContext;

    protected EncryptPathStructureInput(BuilderImpl builder) {
        this.tableName = builder.tableName();
        this.plaintextStructure = builder.plaintextStructure();
        this.cmm = builder.cmm();
        this.algorithmSuiteId = builder.algorithmSuiteId();
        this.encryptionContext = builder.encryptionContext();
    }

    public String tableName() {
        return this.tableName;
    }

    public List<CryptoItem> plaintextStructure() {
        return this.plaintextStructure;
    }

    public ICryptographicMaterialsManager cmm() {
        return this.cmm;
    }

    public DBEAlgorithmSuiteId algorithmSuiteId() {
        return this.algorithmSuiteId;
    }

    public Map<String, String> encryptionContext() {
        return this.encryptionContext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String tableName;
        protected List<CryptoItem> plaintextStructure;
        protected ICryptographicMaterialsManager cmm;
        protected DBEAlgorithmSuiteId algorithmSuiteId;
        protected Map<String, String> encryptionContext;

        protected BuilderImpl() {
        }

        protected BuilderImpl(EncryptPathStructureInput model) {
            this.tableName = model.tableName();
            this.plaintextStructure = model.plaintextStructure();
            this.cmm = model.cmm();
            this.algorithmSuiteId = model.algorithmSuiteId();
            this.encryptionContext = model.encryptionContext();
        }

        @Override
        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public String tableName() {
            return this.tableName;
        }

        @Override
        public Builder plaintextStructure(List<CryptoItem> plaintextStructure) {
            this.plaintextStructure = plaintextStructure;
            return this;
        }

        @Override
        public List<CryptoItem> plaintextStructure() {
            return this.plaintextStructure;
        }

        @Override
        public Builder cmm(ICryptographicMaterialsManager cmm) {
            this.cmm = CryptographicMaterialsManager.wrap((ICryptographicMaterialsManager)cmm);
            return this;
        }

        @Override
        public ICryptographicMaterialsManager cmm() {
            return this.cmm;
        }

        @Override
        public Builder algorithmSuiteId(DBEAlgorithmSuiteId algorithmSuiteId) {
            this.algorithmSuiteId = algorithmSuiteId;
            return this;
        }

        @Override
        public DBEAlgorithmSuiteId algorithmSuiteId() {
            return this.algorithmSuiteId;
        }

        @Override
        public Builder encryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = encryptionContext;
            return this;
        }

        @Override
        public Map<String, String> encryptionContext() {
            return this.encryptionContext;
        }

        @Override
        public EncryptPathStructureInput build() {
            if (Objects.isNull(this.tableName())) {
                throw new IllegalArgumentException("Missing value for required field `tableName`");
            }
            if (Objects.isNull(this.plaintextStructure())) {
                throw new IllegalArgumentException("Missing value for required field `plaintextStructure`");
            }
            if (Objects.isNull(this.cmm())) {
                throw new IllegalArgumentException("Missing value for required field `cmm`");
            }
            return new EncryptPathStructureInput(this);
        }
    }

    public static interface Builder {
        public Builder tableName(String var1);

        public String tableName();

        public Builder plaintextStructure(List<CryptoItem> var1);

        public List<CryptoItem> plaintextStructure();

        public Builder cmm(ICryptographicMaterialsManager var1);

        public ICryptographicMaterialsManager cmm();

        public Builder algorithmSuiteId(DBEAlgorithmSuiteId var1);

        public DBEAlgorithmSuiteId algorithmSuiteId();

        public Builder encryptionContext(Map<String, String> var1);

        public Map<String, String> encryptionContext();

        public EncryptPathStructureInput build();
    }
}

