/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.io;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.crypto.CipherOutputStream;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.StreamException;
import org.bouncycastle.crypto.internal.BufferedBlockCipher;
import org.bouncycastle.crypto.internal.InvalidCipherTextException;
import org.bouncycastle.crypto.internal.StreamCipher;
import org.bouncycastle.crypto.internal.io.StreamIOException;
import org.bouncycastle.crypto.internal.io.Utils;
import org.bouncycastle.crypto.internal.modes.AEADCipher;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.WrappedByteArrayOutputStream;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class CipherOutputStreamImpl
extends CipherOutputStream {
    protected final String algorithmName;
    protected final boolean isApprovedMode;
    protected OutputStream out;
    protected final byte[] oneByte = new byte[1];
    private static final int INPUT_LEN = 32768;

    protected CipherOutputStreamImpl(String string, OutputStream outputStream) {
        this.algorithmName = string;
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.out = outputStream;
    }

    @Override
    public void write(int n) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.oneByte[0] = (byte)n;
        this.write(this.oneByte, 0, 1);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    public static CipherOutputStream getInstance(OutputStream outputStream, StreamCipher streamCipher) {
        if (outputStream instanceof WrappedByteArrayOutputStream) {
            return new DirectStreamCipherOutputStream((WrappedByteArrayOutputStream)outputStream, streamCipher);
        }
        return new StreamCipherOutputStream(outputStream, streamCipher);
    }

    public static CipherOutputStream getInstance(OutputStream outputStream, BufferedBlockCipher bufferedBlockCipher) {
        if (outputStream instanceof WrappedByteArrayOutputStream) {
            return new DirectBufferedCipherOutputStream((WrappedByteArrayOutputStream)outputStream, bufferedBlockCipher);
        }
        return new BufferedCipherOutputStream(outputStream, bufferedBlockCipher);
    }

    public static CipherOutputStream getInstance(OutputStream outputStream, AEADCipher aEADCipher) {
        if (outputStream instanceof WrappedByteArrayOutputStream) {
            return new DirectAEADOutputStream((WrappedByteArrayOutputStream)outputStream, aEADCipher);
        }
        return new AEADOutputStream(outputStream, aEADCipher);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class DirectAEADOutputStream
    extends CipherOutputStreamImpl {
        private final AEADCipher aeadBlockCipher;
        private final WrappedByteArrayOutputStream directOut;

        public DirectAEADOutputStream(WrappedByteArrayOutputStream wrappedByteArrayOutputStream, AEADCipher aEADCipher) {
            super(aEADCipher.getAlgorithmName(), wrappedByteArrayOutputStream);
            this.directOut = wrappedByteArrayOutputStream;
            this.aeadBlockCipher = aEADCipher;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
            int n3 = this.aeadBlockCipher.processBytes(byArray, n, n2, this.directOut.getBuffer(), this.directOut.getOffset());
            this.directOut.moveOffset(n3);
        }

        @Override
        public void close() throws IOException {
            IOException iOException;
            block7: {
                Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
                iOException = null;
                try {
                    int n = this.aeadBlockCipher.doFinal(this.directOut.getBuffer(), this.directOut.getOffset());
                    this.directOut.moveOffset(n);
                }
                catch (InvalidCipherTextException invalidCipherTextException) {
                    iOException = new org.bouncycastle.crypto.InvalidCipherTextException("Error finalising cipher data: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
                }
                catch (IllegalStateException illegalStateException) {
                    iOException = new StreamException(illegalStateException.getMessage(), illegalStateException.getCause());
                }
                catch (Exception exception) {
                    iOException = new StreamIOException("Error closing stream: ", exception);
                }
                try {
                    this.flush();
                }
                catch (IOException iOException2) {
                    if (iOException != null) break block7;
                    iOException = iOException2;
                }
            }
            if (iOException != null) {
                throw iOException;
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class AEADOutputStream
    extends CipherOutputStreamImpl {
        private final AEADCipher aeadBlockCipher;
        private byte[] buf;

        public AEADOutputStream(OutputStream outputStream, AEADCipher aEADCipher) {
            super(aEADCipher.getAlgorithmName(), outputStream);
            this.aeadBlockCipher = aEADCipher;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
            while (n2 > 0) {
                this.ensureCapacity(32768, false);
                int n3 = this.aeadBlockCipher.processBytes(byArray, n, n2 < 32768 ? n2 : 32768, this.buf, 0);
                if (n3 != 0) {
                    this.out.write(this.buf, 0, n3);
                }
                n += 32768;
                n2 -= 32768;
            }
        }

        private void ensureCapacity(int n, boolean bl) {
            int n2 = bl ? this.aeadBlockCipher.getOutputSize(n) : this.aeadBlockCipher.getUpdateOutputSize(n);
            if (this.buf == null) {
                this.buf = new byte[n2];
            } else if (this.buf.length < n2) {
                Arrays.clear(this.buf);
                this.buf = new byte[n2];
            }
        }

        @Override
        public void close() throws IOException {
            IOException iOException;
            block15: {
                Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
                this.ensureCapacity(0, true);
                iOException = null;
                try {
                    int n = this.aeadBlockCipher.doFinal(this.buf, 0);
                    if (n != 0) {
                        this.out.write(this.buf, 0, n);
                    }
                }
                catch (InvalidCipherTextException invalidCipherTextException) {
                    iOException = new org.bouncycastle.crypto.InvalidCipherTextException("Error finalising cipher data: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
                }
                catch (IllegalStateException illegalStateException) {
                    iOException = new StreamException(illegalStateException.getMessage(), illegalStateException.getCause());
                }
                catch (Exception exception) {
                    iOException = new StreamIOException("Error closing stream: ", exception);
                }
                finally {
                    if (this.buf != null) {
                        Arrays.clear(this.buf);
                    }
                }
                try {
                    this.flush();
                }
                catch (IOException iOException2) {
                    if (iOException != null) break block15;
                    iOException = iOException2;
                }
            }
            if (iOException != null) {
                throw iOException;
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class DirectBufferedCipherOutputStream
    extends CipherOutputStreamImpl {
        private final BufferedBlockCipher bufferedBlockCipher;
        private final WrappedByteArrayOutputStream directOut;

        public DirectBufferedCipherOutputStream(WrappedByteArrayOutputStream wrappedByteArrayOutputStream, BufferedBlockCipher bufferedBlockCipher) {
            super(bufferedBlockCipher.getUnderlyingCipher().getAlgorithmName(), wrappedByteArrayOutputStream);
            this.directOut = wrappedByteArrayOutputStream;
            this.bufferedBlockCipher = bufferedBlockCipher;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
            int n3 = this.bufferedBlockCipher.processBytes(byArray, n, n2, this.directOut.getBuffer(), this.directOut.getOffset());
            this.directOut.moveOffset(n3);
        }

        @Override
        public void close() throws IOException {
            IOException iOException;
            block7: {
                Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
                iOException = null;
                try {
                    int n = this.bufferedBlockCipher.doFinal(this.directOut.getBuffer(), this.directOut.getOffset());
                    this.directOut.moveOffset(n);
                }
                catch (InvalidCipherTextException invalidCipherTextException) {
                    iOException = new org.bouncycastle.crypto.InvalidCipherTextException("Error finalising cipher data: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
                }
                catch (IllegalStateException illegalStateException) {
                    iOException = new StreamException(illegalStateException.getMessage(), illegalStateException.getCause());
                }
                catch (Exception exception) {
                    iOException = new StreamIOException("Error closing stream: ", exception);
                }
                try {
                    this.flush();
                }
                catch (IOException iOException2) {
                    if (iOException != null) break block7;
                    iOException = iOException2;
                }
            }
            if (iOException != null) {
                throw iOException;
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class BufferedCipherOutputStream
    extends CipherOutputStreamImpl {
        private final BufferedBlockCipher bufferedBlockCipher;
        private byte[] buf;

        public BufferedCipherOutputStream(OutputStream outputStream, BufferedBlockCipher bufferedBlockCipher) {
            super(bufferedBlockCipher.getUnderlyingCipher().getAlgorithmName(), outputStream);
            this.bufferedBlockCipher = bufferedBlockCipher;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
            while (n2 > 0) {
                this.ensureCapacity(32768, false);
                int n3 = this.bufferedBlockCipher.processBytes(byArray, n, n2 < 32768 ? n2 : 32768, this.buf, 0);
                if (n3 != 0) {
                    this.out.write(this.buf, 0, n3);
                }
                n += 32768;
                n2 -= 32768;
            }
        }

        private void ensureCapacity(int n, boolean bl) {
            int n2 = bl ? this.bufferedBlockCipher.getOutputSize(n) : this.bufferedBlockCipher.getUpdateOutputSize(n);
            if (this.buf == null) {
                this.buf = new byte[n2];
            } else if (this.buf.length < n2) {
                Arrays.clear(this.buf);
                this.buf = new byte[n2];
            }
        }

        @Override
        public void close() throws IOException {
            IOException iOException;
            block15: {
                Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
                this.ensureCapacity(0, true);
                iOException = null;
                try {
                    int n = this.bufferedBlockCipher.doFinal(this.buf, 0);
                    if (n != 0) {
                        this.out.write(this.buf, 0, n);
                    }
                }
                catch (InvalidCipherTextException invalidCipherTextException) {
                    iOException = new org.bouncycastle.crypto.InvalidCipherTextException("Error finalising cipher data: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
                }
                catch (IllegalStateException illegalStateException) {
                    iOException = new StreamException(illegalStateException.getMessage(), illegalStateException.getCause());
                }
                catch (Exception exception) {
                    iOException = new StreamIOException("Error closing stream: ", exception);
                }
                finally {
                    if (this.buf != null) {
                        Arrays.clear(this.buf);
                    }
                }
                try {
                    this.flush();
                }
                catch (IOException iOException2) {
                    if (iOException != null) break block15;
                    iOException = iOException2;
                }
            }
            if (iOException != null) {
                throw iOException;
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class DirectStreamCipherOutputStream
    extends CipherOutputStreamImpl {
        private StreamCipher streamCipher;
        private final WrappedByteArrayOutputStream directOut;

        public DirectStreamCipherOutputStream(WrappedByteArrayOutputStream wrappedByteArrayOutputStream, StreamCipher streamCipher) {
            super(streamCipher.getAlgorithmName(), wrappedByteArrayOutputStream);
            this.directOut = wrappedByteArrayOutputStream;
            this.streamCipher = streamCipher;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
            int n3 = this.streamCipher.processBytes(byArray, n, n2, this.directOut.getBuffer(), this.directOut.getOffset());
            this.directOut.moveOffset(n3);
        }

        @Override
        public void close() throws IOException {
            IOException iOException;
            block6: {
                Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
                iOException = null;
                try {
                    this.streamCipher.reset();
                }
                catch (IllegalStateException illegalStateException) {
                    iOException = new StreamException(illegalStateException.getMessage(), illegalStateException.getCause());
                }
                catch (Exception exception) {
                    iOException = new StreamIOException("Error closing stream: ", exception);
                }
                try {
                    this.flush();
                }
                catch (IOException iOException2) {
                    if (iOException != null) break block6;
                    iOException = iOException2;
                }
            }
            if (iOException != null) {
                throw iOException;
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class StreamCipherOutputStream
    extends CipherOutputStreamImpl {
        private final StreamCipher streamCipher;
        private final byte[] buf;

        public StreamCipherOutputStream(OutputStream outputStream, StreamCipher streamCipher) {
            super(streamCipher.getAlgorithmName(), outputStream);
            this.streamCipher = streamCipher;
            this.buf = new byte[32768];
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
            while (n2 > 0) {
                int n3 = this.streamCipher.processBytes(byArray, n, n2 < 32768 ? n2 : 32768, this.buf, 0);
                if (n3 != 0) {
                    this.out.write(this.buf, 0, n3);
                }
                n += 32768;
                n2 -= 32768;
            }
        }

        @Override
        public void close() throws IOException {
            IOException iOException;
            block11: {
                Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
                iOException = null;
                try {
                    this.streamCipher.reset();
                }
                catch (IllegalStateException illegalStateException) {
                    iOException = new StreamException(illegalStateException.getMessage(), illegalStateException.getCause());
                }
                catch (Exception exception) {
                    iOException = new StreamIOException("Error closing stream: ", exception);
                }
                finally {
                    Arrays.clear(this.buf);
                }
                try {
                    this.flush();
                }
                catch (IOException iOException2) {
                    if (iOException != null) break block11;
                    iOException = iOException2;
                }
            }
            if (iOException != null) {
                throw iOException;
            }
        }
    }
}

