/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.contextmanagement;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.transport.client.Client;

public class ContextManagementIndexUtils {
    @Generated
    private static final Logger log = LogManager.getLogger(ContextManagementIndexUtils.class);
    public static final String CONTEXT_MANAGEMENT_TEMPLATES_INDEX = ".plugins-ml-context-management-templates";
    private final Client client;
    private final ClusterService clusterService;

    public ContextManagementIndexUtils(Client client, ClusterService clusterService) {
        this.client = client;
        this.clusterService = clusterService;
    }

    public boolean doesIndexExist() {
        return this.clusterService.state().metadata().hasIndex(CONTEXT_MANAGEMENT_TEMPLATES_INDEX);
    }

    public void createIndexIfNotExists(ActionListener<Boolean> listener) {
        if (this.doesIndexExist()) {
            log.debug("Context management templates index already exists");
            listener.onResponse((Object)true);
            return;
        }
        try {
            ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();
            ActionListener wrappedListener = ActionListener.runBefore((ActionListener)ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore()), () -> ((ThreadContext.StoredContext)context).close());
            CreateIndexRequest createIndexRequest = new CreateIndexRequest(CONTEXT_MANAGEMENT_TEMPLATES_INDEX).settings(this.getIndexSettings());
            this.client.admin().indices().create(createIndexRequest, ActionListener.wrap(createIndexResponse -> {
                log.info("Successfully created context management templates index");
                wrappedListener.onResponse((Object)true);
            }, exception -> {
                if (exception instanceof ResourceAlreadyExistsException) {
                    log.debug("Context management templates index already exists");
                    wrappedListener.onResponse((Object)true);
                } else {
                    log.error("Failed to create context management templates index", (Throwable)exception);
                    wrappedListener.onFailure(exception);
                }
            }));
        }
        catch (Exception e) {
            log.error("Error creating context management templates index", (Throwable)e);
            listener.onFailure(e);
        }
    }

    private Settings getIndexSettings() {
        return Settings.builder().put("index.number_of_shards", 1).put("index.number_of_replicas", 1).put("index.auto_expand_replicas", "0-1").build();
    }

    public static String getIndexName() {
        return CONTEXT_MANAGEMENT_TEMPLATES_INDEX;
    }
}

