/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.contextmanager;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.contextmanager.ActivationRule;
import org.opensearch.ml.common.contextmanager.ContextManagerContext;
import org.opensearch.ml.common.contextmanager.MessageCountExceedRule;
import org.opensearch.ml.common.contextmanager.TokensExceedRule;

public class ActivationRuleFactory {
    @Generated
    private static final Logger log = LogManager.getLogger(ActivationRuleFactory.class);
    public static final String TOKENS_EXCEED_KEY = "tokens_exceed";
    public static final String MESSAGE_COUNT_EXCEED_KEY = "message_count_exceed";

    public static List<ActivationRule> createRules(Map<String, Object> activationConfig) {
        ArrayList<ActivationRule> rules = new ArrayList<ActivationRule>();
        if (activationConfig == null || activationConfig.isEmpty()) {
            return rules;
        }
        if (activationConfig.containsKey(TOKENS_EXCEED_KEY)) {
            try {
                Object tokenValue = activationConfig.get(TOKENS_EXCEED_KEY);
                int tokenThreshold = ActivationRuleFactory.parseIntegerValue(tokenValue, TOKENS_EXCEED_KEY);
                if (tokenThreshold > 0) {
                    rules.add(new TokensExceedRule(tokenThreshold));
                    log.debug("Created TokensExceedRule with threshold: {}", (Object)tokenThreshold);
                } else {
                    log.warn("Invalid token threshold value: {}. Must be positive integer.", tokenValue);
                }
            }
            catch (Exception e) {
                log.error("Failed to create TokensExceedRule: {}", (Object)e.getMessage());
            }
        }
        if (activationConfig.containsKey(MESSAGE_COUNT_EXCEED_KEY)) {
            try {
                Object messageValue = activationConfig.get(MESSAGE_COUNT_EXCEED_KEY);
                int messageThreshold = ActivationRuleFactory.parseIntegerValue(messageValue, MESSAGE_COUNT_EXCEED_KEY);
                if (messageThreshold > 0) {
                    rules.add(new MessageCountExceedRule(messageThreshold));
                    log.debug("Created MessageCountExceedRule with threshold: {}", (Object)messageThreshold);
                } else {
                    log.warn("Invalid message count threshold value: {}. Must be positive integer.", messageValue);
                }
            }
            catch (Exception e) {
                log.error("Failed to create MessageCountExceedRule: {}", (Object)e.getMessage());
            }
        }
        return rules;
    }

    public static ActivationRule createCompositeRule(List<ActivationRule> rules) {
        if (rules == null || rules.isEmpty()) {
            return null;
        }
        if (rules.size() == 1) {
            return rules.get(0);
        }
        return new CompositeActivationRule(rules);
    }

    private static int parseIntegerValue(Object value, String fieldName) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid integer value for " + fieldName + ": " + String.valueOf(value));
            }
        }
        throw new IllegalArgumentException("Unsupported value type for " + fieldName + ": " + value.getClass().getSimpleName());
    }

    private static class CompositeActivationRule
    implements ActivationRule {
        private final List<ActivationRule> rules;

        public CompositeActivationRule(List<ActivationRule> rules) {
            this.rules = new ArrayList<ActivationRule>(rules);
        }

        @Override
        public boolean evaluate(ContextManagerContext context) {
            for (ActivationRule rule : this.rules) {
                if (rule.evaluate(context)) continue;
                return false;
            }
            return true;
        }

        @Override
        public String getDescription() {
            StringBuilder sb = new StringBuilder();
            sb.append("composite_rule: [");
            for (int i = 0; i < this.rules.size(); ++i) {
                if (i > 0) {
                    sb.append(" AND ");
                }
                sb.append(this.rules.get(i).getDescription());
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

