/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.cache;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import lombok.NonNull;
import org.apache.lucene.util.BytesRef;
import org.opensearch.neuralsearch.sparse.accessor.ClusteredPostingReader;
import org.opensearch.neuralsearch.sparse.accessor.ClusteredPostingWriter;
import org.opensearch.neuralsearch.sparse.codec.SparseTermsLuceneReader;
import org.opensearch.neuralsearch.sparse.data.PostingClusters;

public class CacheGatedPostingsReader
implements ClusteredPostingReader {
    private final String fieldName;
    private final ClusteredPostingReader cacheReader;
    private final ClusteredPostingWriter cacheWriter;
    private final SparseTermsLuceneReader luceneReader;

    public CacheGatedPostingsReader(@NonNull String fieldName, @NonNull ClusteredPostingReader cacheReader, @NonNull ClusteredPostingWriter cacheWriter, @NonNull SparseTermsLuceneReader luceneReader) {
        Objects.requireNonNull(fieldName, "fieldName is marked non-null but is null");
        Objects.requireNonNull(cacheReader, "cacheReader is marked non-null but is null");
        Objects.requireNonNull(cacheWriter, "cacheWriter is marked non-null but is null");
        Objects.requireNonNull(luceneReader, "luceneReader is marked non-null but is null");
        this.fieldName = fieldName;
        this.cacheReader = cacheReader;
        this.cacheWriter = cacheWriter;
        this.luceneReader = luceneReader;
    }

    @Override
    public PostingClusters read(BytesRef term) throws IOException {
        PostingClusters clusters = this.cacheReader.read(term);
        if (clusters != null) {
            return clusters;
        }
        clusters = this.luceneReader.read(this.fieldName, term);
        if (clusters != null) {
            this.cacheWriter.insert(term, clusters.getClusters());
        }
        return clusters;
    }

    @Override
    public Set<BytesRef> getTerms() {
        return this.luceneReader.getTerms(this.fieldName);
    }

    @Override
    public long size() {
        return this.luceneReader.getTerms(this.fieldName).size();
    }
}

