/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cat;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.Bytes;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch.cat.CatRequestBase;
import org.opensearch.client.opensearch.cat.PitSegmentsResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class PitSegmentsRequest
extends CatRequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, PitSegmentsRequest> {
    @Nullable
    private final Bytes bytes;
    @Nonnull
    private final List<String> pitId;
    public static final JsonpDeserializer<PitSegmentsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PitSegmentsRequest::setupPitSegmentsRequestDeserializer);
    public static final Endpoint<PitSegmentsRequest, PitSegmentsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PitSegmentsRequest, PitSegmentsResponse>(request -> "GET", request -> "/_cat/pit_segments", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, PitSegmentsResponse._DESERIALIZER);

    private PitSegmentsRequest(Builder builder) {
        super(builder);
        this.bytes = builder.bytes;
        this.pitId = ApiTypeHelper.unmodifiableRequired(builder.pitId, (Object)this, "pitId");
    }

    public static PitSegmentsRequest of(Function<Builder, ObjectBuilder<PitSegmentsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Bytes bytes() {
        return this.bytes;
    }

    @Nonnull
    public final List<String> pitId() {
        return this.pitId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("pit_id");
        generator.writeStartArray();
        for (String item0 : this.pitId) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupPitSegmentsRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::pitId, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "pit_id");
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.bytes != null) {
            params.put("bytes", this.bytes.jsonValue());
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.bytes);
        result = 31 * result + this.pitId.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PitSegmentsRequest other = (PitSegmentsRequest)o;
        return Objects.equals(this.bytes, other.bytes) && this.pitId.equals(other.pitId);
    }

    public static class Builder
    extends CatRequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, PitSegmentsRequest> {
        @Nullable
        private Bytes bytes;
        private List<String> pitId;

        public Builder() {
        }

        private Builder(PitSegmentsRequest o) {
            super(o);
            this.bytes = o.bytes;
            this.pitId = Builder._listCopy(o.pitId);
        }

        private Builder(Builder o) {
            super(o);
            this.bytes = o.bytes;
            this.pitId = Builder._listCopy(o.pitId);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        @Nonnull
        public final Builder pitId(List<String> list) {
            this.pitId = Builder._listAddAll(this.pitId, list);
            return this;
        }

        @Nonnull
        public final Builder pitId(String value, String ... values) {
            this.pitId = Builder._listAdd(this.pitId, value, values);
            return this;
        }

        @Override
        @Nonnull
        public PitSegmentsRequest build() {
            this._checkSingleUse();
            return new PitSegmentsRequest(this);
        }
    }
}

