/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilderBase;

public abstract class SuggesterBase
implements PlainJsonSerializable {
    @Nullable
    private final String analyzer;
    @Nonnull
    private final String field;
    @Nullable
    private final Integer size;

    protected SuggesterBase(AbstractBuilder<?> builder) {
        this.analyzer = ((AbstractBuilder)builder).analyzer;
        this.field = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).field, this, "field");
        this.size = ((AbstractBuilder)builder).size;
    }

    @Nullable
    public final String analyzer() {
        return this.analyzer;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        generator.writeKey("field");
        generator.write(this.field);
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupSuggesterBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer");
        op.add(AbstractBuilder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(AbstractBuilder::size, JsonpDeserializer.integerDeserializer(), "size");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.analyzer);
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Objects.hashCode(this.size);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SuggesterBase other = (SuggesterBase)o;
        return Objects.equals(this.analyzer, other.analyzer) && this.field.equals(other.field) && Objects.equals(this.size, other.size);
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends ObjectBuilderBase {
        @Nullable
        private String analyzer;
        private String field;
        @Nullable
        private Integer size;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(SuggesterBase o) {
            this.analyzer = o.analyzer;
            this.field = o.field;
            this.size = o.size;
        }

        protected AbstractBuilder(AbstractBuilder<BuilderT> o) {
            this.analyzer = o.analyzer;
            this.field = o.field;
            this.size = o.size;
        }

        @Nonnull
        protected abstract BuilderT self();

        @Nonnull
        public final BuilderT analyzer(@Nullable String value) {
            this.analyzer = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT field(String value) {
            this.field = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT size(@Nullable Integer value) {
            this.size = value;
            return this.self();
        }
    }
}

