/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.aggregation.bucketselectorext;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.alerting.aggregation.bucketselectorext.BucketSelectorExtAggregationBuilder;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.search.aggregations.InternalAggregation;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001:\u0001+BE\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u0012\u0018\u0010\b\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000b\u0010\u000fJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0003H\u0016J\u001e\u0010\u0019\u001a\u00020\u00002\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0014J\u0018\u0010\u001f\u001a\u00020\n2\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010!H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0004J\b\u0010(\u001a\u00020\u0007H\u0016J\u0013\u0010)\u001a\u00020\u001e2\b\u0010*\u001a\u0004\u0018\u00010\nH\u0096\u0002R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006,"}, d2={"Lorg/opensearch/commons/alerting/aggregation/bucketselectorext/BucketSelectorIndices;", "Lorg/opensearch/search/aggregations/InternalAggregation;", "name", "", "parentBucketPath", "bucketIndices", "", "", "metaData", "", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/Map;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getBucketIndices", "()Ljava/util/List;", "setBucketIndices", "(Ljava/util/List;)V", "doWriteTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "getWriteableName", "reduce", "aggregations", "reduceContext", "Lorg/opensearch/search/aggregations/InternalAggregation$ReduceContext;", "mustReduceOnSingleInternalAgg", "", "getProperty", "path", "", "doXContentBody", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "otherStatsToXContent", "hashCode", "equals", "other", "Fields", "common-utils"})
public class BucketSelectorIndices
extends InternalAggregation {
    @NotNull
    private String parentBucketPath;
    @NotNull
    private List<Integer> bucketIndices;

    @NotNull
    public final List<Integer> getBucketIndices() {
        return this.bucketIndices;
    }

    public final void setBucketIndices(@NotNull List<Integer> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.bucketIndices = list;
    }

    public BucketSelectorIndices(@Nullable String name, @NotNull String parentBucketPath, @NotNull List<Integer> bucketIndices, @Nullable Map<String, ? extends Object> metaData) {
        Intrinsics.checkNotNullParameter((Object)parentBucketPath, (String)"parentBucketPath");
        Intrinsics.checkNotNullParameter(bucketIndices, (String)"bucketIndices");
        super(name, metaData);
        this.parentBucketPath = parentBucketPath;
        this.bucketIndices = bucketIndices;
    }

    public BucketSelectorIndices(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        super(sin);
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        this.parentBucketPath = string;
        int[] nArray = sin.readIntArray();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"readIntArray(...)");
        this.bucketIndices = ArraysKt.asList((int[])nArray);
    }

    protected void doWriteTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.parentBucketPath);
        out.writeIntArray(this.bucketIndices.stream().mapToInt(arg_0 -> BucketSelectorIndices.doWriteTo$lambda$1(BucketSelectorIndices::doWriteTo$lambda$0, arg_0)).toArray());
    }

    @NotNull
    public String getWriteableName() {
        String string = BucketSelectorExtAggregationBuilder.Companion.getNAME().getPreferredName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPreferredName(...)");
        return string;
    }

    @NotNull
    public BucketSelectorIndices reduce(@NotNull List<? extends InternalAggregation> aggregations, @NotNull InternalAggregation.ReduceContext reduceContext) {
        Intrinsics.checkNotNullParameter(aggregations, (String)"aggregations");
        Intrinsics.checkNotNullParameter((Object)reduceContext, (String)"reduceContext");
        throw new UnsupportedOperationException("Not supported");
    }

    protected boolean mustReduceOnSingleInternalAgg() {
        return false;
    }

    @NotNull
    public Object getProperty(@Nullable List<String> path) {
        throw new UnsupportedOperationException("Not supported");
    }

    @NotNull
    public XContentBuilder doXContentBody(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) throws IOException {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.field("parent_bucket_path", this.parentBucketPath);
        builder.field("bucket_indices", (Iterable)this.bucketIndices);
        this.otherStatsToXContent(builder);
        return builder;
    }

    @NotNull
    protected final XContentBuilder otherStatsToXContent(@NotNull XContentBuilder builder) throws IOException {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        return builder;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{super.hashCode(), this.parentBucketPath};
        return Objects.hash(objectArray);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(((Object)((Object)this)).getClass(), other.getClass())) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        BucketSelectorIndices otherCast = (BucketSelectorIndices)((Object)other);
        return Intrinsics.areEqual((Object)this.name, (Object)otherCast.name) && Intrinsics.areEqual((Object)this.parentBucketPath, (Object)otherCast.parentBucketPath);
    }

    private static final int doWriteTo$lambda$0(Integer i) {
        Integer n = i;
        Intrinsics.checkNotNull((Object)n);
        return n;
    }

    private static final int doWriteTo$lambda$1(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/opensearch/commons/alerting/aggregation/bucketselectorext/BucketSelectorIndices$Fields;", "", "<init>", "()V", "PARENT_BUCKET_PATH", "", "BUCKET_INDICES", "common-utils"})
    public static final class Fields {
        @NotNull
        public static final Fields INSTANCE = new Fields();
        @NotNull
        public static final String PARENT_BUCKET_PATH = "parent_bucket_path";
        @NotNull
        public static final String BUCKET_INDICES = "bucket_indices";

        private Fields() {
        }
    }
}

