/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.transport;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.resolver.HostsFileEntriesResolver;
import io.netty.resolver.ResolvedAddressTypes;
import io.netty.resolver.dns.DnsAddressResolverGroup;
import io.netty.resolver.dns.DnsCache;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.resolver.dns.DnsNameResolverChannelStrategy;
import io.netty.resolver.dns.DnsQueryLifecycleObserverFactory;
import io.netty.resolver.dns.LoggingDnsQueryLifeCycleObserverFactory;
import io.netty.resolver.dns.RoundRobinDnsAddressResolverGroup;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import reactor.netty.resources.LoopResources;

public final class NameResolverProvider {
    final @Nullable Supplier<? extends @Nullable SocketAddress> bindAddressSupplier;
    final Duration cacheMaxTimeToLive;
    final Duration cacheMinTimeToLive;
    final Duration cacheNegativeTimeToLive;
    final boolean completeOncePreferredResolved;
    final DnsNameResolverChannelStrategy datagramChannelStrategy;
    final boolean disableOptionalRecord;
    final boolean disableRecursionDesired;
    final @Nullable Function<DnsNameResolverBuilder, DnsAddressResolverGroup> dnsAddressResolverGroupProvider;
    final @Nullable HostsFileEntriesResolver hostsFileEntriesResolver;
    final @Nullable DnsQueryLifecycleObserverFactory loggingFactory;
    final @Nullable LoopResources loopResources;
    final int maxPayloadSize;
    final int maxQueriesPerResolve;
    final int ndots;
    final boolean preferNative;
    final Duration queryTimeout;
    final @Nullable DnsCache resolveCache;
    final @Nullable ResolvedAddressTypes resolvedAddressTypes;
    final boolean retryTcpOnTimeout;
    final boolean roundRobinSelection;
    final @Nullable Iterable<String> searchDomains;

    public static NameResolverSpec builder() {
        return new Build();
    }

    public @Nullable Supplier<? extends @Nullable SocketAddress> bindAddressSupplier() {
        return this.bindAddressSupplier;
    }

    public Duration cacheMaxTimeToLive() {
        return this.cacheMaxTimeToLive;
    }

    public Duration cacheMinTimeToLive() {
        return this.cacheMinTimeToLive;
    }

    public Duration cacheNegativeTimeToLive() {
        return this.cacheNegativeTimeToLive;
    }

    public DnsNameResolverChannelStrategy datagramChannelStrategy() {
        return this.datagramChannelStrategy;
    }

    public @Nullable Function<DnsNameResolverBuilder, DnsAddressResolverGroup> dnsAddressResolverGroupProvider() {
        return this.dnsAddressResolverGroupProvider;
    }

    public @Nullable HostsFileEntriesResolver hostsFileEntriesResolver() {
        return this.hostsFileEntriesResolver;
    }

    public boolean isCompleteOncePreferredResolved() {
        return this.completeOncePreferredResolved;
    }

    public boolean isDisableOptionalRecord() {
        return this.disableOptionalRecord;
    }

    public boolean isDisableRecursionDesired() {
        return this.disableRecursionDesired;
    }

    public boolean isPreferNative() {
        return this.preferNative;
    }

    public boolean isRetryTcpOnTimeout() {
        return this.retryTcpOnTimeout;
    }

    public boolean isRoundRobinSelection() {
        return this.roundRobinSelection;
    }

    public @Nullable LoopResources loopResources() {
        return this.loopResources;
    }

    public int maxPayloadSize() {
        return this.maxPayloadSize;
    }

    public int maxQueriesPerResolve() {
        return this.maxQueriesPerResolve;
    }

    public int ndots() {
        return this.ndots;
    }

    public Duration queryTimeout() {
        return this.queryTimeout;
    }

    public @Nullable DnsCache resolveCache() {
        return this.resolveCache;
    }

    public @Nullable ResolvedAddressTypes resolvedAddressTypes() {
        return this.resolvedAddressTypes;
    }

    public @Nullable Iterable<String> searchDomains() {
        return this.searchDomains;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NameResolverProvider)) {
            return false;
        }
        NameResolverProvider that = (NameResolverProvider)o;
        return Objects.equals(this.bindAddressSupplier, that.bindAddressSupplier) && this.cacheMaxTimeToLive.equals(that.cacheMaxTimeToLive) && this.cacheMinTimeToLive.equals(that.cacheMinTimeToLive) && this.cacheNegativeTimeToLive.equals(that.cacheNegativeTimeToLive) && this.completeOncePreferredResolved == that.completeOncePreferredResolved && this.datagramChannelStrategy == that.datagramChannelStrategy && this.disableOptionalRecord == that.disableOptionalRecord && this.disableRecursionDesired == that.disableRecursionDesired && Objects.equals(this.dnsAddressResolverGroupProvider, that.dnsAddressResolverGroupProvider) && Objects.equals(this.loggingFactory, that.loggingFactory) && Objects.equals(this.loopResources, that.loopResources) && this.maxPayloadSize == that.maxPayloadSize && this.maxQueriesPerResolve == that.maxQueriesPerResolve && this.ndots == that.ndots && this.preferNative == that.preferNative && this.queryTimeout.equals(that.queryTimeout) && Objects.equals(this.resolveCache, that.resolveCache) && this.resolvedAddressTypes == that.resolvedAddressTypes && this.retryTcpOnTimeout == that.retryTcpOnTimeout && this.roundRobinSelection == that.roundRobinSelection && Objects.equals(this.searchDomains, that.searchDomains);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.bindAddressSupplier);
        result = 31 * result + Objects.hashCode(this.cacheMaxTimeToLive);
        result = 31 * result + Objects.hashCode(this.cacheMinTimeToLive);
        result = 31 * result + Objects.hashCode(this.cacheNegativeTimeToLive);
        result = 31 * result + Boolean.hashCode(this.completeOncePreferredResolved);
        result = 31 * result + Objects.hashCode(this.datagramChannelStrategy);
        result = 31 * result + Boolean.hashCode(this.disableOptionalRecord);
        result = 31 * result + Boolean.hashCode(this.disableRecursionDesired);
        result = 31 * result + Objects.hashCode(this.dnsAddressResolverGroupProvider);
        result = 31 * result + Objects.hashCode(this.loggingFactory);
        result = 31 * result + Objects.hashCode(this.loopResources);
        result = 31 * result + this.maxPayloadSize;
        result = 31 * result + this.maxQueriesPerResolve;
        result = 31 * result + this.ndots;
        result = 31 * result + Boolean.hashCode(this.preferNative);
        result = 31 * result + Objects.hashCode(this.queryTimeout);
        result = 31 * result + Objects.hashCode(this.resolveCache);
        result = 31 * result + Objects.hashCode(this.resolvedAddressTypes);
        result = 31 * result + Boolean.hashCode(this.retryTcpOnTimeout);
        result = 31 * result + Boolean.hashCode(this.roundRobinSelection);
        result = 31 * result + Objects.hashCode(this.searchDomains);
        return result;
    }

    public DnsAddressResolverGroup newNameResolverGroup(LoopResources defaultLoopResources, boolean defaultPreferNative) {
        EventLoopGroup group;
        LoopResources loop;
        Objects.requireNonNull(defaultLoopResources, "defaultLoopResources");
        if (this.loopResources == null) {
            loop = defaultLoopResources;
            group = loop.onClient(defaultPreferNative);
        } else {
            loop = this.loopResources;
            group = loop.onClient(this.preferNative);
        }
        DnsNameResolverBuilder builder = new DnsNameResolverBuilder().ttl(Math.toIntExact(this.cacheMinTimeToLive.getSeconds()), Math.toIntExact(this.cacheMaxTimeToLive.getSeconds())).negativeTtl(Math.toIntExact(this.cacheNegativeTimeToLive.getSeconds())).completeOncePreferredResolved(this.completeOncePreferredResolved).optResourceEnabled(!this.disableOptionalRecord).recursionDesired(!this.disableRecursionDesired).maxPayloadSize(this.maxPayloadSize).maxQueriesPerResolve(this.maxQueriesPerResolve).ndots(this.ndots).queryTimeoutMillis(this.queryTimeout.toMillis()).eventLoop(group.next()).datagramChannelStrategy(this.datagramChannelStrategy).datagramChannelFactory(() -> loop.onChannel(DatagramChannel.class, group)).socketChannelFactory(() -> loop.onChannel(SocketChannel.class, group), this.retryTcpOnTimeout);
        if (this.bindAddressSupplier != null) {
            builder.localAddress(this.bindAddressSupplier.get());
        }
        if (this.hostsFileEntriesResolver != null) {
            builder.hostsFileEntriesResolver(this.hostsFileEntriesResolver);
        }
        if (this.loggingFactory != null) {
            builder.dnsQueryLifecycleObserverFactory(this.loggingFactory);
        }
        if (this.resolveCache != null) {
            builder.resolveCache(this.resolveCache);
        }
        if (this.resolvedAddressTypes != null) {
            builder.resolvedAddressTypes(this.resolvedAddressTypes);
        }
        if (this.searchDomains != null) {
            builder.searchDomains(this.searchDomains);
        }
        if (this.dnsAddressResolverGroupProvider != null) {
            return this.dnsAddressResolverGroupProvider.apply(builder);
        }
        return this.roundRobinSelection ? new RoundRobinDnsAddressResolverGroup(builder) : new DnsAddressResolverGroup(builder);
    }

    NameResolverProvider(Build build) {
        this.bindAddressSupplier = build.bindAddressSupplier;
        this.cacheMaxTimeToLive = build.cacheMaxTimeToLive;
        this.cacheMinTimeToLive = build.cacheMinTimeToLive;
        this.cacheNegativeTimeToLive = build.cacheNegativeTimeToLive;
        this.completeOncePreferredResolved = build.completeOncePreferredResolved;
        this.datagramChannelStrategy = build.datagramChannelStrategy;
        this.disableOptionalRecord = build.disableOptionalRecord;
        this.disableRecursionDesired = build.disableRecursionDesired;
        this.dnsAddressResolverGroupProvider = build.dnsAddressResolverGroupProvider;
        this.hostsFileEntriesResolver = build.hostsFileEntriesResolver;
        this.loggingFactory = build.loggingFactory;
        this.loopResources = build.loopResources;
        this.maxPayloadSize = build.maxPayloadSize;
        this.maxQueriesPerResolve = build.maxQueriesPerResolve;
        this.ndots = build.ndots;
        this.preferNative = build.preferNative;
        this.queryTimeout = build.queryTimeout;
        this.resolveCache = build.resolveCache;
        this.resolvedAddressTypes = build.resolvedAddressTypes;
        this.retryTcpOnTimeout = build.retryTcpOnTimeout;
        this.roundRobinSelection = build.roundRobinSelection;
        this.searchDomains = build.searchDomains;
    }

    static final class Build
    implements NameResolverSpec {
        static final Duration DEFAULT_CACHE_MAX_TIME_TO_LIVE = Duration.ofSeconds(Integer.MAX_VALUE);
        static final Duration DEFAULT_CACHE_MIN_TIME_TO_LIVE = Duration.ofSeconds(0L);
        static final Duration DEFAULT_CACHE_NEGATIVE_TIME_TO_LIVE = Duration.ofSeconds(0L);
        static final boolean DEFAULT_COMPLETE_ONCE_PREFERRED_RESOLVED = true;
        static final DnsNameResolverChannelStrategy DEFAULT_DATAGRAM_CHANNEL_STRATEGY = DnsNameResolverChannelStrategy.ChannelPerResolver;
        static final int DEFAULT_MAX_PAYLOAD_SIZE = 4096;
        static final int DEFAULT_MAX_QUERIES_PER_RESOLVE = 16;
        static final int DEFAULT_NDOTS = -1;
        static final Duration DEFAULT_QUERY_TIMEOUT = Duration.ofSeconds(5L);
        @Nullable Supplier<? extends @Nullable SocketAddress> bindAddressSupplier;
        Duration cacheMaxTimeToLive = DEFAULT_CACHE_MAX_TIME_TO_LIVE;
        Duration cacheMinTimeToLive = DEFAULT_CACHE_MIN_TIME_TO_LIVE;
        Duration cacheNegativeTimeToLive = DEFAULT_CACHE_NEGATIVE_TIME_TO_LIVE;
        boolean completeOncePreferredResolved = true;
        DnsNameResolverChannelStrategy datagramChannelStrategy = DEFAULT_DATAGRAM_CHANNEL_STRATEGY;
        boolean disableOptionalRecord;
        boolean disableRecursionDesired;
        @Nullable Function<DnsNameResolverBuilder, DnsAddressResolverGroup> dnsAddressResolverGroupProvider;
        @Nullable HostsFileEntriesResolver hostsFileEntriesResolver;
        @Nullable DnsQueryLifecycleObserverFactory loggingFactory;
        @Nullable LoopResources loopResources;
        int maxPayloadSize = 4096;
        int maxQueriesPerResolve = 16;
        int ndots = -1;
        boolean preferNative = LoopResources.DEFAULT_NATIVE;
        Duration queryTimeout = DEFAULT_QUERY_TIMEOUT;
        @Nullable DnsCache resolveCache;
        @Nullable ResolvedAddressTypes resolvedAddressTypes;
        boolean retryTcpOnTimeout;
        boolean roundRobinSelection;
        @Nullable Iterable<String> searchDomains;

        Build() {
        }

        @Override
        public NameResolverSpec bindAddressSupplier(Supplier<? extends @Nullable SocketAddress> bindAddressSupplier) {
            Objects.requireNonNull(bindAddressSupplier, "bindAddressSupplier");
            this.bindAddressSupplier = bindAddressSupplier;
            return this;
        }

        @Override
        public NameResolverSpec cacheMaxTimeToLive(Duration cacheMaxTimeToLive) {
            this.cacheMaxTimeToLive = Objects.requireNonNull(cacheMaxTimeToLive);
            return this;
        }

        @Override
        public NameResolverSpec cacheMinTimeToLive(Duration cacheMinTimeToLive) {
            this.cacheMinTimeToLive = Objects.requireNonNull(cacheMinTimeToLive);
            return this;
        }

        @Override
        public NameResolverSpec cacheNegativeTimeToLive(Duration cacheNegativeTimeToLive) {
            this.cacheNegativeTimeToLive = Objects.requireNonNull(cacheNegativeTimeToLive);
            return this;
        }

        @Override
        public NameResolverSpec completeOncePreferredResolved(boolean enable) {
            this.completeOncePreferredResolved = enable;
            return this;
        }

        @Override
        public NameResolverSpec datagramChannelStrategy(DnsNameResolverChannelStrategy datagramChannelStrategy) {
            this.datagramChannelStrategy = Objects.requireNonNull(datagramChannelStrategy);
            return this;
        }

        @Override
        public NameResolverSpec disableOptionalRecord(boolean disable) {
            this.disableOptionalRecord = disable;
            return this;
        }

        @Override
        public NameResolverSpec disableRecursionDesired(boolean disable) {
            this.disableRecursionDesired = disable;
            return this;
        }

        @Override
        public NameResolverSpec dnsAddressResolverGroupProvider(Function<DnsNameResolverBuilder, DnsAddressResolverGroup> dnsAddressResolverGroupProvider) {
            this.dnsAddressResolverGroupProvider = Objects.requireNonNull(dnsAddressResolverGroupProvider);
            return this;
        }

        @Override
        public NameResolverSpec hostsFileEntriesResolver(HostsFileEntriesResolver hostsFileEntriesResolver) {
            this.hostsFileEntriesResolver = Objects.requireNonNull(hostsFileEntriesResolver);
            return this;
        }

        @Override
        public NameResolverSpec maxPayloadSize(int maxPayloadSize) {
            if (maxPayloadSize < 1) {
                throw new IllegalArgumentException("maxPayloadSize must be positive");
            }
            this.maxPayloadSize = maxPayloadSize;
            return this;
        }

        @Override
        public NameResolverSpec maxQueriesPerResolve(int maxQueriesPerResolve) {
            if (maxQueriesPerResolve < 1) {
                throw new IllegalArgumentException("maxQueriesPerResolve must be positive");
            }
            this.maxQueriesPerResolve = maxQueriesPerResolve;
            return this;
        }

        @Override
        public NameResolverSpec ndots(int ndots) {
            if (ndots < -1) {
                throw new IllegalArgumentException("ndots must be greater or equal to -1");
            }
            this.ndots = ndots;
            return this;
        }

        @Override
        public NameResolverSpec queryTimeout(Duration queryTimeout) {
            this.queryTimeout = Objects.requireNonNull(queryTimeout, "queryTimeout");
            return this;
        }

        @Override
        public NameResolverSpec resolveCache(DnsCache resolveCache) {
            this.resolveCache = Objects.requireNonNull(resolveCache);
            return this;
        }

        @Override
        public NameResolverSpec resolvedAddressTypes(ResolvedAddressTypes resolvedAddressTypes) {
            this.resolvedAddressTypes = Objects.requireNonNull(resolvedAddressTypes);
            return this;
        }

        @Override
        public NameResolverSpec retryTcpOnTimeout(boolean enable) {
            this.retryTcpOnTimeout = enable;
            return this;
        }

        @Override
        public NameResolverSpec roundRobinSelection(boolean enable) {
            this.roundRobinSelection = enable;
            return this;
        }

        @Override
        public NameResolverSpec runOn(EventLoopGroup eventLoopGroup) {
            Objects.requireNonNull(eventLoopGroup, "eventLoopGroup");
            return this.runOn((boolean preferNative) -> eventLoopGroup);
        }

        @Override
        public NameResolverSpec runOn(LoopResources loopResources) {
            Objects.requireNonNull(loopResources, "loopResources");
            return this.runOn(loopResources, LoopResources.DEFAULT_NATIVE);
        }

        @Override
        public NameResolverSpec runOn(LoopResources loopResources, boolean preferNative) {
            Objects.requireNonNull(loopResources, "loopResources");
            this.loopResources = loopResources;
            this.preferNative = preferNative;
            return this;
        }

        @Override
        public NameResolverSpec searchDomains(List<String> searchDomains) {
            this.searchDomains = Objects.requireNonNull(searchDomains, "searchDomains");
            return this;
        }

        @Override
        public NameResolverSpec trace(String category, LogLevel level) {
            Objects.requireNonNull(category, "category");
            Objects.requireNonNull(level, "level");
            this.loggingFactory = new LoggingDnsQueryLifeCycleObserverFactory(category, level);
            return this;
        }

        @Override
        public NameResolverProvider build() {
            return new NameResolverProvider(this);
        }
    }

    public static interface NameResolverSpec {
        public NameResolverSpec bindAddressSupplier(Supplier<? extends @Nullable SocketAddress> var1);

        public NameResolverProvider build();

        public NameResolverSpec cacheMaxTimeToLive(Duration var1);

        public NameResolverSpec cacheMinTimeToLive(Duration var1);

        public NameResolverSpec cacheNegativeTimeToLive(Duration var1);

        public NameResolverSpec completeOncePreferredResolved(boolean var1);

        public NameResolverSpec datagramChannelStrategy(DnsNameResolverChannelStrategy var1);

        public NameResolverSpec disableOptionalRecord(boolean var1);

        public NameResolverSpec disableRecursionDesired(boolean var1);

        public NameResolverSpec dnsAddressResolverGroupProvider(Function<DnsNameResolverBuilder, DnsAddressResolverGroup> var1);

        public NameResolverSpec hostsFileEntriesResolver(HostsFileEntriesResolver var1);

        public NameResolverSpec maxPayloadSize(int var1);

        public NameResolverSpec maxQueriesPerResolve(int var1);

        public NameResolverSpec ndots(int var1);

        public NameResolverSpec queryTimeout(Duration var1);

        public NameResolverSpec resolveCache(DnsCache var1);

        public NameResolverSpec resolvedAddressTypes(ResolvedAddressTypes var1);

        public NameResolverSpec retryTcpOnTimeout(boolean var1);

        public NameResolverSpec roundRobinSelection(boolean var1);

        public NameResolverSpec runOn(EventLoopGroup var1);

        public NameResolverSpec runOn(LoopResources var1);

        public NameResolverSpec runOn(LoopResources var1, boolean var2);

        public NameResolverSpec searchDomains(List<String> var1);

        public NameResolverSpec trace(String var1, LogLevel var2);
    }
}

