/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.http.netty4;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.TooLongHttpLineException;
import java.util.List;
import org.opensearch.ExceptionsHelper;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.http.netty4.HttpResponseHeadersFactory;
import org.opensearch.http.netty4.Netty4HttpRequest;

@ChannelHandler.Sharable
class Netty4Http3RequestCreator
extends MessageToMessageDecoder<FullHttpRequest> {
    private final ByteSizeValue maxInitialLineLength;
    private final HttpResponseHeadersFactory responseHeadersFactory;

    Netty4Http3RequestCreator(ByteSizeValue maxInitialLineLength, HttpResponseHeadersFactory responseHeadersFactory) {
        this.maxInitialLineLength = maxInitialLineLength;
        this.responseHeadersFactory = responseHeadersFactory;
    }

    protected void decode(ChannelHandlerContext ctx, FullHttpRequest msg, List<Object> out) {
        if (msg.decoderResult().isFailure()) {
            Exception nonError;
            Throwable cause = msg.decoderResult().cause();
            if (cause instanceof Error) {
                ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
                nonError = new Exception(cause);
            } else {
                nonError = (Exception)cause;
            }
            out.add(new Netty4HttpRequest(msg.retain(), nonError, this.responseHeadersFactory));
        } else if (msg.uri().length() > this.maxInitialLineLength.bytesAsInt()) {
            out.add(new Netty4HttpRequest(msg.retain(), (Exception)new TooLongHttpLineException("An HTTP line is larger than " + this.maxInitialLineLength.bytesAsInt() + " bytes."), this.responseHeadersFactory));
        } else {
            out.add(new Netty4HttpRequest(msg.retain(), this.responseHeadersFactory));
        }
    }
}

