/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.dialect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.config.NullCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCollectionTypeNameSpec;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlMapTypeNameSpec;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.dialect.MysqlSqlDialect;
import org.apache.calcite.sql.dialect.PostgresqlSqlDialect;
import org.apache.calcite.sql.fun.SqlArrayValueConstructor;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlMapValueConstructor;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.MapSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.RelToSqlConverterUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PrestoSqlDialect
extends SqlDialect {
    public static final RelDataTypeSystem TYPE_SYSTEM = new RelDataTypeSystemImpl(){

        @Override
        public int getMaxPrecision(SqlTypeName typeName) {
            switch (typeName) {
                case DECIMAL: {
                    return 38;
                }
            }
            return super.getMaxPrecision(typeName);
        }

        @Override
        public int getMaxScale(SqlTypeName typeName) {
            switch (typeName) {
                case DECIMAL: {
                    return 38;
                }
            }
            return super.getMaxScale(typeName);
        }

        @Override
        public int getMaxNumericScale() {
            return this.getMaxScale(SqlTypeName.DECIMAL);
        }
    };
    public static final SqlDialect.Context DEFAULT_CONTEXT = SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.PRESTO).withIdentifierQuoteString("\"").withUnquotedCasing(Casing.UNCHANGED).withNullCollation(NullCollation.LAST).withDataTypeSystem(TYPE_SYSTEM);
    public static final SqlDialect DEFAULT = new PrestoSqlDialect(DEFAULT_CONTEXT);

    public PrestoSqlDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public boolean supportsApproxCountDistinct() {
        return true;
    }

    @Override
    public boolean supportsCharSet() {
        return false;
    }

    @Override
    public boolean requiresAliasForFromItems() {
        return true;
    }

    @Override
    public boolean supportsTimestampPrecision() {
        return false;
    }

    @Override
    public void unparseOffsetFetch(SqlWriter writer, @Nullable SqlNode offset, @Nullable SqlNode fetch) {
        PrestoSqlDialect.unparseUsingLimit(writer, offset, fetch);
    }

    @Override
    public boolean supportsImplicitTypeCoercion(RexCall call) {
        RexNode rexNode = call.getOperands().get(0);
        return super.supportsImplicitTypeCoercion(call) && RexUtil.isLiteral(rexNode, false) && (rexNode.getType().getSqlTypeName() == SqlTypeName.VARCHAR || rexNode.getType().getSqlTypeName() == SqlTypeName.CHAR) && !SqlTypeUtil.isNumeric(call.type) && !SqlTypeUtil.isDate(call.type) && !SqlTypeUtil.isTimestamp(call.type);
    }

    private static void unparseUsingLimit(SqlWriter writer, @Nullable SqlNode offset, @Nullable SqlNode fetch) {
        Preconditions.checkArgument((fetch != null || offset != null ? 1 : 0) != 0);
        PrestoSqlDialect.unparseOffset(writer, offset);
        PrestoSqlDialect.unparseLimit(writer, fetch);
    }

    @Override
    public @Nullable SqlNode emulateNullDirection(SqlNode node, boolean nullsFirst, boolean desc) {
        return this.emulateNullDirectionWithIsNull(node, nullsFirst, desc);
    }

    @Override
    public boolean supportsAggregateFunction(SqlKind kind) {
        switch (kind) {
            case AVG: 
            case COUNT: 
            case CUBE: 
            case SUM: 
            case MIN: 
            case MAX: 
            case ROLLUP: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsGroupByWithCube() {
        return true;
    }

    @Override
    public boolean supportsNestedAggregations() {
        return false;
    }

    @Override
    public boolean supportsGroupByWithRollup() {
        return true;
    }

    @Override
    public SqlDialect.CalendarPolicy getCalendarPolicy() {
        return SqlDialect.CalendarPolicy.SHIFT;
    }

    @Override
    public @Nullable SqlNode getCastSpec(RelDataType type) {
        switch (type.getSqlTypeName()) {
            case FLOAT: {
                return new SqlDataTypeSpec(new SqlBasicTypeNameSpec(SqlTypeName.DOUBLE, SqlParserPos.ZERO), SqlParserPos.ZERO);
            }
            case BINARY: {
                return new SqlDataTypeSpec(new SqlBasicTypeNameSpec(SqlTypeName.VARBINARY, SqlParserPos.ZERO), SqlParserPos.ZERO);
            }
            case MAP: {
                MapSqlType mapSqlType = (MapSqlType)type;
                SqlDataTypeSpec keySpec = (SqlDataTypeSpec)this.getCastSpec(mapSqlType.getKeyType());
                SqlDataTypeSpec valueSpec = (SqlDataTypeSpec)this.getCastSpec(mapSqlType.getValueType());
                SqlDataTypeSpec nonNullkeySpec = Objects.requireNonNull(keySpec, "keySpec");
                SqlDataTypeSpec nonNullvalueSpec = Objects.requireNonNull(valueSpec, "valueSpec");
                SqlMapTypeNameSpec sqlMapTypeNameSpec = new SqlMapTypeNameSpec(nonNullkeySpec, nonNullvalueSpec, SqlParserPos.ZERO);
                return new SqlDataTypeSpec(sqlMapTypeNameSpec, SqlParserPos.ZERO);
            }
            case ARRAY: {
                ArraySqlType arraySqlType = (ArraySqlType)type;
                SqlDataTypeSpec arrayValueSpec = (SqlDataTypeSpec)this.getCastSpec(arraySqlType.getComponentType());
                SqlDataTypeSpec nonNullarrayValueSpec = Objects.requireNonNull(arrayValueSpec, "arrayValueSpec");
                SqlCollectionTypeNameSpec sqlArrayTypeNameSpec = new SqlCollectionTypeNameSpec(nonNullarrayValueSpec.getTypeNameSpec(), SqlTypeName.ARRAY, SqlParserPos.ZERO);
                return new SqlDataTypeSpec(sqlArrayTypeNameSpec, SqlParserPos.ZERO);
            }
            case MULTISET: {
                throw new UnsupportedOperationException("Presto dialect does not support cast to " + (Object)((Object)type.getSqlTypeName()));
            }
        }
        return super.getCastSpec(type);
    }

    @Override
    public RexNode prepareUnparse(RexNode rexNode) {
        return RelToSqlConverterUtil.unparseIsTrueOrFalse(rexNode);
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        if (call.getOperator() == SqlStdOperatorTable.SUBSTRING) {
            RelToSqlConverterUtil.specialOperatorByName("SUBSTR").unparse(writer, call, 0, 0);
        } else if (call.getOperator() == SqlStdOperatorTable.APPROX_COUNT_DISTINCT) {
            RelToSqlConverterUtil.specialOperatorByName("APPROX_DISTINCT").unparse(writer, call, 0, 0);
        } else {
            switch (call.getKind()) {
                case MAP_VALUE_CONSTRUCTOR: {
                    PrestoSqlDialect.unparseMapValue(writer, call, leftPrec, rightPrec);
                    break;
                }
                case IS_NULL: 
                case IS_NOT_NULL: {
                    if (call.operand(0) instanceof SqlBasicCall) {
                        SqlWriter.Frame frame = writer.startList("(", ")");
                        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
                        writer.endList(frame);
                        writer.print(call.getOperator().getName() + " ");
                        break;
                    }
                    super.unparseCall(writer, call, leftPrec, rightPrec);
                    break;
                }
                case CHAR_LENGTH: {
                    SqlCall lengthCall = SqlLibraryOperators.LENGTH.createCall(SqlParserPos.ZERO, call.getOperandList());
                    super.unparseCall(writer, lengthCall, leftPrec, rightPrec);
                    break;
                }
                case TRIM: {
                    RelToSqlConverterUtil.unparseTrimLR(writer, call, leftPrec, rightPrec);
                    break;
                }
                default: {
                    PostgresqlSqlDialect.DEFAULT.unparseCall(writer, call, leftPrec, rightPrec);
                }
            }
        }
    }

    @Override
    public void unparseSqlIntervalQualifier(SqlWriter writer, SqlIntervalQualifier qualifier, RelDataTypeSystem typeSystem) {
        MysqlSqlDialect.DEFAULT.unparseSqlIntervalQualifier(writer, qualifier, typeSystem);
    }

    public static void unparseMapValue(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        call = PrestoSqlDialect.convertMapValueCall(call);
        writer.keyword(call.getOperator().getName());
        SqlWriter.Frame frame = writer.startList("(", ")");
        for (SqlNode operand : call.getOperandList()) {
            writer.sep(",");
            operand.unparse(writer, leftPrec, rightPrec);
        }
        writer.endList(frame);
    }

    public static SqlCall convertMapValueCall(SqlCall call) {
        boolean unnestMap;
        boolean bl = unnestMap = call.operandCount() > 0 && (call.getOperandList().get(0) instanceof SqlLiteral || call.getOperandList().get(1) instanceof SqlLiteral);
        if (!unnestMap) {
            return call;
        }
        ArrayList keys = new ArrayList();
        ArrayList values = new ArrayList();
        for (int i = 0; i < call.operandCount(); ++i) {
            if (i % 2 == 0) {
                keys.add(call.operand(i));
                continue;
            }
            values.add(call.operand(i));
        }
        SqlParserPos pos = call.getParserPosition();
        return new SqlBasicCall((SqlOperator)new SqlMapValueConstructor(), (List<? extends SqlNode>)ImmutableList.of((Object)new SqlBasicCall((SqlOperator)new SqlArrayValueConstructor(), keys, pos), (Object)new SqlBasicCall((SqlOperator)new SqlArrayValueConstructor(), values, pos)), pos);
    }
}

