/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.collect.Maps;
import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.DelegatingScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.ast.PyAstElementVisitor;
import com.jetbrains.python.ast.impl.PyUtilCore;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyCompoundStatement;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStarImportElement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypeAliasStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PythonVisitorFilter;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.impl.LightNamedElement;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyVersionAwareTopLevelElementVisitor;
import com.jetbrains.python.psi.impl.PythonLanguageLevelPusher;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.impl.references.PyReferenceImpl;
import com.jetbrains.python.psi.impl.stubs.PyVersionSpecificStubBaseKt;
import com.jetbrains.python.psi.resolve.ImportedResolveResult;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.resolve.PyResolveProcessor;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.resolve.VariantsProcessor;
import com.jetbrains.python.psi.stubs.PyFileStub;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyFileImpl
extends PsiFileBase
implements PyFile,
PyExpression {
    @Nullable
    protected volatile PyType myType;
    private final Map<FutureFeature, Boolean> myFutureFeatures;
    @Nullable
    private volatile List<String> myDunderAll;
    private volatile boolean myDunderAllCalculated;
    @NotNull
    private volatile SoftReference<ExportedNameCache> myExportedNameCache = new SoftReference<Object>(null);
    @NotNull
    private final PsiModificationTracker myModificationTracker;
    private final Key<Set<PyFile>> PROCESSED_FILES = Key.create((String)"PyFileImpl.processDeclarations.processedFiles");

    protected void prioritizeNameRedefinitions(@NotNull List<PsiNamedElement> definitions, @NotNull TypeEvalContext typeEvalContext) {
        if (definitions == null) {
            PyFileImpl.$$$reportNull$$$0(0);
        }
        if (typeEvalContext == null) {
            PyFileImpl.$$$reportNull$$$0(1);
        }
        List grouped = StreamEx.of(definitions).groupRuns((e1, e2) -> PyiUtil.isOverload((PsiElement)e1, typeEvalContext) && e2 instanceof PyFunction).toList();
        definitions.clear();
        StreamEx.ofReversed((List)grouped).flatCollection(Function.identity()).into(definitions);
    }

    public PyFileImpl(FileViewProvider viewProvider) {
        this(viewProvider, PythonLanguage.getInstance());
    }

    public PyFileImpl(FileViewProvider viewProvider, Language language) {
        super(viewProvider, language);
        this.myFutureFeatures = new HashMap<FutureFeature, Boolean>();
        this.myModificationTracker = PsiModificationTracker.getInstance((Project)this.getProject());
    }

    @NotNull
    public FileType getFileType() {
        PythonFileType pythonFileType = PythonFileType.INSTANCE;
        if (pythonFileType == null) {
            PyFileImpl.$$$reportNull$$$0(2);
        }
        return pythonFileType;
    }

    public String toString() {
        return "PyFile:" + this.getName();
    }

    @Override
    public PyFunction findTopLevelFunction(@NotNull String name2) {
        if (name2 == null) {
            PyFileImpl.$$$reportNull$$$0(3);
        }
        return PyFileImpl.findByName(name2, this.getTopLevelFunctions());
    }

    @Override
    public PyClass findTopLevelClass(@NotNull String name2) {
        if (name2 == null) {
            PyFileImpl.$$$reportNull$$$0(4);
        }
        return PyFileImpl.findByName(name2, this.getTopLevelClasses());
    }

    @Override
    @Nullable
    public PyTargetExpression findTopLevelAttribute(@NotNull String name2) {
        if (name2 == null) {
            PyFileImpl.$$$reportNull$$$0(5);
        }
        return PyFileImpl.findByName(name2, this.getTopLevelAttributes());
    }

    @Override
    @NotNull
    public List<PyTypeAliasStatement> getTypeAliasStatements() {
        return this.collectChildren(PyTypeAliasStatement.class);
    }

    @Override
    @Nullable
    public PyTypeAliasStatement findTypeAliasStatement(@NotNull String name2) {
        if (name2 == null) {
            PyFileImpl.$$$reportNull$$$0(6);
        }
        return PyFileImpl.findByName(name2, this.getTypeAliasStatements());
    }

    @Nullable
    private static <T extends PsiNamedElement> T findByName(@NotNull String name2, @NotNull List<T> namedElements) {
        if (name2 == null) {
            PyFileImpl.$$$reportNull$$$0(7);
        }
        if (namedElements == null) {
            PyFileImpl.$$$reportNull$$$0(8);
        }
        for (PsiNamedElement namedElement : namedElements) {
            if (!name2.equals(namedElement.getName())) continue;
            return (T)namedElement;
        }
        return null;
    }

    @Override
    public LanguageLevel getLanguageLevel() {
        return PythonLanguageLevelPusher.getLanguageLevelForFile(this);
    }

    public Icon getIcon(int flags) {
        return PythonFileType.INSTANCE.getIcon();
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PyFileImpl.$$$reportNull$$$0(9);
        }
        if (this.isAcceptedFor((Class)visitor2.getClass())) {
            if (visitor2 instanceof PyElementVisitor) {
                PyElementVisitor pyVisitor = (PyElementVisitor)visitor2;
                pyVisitor.visitPyFile(this);
            } else if (visitor2 instanceof PyAstElementVisitor) {
                PyAstElementVisitor pyVisitor = (PyAstElementVisitor)visitor2;
                pyVisitor.visitPyFile(this);
            } else {
                super.accept(visitor2);
            }
        }
    }

    public boolean isAcceptedFor(@NotNull Class visitorClass) {
        if (visitorClass == null) {
            PyFileImpl.$$$reportNull$$$0(10);
        }
        for (Language lang : this.getViewProvider().getLanguages()) {
            List filters = PythonVisitorFilter.INSTANCE.allForLanguage(lang);
            for (PythonVisitorFilter filter : filters) {
                if (filter.isSupported(visitorClass, this)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState resolveState, PsiElement lastParent, @NotNull PsiElement place) {
        List<String> dunderAll;
        if (processor2 == null) {
            PyFileImpl.$$$reportNull$$$0(11);
        }
        if (resolveState == null) {
            PyFileImpl.$$$reportNull$$$0(12);
        }
        if (place == null) {
            PyFileImpl.$$$reportNull$$$0(13);
        }
        final ArrayList<String> remainingDunderAll = (dunderAll = this.getDunderAll()) == null ? null : new ArrayList<String>(dunderAll);
        DelegatingScopeProcessor wrapper2 = new DelegatingScopeProcessor(processor2){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state2) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!super.execute(element, state2)) {
                    return false;
                }
                if (remainingDunderAll != null && element instanceof PyElement) {
                    remainingDunderAll.remove(((PyElement)element).getName());
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/psi/impl/PyFileImpl$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        HashSet<PyFileImpl> pyFiles = (HashSet<PyFileImpl>)resolveState.get(this.PROCESSED_FILES);
        if (pyFiles == null) {
            pyFiles = new HashSet<PyFileImpl>();
            resolveState = resolveState.put(this.PROCESSED_FILES, pyFiles);
        }
        if (pyFiles.contains(this)) {
            return true;
        }
        pyFiles.add(this);
        for (PyClass pyClass : this.getTopLevelClasses()) {
            if (pyClass == lastParent || wrapper2.execute((PsiElement)pyClass, resolveState)) continue;
            return false;
        }
        for (PyFunction pyFunction : this.getTopLevelFunctions()) {
            if (pyFunction == lastParent || wrapper2.execute((PsiElement)pyFunction, resolveState)) continue;
            return false;
        }
        for (PyTargetExpression pyTargetExpression : this.getTopLevelAttributes()) {
            if (pyTargetExpression == lastParent || wrapper2.execute((PsiElement)pyTargetExpression, resolveState)) continue;
            return false;
        }
        for (PyImportElement pyImportElement : this.getImportTargets()) {
            if (pyImportElement == lastParent || wrapper2.execute((PsiElement)pyImportElement, resolveState)) continue;
            return false;
        }
        for (PyFromImportStatement pyFromImportStatement : this.getFromImports()) {
            if (pyFromImportStatement == lastParent || pyFromImportStatement.processDeclarations((PsiScopeProcessor)wrapper2, resolveState, null, (PsiElement)this)) continue;
            return false;
        }
        if (remainingDunderAll != null) {
            for (String string : remainingDunderAll) {
                if (!PyNames.isIdentifier(string) || processor2.execute((PsiElement)new LightNamedElement((PsiManager)this.myManager, PythonLanguage.getInstance(), string), resolveState)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @NotNull
    public List<PyClass> getTopLevelClasses() {
        return this.collectChildren(PyClass.class);
    }

    @Override
    @NotNull
    public List<PyFunction> getTopLevelFunctions() {
        return this.collectChildren(PyFunction.class);
    }

    @Override
    public List<PyTargetExpression> getTopLevelAttributes() {
        return this.collectChildren(PyTargetExpression.class);
    }

    @Override
    @Nullable
    public PsiElement findExportedName(String name2) {
        PsiElement element;
        List<RatedResolveResult> results = this.multiResolveName(name2);
        ArrayList<PyImportedNameDefiner> elements = new ArrayList<PyImportedNameDefiner>();
        for (RatedResolveResult result2 : results) {
            PsiElement element2 = result2.getElement();
            ImportedResolveResult importedResult = PyUtil.as(result2, ImportedResolveResult.class);
            if (importedResult != null) {
                PyImportedNameDefiner definer = importedResult.getDefiner();
                if (definer == null) continue;
                elements.add(definer);
                continue;
            }
            if (element2 == null || element2.getContainingFile() != this) continue;
            elements.add((PyImportedNameDefiner)element2);
        }
        PsiElement psiElement = element = elements.isEmpty() ? null : (PsiElement)elements.get(elements.size() - 1);
        if (element != null && !element.isValid()) {
            throw new PsiInvalidElementAccessException(element);
        }
        return element;
    }

    @Override
    @NotNull
    public List<RatedResolveResult> multiResolveName(@NotNull String name2) {
        if (name2 == null) {
            PyFileImpl.$$$reportNull$$$0(14);
        }
        List<RatedResolveResult> list = this.multiResolveName(name2, true);
        if (list == null) {
            PyFileImpl.$$$reportNull$$$0(15);
        }
        return list;
    }

    @Override
    @NotNull
    public List<RatedResolveResult> multiResolveName(@NotNull String name2, boolean exported) {
        List results;
        if (name2 == null) {
            PyFileImpl.$$$reportNull$$$0(16);
        }
        if ((results = (List)RecursionManager.doPreventingRecursion((Object)this, (boolean)false, () -> this.getExportedNameCache().multiResolve(name2))) != null && !results.isEmpty()) {
            List list = results;
            if (list == null) {
                PyFileImpl.$$$reportNull$$$0(17);
            }
            return list;
        }
        List<String> allNames = this.getDunderAll();
        if (allNames != null && !name2.contains(".") && allNames.contains(name2)) {
            ResolveResultList allFallbackResults = new ResolveResultList();
            PyResolveImportUtil.resolveModuleAt(QualifiedName.fromComponents((String[])new String[]{name2}), (PsiFileSystemItem)this.getContainingDirectory(), PyResolveImportUtil.fromFoothold((PsiElement)this)).forEach(module2 -> allFallbackResults.poke((PsiElement)module2, -1000));
            PsiElement allElement = this.findExportedName("__all__");
            allFallbackResults.poke(allElement, -1000);
            ResolveResultList resolveResultList = allFallbackResults;
            if (resolveResultList == null) {
                PyFileImpl.$$$reportNull$$$0(18);
            }
            return resolveResultList;
        }
        List<RatedResolveResult> list = Collections.emptyList();
        if (list == null) {
            PyFileImpl.$$$reportNull$$$0(19);
        }
        return list;
    }

    private ExportedNameCache getExportedNameCache() {
        ExportedNameCache cache = this.myExportedNameCache.get();
        long modificationStamp = this.getModificationStamp();
        if (cache != null && modificationStamp != cache.getModificationStamp()) {
            this.myExportedNameCache.clear();
            cache = null;
        }
        if (cache == null) {
            cache = new ExportedNameCache(modificationStamp);
            this.myExportedNameCache = new SoftReference<ExportedNameCache>(cache);
        }
        return cache;
    }

    @Override
    @Nullable
    public PsiElement getElementNamed(String name2) {
        PsiElement element;
        List<RatedResolveResult> results = this.multiResolveName(name2);
        List<PsiElement> elements = PyUtil.filterTopPriorityElements(results);
        PsiElement psiElement = element = elements.isEmpty() ? null : elements.get(elements.size() - 1);
        if (element != null) {
            if (!element.isValid()) {
                throw new PsiInvalidElementAccessException(element);
            }
            return element;
        }
        return null;
    }

    @Override
    @NotNull
    public Iterable<PyElement> iterateNames() {
        final ArrayList<PyElement> result2 = new ArrayList<PyElement>();
        VariantsProcessor processor2 = new VariantsProcessor((PsiElement)this){

            @Override
            protected void addElement(@NotNull String name2, @NotNull PsiElement element) {
                if (name2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (element == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((element = PyUtil.turnDirIntoInit(element)) instanceof PyElement) {
                    result2.add((PyElement)element);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/psi/impl/PyFileImpl$2";
                objectArray[2] = "addElement";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        processor2.setAllowedNames(this.getDunderAll());
        this.processDeclarations(processor2, ResolveState.initial(), null, (PsiElement)this);
        ArrayList<PyElement> arrayList = result2;
        if (arrayList == null) {
            PyFileImpl.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<PyImportElement> getImportTargets() {
        ArrayList<PyImportElement> ret = new ArrayList<PyImportElement>();
        List<PyImportStatement> imports = this.collectChildren(PyImportStatement.class);
        for (PyImportStatement one : imports) {
            ContainerUtil.addAll(ret, (Object[])one.getImportElements());
        }
        ArrayList<PyImportElement> arrayList = ret;
        if (arrayList == null) {
            PyFileImpl.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<PyFromImportStatement> getFromImports() {
        return this.collectChildren(PyFromImportStatement.class);
    }

    @Override
    @Nullable
    public List<String> getDunderAll() {
        return (List)this.withGreenStubOrAst(PyFileStub.class, stub -> stub.getDunderAll(), ast -> {
            if (!this.myDunderAllCalculated) {
                List<String> dunderAll = this.calculateDunderAll();
                this.myDunderAll = dunderAll == null ? null : Collections.unmodifiableList(dunderAll);
                this.myDunderAllCalculated = true;
            }
            return this.myDunderAll;
        });
    }

    @Nullable
    public List<String> calculateDunderAll() {
        DunderAllBuilder builder = new DunderAllBuilder();
        this.accept(builder);
        return builder.result();
    }

    @Override
    public boolean hasImportFromFuture(FutureFeature feature) {
        return (Boolean)this.withGreenStubOrAst(PyFileStub.class, stub -> stub.getFutureFeatures().get(feature.ordinal()), ast -> {
            Boolean enabled = this.myFutureFeatures.get((Object)feature);
            if (enabled == null) {
                enabled = this.calculateImportFromFuture(feature);
                this.myFutureFeatures.put(feature, enabled);
            }
            return enabled;
        });
    }

    @Override
    public String getDeprecationMessage() {
        return (String)this.withGreenStubOrAst(PyFileStub.class, stub -> stub.getDeprecationMessage(), ast -> this.extractDeprecationMessage());
    }

    @Override
    public List<PyImportStatementBase> getImportBlock() {
        ArrayList<PyImportStatementBase> result2 = new ArrayList<PyImportStatementBase>();
        PsiElement firstChild = this.getFirstChild();
        PsiElement currentStatement = firstChild instanceof PyImportStatementBase ? firstChild : PsiTreeUtil.getNextSiblingOfType((PsiElement)firstChild, PyImportStatementBase.class);
        if (currentStatement != null) {
            ArrayList<PyImportStatementBase> fromFuture = new ArrayList<PyImportStatementBase>();
            while (currentStatement instanceof PyFromImportStatement && ((PyFromImportStatement)currentStatement).isFromFuture()) {
                fromFuture.add((PyImportStatementBase)currentStatement);
                currentStatement = PyPsiUtils.getNextNonCommentSibling(currentStatement, true);
            }
            boolean hasModuleLevelDunders = false;
            while (PyUtilCore.isAssignmentToModuleLevelDunderName(currentStatement)) {
                hasModuleLevelDunders = true;
                currentStatement = PyPsiUtils.getNextNonCommentSibling(currentStatement, true);
            }
            if (!hasModuleLevelDunders) {
                result2.addAll(fromFuture);
            }
            while (currentStatement instanceof PyImportStatementBase) {
                result2.add((PyImportStatementBase)currentStatement);
                currentStatement = PyPsiUtils.getNextNonCommentSibling(currentStatement, true);
            }
        }
        return result2;
    }

    public String extractDeprecationMessage() {
        if (PyFileImpl.canHaveDeprecationMessage(this.getText())) {
            return PyFunction.extractDeprecationMessage(this.getStatements());
        }
        return null;
    }

    private static boolean canHaveDeprecationMessage(String text) {
        return text.contains("DeprecationWarning") || text.contains("PendingDeprecationWarning");
    }

    public boolean calculateImportFromFuture(FutureFeature feature) {
        if (this.getText().contains(feature.toString())) {
            List<PyFromImportStatement> fromImports = this.getFromImports();
            for (PyFromImportStatement fromImport : fromImports) {
                PyImportElement[] pyImportElements;
                if (!fromImport.isFromFuture()) continue;
                for (PyImportElement element : pyImportElements = fromImport.getImportElements()) {
                    QualifiedName qName = element.getImportedQName();
                    if (qName == null || !qName.matches(new String[]{feature.toString()})) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    @Nullable
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            PyFileImpl.$$$reportNull$$$0(22);
        }
        if (key == null) {
            PyFileImpl.$$$reportNull$$$0(23);
        }
        if (this.myType == null) {
            this.myType = new PyModuleType(this);
        }
        return this.myType;
    }

    @Override
    @Nullable
    public StructuredDocString getStructuredDocString() {
        return DocStringUtil.getStructuredDocString(this);
    }

    public void clearCaches() {
        super.clearCaches();
        ControlFlowCache.clear(this);
        this.myDunderAllCalculated = false;
        this.myFutureFeatures.clear();
        this.myExportedNameCache.clear();
    }

    public void delete() throws IncorrectOperationException {
        String path2 = this.getVirtualFile().getPath();
        super.delete();
        PyUtil.deletePycFiles(path2);
    }

    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            PyFileImpl.$$$reportNull$$$0(24);
        }
        String path2 = this.getVirtualFile().getPath();
        PsiElement newElement = super.setName(name2);
        PyUtil.deletePycFiles(path2);
        return newElement;
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return 3.getModuleName(PyFileImpl.this);
            }

            public String getLocationString() {
                String name2 = this.getLocationName();
                return name2 != null ? "(" + name2 + ")" : null;
            }

            public Icon getIcon(boolean open2) {
                if (PyUtil.isPackage(PyFileImpl.this)) {
                    return AllIcons.Nodes.Package;
                }
                return PyFileImpl.this.getIcon(0);
            }

            @NotNull
            private static String getModuleName(@NotNull PyFile file) {
                PsiDirectory dir;
                if (file == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (PyUtil.isPackage(file) && (dir = file.getContainingDirectory()) != null) {
                    String string = dir.getName();
                    if (string == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                String string = FileUtilRt.getNameWithoutExtension((String)file.getName());
                if (string == null) {
                    3.$$$reportNull$$$0(2);
                }
                return string;
            }

            @Nullable
            private String getLocationName() {
                QualifiedName prefix;
                QualifiedName name2 = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)PyFileImpl.this);
                if (name2 != null && (prefix = name2.removeTail(1)).getComponentCount() > 0) {
                    return prefix.toString();
                }
                String relativePath = this.getRelativeContainerPath();
                if (relativePath != null) {
                    return relativePath;
                }
                PsiDirectory psiDirectory = PyFileImpl.this.getParent();
                if (psiDirectory != null) {
                    return psiDirectory.getVirtualFile().getPresentableUrl();
                }
                return null;
            }

            @Nullable
            private String getRelativeContainerPath() {
                VirtualFile root;
                VirtualFile virtualFile;
                PsiDirectory psiDirectory = PyFileImpl.this.getParent();
                if (psiDirectory != null && (virtualFile = PyFileImpl.this.getVirtualFile()) != null && (root = ProjectFileIndex.getInstance((Project)PyFileImpl.this.getProject()).getContentRootForFile(virtualFile)) != null) {
                    VirtualFile parent = virtualFile.getParent();
                    VirtualFile rootParent = root.getParent();
                    if (rootParent != null && parent != null) {
                        return VfsUtilCore.getRelativePath((VirtualFile)parent, (VirtualFile)rootParent, (char)File.separatorChar);
                    }
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/psi/impl/PyFileImpl$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/psi/impl/PyFileImpl$3";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getModuleName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getModuleName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    private <T extends PyElement> List<T> collectChildren(final Class<T> type2) {
        @Nullable StubElement stub = this.getGreenStub();
        @NotNull LanguageLevel languageLevel = PythonLanguageLevelPusher.getLanguageLevelForFile(this);
        final ArrayList<PyElement> result2 = new ArrayList<PyElement>();
        if (stub != null) {
            for (StubElement<?> child : PyVersionSpecificStubBaseKt.getChildrenStubs(stub, languageLevel)) {
                PsiElement childPsi = child.getPsi();
                if (!type2.isInstance(childPsi)) continue;
                result2.add((PyElement)type2.cast(childPsi));
            }
        } else {
            this.acceptChildren(new PyVersionAwareTopLevelElementVisitor(languageLevel){

                @Override
                protected void checkAddElement(PsiElement node) {
                    if (type2.isInstance(node)) {
                        result2.add((PyElement)type2.cast(node));
                    }
                }

                @Override
                public void visitPyStatement(@NotNull PyStatement node) {
                    if (node == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (PyStatement.class.isAssignableFrom(type2) && !(node instanceof PyCompoundStatement)) {
                        this.checkAddElement((PsiElement)node);
                        return;
                    }
                    super.visitPyStatement(node);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/psi/impl/PyFileImpl$4", "visitPyStatement"));
                }
            });
        }
        ArrayList<PyElement> arrayList = result2;
        if (arrayList == null) {
            PyFileImpl.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiElement> collectAllChildren(@NotNull PsiElement element, @Nullable StubElement<?> stub, @NotNull LanguageLevel languageLevel) {
        if (element == null) {
            PyFileImpl.$$$reportNull$$$0(26);
        }
        if (languageLevel == null) {
            PyFileImpl.$$$reportNull$$$0(27);
        }
        final ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        if (stub != null) {
            for (StubElement<?> child : PyVersionSpecificStubBaseKt.getChildrenStubs(stub, languageLevel)) {
                result2.add(child.getPsi());
            }
        } else {
            element.acceptChildren((PsiElementVisitor)new PyVersionAwareTopLevelElementVisitor(languageLevel){

                @Override
                protected void checkAddElement(PsiElement node) {
                    result2.add(node);
                }
            });
        }
        ArrayList<PsiElement> arrayList = result2;
        if (arrayList == null) {
            PyFileImpl.$$$reportNull$$$0(28);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 15, 17, 18, 19, 20, 21, 25, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeEvalContext";
                break;
            }
            case 2: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyFileImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 16: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElements";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitorClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveState";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyFileImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateNames";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportTargets";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "collectChildren";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAllChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prioritizeNameRedefinitions";
                break;
            }
            case 2: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 28: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findTopLevelFunction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findTopLevelClass";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findTopLevelAttribute";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findTypeAliasStatement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findByName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptedFor";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveName";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "collectAllChildren";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 15, 17, 18, 19, 20, 21, 25, 28 -> new IllegalStateException(string);
        };
    }

    private final class ExportedNameCache {
        private final Set<String> myNameDefinerNegativeCache = new HashSet<String>();
        private long myNameDefinerOOCBModCount = -1L;
        private final long myModificationStamp;
        private final Map<String, List<PsiNamedElement>> myNamedElements = Maps.newHashMap();
        private final List<PyImportedNameDefiner> myImportedNameDefiners = new ArrayList<PyImportedNameDefiner>();

        private ExportedNameCache(long modificationStamp) {
            this.myModificationStamp = modificationStamp;
            StubElement stub = PyFileImpl.this.getStub();
            LanguageLevel languageLevel = PythonLanguageLevelPusher.getLanguageLevelForFile(PyFileImpl.this);
            ExportedNameCache.processDeclarations((PsiElement)PyFileImpl.this, stub, languageLevel, (Processor<? super PsiElement>)((Processor)element -> {
                if (element instanceof PsiNamedElement) {
                    PsiNamedElement namedElement = (PsiNamedElement)element;
                    if (!(element instanceof PyKeywordArgument || stub == null && element.getParent() instanceof PyImportElement)) {
                        this.myNamedElements.computeIfAbsent(namedElement.getName(), __ -> new ArrayList()).add(namedElement);
                    }
                }
                if (element instanceof PyImportedNameDefiner) {
                    this.myImportedNameDefiners.add((PyImportedNameDefiner)element);
                }
                if (element instanceof PyFromImportStatement) {
                    PyFromImportStatement fromImportStatement = (PyFromImportStatement)element;
                    PyStarImportElement starImportElement = fromImportStatement.getStarImportElement();
                    if (starImportElement != null) {
                        this.myImportedNameDefiners.add(starImportElement);
                    } else {
                        Collections.addAll(this.myImportedNameDefiners, fromImportStatement.getImportElements());
                    }
                } else if (element instanceof PyImportStatement) {
                    PyImportStatement importStatement = (PyImportStatement)element;
                    Collections.addAll(this.myImportedNameDefiners, importStatement.getImportElements());
                }
                return true;
            }));
            TypeEvalContext typeEvalContext = TypeEvalContext.codeInsightFallback(PyFileImpl.this.getProject());
            for (List<PsiNamedElement> elements : this.myNamedElements.values()) {
                PyFileImpl.this.prioritizeNameRedefinitions(elements, typeEvalContext);
            }
            Collections.reverse(this.myImportedNameDefiners);
        }

        private static boolean processDeclarations(@NotNull PsiElement element, @Nullable StubElement<?> stub, @NotNull LanguageLevel languageLevel, @NotNull Processor<? super PsiElement> processor2) {
            if (element == null) {
                ExportedNameCache.$$$reportNull$$$0(0);
            }
            if (languageLevel == null) {
                ExportedNameCache.$$$reportNull$$$0(1);
            }
            if (processor2 == null) {
                ExportedNameCache.$$$reportNull$$$0(2);
            }
            for (PsiElement child : PyFileImpl.collectAllChildren(element, stub, languageLevel)) {
                PyExceptPart part;
                if (!processor2.process((Object)child)) {
                    return false;
                }
                if (!(child instanceof PyExceptPart) || ExportedNameCache.processDeclarations(part = (PyExceptPart)child, part.getStub(), languageLevel, processor2)) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        private List<RatedResolveResult> multiResolve(@NotNull String name2) {
            Iterator<Map.Entry<PsiElement, PyImportedNameDefiner>> iterator;
            TypeEvalContext typeEvalContext;
            ResolveResultList resultList;
            Map<PsiElement, PyImportedNameDefiner> results;
            if (name2 == null) {
                ExportedNameCache.$$$reportNull$$$0(3);
            }
            Set<String> set = this.myNameDefinerNegativeCache;
            synchronized (set) {
                long modCount = PyFileImpl.this.myModificationTracker.getModificationCount();
                if (modCount != this.myNameDefinerOOCBModCount) {
                    this.myNameDefinerNegativeCache.clear();
                    this.myNameDefinerOOCBModCount = modCount;
                } else if (this.myNameDefinerNegativeCache.contains(name2)) {
                    List<RatedResolveResult> list = Collections.emptyList();
                    // MONITOREXIT @DISABLED, blocks:[16, 17, 3] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                    if (list == null) {
                        ExportedNameCache.$$$reportNull$$$0(4);
                    }
                    return list;
                }
            }
            PyResolveProcessor processor2 = new PyResolveProcessor(name2);
            boolean stopped = false;
            if (this.myNamedElements.containsKey(name2)) {
                for (PsiNamedElement element : this.myNamedElements.get(name2)) {
                    if (processor2.execute((PsiElement)element, ResolveState.initial())) continue;
                    stopped = true;
                    break;
                }
            }
            if (!stopped) {
                for (PyImportedNameDefiner definer : this.myImportedNameDefiners) {
                    if (!processor2.execute((PsiElement)definer, ResolveState.initial())) break;
                }
            }
            if (!(results = processor2.getResults()).isEmpty()) {
                resultList = new ResolveResultList();
                typeEvalContext = TypeEvalContext.codeInsightFallback(PyFileImpl.this.getProject());
                iterator = results.entrySet().iterator();
            } else {
                Set<String> set2 = this.myNameDefinerNegativeCache;
                synchronized (set2) {
                    this.myNameDefinerNegativeCache.add(name2);
                }
                List<RatedResolveResult> list = Collections.emptyList();
                if (list == null) {
                    ExportedNameCache.$$$reportNull$$$0(6);
                }
                return list;
            }
            while (iterator.hasNext()) {
                Map.Entry<PsiElement, PyImportedNameDefiner> entry = iterator.next();
                PsiElement element = entry.getKey();
                PyImportedNameDefiner definer = entry.getValue();
                if (element == null) continue;
                int elementRate = PyReferenceImpl.getRate(element, typeEvalContext);
                if (definer != null) {
                    resultList.add(new ImportedResolveResult(element, elementRate, definer));
                    continue;
                }
                resultList.poke(element, elementRate);
            }
            ResolveResultList resolveResultList = resultList;
            if (resolveResultList == null) {
                ExportedNameCache.$$$reportNull$$$0(5);
            }
            return resolveResultList;
        }

        public long getModificationStamp() {
            return this.myModificationStamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageLevel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/impl/PyFileImpl$ExportedNameCache";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/impl/PyFileImpl$ExportedNameCache";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "multiResolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "processDeclarations";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "multiResolve";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    private static class DunderAllBuilder
    extends PyRecursiveElementVisitor {
        @NotNull
        private final List<String> myResult = new ArrayList<String>();
        private boolean myDynamic = false;
        private boolean myFoundDunderAll = false;
        @NotNull
        private final Map<String, List<String>> myDunderLike = new HashMap<String, List<String>>();

        private DunderAllBuilder() {
        }

        @Override
        public void visitPyFile(@NotNull PyFile node) {
            if (node == null) {
                DunderAllBuilder.$$$reportNull$$$0(0);
            }
            if (node.getText().contains("__all__")) {
                super.visitPyFile(node);
            }
        }

        @Override
        public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
            List<String> names;
            if (node == null) {
                DunderAllBuilder.$$$reportNull$$$0(1);
            }
            if (this.myDynamic) {
                return;
            }
            if ("__all__".equals(node.getName())) {
                this.myFoundDunderAll = true;
                PyExpression value = node.findAssignedValue();
                if (value instanceof PyBinaryExpression) {
                    PyBinaryExpression binaryExpression = (PyBinaryExpression)value;
                    if (binaryExpression.isOperator("+")) {
                        this.processSubList(this.getStringListFromValue(binaryExpression.getLeftExpression()));
                        this.processSubList(this.getStringListFromValue(binaryExpression.getRightExpression()));
                    } else {
                        this.myDynamic = true;
                    }
                } else {
                    this.processSubList(this.getStringListFromValue(value));
                }
            }
            if (!this.myFoundDunderAll && (names = this.getStringListFromValue(node.findAssignedValue())) != null) {
                this.myDunderLike.put(node.getName(), names);
            }
        }

        @Override
        public void visitPyAugAssignmentStatement(@NotNull PyAugAssignmentStatement node) {
            if (node == null) {
                DunderAllBuilder.$$$reportNull$$$0(2);
            }
            if (this.myDynamic || !this.myFoundDunderAll) {
                return;
            }
            if ("__all__".equals(node.getTarget().getName())) {
                this.processSubList(this.getStringListFromValue(node.getValue()));
            }
        }

        @Override
        public void visitPyCallExpression(@NotNull PyCallExpression node) {
            PyExpression qualifier;
            if (node == null) {
                DunderAllBuilder.$$$reportNull$$$0(3);
            }
            if (this.myDynamic || !this.myFoundDunderAll) {
                return;
            }
            PyExpression callee = node.getCallee();
            if (callee instanceof PyQualifiedExpression && (qualifier = ((PyQualifiedExpression)callee).getQualifier()) != null && "__all__".equals(qualifier.getText())) {
                String calleeName = callee.getName();
                if ("append".equals(calleeName)) {
                    PyStringLiteralExpression argument = node.getArgument(0, PyStringLiteralExpression.class);
                    if (argument != null) {
                        this.myResult.add(argument.getStringValue());
                        return;
                    }
                } else if ("extend".equals(calleeName)) {
                    PyExpression argument = node.getArgument(0, PyExpression.class);
                    this.processSubList(this.getStringListFromValue(argument));
                    return;
                }
                this.myDynamic = true;
            }
        }

        @Override
        public void visitPyClass(@NotNull PyClass node) {
            if (node == null) {
                DunderAllBuilder.$$$reportNull$$$0(4);
            }
        }

        @Nullable
        List<String> result() {
            return this.myDynamic || !this.myFoundDunderAll ? null : this.myResult;
        }

        private void processSubList(@Nullable List<String> list) {
            if (list == null) {
                this.myDynamic = true;
            } else {
                this.myResult.addAll(list);
            }
        }

        @Nullable
        private List<String> getStringListFromValue(@Nullable PyExpression expression) {
            if (expression instanceof PyReferenceExpression && !((PyReferenceExpression)expression).isQualified()) {
                return this.myDunderLike.get(((PyReferenceExpression)expression).getReferencedName());
            }
            return PyUtil.strListValue(expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "node";
            objectArray2[1] = "com/jetbrains/python/psi/impl/PyFileImpl$DunderAllBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyTargetExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyAugAssignmentStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyCallExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyClass";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

