/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.DateChecker;
import ai.grazie.rules.en.Commas;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.Number;
import ai.grazie.rules.en.PunctuationRules;
import ai.grazie.rules.en.Questions;
import ai.grazie.rules.en.SubjectVerbAgreement;
import ai.grazie.rules.tree.ActionSuggestion;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.ReportingKind;
import ai.grazie.rules.tree.TextRange;
import ai.grazie.rules.tree.Tree;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.languagetool.tools.StringTools;

class LongSentenceRule {
    private static final int LIMIT = 40;
    private static final NodePattern rootClause = NodePattern.ROOT.and(EnglishTreePatterns.clause);
    private static final NodePattern misattachedConj = NodePattern.or(NodePattern.N.withDependent("nsubj.*", CommonPatterns.possiblySkipDown("det", NodePattern.N.form("that"))).withPrevSibling(NodePattern.N.withHeadRelation("ccomp")), NodePattern.N.withPrevSibling(NodePattern.N.afterHead().withHeadRelation("advcl").withDependent("mark").withDependent("nsubj(:pass|:outer)?|csubj(:pass)?")).withDependent("cc", NodePattern.N.form("and")), NodePattern.N.withPrevSibling(NodePattern.N.afterHead().withHeadRelation("acl:relcl")).withDependent(".*", Questions.whPhrase));
    private static final NodePattern addHowever = NodePattern.N.form("but").withNextSibling(NodePattern.not(Commas.adverbsToFrontWithComma)).andNot(NodePattern.N.before(NodePattern.N.form("however")));
    private static final NodePattern contrastingCoordination = NodePattern.or(EnglishTreePatterns.tHere.withHead(EnglishTreePatterns.tHere), NodePattern.N.withDependent("cc", addHowever).after(EnglishTreePatterns.notOnly));
    private static final NodePattern partialAuxCoordination = NodePattern.N.withHead(NodePattern.N.withDependent("cop|aux|aux:pass")).noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl").noDependents("cop|aux|aux:pass");
    private static final NodePattern fullClauseIndicator = NodePattern.N.pos("VB[PDZ]").noPos("NN.*");
    private static final NodePattern academicCitation = DateChecker.year.and(CommonPatterns.afterSkipping(CommonPatterns.comma, CommonPatterns.capitalized));
    private static final NodePattern splittable = CommonPatterns.beforeSkipping(PunctuationRules.commaLike, NodePattern.not(NodePattern.PUNCT).markAs("NextWord")).and(CommonPatterns.afterSkipping(PunctuationRules.commaLike, NodePattern.N.markAs("PrevWord"))).andOr(NodePattern.N.inFormSequence(1, ",", "and|but").withHead("cc", EnglishTreePatterns.clause.markAs("Conj1").withHead("conj|parataxis", rootClause.noDependents("conj|parataxis", NodePattern.N.before("Conj1"))).andNot(NodePattern.N.withDependent("mark", NodePattern.N.form("to"))).andNot(contrastingCoordination).andNot(misattachedConj).andNot(partialAuxCoordination)).and((cc, match) -> {
        String pronoun;
        List<String> intros;
        Node conjClause = Objects.requireNonNull(cc.head());
        List<String> list = intros = addHowever.matches(cc) ? List.of("However, ") : List.of("");
        if (conjClause.hasDependent("nsubj(:pass|:outer)?|csubj(:pass)?|expl")) {
            return LongSentenceRule.splitSentence(match, intros);
        }
        Node mainClause = Objects.requireNonNull(conjClause.head());
        Node mainSubject = EnglishTreePatterns.findSubject(mainClause);
        String string = pronoun = mainSubject == null ? null : LongSentenceRule.suggestSubjectPronoun(mainClause, mainSubject);
        if (pronoun == null) {
            return null;
        }
        String capitalizedPronoun = StringTools.uppercaseFirstChar((String)pronoun);
        String decapitalizedPronoun = "I".equals(pronoun) ? "I" : pronoun.toLowerCase(Locale.ROOT);
        return LongSentenceRule.splitSentence(match, intros.stream().map(i -> i.isEmpty() ? capitalizedPronoun + " " : i + decapitalizedPronoun + " ").toList());
    }), CommonPatterns.firstChildPhrase.withHead("mark", EnglishTreePatterns.clause.afterHead().withHead("advcl", rootClause)).andOr(NodePattern.N.form("to").directlyAfter(CommonPatterns.comma).withHead(NodePattern.not(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("conj|parataxis")))).and((node, match) -> LongSentenceRule.splitSentence(match, List.of("This is to "))), NodePattern.N.form("because").directlyAfter(NodePattern.N.noLemma("be").andNot(NodePattern.N.onlyPos("RB")).noDependents("advmod", NodePattern.N.form("only"))).and((mark, match) -> LongSentenceRule.splitSentence(match, List.of("", "This is because ")))), NodePattern.N.directlyBefore(Commas.forExample.and(CommonPatterns.firstChildPhrase).withHead(NodePattern.N.withHeadRelation("parataxis"))).directlyAfter(CommonPatterns.comma).and((node, match) -> LongSentenceRule.splitSentence(match, List.of("For "))), NodePattern.N.directlyAfter(CommonPatterns.openingParen.before(CommonPatterns.lastToken.form("[.!?]").directlyAfter(CommonPatterns.closingParen.markAs("Closing"))).andOr(CommonPatterns.firstChildPhrase.withHead("punct", NodePattern.or(NodePattern.N.withHeadRelation("parataxis"), NodePattern.N.withHead("dep", NodePattern.ROOT).andNot(CommonPatterns.capitalized.before(academicCitation)))), NodePattern.N.inFlatTree().directlyBefore(NodePattern.N.noPos("CC")).after(fullClauseIndicator).before(fullClauseIndicator.markAs("ParenClause")).andNot(NodePattern.N.after(NodePattern.or(CommonPatterns.openingParen, CommonPatterns.closingParen))).andNot(NodePattern.N.before(NodePattern.or(NodePattern.N.form("who|which|that"), academicCitation).before("ParenClause"))))).noMatchUntil("Closing", CommonPatterns.closingParen).and((nextWord, match) -> {
        Node prevWord = nextWord.neighbor(-2);
        Node closingParen = match.getMarkedNode("Closing");
        Node endPunct = closingParen.neighbor(1);
        NodeCorrector splitStart = NodeCorrector.rawReplace(prevWord.startOffset(), nextWord.endOffset(), prevWord.form() + ". (" + StringTools.uppercaseFirstChar((String)nextWord.form()));
        NodeCorrector splitEnd = NodeCorrector.replaceNodes(closingParen, endPunct, endPunct.form() + closingParen.form());
        return match.withCorrector(splitStart.join(splitEnd)).withReportedRange(prevWord.startOffset(), nextWord.endOffset(), nextWord.tree());
    }));
    private static final int MIN_SPLIT_SENTENCE_SIZE = 5;
    private static final String MSG_TEMPLATE = "Long sentences (%s words here) are harder to read, according to the research; consider splitting";
    private static final NodePattern innerSentenceLikeBoundary = NodePattern.N.form("[.;:]").andNot(CommonPatterns.lastWord);
    private static final NodePattern suppressRule = NodePattern.or(innerSentenceLikeBoundary, PunctuationRules.wordInternalSentenceBoundary);
    private static final NodePattern word = CommonPatterns.letterWord.andOr(NodePattern.not(NodePattern.N.noSpaceBefore().directlyAfter(NodePattern.or(CommonPatterns.HYPHEN_NODE, CommonPatterns.letterWord))), NodePattern.N.withNeighbor(-2, CommonPatterns.withNumberLikeForm));

    LongSentenceRule() {
    }

    private static String suggestSubjectPronoun(Node mainClause, Node mainSubject) {
        if (mainSubject.hasPos("PRP")) {
            return mainSubject.form();
        }
        if (CommonPatterns.nerPerson.matches(mainSubject)) {
            return null;
        }
        Number number = SubjectVerbAgreement.subjectNumber(mainSubject, mainClause);
        return number == Number.ambiguous ? null : (number == Number.plural ? "they" : "it");
    }

    static NodeMatch checkTree(Tree tree) {
        List<Node> nodes;
        block10: {
            block9: {
                if (tree.nodes().isEmpty() && tree.text().length() > 80) {
                    tree = tree.getFlatTree();
                }
                if ((nodes = tree.nodes()).size() < 40) break block9;
                if (!nodes.stream().anyMatch(suppressRule::matches)) break block10;
            }
            return null;
        }
        List<Node> words = nodes.stream().filter(word::matches).toList();
        long newLineCount = tree.text().chars().filter(nl -> nl == 10).count();
        if (newLineCount >= (long)(words.size() / 2)) {
            return null;
        }
        if (words.size() < 40) {
            return null;
        }
        String message = MSG_TEMPLATE.formatted(words.size());
        if (nodes.stream().noneMatch(PunctuationRules.commaSplicing::matches)) {
            for (int i = 5; i < words.size() - 5; ++i) {
                NodeMatch match = splittable.match(words.get(i));
                if (match == null) continue;
                return match.withMessage(message).withActions(ActionSuggestion.SHORTEN);
            }
        }
        NodeMatch match = NodeMatch.EMPTY.withActions(ActionSuggestion.SHORTEN);
        Node lastNode = nodes.get(nodes.size() - 1);
        if (!CommonPatterns.punctForm.matches(lastNode) || lastNode.hasForm("[,;:]")) {
            match = match.withSuppressableKind(NodeMatch.SuppressableKind.UNFINISHED_SENTENCE);
        }
        return match.withReportedRange(CommonPatterns.withPrevWord(lastNode), tree).withReportedRange(new TextRange(0, tree.text().length()), tree, ReportingKind.Hover).withAnchor(lastNode).withMessage(message);
    }

    private static NodeMatch splitSentence(NodeMatch match, List<String> intros) {
        Node prevWord = match.getMarkedNode("PrevWord");
        Node nextWord = match.getMarkedNode("NextWord");
        TextRange range = new TextRange(prevWord.startOffset(), nextWord.endOffset());
        for (String intro : intros) {
            String replacement = prevWord.form() + ". " + intro + (intro.isEmpty() ? StringTools.uppercaseFirstChar((String)nextWord.form()) : nextWord.form());
            match = match.withCorrector(NodeCorrector.rawReplace(range, replacement));
        }
        return match.withReportedRange(range, nextWord.tree()).withReportedRange(CommonPatterns.withPrevWord(prevWord), prevWord.tree());
    }
}

