/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.highlighting;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.textmate.joni.JoniRegexFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateHighlighter;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateCachingSyntaxMatcherCoreKt;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateHighlightingLexer;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateSyntaxMatcher;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateSyntaxMatcherImpl;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateCachingSelectorWeigherKt;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorWeigher;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorWeigherImpl;
import org.jetbrains.plugins.textmate.regex.CaffeineCachingRegexProvider;
import org.jetbrains.plugins.textmate.regex.RegexFactory;
import org.jetbrains.plugins.textmate.regex.RegexProvider;
import org.jetbrains.plugins.textmate.regex.RememberingLastMatchRegexFactory;

public class TextMateSyntaxHighlighterFactory
extends SyntaxHighlighterFactory {
    private static final SyntaxHighlighter PLAIN_SYNTAX_HIGHLIGHTER = new TextMateHighlighter(null);
    private static final Logger LOG = Logger.getInstance(TextMateSyntaxHighlighterFactory.class);

    @NotNull
    public SyntaxHighlighter getSyntaxHighlighter(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        TextMateLanguageDescriptor languageDescriptor;
        if (virtualFile == null) {
            SyntaxHighlighter syntaxHighlighter = PLAIN_SYNTAX_HIGHLIGHTER;
            if (syntaxHighlighter == null) {
                TextMateSyntaxHighlighterFactory.$$$reportNull$$$0(0);
            }
            return syntaxHighlighter;
        }
        TextMateService textMateService = TextMateService.getInstance();
        if (textMateService != null && (languageDescriptor = textMateService.getLanguageDescriptorByFileName(virtualFile.getName())) != null) {
            LOG.debug("Textmate highlighting: " + virtualFile.getPath());
            return new TextMateHighlighter((Lexer)new TextMateHighlightingLexer(languageDescriptor, Inner.syntaxMatcher, Registry.get((String)"textmate.line.highlighting.limit").asInteger()));
        }
        SyntaxHighlighter syntaxHighlighter = PLAIN_SYNTAX_HIGHLIGHTER;
        if (syntaxHighlighter == null) {
            TextMateSyntaxHighlighterFactory.$$$reportNull$$$0(1);
        }
        return syntaxHighlighter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/language/syntax/highlighting/TextMateSyntaxHighlighterFactory", "getSyntaxHighlighter"));
    }

    private static class Inner {
        private static final RegexProvider regexProvider = new CaffeineCachingRegexProvider((RegexFactory)new RememberingLastMatchRegexFactory((RegexFactory)new JoniRegexFactory()));
        private static final TextMateSelectorWeigher weigher = TextMateCachingSelectorWeigherKt.caching((TextMateSelectorWeigher)new TextMateSelectorWeigherImpl());
        private static final TextMateSyntaxMatcher syntaxMatcher = TextMateCachingSyntaxMatcherCoreKt.caching((TextMateSyntaxMatcher)new TextMateSyntaxMatcherImpl(regexProvider, weigher));

        private Inner() {
        }
    }
}

