/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.io.File;
import java.nio.file.Path;
import org.assertj.core.error.BasicErrorMessageFactory;

public class ShouldHaveParent
extends BasicErrorMessageFactory {
    private static final String PATH_NO_PARENT = "%nExpecting path%n  %s%nto have parent:%n  %s%nbut did not have one.";
    private static final String PATH_NOT_EXPECTED_PARENT = "%nExpecting path%n  %s%nto have parent:%n  %s%nbut had:%n  %s.";
    private static final String FILE_NO_PARENT = "%nExpecting file%n  %s%nto have parent:%n  %s%nbut did not have one.";
    private static final String FILE_NOT_EXPECTED_PARENT = "%nExpecting file%n  %s%nto have parent:%n  %s%nbut had:%n  %s.";

    public static ShouldHaveParent shouldHaveParent(File actual, File expected) {
        return actual.getParentFile() == null ? new ShouldHaveParent(actual, expected) : new ShouldHaveParent(actual, actual.getParentFile(), expected);
    }

    public static ShouldHaveParent shouldHaveParent(Path actual, Path expected) {
        Path actualParent = actual.getParent();
        return actualParent == null ? new ShouldHaveParent(actual, expected) : new ShouldHaveParent(actual, actualParent, expected);
    }

    public static ShouldHaveParent shouldHaveParent(Path actual, Path actualParent, Path expected) {
        return new ShouldHaveParent(actual, actualParent, expected);
    }

    private ShouldHaveParent(File actual, File expected) {
        super(FILE_NO_PARENT, actual, expected);
    }

    private ShouldHaveParent(File actual, File actualParent, File expected) {
        super(FILE_NOT_EXPECTED_PARENT, actual, expected, actualParent);
    }

    private ShouldHaveParent(Path actual, Path expected) {
        super(PATH_NO_PARENT, actual, expected);
    }

    private ShouldHaveParent(Path actual, Path actualParent, Path expected) {
        super(PATH_NOT_EXPECTED_PARENT, actual, expected, actualParent);
    }
}

