# asciinema

[![Build Status](https://github.com/asciinema/asciinema/actions/workflows/ci.yml/badge.svg)](https://github.com/asciinema/asciinema/actions/workflows/asciinema.yml)
[![license](http://img.shields.io/badge/license-GNU-blue.svg)](https://raw.githubusercontent.com/asciinema/asciinema/master/LICENSE)

__asciinema__ (aka asciinema CLI or asciinema recorder) is a command-line tool
for recording and live streaming terminal sessions.

Unlike typical _screen_ recording software, which records visual output of a
screen into a heavyweight video files (`.mp4`, `.mov`), asciinema CLI runs
_inside a terminal_, capturing terminal session output into a lightweight
recording files in the
[asciicast](https://docs.asciinema.org/manual/asciicast/v3/) format (`.cast`),
or streaming it live to viewers in real-time.

The recordings can be replayed in a terminal, embedded on a web page with the
[asciinema player](https://docs.asciinema.org/manual/player/), or published to
an [asciinema server](https://docs.asciinema.org/manual/server/), such as
[asciinema.org](https://asciinema.org), for further sharing. Live streams allow
viewers to watch terminal sessions as they happen.

asciinema runs on GNU/Linux, macOS and FreeBSD.

<a href="https://asciinema.org/a/756853?autoplay=1"><img src="https://asciinema.org/a/756853.svg" alt="asciinema CLI demo" width="100%" /></a>

Notable features:

- recording and replaying of sessions inside a terminal,
- local and remote [live
  streaming](https://docs.asciinema.org/manual/cli/quick-start/#stream-a-terminal-session)
  of terminal sessions to multiple viewers in real-time,
- [lightweight recording
  format](https://docs.asciinema.org/manual/asciicast/v3/), which is highly
  compressible (down to 15% of the original size e.g. with `zstd` or `gzip`),
- integration with [asciinema
  server](https://docs.asciinema.org/manual/server/), e.g.
  [asciinema.org](https://asciinema.org), for easy recording hosting and live
  streaming.

To record a session run this command in your shell:

```sh
asciinema rec demo.cast
```

To stream a session via built-in HTTP server run:

```sh
asciinema stream -l
```

To stream a session via a relay (asciinema server) run:

```sh
asciinema stream -r
```

Check out the [Getting started
guide](https://docs.asciinema.org/getting-started/) for installation and usage
overview.

## Building

Building asciinema from source requires the [Rust](https://www.rust-lang.org/)
compiler (1.82 or later), and the [Cargo package
manager](https://doc.rust-lang.org/cargo/). If they are not available via your
system package manager then use [rustup](https://rustup.rs/).

To download the source code, build the asciinema binary, and install it in
`$HOME/.cargo/bin` in one go run:

```sh
cargo install --locked --git https://github.com/asciinema/asciinema
```

Then, ensure `$HOME/.cargo/bin` is in your shell's `$PATH`.

Alternatively, you can manually download the source code and build the asciinema
binary with:

```sh
git clone https://github.com/asciinema/asciinema
cd asciinema
cargo build --release
```

This produces the binary at `target/release/asciinema`. You can just copy the
binary to a directory in your `$PATH`.

To generate man pages and shell completion files, set `ASCIINEMA_GEN_DIR` to the
path where these artifacts should be stored. For example:

```sh
ASCIINEMA_GEN_DIR=/foo cargo build --release
```

The above command will build the binary and place the man pages in `/foo/man/`,
and the shell completion files in the `/foo/completion/` directory.

> [!NOTE]
> Windows is currently not supported. See [#467](https://github.com/orgs/asciinema/discussions/278).
> You can try [PowerSession](https://github.com/Watfaq/PowerSession-rs) instead.

## Development

All development happens on `develop` branch. This branch contains the current
generation (3.x) of the asciinema CLI, written in Rust.

The previous generation (2.x), written in Python, can be found in the `python`
branch.

If you wish to propose non-trivial code changes, please first reach out to the
team via [forum](https://discourse.asciinema.org/),
[Matrix](https://matrix.to/#/#asciinema:matrix.org) or
[IRC](https://web.libera.chat/#asciinema).

## Donations

Sustainability of asciinema development relies on donations and sponsorships.

If you like the project then consider becoming a
[supporter](https://docs.asciinema.org/donations/#individuals) or a [corporate
sponsor](https://docs.asciinema.org/donations/#corporate-sponsorship).

asciinema is sponsored by:

- [Brightbox](https://www.brightbox.com/)

## Consulting

If you're interested in integration or customization of asciinema to suit your
needs, check [asciinema consulting
services](https://docs.asciinema.org/consulting/).

## License

© 2011 Marcin Kulik.

All code is licensed under the GPL, v3 or later. See [LICENSE](./LICENSE) file
for details.
