﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/model/IncrementalScanDetails.h>
#include <aws/guardduty/model/RecoveryPoint.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace GuardDuty {
namespace Model {

/**
 * <p>Contains information about the configuration to be used for the malware
 * scan.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/StartMalwareScanConfiguration">AWS
 * API Reference</a></p>
 */
class StartMalwareScanConfiguration {
 public:
  AWS_GUARDDUTY_API StartMalwareScanConfiguration() = default;
  AWS_GUARDDUTY_API StartMalwareScanConfiguration(Aws::Utils::Json::JsonView jsonValue);
  AWS_GUARDDUTY_API StartMalwareScanConfiguration& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GUARDDUTY_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Amazon Resource Name (ARN) of the IAM role that is used for scanning the
   * resource.</p>
   */
  inline const Aws::String& GetRole() const { return m_role; }
  inline bool RoleHasBeenSet() const { return m_roleHasBeenSet; }
  template <typename RoleT = Aws::String>
  void SetRole(RoleT&& value) {
    m_roleHasBeenSet = true;
    m_role = std::forward<RoleT>(value);
  }
  template <typename RoleT = Aws::String>
  StartMalwareScanConfiguration& WithRole(RoleT&& value) {
    SetRole(std::forward<RoleT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Contains information about the incremental scan configuration. When
   * specified, the scan will only process changes since the baseline resource.</p>
   */
  inline const IncrementalScanDetails& GetIncrementalScanDetails() const { return m_incrementalScanDetails; }
  inline bool IncrementalScanDetailsHasBeenSet() const { return m_incrementalScanDetailsHasBeenSet; }
  template <typename IncrementalScanDetailsT = IncrementalScanDetails>
  void SetIncrementalScanDetails(IncrementalScanDetailsT&& value) {
    m_incrementalScanDetailsHasBeenSet = true;
    m_incrementalScanDetails = std::forward<IncrementalScanDetailsT>(value);
  }
  template <typename IncrementalScanDetailsT = IncrementalScanDetails>
  StartMalwareScanConfiguration& WithIncrementalScanDetails(IncrementalScanDetailsT&& value) {
    SetIncrementalScanDetails(std::forward<IncrementalScanDetailsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Contains information about the recovery point configuration for the requested
   * scan.</p>
   */
  inline const RecoveryPoint& GetRecoveryPoint() const { return m_recoveryPoint; }
  inline bool RecoveryPointHasBeenSet() const { return m_recoveryPointHasBeenSet; }
  template <typename RecoveryPointT = RecoveryPoint>
  void SetRecoveryPoint(RecoveryPointT&& value) {
    m_recoveryPointHasBeenSet = true;
    m_recoveryPoint = std::forward<RecoveryPointT>(value);
  }
  template <typename RecoveryPointT = RecoveryPoint>
  StartMalwareScanConfiguration& WithRecoveryPoint(RecoveryPointT&& value) {
    SetRecoveryPoint(std::forward<RecoveryPointT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_role;
  bool m_roleHasBeenSet = false;

  IncrementalScanDetails m_incrementalScanDetails;
  bool m_incrementalScanDetailsHasBeenSet = false;

  RecoveryPoint m_recoveryPoint;
  bool m_recoveryPointHasBeenSet = false;
};

}  // namespace Model
}  // namespace GuardDuty
}  // namespace Aws
