﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/dax/DAX_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace DAX {
namespace Model {

/**
 * <p>An individual DAX parameter.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/ParameterNameValue">AWS
 * API Reference</a></p>
 */
class ParameterNameValue {
 public:
  AWS_DAX_API ParameterNameValue() = default;
  AWS_DAX_API ParameterNameValue(Aws::Utils::Json::JsonView jsonValue);
  AWS_DAX_API ParameterNameValue& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_DAX_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the parameter.</p>
   */
  inline const Aws::String& GetParameterName() const { return m_parameterName; }
  inline bool ParameterNameHasBeenSet() const { return m_parameterNameHasBeenSet; }
  template <typename ParameterNameT = Aws::String>
  void SetParameterName(ParameterNameT&& value) {
    m_parameterNameHasBeenSet = true;
    m_parameterName = std::forward<ParameterNameT>(value);
  }
  template <typename ParameterNameT = Aws::String>
  ParameterNameValue& WithParameterName(ParameterNameT&& value) {
    SetParameterName(std::forward<ParameterNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The value of the parameter.</p>
   */
  inline const Aws::String& GetParameterValue() const { return m_parameterValue; }
  inline bool ParameterValueHasBeenSet() const { return m_parameterValueHasBeenSet; }
  template <typename ParameterValueT = Aws::String>
  void SetParameterValue(ParameterValueT&& value) {
    m_parameterValueHasBeenSet = true;
    m_parameterValue = std::forward<ParameterValueT>(value);
  }
  template <typename ParameterValueT = Aws::String>
  ParameterNameValue& WithParameterValue(ParameterValueT&& value) {
    SetParameterValue(std::forward<ParameterValueT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_parameterName;

  Aws::String m_parameterValue;
  bool m_parameterNameHasBeenSet = false;
  bool m_parameterValueHasBeenSet = false;
};

}  // namespace Model
}  // namespace DAX
}  // namespace Aws
