﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iotsitewise/IoTSiteWise_EXPORTS.h>

namespace Aws {
namespace IoTSiteWise {
namespace Model {
enum class DatasetState { NOT_SET, CREATING, ACTIVE, UPDATING, DELETING, FAILED };

namespace DatasetStateMapper {
AWS_IOTSITEWISE_API DatasetState GetDatasetStateForName(const Aws::String& name);

AWS_IOTSITEWISE_API Aws::String GetNameForDatasetState(DatasetState value);
}  // namespace DatasetStateMapper
}  // namespace Model
}  // namespace IoTSiteWise
}  // namespace Aws
