﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/rds/RDS_EXPORTS.h>
#include <aws/rds/model/OrderableDBInstanceOption.h>
#include <aws/rds/model/ResponseMetadata.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace RDS {
namespace Model {
/**
 * <p>Contains the result of a successful invocation of the
 * <code>DescribeOrderableDBInstanceOptions</code> action.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/OrderableDBInstanceOptionsMessage">AWS
 * API Reference</a></p>
 */
class DescribeOrderableDBInstanceOptionsResult {
 public:
  AWS_RDS_API DescribeOrderableDBInstanceOptionsResult() = default;
  AWS_RDS_API DescribeOrderableDBInstanceOptionsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_RDS_API DescribeOrderableDBInstanceOptionsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>An <code>OrderableDBInstanceOption</code> structure containing information
   * about orderable options for the DB instance.</p>
   */
  inline const Aws::Vector<OrderableDBInstanceOption>& GetOrderableDBInstanceOptions() const { return m_orderableDBInstanceOptions; }
  template <typename OrderableDBInstanceOptionsT = Aws::Vector<OrderableDBInstanceOption>>
  void SetOrderableDBInstanceOptions(OrderableDBInstanceOptionsT&& value) {
    m_orderableDBInstanceOptionsHasBeenSet = true;
    m_orderableDBInstanceOptions = std::forward<OrderableDBInstanceOptionsT>(value);
  }
  template <typename OrderableDBInstanceOptionsT = Aws::Vector<OrderableDBInstanceOption>>
  DescribeOrderableDBInstanceOptionsResult& WithOrderableDBInstanceOptions(OrderableDBInstanceOptionsT&& value) {
    SetOrderableDBInstanceOptions(std::forward<OrderableDBInstanceOptionsT>(value));
    return *this;
  }
  template <typename OrderableDBInstanceOptionsT = OrderableDBInstanceOption>
  DescribeOrderableDBInstanceOptionsResult& AddOrderableDBInstanceOptions(OrderableDBInstanceOptionsT&& value) {
    m_orderableDBInstanceOptionsHasBeenSet = true;
    m_orderableDBInstanceOptions.emplace_back(std::forward<OrderableDBInstanceOptionsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An optional pagination token provided by a previous
   * OrderableDBInstanceOptions request. If this parameter is specified, the response
   * includes only records beyond the marker, up to the value specified by
   * <code>MaxRecords</code>.</p>
   */
  inline const Aws::String& GetMarker() const { return m_marker; }
  template <typename MarkerT = Aws::String>
  void SetMarker(MarkerT&& value) {
    m_markerHasBeenSet = true;
    m_marker = std::forward<MarkerT>(value);
  }
  template <typename MarkerT = Aws::String>
  DescribeOrderableDBInstanceOptionsResult& WithMarker(MarkerT&& value) {
    SetMarker(std::forward<MarkerT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  DescribeOrderableDBInstanceOptionsResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<OrderableDBInstanceOption> m_orderableDBInstanceOptions;

  Aws::String m_marker;

  ResponseMetadata m_responseMetadata;
  bool m_orderableDBInstanceOptionsHasBeenSet = false;
  bool m_markerHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace RDS
}  // namespace Aws
