﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sns/SNS_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace SNS {
namespace Model {

/**
 * <p>Platform application object.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/PlatformApplication">AWS
 * API Reference</a></p>
 */
class PlatformApplication {
 public:
  AWS_SNS_API PlatformApplication() = default;
  AWS_SNS_API PlatformApplication(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_SNS_API PlatformApplication& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_SNS_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
  AWS_SNS_API void OutputToStream(Aws::OStream& oStream, const char* location) const;

  ///@{
  /**
   * <p>PlatformApplicationArn for platform application object.</p>
   */
  inline const Aws::String& GetPlatformApplicationArn() const { return m_platformApplicationArn; }
  inline bool PlatformApplicationArnHasBeenSet() const { return m_platformApplicationArnHasBeenSet; }
  template <typename PlatformApplicationArnT = Aws::String>
  void SetPlatformApplicationArn(PlatformApplicationArnT&& value) {
    m_platformApplicationArnHasBeenSet = true;
    m_platformApplicationArn = std::forward<PlatformApplicationArnT>(value);
  }
  template <typename PlatformApplicationArnT = Aws::String>
  PlatformApplication& WithPlatformApplicationArn(PlatformApplicationArnT&& value) {
    SetPlatformApplicationArn(std::forward<PlatformApplicationArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Attributes for platform application object.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetAttributes() const { return m_attributes; }
  inline bool AttributesHasBeenSet() const { return m_attributesHasBeenSet; }
  template <typename AttributesT = Aws::Map<Aws::String, Aws::String>>
  void SetAttributes(AttributesT&& value) {
    m_attributesHasBeenSet = true;
    m_attributes = std::forward<AttributesT>(value);
  }
  template <typename AttributesT = Aws::Map<Aws::String, Aws::String>>
  PlatformApplication& WithAttributes(AttributesT&& value) {
    SetAttributes(std::forward<AttributesT>(value));
    return *this;
  }
  template <typename AttributesKeyT = Aws::String, typename AttributesValueT = Aws::String>
  PlatformApplication& AddAttributes(AttributesKeyT&& key, AttributesValueT&& value) {
    m_attributesHasBeenSet = true;
    m_attributes.emplace(std::forward<AttributesKeyT>(key), std::forward<AttributesValueT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_platformApplicationArn;

  Aws::Map<Aws::String, Aws::String> m_attributes;
  bool m_platformApplicationArnHasBeenSet = false;
  bool m_attributesHasBeenSet = false;
};

}  // namespace Model
}  // namespace SNS
}  // namespace Aws
