/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net.ssh;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCInvalidatePhase;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWTunnel;
import org.jkiss.dbeaver.model.net.DBWUtils;
import org.jkiss.dbeaver.model.net.ssh.SSHSession;
import org.jkiss.dbeaver.model.net.ssh.SSHSessionController;
import org.jkiss.dbeaver.model.net.ssh.SSHUtils;
import org.jkiss.dbeaver.model.net.ssh.config.SSHAuthConfiguration;
import org.jkiss.dbeaver.model.net.ssh.config.SSHHostConfiguration;
import org.jkiss.dbeaver.model.net.ssh.config.SSHPortForwardConfiguration;
import org.jkiss.dbeaver.model.net.ssh.registry.SSHSessionControllerDescriptor;
import org.jkiss.dbeaver.model.net.ssh.registry.SSHSessionControllerRegistry;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.Base64;
import org.jkiss.utils.CommonUtils;

public class SSHTunnelImpl
implements DBWTunnel {
    private static final Log log = Log.getLog(SSHTunnelImpl.class);
    private static final String DEF_IMPLEMENTATION = "sshj";
    private DBWHandlerConfiguration configuration;
    private SSHSessionController controller;
    private SSHSession session;
    private final List<Runnable> listeners = new ArrayList<Runnable>();

    @Nullable
    public SSHSession getImplementation() {
        return this.session;
    }

    public void addCloseListener(@NotNull Runnable listener) {
        this.listeners.add(listener);
    }

    @NotNull
    public DBPConnectionConfiguration initializeHandler(@NotNull DBRProgressMonitor monitor, @NotNull DBWHandlerConfiguration configuration, @NotNull DBPConnectionConfiguration connectionInfo) throws DBException {
        SSHSessionControllerDescriptor descriptor;
        this.configuration = configuration;
        String implId = configuration.getStringProperty("implementation");
        if (CommonUtils.isEmpty((String)implId)) {
            implId = DEF_IMPLEMENTATION;
        }
        if ((descriptor = SSHSessionControllerRegistry.getInstance().getDescriptor(implId)) == null) {
            descriptor = SSHSessionControllerRegistry.getInstance().getDescriptor(DEF_IMPLEMENTATION);
        }
        if (descriptor == null) {
            throw new DBException("Can't find SSH tunnel implementation '" + implId + "'");
        }
        try {
            this.controller = descriptor.getInstance();
        }
        catch (DBException e) {
            throw new DBException("Can't create SSH tunnel implementation '" + implId + "'", (Throwable)e);
        }
        return this.initTunnel(monitor, configuration, connectionInfo, this.controller);
    }

    public boolean matchesParameters(@NotNull String host, int port) {
        if (host.equals(this.configuration.getStringProperty("host"))) {
            int sshPort = this.configuration.getIntProperty("port");
            return sshPort == port;
        }
        return false;
    }

    @NotNull
    public DBWTunnel.AuthCredentials getRequiredCredentials(@NotNull DBWHandlerConfiguration configuration) throws DBException {
        DBWTunnel.AuthCredentials authCredentials;
        SSHAuthConfiguration sSHAuthConfiguration;
        if (!configuration.isEnabled() || !configuration.isSecured()) {
            return DBWTunnel.AuthCredentials.NONE;
        }
        SSHHostConfiguration[] hosts = SSHUtils.loadHostConfigurations(configuration, false);
        SSHHostConfiguration host = hosts[hosts.length - 1];
        SSHAuthConfiguration sSHAuthConfiguration2 = host.auth();
        Objects.requireNonNull(sSHAuthConfiguration2);
        SSHAuthConfiguration sSHAuthConfiguration3 = sSHAuthConfiguration = sSHAuthConfiguration2;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SSHAuthConfiguration.WithPassword.class, SSHAuthConfiguration.KeyFile.class, SSHAuthConfiguration.KeyData.class, SSHAuthConfiguration.Agent.class}, (Object)sSHAuthConfiguration3, n)) {
                case 0: {
                    SSHAuthConfiguration.WithPassword password = (SSHAuthConfiguration.WithPassword)sSHAuthConfiguration;
                    if (!password.savePassword()) {
                        sSHAuthConfiguration3 = sSHAuthConfiguration;
                        n = 1;
                        continue block6;
                    }
                    authCredentials = DBWTunnel.AuthCredentials.NONE;
                    break block6;
                }
                case 1: {
                    SSHAuthConfiguration.KeyFile key = (SSHAuthConfiguration.KeyFile)sSHAuthConfiguration;
                    if (SSHUtils.isKeyFileEncrypted(key.path())) {
                        authCredentials = DBWTunnel.AuthCredentials.PASSWORD;
                        break block6;
                    }
                    authCredentials = DBWTunnel.AuthCredentials.NONE;
                    break block6;
                }
                case 2: {
                    SSHAuthConfiguration.KeyData key = (SSHAuthConfiguration.KeyData)sSHAuthConfiguration;
                    if (SSHUtils.isKeyEncrypted(Base64.decode((String)key.data()))) {
                        authCredentials = DBWTunnel.AuthCredentials.PASSWORD;
                        break block6;
                    }
                    authCredentials = DBWTunnel.AuthCredentials.NONE;
                    break block6;
                }
                case 3: {
                    SSHAuthConfiguration.Agent ignored = (SSHAuthConfiguration.Agent)sSHAuthConfiguration;
                    authCredentials = DBWTunnel.AuthCredentials.NONE;
                    break block6;
                }
                default: {
                    authCredentials = DBWTunnel.AuthCredentials.CREDENTIALS;
                }
            }
            break;
        }
        return authCredentials;
    }

    public void invalidateHandler(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull DBCInvalidatePhase phase) throws DBException {
        if (this.session == null) {
            return;
        }
        try {
            try {
                monitor.subTask("Invalidate SSH tunnel");
                this.controller.invalidate(monitor, this.session, phase, this.configuration, dataSource.getContainer().getPreferenceStore().getInt("connection.validation.timeout"));
            }
            catch (DBException e) {
                log.debug((Object)"Error invalidating SSH tunnel. Closing.", (Throwable)e);
                try {
                    this.closeTunnel(monitor);
                }
                catch (Exception e1) {
                    log.error((Object)"Error closing broken tunnel", (Throwable)e1);
                }
                throw new DBException("Error invalidating SSH tunnel", (Throwable)e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void closeTunnel(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.session != null) {
            DBPDataSourceContainer container = this.configuration.getDataSource();
            int timeout = container != null ? container.getPreferenceStore().getInt("connection.validation.timeout") : 0;
            try {
                this.controller.release(monitor, this.session, this.configuration, timeout);
            }
            catch (DBException e) {
                log.debug((Object)"Error releasing SSH session controller", (Throwable)e);
            }
        }
        for (Runnable listener : this.listeners) {
            listener.run();
        }
        this.listeners.clear();
    }

    @NotNull
    public DBPDataSourceContainer[] getDependentDataSources() {
        return this.controller.getDependentDataSources(this.session);
    }

    @NotNull
    private DBPConnectionConfiguration initTunnel(@NotNull DBRProgressMonitor monitor, @NotNull DBWHandlerConfiguration configuration, @NotNull DBPConnectionConfiguration connectionInfo, @NotNull SSHSessionController controller) throws DBException {
        SSHHostConfiguration[] hosts = SSHUtils.loadHostConfigurations(configuration, true);
        SSHPortForwardConfiguration portForward = SSHTunnelImpl.loadPortForwardConfiguration(configuration, connectionInfo);
        SSHSession[] sessions = new SSHSession[hosts.length];
        int index = 0;
        while (index < hosts.length) {
            sessions[index] = controller.acquireSession(monitor, configuration, hosts[index], index != 0 ? sessions[index - 1] : null, index == hosts.length - 1 ? portForward : null);
            ++index;
        }
        this.session = sessions[sessions.length - 1];
        connectionInfo = new DBPConnectionConfiguration(connectionInfo);
        DBWUtils.updateConfigWithTunnelInfo((DBWHandlerConfiguration)configuration, (DBPConnectionConfiguration)connectionInfo, (String)portForward.localHost(), (int)portForward.localPort());
        return connectionInfo;
    }

    @Nullable
    public SSHSessionController getController() {
        return this.controller;
    }

    @NotNull
    private static SSHPortForwardConfiguration loadPortForwardConfiguration(@NotNull DBWHandlerConfiguration configuration, @NotNull DBPConnectionConfiguration connectionInfo) {
        int sshRemotePort;
        String sshRemoteHost;
        String sshLocalHost = CommonUtils.toString((Object)configuration.getProperty("localHost"));
        int sshLocalPort = configuration.getIntProperty("localPort");
        if (sshLocalPort == 0) {
            sshLocalPort = SSHUtils.findFreePort();
        }
        if (CommonUtils.isEmpty((String)(sshRemoteHost = CommonUtils.toString((Object)configuration.getProperty("remoteHost"))))) {
            sshRemoteHost = CommonUtils.notEmpty((String)connectionInfo.getHostName());
        }
        if ((sshRemotePort = configuration.getIntProperty("remotePort")) == 0 && configuration.getDriver() != null) {
            sshRemotePort = CommonUtils.toInt((Object)connectionInfo.getHostPort());
        }
        return new SSHPortForwardConfiguration(sshLocalHost, sshLocalPort, sshRemoteHost, sshRemotePort);
    }
}

