/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.debug;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.osgi.service.log.LogService;

public class Debug
implements DebugOptionsListener {
    public static final String EQUINOX_TRACE = "EQUINOX.TRACE";
    public static final String ECLIPSE_OSGI = "org.eclipse.osgi";
    public static final String OPTION_DEBUG_GENERAL = "org.eclipse.osgi/debug";
    public static final String OPTION_DEBUG_BUNDLE_TIME = "org.eclipse.osgi/debug/bundleTime";
    public static final String OPTION_DEBUG_BUNDLE_START_TIME = "org.eclipse.osgi/debug/bundleStartTime";
    public static final String OPTION_DEBUG_LOADER = "org.eclipse.osgi/debug/loader";
    public static final String OPTION_DEBUG_LOADER_PACKAGES = "org.eclipse.osgi/debug/loader/packages";
    public static final String OPTION_DEBUG_LOADER_DYAMIC_IMPORT = "org.eclipse.osgi/debug/loader/dynamicImport";
    public static final String OPTION_DEBUG_LOADER_CDS = "org.eclipse.osgi/debug/loader/cds";
    public static final String OPTION_DEBUG_STORAGE = "org.eclipse.osgi/debug/storage";
    public static final String OPTION_DEBUG_EVENTS = "org.eclipse.osgi/debug/events";
    public static final String OPTION_DEBUG_SERVICES = "org.eclipse.osgi/debug/services";
    public static final String OPTION_DEBUG_HOOKS = "org.eclipse.osgi/debug/hooks";
    public static final String OPTION_DEBUG_SECURITY = "org.eclipse.osgi/debug/security";
    public static final String OPTION_DEBUG_STARTLEVEL = "org.eclipse.osgi/debug/startlevel";
    public static final String OPTION_MONITOR_ACTIVATION = "org.eclipse.osgi/monitor/activation";
    public static final String OPTION_MONITOR_LAZY = "org.eclipse.osgi/monitor/lazy";
    public static final String OPTION_DEBUG_MESSAGE_BUNDLES = "org.eclipse.osgi/debug/messageBundles";
    public static final String OPTION_DEBUG_LOCATION = "org.eclipse.osgi/debug/location";
    public static final String OPTION_CACHED_MANIFEST = "org.eclipse.osgi/debug/cachedmanifest";
    public static final String OPTION_DEBUG_SYSTEM_BUNDLE = "org.eclipse.osgi/debug/systemBundle";
    public static final String OPTION_DEBUG_BUNDLE_FILE = "org.eclipse.osgi/debug/bundleFile";
    public static final String OPTION_DEBUG_BUNDLE_FILE_OPEN = "org.eclipse.osgi/debug/bundleFile/open";
    public static final String OPTION_DEBUG_BUNDLE_FILE_CLOSE = "org.eclipse.osgi/debug/bundleFile/close";
    public boolean DEBUG_GENERAL = false;
    public boolean DEBUG_BUNDLE_TIME = false;
    public boolean DEBUG_LOADER = false;
    public boolean DEBUG_LOADER_PACKAGES = false;
    public Set<String> DEBUG_LOADER_PACKAGES_SET = Collections.emptySet();
    public boolean DEBUG_LOADER_DYNAMIC_IMPORT = false;
    public boolean DEBUG_LOADER_CDS = false;
    public boolean DEBUG_STORAGE = false;
    public boolean DEBUG_EVENTS = false;
    public boolean DEBUG_SERVICES = false;
    public boolean DEBUG_HOOKS = false;
    public boolean DEBUG_SECURITY = false;
    public boolean DEBUG_STARTLEVEL = false;
    public boolean MONITOR_ACTIVATION = false;
    public boolean DEBUG_LOCATION = false;
    public boolean DEBUG_CACHED_MANIFEST = false;
    public boolean DEBUG_SYSTEM_BUNDLE = false;
    public boolean DEBUG_BUNDLE_FILE = false;
    public boolean DEBUG_BUNDLE_FILE_OPEN = false;
    public boolean DEBUG_BUNDLE_FILE_CLOSE = false;
    public static PrintStream out = System.out;
    private volatile LogService logService;

    public Debug(DebugOptions dbgOptions) {
        this.optionsChanged(dbgOptions);
    }

    @Override
    public void optionsChanged(DebugOptions dbgOptions) {
        this.DEBUG_GENERAL = dbgOptions.getBooleanOption(OPTION_DEBUG_GENERAL, false);
        this.DEBUG_BUNDLE_TIME = dbgOptions.getBooleanOption(OPTION_DEBUG_BUNDLE_TIME, false) || dbgOptions.getBooleanOption("org.eclipse.core.runtime/timing/startup", false);
        this.DEBUG_LOADER = dbgOptions.getBooleanOption(OPTION_DEBUG_LOADER, false);
        this.DEBUG_LOADER_DYNAMIC_IMPORT = dbgOptions.getBooleanOption(OPTION_DEBUG_LOADER_DYAMIC_IMPORT, false);
        String pkgsValue = dbgOptions.getOption(OPTION_DEBUG_LOADER_PACKAGES, "");
        HashSet<String> packages = new HashSet<String>(Arrays.asList(pkgsValue.split(",")));
        this.DEBUG_LOADER_PACKAGES = !packages.isEmpty();
        this.DEBUG_LOADER_PACKAGES_SET = packages.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(packages);
        this.DEBUG_LOADER_CDS = dbgOptions.getBooleanOption(OPTION_DEBUG_LOADER_CDS, false);
        this.DEBUG_STORAGE = dbgOptions.getBooleanOption(OPTION_DEBUG_STORAGE, false);
        this.DEBUG_EVENTS = dbgOptions.getBooleanOption(OPTION_DEBUG_EVENTS, false);
        this.DEBUG_SERVICES = dbgOptions.getBooleanOption(OPTION_DEBUG_SERVICES, false);
        this.DEBUG_HOOKS = dbgOptions.getBooleanOption(OPTION_DEBUG_HOOKS, false);
        this.DEBUG_SECURITY = dbgOptions.getBooleanOption(OPTION_DEBUG_SECURITY, false);
        this.DEBUG_STARTLEVEL = dbgOptions.getBooleanOption(OPTION_DEBUG_STARTLEVEL, false);
        this.MONITOR_ACTIVATION = dbgOptions.getBooleanOption(OPTION_MONITOR_ACTIVATION, false);
        this.DEBUG_LOCATION = dbgOptions.getBooleanOption(OPTION_DEBUG_LOCATION, false);
        this.DEBUG_CACHED_MANIFEST = dbgOptions.getBooleanOption(OPTION_CACHED_MANIFEST, false);
        this.DEBUG_SYSTEM_BUNDLE = dbgOptions.getBooleanOption(OPTION_DEBUG_SYSTEM_BUNDLE, false);
        this.DEBUG_BUNDLE_FILE = dbgOptions.getBooleanOption(OPTION_DEBUG_BUNDLE_FILE, false);
        this.DEBUG_BUNDLE_FILE_OPEN = dbgOptions.getBooleanOption(OPTION_DEBUG_BUNDLE_FILE_OPEN, false);
        this.DEBUG_BUNDLE_FILE_CLOSE = dbgOptions.getBooleanOption(OPTION_DEBUG_BUNDLE_FILE_CLOSE, false);
    }

    public void setLogService(LogService log) {
        this.logService = log;
    }

    public static void println(String x) {
        out.println(x);
    }

    public void trace(String topic, String message) {
        LogService current = this.logService;
        if (current != null) {
            current.getLogger(topic).debug(message);
        } else {
            out.println(message);
        }
    }

    public String loaderWithPackage(String packageName) {
        if (this.DEBUG_LOADER) {
            return OPTION_DEBUG_LOADER;
        }
        if (this.DEBUG_LOADER_PACKAGES && this.DEBUG_LOADER_PACKAGES_SET.contains(packageName)) {
            return OPTION_DEBUG_LOADER_PACKAGES;
        }
        return null;
    }

    public String loaderWithClass(String className) {
        String packageName;
        if (this.DEBUG_LOADER) {
            return OPTION_DEBUG_LOADER;
        }
        if (this.DEBUG_LOADER_PACKAGES && this.DEBUG_LOADER_PACKAGES_SET.contains(packageName = BundleLoader.getPackageName(className))) {
            return OPTION_DEBUG_LOADER_PACKAGES;
        }
        return null;
    }

    public String dynamicPackage(String packageName) {
        if (this.DEBUG_LOADER) {
            return OPTION_DEBUG_LOADER;
        }
        if (this.DEBUG_LOADER_DYNAMIC_IMPORT) {
            return OPTION_DEBUG_LOADER_DYAMIC_IMPORT;
        }
        if (this.DEBUG_LOADER_PACKAGES && this.DEBUG_LOADER_PACKAGES_SET.contains(packageName)) {
            return OPTION_DEBUG_LOADER_PACKAGES;
        }
        return null;
    }

    public void traceThrowable(String topic, Throwable t) {
        if (t == null) {
            return;
        }
        LogService current = this.logService;
        if (current != null) {
            current.getLogger(topic).trace(topic, (Object)t);
        } else {
            t.printStackTrace(out);
        }
    }

    public static void printStackTrace(Throwable t) {
        t.printStackTrace(out);
    }
}

