/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.impls.timescale;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableRegular;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;

public class TimescaleTable
extends PostgreTableRegular {
    private static final Log log = Log.getLog(TimescaleTable.class);

    public TimescaleTable(PostgreSchema schema, ResultSet dbResult) {
        super(schema, dbResult);
    }

    @Override
    protected void readTableStatistics(@NotNull JDBCSession session) throws DBException, SQLException {
        if (!((PostgreDataSource)this.getDataSource()).getServerType().supportsTableStatistics()) {
            return;
        }
        if (!this.isHypertable(session)) {
            super.readTableStatistics(session);
            return;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT total_bytes as total_rel_size, table_bytes as rel_size FROM hypertable_detailed_size(?)");){
            dbStat.setLong(1, this.getObjectId());
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                if (dbResult.next()) {
                    this.fetchStatistics(dbResult);
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    private boolean isHypertable(@NotNull JDBCSession session) throws SQLException {
        String sql = "SELECT 1 FROM timescaledb_information.hypertables WHERE hypertable_schema = ? AND hypertable_name = ?";
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCPreparedStatement stmt = session.prepareStatement(sql);){
                boolean bl;
                JDBCResultSet rs;
                Throwable throwable2;
                block21: {
                    stmt.setString(1, this.getSchema().getName());
                    stmt.setString(2, this.getName());
                    throwable2 = null;
                    Object var7_11 = null;
                    rs = stmt.executeQuery();
                    bl = rs.next();
                    if (rs == null) break block21;
                    rs.close();
                }
                return bl;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            log.error((Object)("Failed to check if table is a hypertable: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    @Override
    protected void fetchStatistics(@NotNull JDBCResultSet dbResult) throws DBException, SQLException {
        super.fetchStatistics(dbResult);
    }
}

