/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.app;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.secret.DBSValueEncryptor;
import org.jkiss.utils.IOUtils;

public class DefaultValueEncryptor
implements DBSValueEncryptor {
    public static final String CIPHER_NAME = "AES/CBC/PKCS5Padding";
    public static final String KEY_ALGORITHM = "AES";
    private final SecretKey secretKey;
    private final Cipher cipher;

    public DefaultValueEncryptor(SecretKey secretKey) {
        this.secretKey = secretKey;
        try {
            this.cipher = Cipher.getInstance(CIPHER_NAME);
        }
        catch (Exception e) {
            throw new IllegalStateException("Internal error during encrypted init", e);
        }
    }

    public static SecretKey makeSecretKeyFromPassword(String password) {
        byte[] bytes = password.getBytes(StandardCharsets.UTF_8);
        byte[] passBytes = Arrays.copyOf(bytes, 16);
        return new SecretKeySpec(passBytes, KEY_ALGORITHM);
    }

    @Override
    @NotNull
    public byte[] encryptValue(@NotNull byte[] value) throws DBException {
        try {
            this.cipher.init(1, this.secretKey);
            byte[] iv = this.cipher.getIV();
            ByteArrayOutputStream resultBuffer = new ByteArrayOutputStream();
            try (CipherOutputStream cipherOut = new CipherOutputStream(resultBuffer, this.cipher);){
                resultBuffer.write(iv);
                cipherOut.write(value);
            }
            return resultBuffer.toByteArray();
        }
        catch (Exception e) {
            throw new DBException("Error encrypting value", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public byte[] decryptValue(@NotNull byte[] value) throws DBException {
        try (ByteArrayInputStream byteStream = new ByteArrayInputStream(value);){
            byte[] byArray;
            byte[] fileIv = new byte[16];
            byteStream.read(fileIv);
            this.cipher.init(2, (Key)this.secretKey, new IvParameterSpec(fileIv));
            try (CipherInputStream cipherIn = new CipherInputStream(byteStream, this.cipher);){
                ByteArrayOutputStream resultBuffer = new ByteArrayOutputStream();
                IOUtils.copyStream((InputStream)cipherIn, (OutputStream)resultBuffer);
                byArray = resultBuffer.toByteArray();
            }
            return byArray;
        }
        catch (Exception e) {
            throw new DBException("Error decrypting value", e);
        }
    }
}

