/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.runtime.jobs.DataSourceJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.dialogs.BaseSQLDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;

public abstract class GenerateSQLDialog
extends BaseSQLDialog {
    private final DBCExecutionContext executionContext;
    private Runnable onSuccess;
    protected SelectionListener SQL_CHANGE_LISTENER = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            GenerateSQLDialog.this.updateSQL();
        }
    };

    public GenerateSQLDialog(IWorkbenchPartSite parentSite, DBCExecutionContext executionContext, String title, @Nullable DBPImage image) {
        super(parentSite, title, image);
        this.executionContext = executionContext;
    }

    public void setOnSuccess(Runnable onSuccess) {
        this.onSuccess = onSuccess;
    }

    @Override
    protected boolean isWordWrap() {
        return true;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Composite controlsPanel = UIUtils.createPlaceholder((Composite)composite, (int)1, (int)5);
        GridData gd = new GridData(1808);
        controlsPanel.setLayoutData((Object)gd);
        this.createControls(controlsPanel);
        Label divLabel = new Label(controlsPanel, 258);
        divLabel.setLayoutData((Object)new GridData(768));
        this.createSQLPanel(controlsPanel);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createCopyButton(parent);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    @Override
    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.setReturnCode(0);
            this.executeSQL();
            this.close();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void executeSQL() {
        final String jobName = this.getShell().getText();
        final String[] scriptLines = this.generateSQLScript();
        DataSourceJob job = new DataSourceJob(this, jobName, this.executionContext){

            @NotNull
            protected IStatus run(@NotNull DBRProgressMonitor monitor) {
                try (DBCSession session = this.getExecutionContext().openSession(monitor, DBCExecutionPurpose.UTIL, jobName);){
                    for (String line : scriptLines) {
                        try (DBCStatement statement = DBUtils.makeStatement((DBCSession)session, (String)line, (boolean)false);){
                            statement.executeStatement();
                        }
                    }
                }
                catch (DBException e) {
                    return GeneralUtils.makeExceptionStatus((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK() && GenerateSQLDialog.this.onSuccess != null) {
                    GenerateSQLDialog.this.onSuccess.run();
                }
            }
        });
        job.schedule();
    }

    @Override
    protected DBCExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @Override
    protected String getSQLText() {
        DBPDataSource dataSource = this.executionContext.getDataSource();
        String lineSeparator = GeneralUtils.getDefaultLineSeparator();
        SQLDialect sqlDialect = dataSource.getSQLDialect();
        String scriptDelimiter = SQLUtils.getDefaultScriptDelimiter((SQLDialect)sqlDialect) + lineSeparator;
        String[] scriptLines = this.generateSQLScript();
        StringBuilder sql = new StringBuilder(scriptLines.length * 64);
        for (String line : scriptLines) {
            sql.append(line).append(scriptDelimiter);
        }
        if (sql.length() > lineSeparator.length()) {
            sql.setLength(sql.length() - lineSeparator.length());
        }
        return sql.toString();
    }

    protected abstract void createControls(Composite var1);

    protected abstract String[] generateSQLScript();
}

