/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.config.migration.wizards.sqlworkbench;

import java.io.Reader;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerDescriptor;
import org.jkiss.dbeaver.model.net.ssh.SSHConstants;
import org.jkiss.dbeaver.registry.driver.DriverUtils;
import org.jkiss.dbeaver.registry.network.NetworkHandlerDescriptor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerRegistry;
import org.jkiss.dbeaver.ui.config.migration.wizards.ImportConfigurationException;
import org.jkiss.dbeaver.ui.config.migration.wizards.ImportConnectionInfo;
import org.jkiss.dbeaver.ui.config.migration.wizards.ImportData;
import org.jkiss.dbeaver.ui.config.migration.wizards.ImportDriverInfo;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLException;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SqlWorkbenchImportConfigurationService {
    private static final Log log = Log.getLog(SqlWorkbenchImportConfigurationService.class);
    public static final SqlWorkbenchImportConfigurationService INSTANCE = new SqlWorkbenchImportConfigurationService();
    private final Set<String> keyWords;
    private final Pattern urlPattern = Pattern.compile("^(?<host>[a-zA-Z0-9.-]+):(?<port>\\d+)$");
    private final Set<String> kerberosDriverTypes = Set.of("ldap_kerberos", "ldap_sasl_kerberos");
    private ImportDriverInfo mysqlDriver;

    private SqlWorkbenchImportConfigurationService() {
        this.keyWords = Set.of("", "hostName", "password", "port", "schema", "sshCompressionLevel", "sshHost", "sshKeyFile", "sshPassword", "sshUserName", "sslCA", "sslCert", "sslCipher", "sslKey", "useSSL", "userName", "kerberosMode", "krb5", "krb5cache", "mysqlplugindir");
        String idMysql = "mysql8";
        DriverUtils.getAllDrivers().stream().filter(dbpDriver -> dbpDriver.getId().equals(idMysql)).findAny().ifPresentOrElse(dbpDriver -> {
            this.mysqlDriver = new ImportDriverInfo(dbpDriver.getId(), dbpDriver.getName(), dbpDriver.getSampleURL(), dbpDriver.getDriverClassName());
        }, () -> {
            this.mysqlDriver = new ImportDriverInfo(idMysql, "MySQL", "jdbc:mysql://{host}[:{port}]/[{database}]", "com.mysql.cj.jdbc.Driver");
        });
    }

    public void importXML(ImportData importData, Reader reader) throws XMLException {
        Document document = XMLUtils.parseDocument((Reader)reader);
        Collection allElements = XMLUtils.getChildElementList((Element)((Element)XMLUtils.getChildElementList((Element)document.getDocumentElement()).iterator().next()));
        for (Element conElement : allElements) {
            importData.addConnection(this.parseConnection(conElement));
        }
    }

    private ImportConnectionInfo parseConnection(Element conElement) {
        String alias = this.getElementValueOrEmptyString(conElement, "name");
        Element parameterValues = this.getElemByNameAndTagKeyValue(conElement, "parameterValues");
        if (parameterValues == null) {
            throw new ImportConfigurationException("Can't find parameterValues tag in the xml");
        }
        String hostName = this.getElementValueOrEmptyString(parameterValues, "hostName");
        String port = this.getElementValueOrEmptyString(parameterValues, "port");
        String userName = this.getElementValueOrEmptyString(parameterValues, "userName");
        ImportConnectionInfo connectionInfo = new ImportConnectionInfo(this.mysqlDriver, null, alias, null, hostName, port, null, userName, null);
        this.configureAuthType(conElement, parameterValues, connectionInfo);
        this.configureSsh(parameterValues, connectionInfo);
        this.configureSsl(parameterValues, connectionInfo);
        this.configureDriverProperties(parameterValues, connectionInfo);
        return connectionInfo;
    }

    private void configureAuthType(Element conElement, Element parameterValues, ImportConnectionInfo connectionInfo) {
        String krbPathConfig;
        String driver = this.getElementValueOrEmptyString(conElement, "driver");
        if (driver == null) {
            log.warn((Object)"Can't find driver tag in the xml");
            return;
        }
        String[] split = driver.split("\\.");
        String driverModel = split[split.length - 1];
        if (this.kerberosDriverTypes.contains(driverModel)) {
            connectionInfo.setAuthModelId("mysql_krb5");
        }
        if (CommonUtils.isNotEmpty((String)(krbPathConfig = this.getElementValueOrEmptyString(parameterValues, "krb5")))) {
            connectionInfo.setAuthProperty("krb5.conf.path", krbPathConfig);
        }
    }

    private void configureDriverProperties(Element parameterValues, ImportConnectionInfo connectionInfo) {
        for (Element element : XMLUtils.getChildElementList((Element)parameterValues)) {
            String driverPropertyValue;
            if (this.keyWords.contains(element.getAttribute("key")) || !CommonUtils.isNotEmpty((String)(driverPropertyValue = XMLUtils.getElementBody((Element)element)))) continue;
            connectionInfo.setProperty(element.getAttribute("key"), driverPropertyValue);
        }
    }

    private void configureSsl(Element parameterValues, ImportConnectionInfo connectionInfo) {
        String sslCA = this.getElementValueOrEmptyString(parameterValues, "sslCA");
        String sslCert = this.getElementValueOrEmptyString(parameterValues, "sslCert");
        String sslCipher = this.getElementValueOrEmptyString(parameterValues, "sslCipher");
        String sslKey = this.getElementValueOrEmptyString(parameterValues, "sslKey");
        NetworkHandlerDescriptor sslHD = NetworkHandlerRegistry.getInstance().getDescriptor("mysql_ssl");
        DBWHandlerConfiguration sslHandler = new DBWHandlerConfiguration((DBWHandlerDescriptor)sslHD, null);
        sslHandler.setProperty("ssl.ca.cert", (Object)sslCA);
        sslHandler.setProperty("ssl.client.cert", (Object)sslCert);
        sslHandler.setProperty("ssl.client.key", (Object)sslKey);
        sslHandler.setProperty("ssl.cipher.suites", (Object)sslCipher);
        String isSslOff = "0";
        if (isSslOff.equals(this.getElementValueOrEmptyString(parameterValues, "useSSL"))) {
            sslHandler.setEnabled(false);
        } else {
            sslHandler.setEnabled(true);
        }
        connectionInfo.addNetworkHandler(sslHandler);
    }

    private void configureSsh(Element parameterValues, ImportConnectionInfo connectionInfo) {
        String sshHost = this.getElementValueOrEmptyString(parameterValues, "sshHost");
        if (CommonUtils.isEmpty((String)sshHost)) {
            return;
        }
        String sshPort = null;
        Matcher matcher = this.urlPattern.matcher(sshHost);
        if (matcher.matches()) {
            sshHost = matcher.group("host");
            sshPort = matcher.group("port");
        }
        String sshKeyFile = this.getElementValueOrEmptyString(parameterValues, "sshKeyFile");
        String sshUserName = this.getElementValueOrEmptyString(parameterValues, "sshUserName");
        NetworkHandlerDescriptor sslHD = NetworkHandlerRegistry.getInstance().getDescriptor("ssh_tunnel");
        DBWHandlerConfiguration sshHandler = new DBWHandlerConfiguration((DBWHandlerDescriptor)sslHD, null);
        sshHandler.setUserName(sshUserName);
        sshHandler.setSavePassword(true);
        sshHandler.setProperty("host", (Object)sshHost);
        sshHandler.setProperty("port", (Object)sshPort);
        if (!CommonUtils.isEmpty((String)sshKeyFile)) {
            sshHandler.setProperty("authType", (Object)SSHConstants.AuthType.PUBLIC_KEY);
            sshHandler.setProperty("keyPath", (Object)sshKeyFile);
        } else {
            sshHandler.setProperty("authType", (Object)SSHConstants.AuthType.PASSWORD);
        }
        sshHandler.setProperty("implementation", (Object)"sshj");
        sshHandler.setEnabled(true);
        connectionInfo.addNetworkHandler(sshHandler);
    }

    @Nullable
    private String getElementValueOrEmptyString(@Nullable Element conElement, @NotNull String keyValue) {
        if (conElement == null) {
            return "";
        }
        Element element = this.getElemByNameAndTagKeyValue(conElement, keyValue);
        if (element == null) {
            return "";
        }
        return XMLUtils.getElementBody((Element)element);
    }

    @Nullable
    private Element getElemByNameAndTagKeyValue(@Nullable Element conElement, String keyValue) {
        if (conElement == null) {
            return null;
        }
        for (Element element : XMLUtils.getChildElementList((Element)conElement)) {
            if (!keyValue.equals(element.getAttribute("key"))) continue;
            return element;
        }
        return null;
    }
}

