/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class ResourceDragAndDropEditor {
    PreferenceGroup folderPref = new PreferenceGroup(IDEWorkbenchMessages.LinkedResourcesPreference_dragAndDropHandlingMessage, "IMPORT_FILES_AND_FOLDERS_MODE", new String[]{IDEWorkbenchMessages.Prompt, IDEWorkbenchMessages.linkedResourcesPreference_copy, IDEWorkbenchMessages.LinkedResourcesPreference_link, IDEWorkbenchMessages.LinkedResourcesPreference_linkAndVirtualFolder}, new String[]{"prompt", "MOVE_COPY", "LINK", "LINK_AND_VIRTUAL_FOLDER"});
    PreferenceGroup virtualFolderPref = new PreferenceGroup(IDEWorkbenchMessages.LinkedResourcesPreference_dragAndDropVirtualFolderHandlingMessage, "IMPORT_FILES_AND_FOLDERS_VIRTUAL_FOLDER_MODE", new String[]{IDEWorkbenchMessages.LinkedResourcesPreference_promptVirtual, IDEWorkbenchMessages.LinkedResourcesPreference_linkVirtual, IDEWorkbenchMessages.LinkedResourcesPreference_linkAndVirtualFolderVirtual}, new String[]{"prompt", "LINK", "LINK_AND_VIRTUAL_FOLDER"});

    public ResourceDragAndDropEditor(Composite composite) {
        this.createControl(composite);
    }

    protected void createControl(Composite parent) {
        this.folderPref.createControl(parent);
        this.virtualFolderPref.createControl(parent);
    }

    public void doLoad() {
        this.folderPref.doLoad();
        this.virtualFolderPref.doLoad();
    }

    public void loadDefault() {
        this.folderPref.loadDefault();
        this.virtualFolderPref.loadDefault();
    }

    public void store() {
        this.folderPref.store();
        this.virtualFolderPref.store();
    }

    public void setEnabled(boolean enableLinking) {
        this.folderPref.setEnabled(enableLinking);
        this.virtualFolderPref.setEnabled(enableLinking);
    }

    static class PreferenceGroup {
        Group group;
        String preferenceKey;
        String title;
        String[] labels;
        String[] values;
        Button[] buttons;

        public PreferenceGroup(String title, String pref, String[] labels, String[] values) {
            this.preferenceKey = pref;
            this.title = title;
            this.labels = labels;
            this.values = values;
        }

        public void createControl(Composite parent) {
            Font font = parent.getFont();
            this.group = new Group(parent, 0);
            GridData data = new GridData(768);
            this.group.setLayoutData((Object)data);
            GridLayout layout = new GridLayout();
            layout.numColumns = this.labels.length;
            this.group.setLayout((Layout)layout);
            this.group.setText(this.title);
            this.group.setFont(font);
            this.buttons = new Button[this.labels.length];
            int i = 0;
            while (i < this.labels.length) {
                this.buttons[i] = new Button((Composite)this.group, 16);
                this.buttons[i].setText(this.labels[i]);
                this.buttons[i].setData((Object)this.values[i]);
                this.buttons[i].setFont(font);
                ++i;
            }
        }

        public void doLoad() {
            String resourcePreference = this.getStoredValue(false);
            this.updateState(resourcePreference);
        }

        private void updateState(String value) {
            int i = 0;
            while (i < this.labels.length) {
                if (value.equals(this.buttons[i].getData())) {
                    this.buttons[i].setSelection(true);
                }
                ++i;
            }
        }

        public void loadDefault() {
            String value = this.getStoredValue(true);
            this.updateState(value);
        }

        public String getStoredValue(boolean useDefault) {
            IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
            if (useDefault) {
                return store.getDefaultString(this.preferenceKey);
            }
            return store.getString(this.preferenceKey);
        }

        private String getSelection() {
            int i = 0;
            while (i < this.labels.length) {
                if (this.buttons[i].getSelection()) {
                    return (String)this.buttons[i].getData();
                }
                ++i;
            }
            return this.values[0];
        }

        public void store() {
            IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
            store.putValue(this.preferenceKey, this.getSelection());
        }

        public void setEnabled(boolean enableLinking) {
            this.group.setEnabled(enableLinking);
            int i = 0;
            while (i < this.labels.length) {
                if (this.buttons[i] != null && !this.buttons[i].isDisposed()) {
                    this.buttons[i].setEnabled(enableLinking);
                }
                ++i;
            }
        }
    }
}

