/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.runtime.IPersistentStorage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.editors.IInMemoryEditorInput;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.IOUtils;

public abstract class AbstractStorageEditorInput
implements IStorageEditorInput,
IInMemoryEditorInput {
    private final String name;
    private final StringBuilder buffer;
    private boolean readOnly;
    private StringStorage storage;
    private final Charset charset;
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public AbstractStorageEditorInput(String name, CharSequence value, boolean readOnly, String charset) {
        this.name = name;
        this.buffer = new StringBuilder(value);
        this.readOnly = readOnly;
        this.charset = Charset.forName(charset);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_INFO);
    }

    public String getName() {
        return this.name;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public StringStorage getStorage() {
        if (this.storage == null) {
            this.storage = new StringStorage();
        }
        return this.storage;
    }

    public String getToolTipText() {
        return this.name;
    }

    @Override
    @Nullable
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public void setProperty(@NotNull String name, @Nullable Object value) {
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setText(String text) {
        this.buffer.setLength(0);
        this.buffer.append(text);
    }

    public String toString() {
        return this.buffer.toString();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IStorage.class) {
            return adapter.cast(this.getStorage());
        }
        return null;
    }

    protected void handleContentSave(IProgressMonitor monitor) throws CoreException {
    }

    public class StringStorage
    implements IPersistentStorage,
    IEncodedStorage {
        public InputStream getContents() {
            return new ByteArrayInputStream(AbstractStorageEditorInput.this.buffer.toString().getBytes(AbstractStorageEditorInput.this.charset));
        }

        public IPath getFullPath() {
            return null;
        }

        public String getName() {
            return AbstractStorageEditorInput.this.name;
        }

        public boolean isReadOnly() {
            return AbstractStorageEditorInput.this.readOnly;
        }

        public <T> T getAdapter(Class<T> adapter) {
            return null;
        }

        public void setContents(IProgressMonitor monitor, InputStream stream) throws CoreException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                IOUtils.copyStream((InputStream)stream, (OutputStream)baos);
                AbstractStorageEditorInput.this.buffer.setLength(0);
                AbstractStorageEditorInput.this.buffer.append(baos.toString(AbstractStorageEditorInput.this.charset));
                AbstractStorageEditorInput.this.handleContentSave(monitor);
            }
            catch (IOException e) {
                throw new CoreException(GeneralUtils.makeExceptionStatus((Throwable)e));
            }
        }

        public String getCharset() {
            return AbstractStorageEditorInput.this.charset.name();
        }

        public void setString(String str) {
            AbstractStorageEditorInput.this.buffer.setLength(0);
            if (str != null) {
                AbstractStorageEditorInput.this.buffer.append(str);
            }
        }

        public String getString() {
            return AbstractStorageEditorInput.this.buffer.toString();
        }

        public int getLength() {
            return AbstractStorageEditorInput.this.buffer.length();
        }
    }
}

