/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.menubuilders.generic;

import java.awt.Component;
import javax.swing.Icon;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.ResourceAccessor;
import org.freeplane.core.util.TextUtils;

public class EntryAccessor {
    private static final String COMPONENT = "component";
    private static final String TEXT = "text";
    private static final String TEXT_KEY = "textKey";
    public static final String ICON = "icon";
    public static final String DRAW_MENU_ICON_ALWAYS = "draw_menu_icon_always";
    public static final String SHOW_MENU_ICONS_PROPERTY = "show_menu_icons";
    public static final Class<Icon> ICON_INSTANCE = Icon.class;
    public static final String ACCELERATOR = "accelerator";
    private final ResourceAccessor resourceAccessor;
    public static final String MENU_ELEMENT_SEPARATOR = " -> ";

    public EntryAccessor(ResourceAccessor resourceAccessor) {
        this.resourceAccessor = resourceAccessor;
    }

    public EntryAccessor() {
        this(ResourceAccessor.NULL_RESOURCE_ACCESSOR);
    }

    public Icon getIcon(Entry entry) {
        if (entry.getAttribute(ICON_INSTANCE) != null) {
            return entry.getAttribute(ICON_INSTANCE);
        }
        String key = (String)entry.getAttribute(ICON);
        if (key == null) {
            String name = entry.getName();
            key = name + ".icon";
        }
        Icon icon = this.resourceAccessor.getIcon(key);
        return icon;
    }

    public String getText(Entry entry) {
        if (entry.getAttribute(TEXT) != null) {
            return (String)entry.getAttribute(TEXT);
        }
        String textKey = (String)entry.getAttribute(TEXT_KEY);
        if (textKey != null) {
            return this.resourceAccessor.getRawText(textKey);
        }
        AFreeplaneAction action = this.getAction(entry);
        if (action != null) {
            return action.getRawText();
        }
        String name = entry.getName();
        if (name.isEmpty()) {
            return "";
        }
        String rawText = this.resourceAccessor.getRawText(name);
        if (rawText != null) {
            return rawText;
        }
        return "";
    }

    public String getTextKey(Entry entry) {
        if (entry.getAttribute(TEXT) != null) {
            return null;
        }
        String textKey = (String)entry.getAttribute(TEXT_KEY);
        if (textKey != null) {
            return textKey;
        }
        AFreeplaneAction action = this.getAction(entry);
        if (action != null) {
            String actionTextKey = action.getTextKey();
            if (TextUtils.getRawText(actionTextKey, null) != null) {
                return actionTextKey;
            }
            return null;
        }
        String name = entry.getName();
        if (name.isEmpty()) {
            return null;
        }
        return name;
    }

    public String getTooltipKey(Entry entry) {
        AFreeplaneAction action = this.getAction(entry);
        if (action != null) {
            String actionTooltipKey = action.getTooltipKey();
            return actionTooltipKey;
        }
        return null;
    }

    public Component getComponent(Entry entry) {
        return (Component)entry.getAttribute(COMPONENT);
    }

    public Object removeComponent(Entry entry) {
        return entry.removeAttribute(COMPONENT);
    }

    public void setComponent(Entry entry, Component component) {
        entry.setAttribute(COMPONENT, (Object)component);
    }

    public AFreeplaneAction getAction(Entry entry) {
        return entry.getAction();
    }

    public void setAction(Entry entry, AFreeplaneAction action) {
        entry.setAction(action);
    }

    public Object getAncestorComponent(Entry entry) {
        Entry parent = entry.getParent();
        if (parent == null) {
            return null;
        }
        Component parentComponent = this.getComponent(parent);
        if (parentComponent != null) {
            return parentComponent;
        }
        return this.getAncestorComponent(parent);
    }

    public void setText(Entry entry, String text) {
        entry.setAttribute(TEXT, (Object)text);
    }

    public void setIcon(Entry entry, Icon icon) {
        entry.setAttribute(ICON_INSTANCE, (Object)icon);
    }

    public void drawMenuIconAlways(Entry entry) {
        entry.setAttribute(DRAW_MENU_ICON_ALWAYS, (Object)Boolean.TRUE);
    }

    public void processUiOnPopup(Entry entry) {
        entry.setAttribute("processOnPopup", (Object)"UI");
    }

    public boolean shouldRemoveMenuIcon(Entry entry) {
        return !this.resourceAccessor.getBooleanProperty(SHOW_MENU_ICONS_PROPERTY, true) && !Boolean.TRUE.equals(entry.getAttribute(DRAW_MENU_ICON_ALWAYS));
    }

    public String getAccelerator(Entry entry) {
        String accelerator = (String)entry.getAttribute(ACCELERATOR);
        return accelerator;
    }

    public Entry addChildAction(Entry target, AFreeplaneAction action) {
        Entry actionEntry = new Entry();
        actionEntry.addConstraint(target);
        actionEntry.setName(action.getKey());
        this.setAction(actionEntry, action);
        target.addChild(actionEntry);
        return actionEntry;
    }

    public String getLocationDescription(Entry entry) {
        StringBuilder stringBuilder = new StringBuilder();
        this.buildLocationDescription(entry, stringBuilder);
        return stringBuilder.toString();
    }

    private void buildLocationDescription(Entry entry, StringBuilder stringBuilder) {
        String entryText;
        Entry parent = entry.getParent();
        if (parent != null) {
            this.buildLocationDescription(parent, stringBuilder);
        }
        if (!(entryText = TextUtils.removeMnemonic(this.getText(entry))).isEmpty()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(MENU_ELEMENT_SEPARATOR);
            }
            stringBuilder.append(entryText);
        }
    }
}

