/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.mode;

import java.awt.event.ActionEvent;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.features.mode.Controller;
import org.freeplane.view.swing.map.MapView;

class FreeScrollAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private final Direction direction;

    public FreeScrollAction(Direction direction) {
        super("FreeScrollAction." + direction.name());
        this.direction = direction;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MapView mapView = (MapView)Controller.getCurrentController().getMapViewManager().getMapViewComponent();
        this.direction.scroll(mapView, ResourceController.getResourceController().getIntProperty("scrollbar_increment", 80));
    }

    public static enum Direction {
        LEFT{

            @Override
            void scroll(MapView mapView, int wheelVelocity) {
                mapView.scrollBy(wheelVelocity, 0);
            }
        }
        ,
        UP{

            @Override
            void scroll(MapView mapView, int wheelVelocity) {
                mapView.scrollBy(0, wheelVelocity);
            }
        }
        ,
        RIGHT{

            @Override
            void scroll(MapView mapView, int wheelVelocity) {
                mapView.scrollBy(-wheelVelocity, 0);
            }
        }
        ,
        DOWN{

            @Override
            void scroll(MapView mapView, int wheelVelocity) {
                mapView.scrollBy(0, -wheelVelocity);
            }
        };


        abstract void scroll(MapView var1, int var2);
    }
}

