/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.tools.edit;

import java.util.Objects;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.ai.tools.edit.EditOperation;

public class HyperlinkContentEditor {
    private final MLinkController linkController;

    public HyperlinkContentEditor(MLinkController linkController) {
        this.linkController = Objects.requireNonNull(linkController, "linkController");
    }

    public void setInitialHyperlink(NodeModel nodeModel, String hyperlink) {
        if (nodeModel == null || hyperlink == null || hyperlink.trim().isEmpty()) {
            return;
        }
        this.linkController.setLink(nodeModel, hyperlink, this.linkController.linkType());
    }

    public void editHyperlink(NodeModel nodeModel, EditOperation operation, String hyperlink) {
        if (nodeModel == null) {
            throw new IllegalArgumentException("Missing node model.");
        }
        if (operation == null) {
            throw new IllegalArgumentException("Missing edit operation.");
        }
        if (operation == EditOperation.DELETE) {
            this.linkController.setLink(nodeModel, (String)null, 0);
            return;
        }
        if (operation != EditOperation.REPLACE) {
            throw new IllegalArgumentException("Unsupported hyperlink edit operation: " + String.valueOf((Object)operation));
        }
        if (hyperlink == null) {
            this.linkController.setLink(nodeModel, (String)null, 0);
            return;
        }
        this.linkController.setLink(nodeModel, hyperlink, this.linkController.linkType());
    }
}

