/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.tools.move;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.map.mindmapmode.OperationErrorHandler;
import org.freeplane.plugin.ai.maps.AvailableMaps;
import org.freeplane.plugin.ai.tools.create.AnchorPlacement;
import org.freeplane.plugin.ai.tools.create.AnchorPlacementCalculator;
import org.freeplane.plugin.ai.tools.create.AnchorPlacementMode;
import org.freeplane.plugin.ai.tools.create.AnchorPlacementResult;
import org.freeplane.plugin.ai.tools.move.MoveNodesRequest;
import org.freeplane.plugin.ai.tools.move.MoveNodesResponse;
import org.freeplane.plugin.ai.tools.utilities.ToolCallSummary;
import org.freeplane.plugin.ai.tools.utilities.ToolErrorHandler;

public class MoveNodesTool {
    private final AvailableMaps availableMaps;
    private final AvailableMaps.MapAccessListener mapAccessListener;
    private final MMapController mapController;
    private final AnchorPlacementCalculator anchorPlacementCalculator;

    public MoveNodesTool(AvailableMaps availableMaps, AvailableMaps.MapAccessListener mapAccessListener, MMapController mapController, AnchorPlacementCalculator anchorPlacementCalculator) {
        this.availableMaps = Objects.requireNonNull(availableMaps, "availableMaps");
        this.mapAccessListener = mapAccessListener;
        this.mapController = Objects.requireNonNull(mapController, "mapController");
        this.anchorPlacementCalculator = Objects.requireNonNull(anchorPlacementCalculator, "anchorPlacementCalculator");
    }

    public MoveNodesResponse moveNodes(MoveNodesRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("Missing request");
        }
        String mapIdentifierValue = this.requireValue(request.getMapIdentifier(), "mapIdentifier");
        UUID mapIdentifier = this.parseMapIdentifier(mapIdentifierValue);
        MapModel mapModel = this.availableMaps.findMapModel(mapIdentifier, this.mapAccessListener);
        if (mapModel == null) {
            throw new IllegalArgumentException("Unknown map identifier: " + mapIdentifierValue);
        }
        String userSummary = this.requireValue(request.getUserSummary(), "userSummary");
        AnchorPlacement anchorPlacement = this.requireValue(request.getAnchorPlacement(), "anchorPlacement");
        String anchorNodeIdentifier = this.requireValue(anchorPlacement.getAnchorNodeIdentifier(), "anchorNodeIdentifier");
        AnchorPlacementMode placementMode = this.requireValue(anchorPlacement.getPlacementMode(), "placementMode");
        NodeModel anchorNode = mapModel.getNodeForID(anchorNodeIdentifier);
        if (anchorNode == null) {
            throw new IllegalArgumentException("Invalid anchor node identifier: " + anchorNodeIdentifier);
        }
        List<String> nodeIdentifiers = this.requireNodes(request.getNodeIdentifiers());
        List<NodeModel> nodesToMove = this.resolveNodes(mapModel, nodeIdentifiers);
        AnchorPlacementResult placement = this.anchorPlacementCalculator.calculatePlacement(anchorNode, placementMode);
        NodeModel parentNode = placement.getParentNode();
        int insertionIndex = placement.getInsertionIndex();
        this.mapController.moveNodes(nodesToMove, parentNode, insertionIndex, (OperationErrorHandler)new ToolErrorHandler("Move failure: "));
        return new MoveNodesResponse(mapIdentifierValue, userSummary, parentNode.createID(), insertionIndex);
    }

    public ToolCallSummary buildToolCallSummary(MoveNodesRequest request, MoveNodesResponse response) {
        if (request == null) {
            return null;
        }
        int itemCount = request.getNodeIdentifiers() == null ? 0 : request.getNodeIdentifiers().size();
        String summaryText = "moveNodes: items=" + itemCount;
        if (request.getUserSummary() != null && !request.getUserSummary().isEmpty()) {
            summaryText = summaryText + ", userSummary=\"" + request.getUserSummary() + "\"";
        }
        return new ToolCallSummary("moveNodes", summaryText, false);
    }

    public ToolCallSummary buildToolCallErrorSummary(MoveNodesRequest request, RuntimeException error) {
        String summaryText = "moveNodes error: " + error.getMessage();
        return new ToolCallSummary("moveNodes", summaryText, true);
    }

    private List<String> requireNodes(List<String> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            throw new IllegalArgumentException("Node identifiers list must be non-empty.");
        }
        return nodes;
    }

    private List<NodeModel> resolveNodes(MapModel mapModel, List<String> nodeIdentifiers) {
        HashSet<String> seen = new HashSet<String>();
        ArrayList<String> duplicates = new ArrayList<String>();
        for (String nodeIdentifier : nodeIdentifiers) {
            if (seen.add(nodeIdentifier)) continue;
            duplicates.add(nodeIdentifier);
        }
        if (!duplicates.isEmpty()) {
            throw new IllegalArgumentException("duplicate node identifiers");
        }
        ArrayList<String> missingIdentifiers = new ArrayList<String>();
        ArrayList<NodeModel> nodes = new ArrayList<NodeModel>(nodeIdentifiers.size());
        for (String nodeIdentifier : nodeIdentifiers) {
            NodeModel node = mapModel.getNodeForID(nodeIdentifier);
            if (node == null) {
                missingIdentifiers.add(nodeIdentifier);
                continue;
            }
            nodes.add(node);
        }
        if (!missingIdentifiers.isEmpty()) {
            throw new IllegalArgumentException("Invalid node identifiers: " + String.valueOf(missingIdentifiers));
        }
        return nodes;
    }

    private <T> T requireValue(T value, String fieldName) {
        if (value == null) {
            throw new IllegalArgumentException("Missing " + fieldName + ".");
        }
        return value;
    }

    private String requireValue(String value, String fieldName) {
        if (value == null || value.trim().isEmpty()) {
            throw new IllegalArgumentException("Missing " + fieldName + ".");
        }
        return value;
    }

    private UUID parseMapIdentifier(String mapIdentifier) {
        try {
            return UUID.fromString(mapIdentifier);
        }
        catch (IllegalArgumentException error) {
            throw new IllegalArgumentException("Invalid map identifier: " + mapIdentifier);
        }
    }
}

