/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode.styleeditorpanel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.freeplane.core.resources.components.PropertyBean;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.IconFont;

class RevertingProperty
extends PropertyBean {
    static final String NAME = "revert";
    private static final int PADDING = (int)(UITools.FONT_SCALE_FACTOR * 2.0f);
    private static final Border BORDER = BorderFactory.createEmptyBorder(PADDING, PADDING, PADDING, PADDING);
    private static final String REVERT_RESOURCE = "reset_property_text";
    private static final String TEXT = TextUtils.getText((String)"reset_property_text");
    private final JButton revertButton = IconFont.createIconButton();

    RevertingProperty() {
        this(NAME);
    }

    RevertingProperty(String name) {
        super(name);
        this.revertButton.setText("\ue901");
        this.revertButton.setToolTipText(TEXT);
        this.revertButton.setBorder(BORDER);
        this.revertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RevertingProperty.this.setValue(!RevertingProperty.this.getBooleanValue());
            }
        });
    }

    public String getValue() {
        return this.revertButton.isVisible() ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
    }

    public JComponent getValueComponent() {
        return this.revertButton;
    }

    public void appendToForm(DefaultFormBuilder builder) {
        builder.append((Component)this.revertButton);
    }

    public void setEnabled(boolean pEnabled) {
        this.revertButton.setEnabled(pEnabled);
        super.setEnabled(pEnabled);
    }

    public boolean isEnabled() {
        return this.revertButton.isEnabled();
    }

    public void setValue(String value) {
        boolean booleanValue = Boolean.parseBoolean(value);
        this.setValue(booleanValue);
    }

    public void setValue(boolean booleanValue) {
        if (this.revertButton.isVisible() != booleanValue) {
            if (!booleanValue && this.revertButton.isFocusOwner()) {
                this.moveFocusToPreviousFocusableComponent();
            }
            this.revertButton.setVisible(booleanValue);
            this.firePropertyChangeEvent();
        }
    }

    private void moveFocusToPreviousFocusableComponent() {
        Component component;
        int i;
        Container parent = this.revertButton.getParent();
        for (i = parent.getComponentCount() - 1; i >= 0 && this.revertButton != (component = parent.getComponent(i)); --i) {
        }
        --i;
        while (i >= 0 && !this.requestFocusInWindow(component = parent.getComponent(i))) {
            --i;
        }
    }

    private boolean requestFocusInWindow(Component component) {
        if (!(component instanceof Container) || ((Container)component).getComponentCount() == 0) {
            boolean isFocusable = component.isFocusable();
            if (isFocusable) {
                component.requestFocusInWindow();
            }
            return isFocusable;
        }
        Container container = (Container)component;
        for (int i = container.getComponentCount() - 1; i >= 0; --i) {
            if (!this.requestFocusInWindow(container.getComponent(i))) continue;
            return true;
        }
        return false;
    }

    public boolean getBooleanValue() {
        return this.revertButton.isVisible();
    }
}

