/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.headlessmode;

import java.util.Set;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.logging.internal.LogInitializer;
import org.freeplane.features.attribute.ModelessAttributeController;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.format.FormatController;
import org.freeplane.features.format.ScannerController;
import org.freeplane.features.help.HelpController;
import org.freeplane.features.highlight.HighlightController;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.MapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.LogicalStyleFilterController;
import org.freeplane.features.text.TextController;
import org.freeplane.features.time.TimeController;
import org.freeplane.main.application.ApplicationResourceController;
import org.freeplane.main.application.CommandLineOptions;
import org.freeplane.main.application.FreeplaneStarter;
import org.freeplane.main.headlessmode.HeadlessMModeControllerFactory;
import org.freeplane.main.headlessmode.HeadlessMapViewController;
import org.freeplane.main.headlessmode.HeadlessUIController;
import org.freeplane.view.swing.features.nodehistory.NodeHistory;

public class FreeplaneHeadlessStarter
implements FreeplaneStarter {
    private final ApplicationResourceController applicationResourceController;
    private HeadlessUIController viewController;
    private final CommandLineOptions options;

    public FreeplaneHeadlessStarter(CommandLineOptions options) {
        this.options = options;
        this.applicationResourceController = new ApplicationResourceController();
    }

    public void setDontLoadLastMaps() {
    }

    public Controller createController() {
        try {
            Controller controller = new Controller((ResourceController)this.applicationResourceController);
            Controller.setCurrentController(controller);
            this.applicationResourceController.init();
            LogInitializer.createLogger();
            ApplicationResourceController.showSysInfo();
            HeadlessMapViewController mapViewController = new HeadlessMapViewController();
            controller.setMapViewManager(mapViewController);
            this.viewController = new HeadlessUIController(controller, mapViewController, "");
            controller.setViewController(this.viewController);
            controller.addExtension(HighlightController.class, new HighlightController());
            FilterController.install();
            FormatController.install(new FormatController());
            ScannerController scannerController = new ScannerController();
            ScannerController.install(scannerController);
            scannerController.addParsersForStandardFormats();
            ModelessAttributeController.install();
            TextController.install();
            TimeController.install();
            LinkController.install();
            IconController.installConditionControllers();
            HelpController.install();
            FilterController.getCurrentFilterController().getConditionFactory().addConditionController(70, new LogicalStyleFilterController());
            MapController.install();
            NodeHistory.install(controller);
            return controller;
        }
        catch (Exception e) {
            LogUtils.severe(e);
            throw new RuntimeException(e);
        }
    }

    public void createModeControllers(Controller controller) {
        HeadlessMModeControllerFactory.createModeController();
    }

    public void buildMenus(Controller controller, Set<String> plugins) {
    }

    public void createFrame() {
        Controller controller = Controller.getCurrentController();
        ModeController modeController = controller.getModeController("MindMap");
        controller.selectModeForBuild(modeController);
        Controller.getCurrentController().fireStartupFinished();
        if (this.options.shouldStopAfterLaunch()) {
            this.stop();
            System.exit(0);
        }
    }

    public void stop() {
        if (this.viewController != null) {
            this.viewController.shutdown();
        }
    }

    public ResourceController getResourceController() {
        return this.applicationResourceController;
    }

    public void loadMapsLater(String[] args) {
    }
}

