#############################################################################
##
#W  compositionfactors.g           GAP4 Package `RCWA'            Stefan Kohl
##
##  Data library of groups generated by 3 class transpositions which inter-
##  change residue classes with moduli <= 6: part containing lists of
##  orders of composition factors.
##
##  For all i in [1..52394] for which grps[i] is finite,
##  compositionfactors[i] is a list of the orders of the composition factors
##  of grps[i], with multiplicities.
##
#############################################################################

local  compfactset, compfactpos, compositionfactors;

compfactset :=
[ fail,[ 2,2 ],[ 2,2,2 ],[ 2,2,2,2 ],[ 2,2,2,2,2 ],
  [ 2,2,2,2,2,2,2 ],[ 2,2,2,2,2,2,2,2,2 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
      3,3,3,60,360,20160,20160,20160,19958400,19958400,43589145600,
      10461394944000,3201186852864000,7755605021665492992000000,
      132626429906095529318154240000000 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,360,
      360,20160,19958400,239500800,3113510400,3113510400 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,60,60,360,
      360,360,360,2520,20160,181440,181440,1814400,1814400,1814400,
      19958400,19958400,19958400,19958400,239500800,239500800,
      239500800,239500800,239500800,3113510400,3113510400,3113510400,
      3113510400,43589145600,43589145600,653837184000,653837184000,
      10461394944000 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,60,
      60,60,60,360,360,181440,43589145600 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,60,60,
      60,360,20160,20160,19958400 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,60,2520,
      2520,20160,181440 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,181440,19958400,
      43589145600,43589145600,653837184000,3201186852864000 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,60,168 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,2520,181440 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,239500800 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,60,360,360,
      2520,2520,2520 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,60,168,360,2520 ]
    ,[ 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,360 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,2520,20160,
      1814400,19958400,239500800,653837184000,10461394944000,
      177843714048000,3201186852864000,60822550204416000,
      310224200866619719680000,201645730563302817792000000 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,360,2520,239500800,
      10461394944000,177843714048000,177843714048000,3201186852864000,
      152444172305856930250752000000,4420880996869850977271808000000 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,181440,239500800,
      3113510400,3113510400,43589145600 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,60,60,60,360,
      360,360,2520,2520,181440,19958400 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,168 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,60,60 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,60,60,360,360,360,
      20160,181440,1814400,1814400,1814400,19958400,19958400,19958400,
      19958400,239500800,239500800,239500800,239500800,239500800,
      3113510400,3113510400,3113510400,3113510400,43589145600,
      43589145600,43589145600,653837184000,653837184000,10461394944000 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,360,2520,20160,
      181440,1814400 ],[ 2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,60 
     ],[ 2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,1814400,1814400 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,3,3 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,60,360,360,2520,
      2520,2520,181440,1814400,1814400,19958400,653837184000 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,60,360,360,2520,
      19958400 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,60,60,168,360,360,
      2520 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,60,60,360,2520,
      20160 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,60,168,360,360,
      2520 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,168,360,2520 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,60,60,60,60,360,360,
      360,2520,239500800 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,60 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,60,60 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,60,2520,2520,2520,20160,
      3113510400 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,168,20160,181440,1814400,
      19958400,43589145600,3201186852864000 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,181440,19958400,
      3113510400,43589145600,177843714048000 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,3,60,60,360,360 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,3,60,360,2520,181440,181440,
      1814400,1814400 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,2,3,60,360,1814400,3113510400 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,3 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,3,3 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,3,3,3 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,5,360,360,
      2520,20160,20160,20160,20160,181440,181440 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,60,60,60,168,
      20160,181440,181440 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,60 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,60,60,360,20160,
      20160,181440,1814400,3113510400 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,60,360,2520 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,168,19958400,19958400,
      239500800,43589145600 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,181440,181440,1814400,
      1814400 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,360,360,20160 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,2520,2520,20160 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,3,3,60 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,2,3,3,60,360,2520,2520,20160,
      20160,3113510400 ],[ 2,2,2,2,2,2,2,2,2,2,2,3,3 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,3,3,3 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,5,60,360,360,2520,
      20160,181440,1814400,19958400,239500800 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,60,360,360,360,
      2520,2520,2520,2520 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,60,60,60,360,2520,
      20160,20160,181440,181440,1814400,19958400 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,60,360,2520,20160,
      20160 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,60,2520,20160 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,360,20160,20160 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,5,60,360,360,360,2520,
      2520 ],[ 2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,60,60 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,60,60,60,60,2520,2520,
      20160 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,60,2520,181440,1814400 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,168,360,360,360,20160,
      19958400,19958400,239500800,3113510400 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,168,360,2520,2520,
      239500800 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,20160,19958400,19958400,
      19958400 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,20160,19958400,3113510400 ]
    ,[ 2,2,2,2,2,2,2,2,2,2,2,3,3,3,60,2520 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,3,3,60 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,3,3,60,168 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,3,3,60,168,2520 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,3,3,60,360,360,2520,2520,19958400 
     ],[ 2,2,2,2,2,2,2,2,2,2,2,3,3,60,181440 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,3,168,2520,20160 ],
  [ 2,2,2,2,2,2,2,2,2,2,2,3,360 ],
  [ 2,2,2,2,2,2,2,2,2,2,3 ],[ 2,2,2,2,2,2,2,2,2,2,3,3 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,5,2520,2520,
      3113510400,3113510400 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,60,60,60,168,2520,
      181440 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,5,60,60,60,60,360,
      2520,20160,181440,181440,181440,43589145600,653837184000 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,5,60,60,60,360,360,
      2520,2520,2520,20160 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,5,60,60,2520,20160 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,5,360,2520,181440,
      181440,1814400 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,60,60,60,60,360,360,
      360,2520,2520,20160 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,60,60,60,168,360,360,
      2520,20160,181440,1814400 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,60,60,60,2520,20160 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,60,60,360 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,60,168,360,360,2520,
      2520 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,3,5,360,2520,20160,19958400,
      239500800 ],[ 2,2,2,2,2,2,2,2,2,2,3,3,3,3,60 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,3,60,60,60,60,60,360,20160,
      20160,20160,181440,181440,239500800,3113510400,3113510400,
      43589145600,43589145600,653837184000 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,3,60,60,60,60,360 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,3,60,60,60,168,360 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,3,60,60,60,168,360,360,
      2520,2520,20160,20160,181440 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,3,60,60,60,360 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,3,60,360,360,360,360,2520 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,3,60,360,360,2520,181440,
      181440 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,3,60,360,2520,2520,2520,
      20160,20160 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,3,60,360,2520,2520,20160 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,3,60,360,2520,20160,20160,
      1814400 ],[ 2,2,2,2,2,2,2,2,2,2,3,3,3,3,2520 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,3,1814400,19958400,19958400,
      19958400,653837184000 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,5,60,60,60,360,360,2520,
      2520,20160 ],[ 2,2,2,2,2,2,2,2,2,2,3,3,3,60 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,60,60,60,60,360,360,360,
      2520,19958400 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,60,60,60,360 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,60,360,2520,181440,181440,
      181440,1814400,19958400,239500800 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,60,360,2520,181440,19958400,
      3113510400 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,60,2520,1814400,239500800 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,360 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,2520,20160,181440,181440,
      43589145600,10461394944000 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,3,181440 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,60 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,60,2520,181440 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,60,20160 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,60,181440 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,3,20160 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,60 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,60,60,360 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,360 ],
  [ 2,2,2,2,2,2,2,2,2,2,3,360,360 ],
  [ 2,2,2,2,2,2,2,2,2,3 ],[ 2,2,2,2,2,2,2,2,2,3,3 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,3 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,3,3 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,60,60,60,360,2520,2520,
      2520,181440 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,3,5,5,360,2520,2520,20160,
      20160,20160 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,3,5,360,360,2520,20160,
      20160,20160,181440 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,3,60,60,60,360,2520,181440,
      1814400 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,3,60,60,360,20160,181440,
      181440,181440,1814400,1814400 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,3,60,60,2520,1814400,
      239500800 ],[ 2,2,2,2,2,2,2,2,2,3,3,3,3,5,60 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,5,360 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,60 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,60,60,60,60,168,360 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,60,60,60,60,168,360,360,
      2520,20160,181440,1814400 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,60,60,60,60,360 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,60,60,60,60,360,360,2520,
      20160,181440,1814400,1814400,239500800,3113510400 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,60,60,60,60,2520,20160 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,60,60,60,168,360,360,360,
      2520 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,60,60,60,168,360,20160 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,60,60,60,360,360 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,60,60,60,360,360,2520 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,60,60,60,360,20160,20160,
      20160,1814400,3113510400,653837184000 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,60,60,60,2520,239500800,
      3113510400 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,60,60,60,20160 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,60,60,360,360,2520,2520,
      20160,20160,181440,181440,1814400 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,60,60,360,2520,1814400 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,60,60,1814400,1814400 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,60,168,2520,2520,2520,20160,
      20160,181440,181440 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,60,360,360 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,60,360,360,2520,2520,2520,
      2520,20160 ],[ 2,2,2,2,2,2,2,2,2,3,3,3,3,60,360,2520 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,60,360,2520,2520,2520,
      239500800 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,60,360,181440,181440,1814400,
      1814400 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,60,20160,20160,20160,181440,
      19958400,19958400 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,168,360,360,2520,2520,181440,
      1814400 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,360,360,2520,2520,2520,181440 
     ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,360,20160,1814400,1814400,
      19958400 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,3,2520,2520,1814400,3113510400 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,5,60,60,360,360,2520,20160 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,60,60 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,60,60,60,60,360 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,60,60,168,360,360,2520 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,60,60,2520,181440 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,60,2520,20160,20160 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,60,20160 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,3,20160,181440,181440,1814400,
      19958400 ],[ 2,2,2,2,2,2,2,2,2,3,3,3,19958400 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,5,2520,20160,181440,1814400 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,60 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,60,60,360,2520,2520,20160,20160,
      20160,239500800 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,60,360,2520,181440 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,168,2520,181440,181440,3113510400,
      653837184000,10461394944000 ],[ 2,2,2,2,2,2,2,2,2,3,3,360 ]
    ,[ 2,2,2,2,2,2,2,2,2,3,3,360,360 ],
  [ 2,2,2,2,2,2,2,2,2,3,3,360,2520,181440,239500800,239500800,
      239500800,43589145600 ],[ 2,2,2,2,2,2,2,2,2,3,60 ],
  [ 2,2,2,2,2,2,2,2,2,3,60,60,60,60 ],
  [ 2,2,2,2,2,2,2,2,2,3,60,360,360,2520,2520,20160,181440 ],
  [ 2,2,2,2,2,2,2,2,2,3,60,360,360,2520,181440,1814400,
      19958400 ],
  [ 2,2,2,2,2,2,2,2,2,3,60,360,1814400,1814400,19958400 ],
  [ 2,2,2,2,2,2,2,2,2,3,2520 ],
  [ 2,2,2,2,2,2,2,2,2,3,1814400 ],
  [ 2,2,2,2,2,2,2,2,2,360 ],[ 2,2,2,2,2,2,2,2,3 ],
  [ 2,2,2,2,2,2,2,2,3,3 ],[ 2,2,2,2,2,2,2,2,3,3,3 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,3,3 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,3,3,5,60,60,360,360,360,2520,
      20160,181440 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,3,3,5,60,360,360,360,2520,2520 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,3,3,5,60,360,2520,20160,181440,
      1814400 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,3,3,60,60,60,360,2520 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,3,3,60,60,168,360 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,3,3,60,60,360,360,2520,2520,
      181440 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,3,3,60,60,360,2520,20160 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,3,3,60,168,360,360,2520 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,3,3,60,168,360,2520,20160 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,3,3,60,360,360,2520 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,3,3,360,360,2520,2520,20160,
      181440,1814400 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,3,5,5,60,60,360,360,2520,2520,
      20160 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,3,5,60,60,360,360,2520,2520,
      20160 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,3,5,60,60,360,360,2520,2520,
      20160,181440 ],[ 2,2,2,2,2,2,2,2,3,3,3,3,60 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,3,60,60,60,60,360 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,3,60,60,60,60,360,360 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,3,60,60,60,360,20160,181440,
      239500800 ],[ 2,2,2,2,2,2,2,2,3,3,3,3,60,60,168,360 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,3,60,60,168,360,360,360,2520,
      2520,20160,20160,181440 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,3,60,60,360,360,360,2520,2520,
      2520 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,3,60,60,360,360,2520,20160,
      1814400,19958400 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,3,60,60,360,2520 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,3,60,60,360,2520,20160 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,3,60,360,360,360,360,2520,20160 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,3,60,360,360,2520,2520,2520,
      20160,181440,1814400 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,3,60,360,360,2520,10461394944000,
      177843714048000 ],[ 2,2,2,2,2,2,2,2,3,3,3,3,360 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,3,360,2520,20160,1814400,1814400,
      19958400,239500800,653837184000,10461394944000 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,3,360,2520,20160,1814400,19958400 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,3,360,20160,20160,3201186852864000,
      3201186852864000 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,5,60,60,360,360,360,2520,2520,
      2520,20160,20160,181440 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,5,60,168,360,20160,20160,20160,
      1814400,3113510400,653837184000 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,5,60,360 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,60 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,60,60,60,60,60,360,20160,181440 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,60,60,60,60,360,360,2520,2520,
      20160 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,60,60,60,2520,2520,10461394944000,
      177843714048000 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,60,60,60,181440,653837184000 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,60,60,168,360,360,2520 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,60,60,2520,20160 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,60,60,20160,20160 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,60,168 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,60,168,360,360,2520,2520,20160,
      181440,1814400,1814400 ],[ 2,2,2,2,2,2,2,2,3,3,3,60,360 ]
    ,[ 2,2,2,2,2,2,2,2,3,3,3,60,360,360,2520,181440,181440,
      1814400,1814400 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,60,2520,2520,20160,20160 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,60,2520,2520,20160,181440,181440 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,60,2520,20160,20160 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,60,2520,20160,181440,19958400,
      43589145600,177843714048000,3201186852864000,25545471085854720000,
      12926008369442488320000,310224200866619719680000,
      7755605021665492992000000,201645730563302817792000000,
      5444434725209176080384000000 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,60,2520,20160,3113510400,
      653837184000,3201186852864000,152444172305856930250752000000 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,60,2520,181440,181440,1814400,
      653837184000 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,60,2520,1814400,239500800,
      43589145600,177843714048000,3201186852864000,
      310224200866619719680000,7755605021665492992000000,
      201645730563302817792000000,5444434725209176080384000000,
      5444434725209176080384000000,4420880996869850977271808000000 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,60,2520,19958400 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,60,2520,19958400,239500800,
      653837184000 ],[ 2,2,2,2,2,2,2,2,3,3,3,168 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,360,360,2520,20160,20160,181440 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,360,20160 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,2520 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,2520,2520 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,2520,20160,181440 ],
  [ 2,2,2,2,2,2,2,2,3,3,3,1814400 ],
  [ 2,2,2,2,2,2,2,2,3,3,5,60,60,60,3113510400 ],
  [ 2,2,2,2,2,2,2,2,3,3,5,60,60,20160,19958400 ],
  [ 2,2,2,2,2,2,2,2,3,3,60 ],
  [ 2,2,2,2,2,2,2,2,3,3,60,60,60,20160,181440,19958400 ],
  [ 2,2,2,2,2,2,2,2,3,3,60,60,168,168,360,2520,20160 ],
  [ 2,2,2,2,2,2,2,2,3,3,60,60,360,20160 ],
  [ 2,2,2,2,2,2,2,2,3,3,60,168 ],
  [ 2,2,2,2,2,2,2,2,3,3,60,168,360,2520,2520,181440,181440 ],
  [ 2,2,2,2,2,2,2,2,3,3,60,360,1814400 ],
  [ 2,2,2,2,2,2,2,2,3,3,60,1814400 ],
  [ 2,2,2,2,2,2,2,2,3,3,168 ],
  [ 2,2,2,2,2,2,2,2,3,3,168,168,360,360 ],
  [ 2,2,2,2,2,2,2,2,3,3,168,360,2520,2520,20160 ],
  [ 2,2,2,2,2,2,2,2,3,3,360 ],
  [ 2,2,2,2,2,2,2,2,3,3,2520 ],
  [ 2,2,2,2,2,2,2,2,3,3,2520,181440 ],
  [ 2,2,2,2,2,2,2,2,3,3,2520,1814400 ],
  [ 2,2,2,2,2,2,2,2,3,60 ],
  [ 2,2,2,2,2,2,2,2,3,60,360,181440 ],
  [ 2,2,2,2,2,2,2,2,3,60,2520 ],
  [ 2,2,2,2,2,2,2,2,3,60,2520,181440 ],
  [ 2,2,2,2,2,2,2,2,3,60,3113510400,10461394944000,
      177843714048000,177843714048000,60822550204416000,
      310224200866619719680000 ],[ 2,2,2,2,2,2,2,2,3,2520 ],
  [ 2,2,2,2,2,2,2,2,3,2520,181440,19958400 ],
  [ 2,2,2,2,2,2,2,2,3,20160,181440 ],
  [ 2,2,2,2,2,2,2,2,60 ],[ 2,2,2,2,2,2,2,2,60,60 ],
  [ 2,2,2,2,2,2,2,2,60,60,60,360 ],
  [ 2,2,2,2,2,2,2,2,60,360,181440,1814400,43589145600 ],
  [ 2,2,2,2,2,2,2,2,60,360,19958400 ],
  [ 2,2,2,2,2,2,2,2,60,181440 ],[ 2,2,2,2,2,2,2,3 ],
  [ 2,2,2,2,2,2,2,3,3 ],[ 2,2,2,2,2,2,2,3,3,3 ],
  [ 2,2,2,2,2,2,2,3,3,3,3 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,3,3,60,1814400,19958400,19958400 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,3,5,5,60,360,2520,2520,20160,
      20160,20160 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,3,5,60,60,360,360,360,2520 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,3,5,60,360,360,360,360,2520,
      2520,20160,181440 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,3,5,60,360,2520,2520,2520,20160 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,3,60,20160,181440,181440,1814400,
      1814400,10461394944000,177843714048000 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,3,360,360,2520,2520,20160,
      239500800,3113510400 ],[ 2,2,2,2,2,2,2,3,3,3,3,3,181440 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,5,360 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,5,181440 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,5,1814400 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,60 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,60,60,60,360,360,2520,2520,20160,
      20160,181440,1814400,1814400,19958400 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,60,60,60,360,360,2520,20160,
      181440 ],[ 2,2,2,2,2,2,2,3,3,3,3,60,60,60,360,2520 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,60,60,60,360,2520,20160 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,60,60,60,20160 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,60,60,168,360 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,60,60,168,360,360,2520,20160 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,60,60,360,360,2520 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,60,60,360,360,2520,2520,20160 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,60,60,360,360,2520,2520,20160,
      181440,1814400 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,60,60,360,360,1814400,19958400 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,60,60,360,2520,2520,20160 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,60,60,360,2520,2520,20160,20160,
      20160,181440 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,60,60,360,2520,20160 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,60,60,2520,181440,181440,1814400,
      1814400,19958400,19958400,239500800,239500800,239500800,
      43589145600 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,60,60,20160,20160,181440,
      10461394944000,177843714048000 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,60,60,181440,239500800,
      177843714048000 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,60,168,168,360,360,360,181440,
      181440,1814400,1814400 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,60,168,360,360,360,2520,2520,
      20160,181440,181440,181440,1814400,1814400 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,60,360 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,60,360,360,181440,1814400 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,60,360,2520,2520,239500800,
      239500800,10461394944000 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,60,2520,2520,2520,1814400 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,60,2520,2520,20160 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,60,2520,2520,20160,181440,181440,
      181440 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,60,20160,19958400,239500800,
      653837184000 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,168,360,20160,181440,181440,
      19958400,239500800 ],[ 2,2,2,2,2,2,2,3,3,3,3,360 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,360,360 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,360,360,2520,2520 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,360,2520 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,360,2520,2520,2520,20160,20160 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,360,20160 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,360,1814400 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,2520,2520,20160,1814400,19958400 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,2520,2520,20160,19958400 ],
  [ 2,2,2,2,2,2,2,3,3,3,3,20160,20160,181440,19958400 ],
  [ 2,2,2,2,2,2,2,3,3,3,5,60,60,360,360,360 ],
  [ 2,2,2,2,2,2,2,3,3,3,5,60,60,2520 ],
  [ 2,2,2,2,2,2,2,3,3,3,5,60,360,360 ],
  [ 2,2,2,2,2,2,2,3,3,3,5,60,20160 ],
  [ 2,2,2,2,2,2,2,3,3,3,5,360,181440,181440,181440,1814400,
      43589145600 ],[ 2,2,2,2,2,2,2,3,3,3,60 ],
  [ 2,2,2,2,2,2,2,3,3,3,60,60 ],
  [ 2,2,2,2,2,2,2,3,3,3,60,60,60,60,360,2520,2520,2520,
      181440 ],[ 2,2,2,2,2,2,2,3,3,3,60,60,60,168,360,2520 ],
  [ 2,2,2,2,2,2,2,3,3,3,60,60,60,168,360,2520,20160 ],
  [ 2,2,2,2,2,2,2,3,3,3,60,60,60,360 ],
  [ 2,2,2,2,2,2,2,3,3,3,60,60,60,360,2520,2520,181440,
      239500800,10461394944000 ],
  [ 2,2,2,2,2,2,2,3,3,3,60,60,168 ],
  [ 2,2,2,2,2,2,2,3,3,3,60,60,168,360,360 ],
  [ 2,2,2,2,2,2,2,3,3,3,60,60,168,360,2520 ],
  [ 2,2,2,2,2,2,2,3,3,3,60,60,168,360,1814400 ],
  [ 2,2,2,2,2,2,2,3,3,3,60,60,168,2520,2520,2520,1814400,
      19958400 ],[ 2,2,2,2,2,2,2,3,3,3,60,60,360,360,360,2520 
     ],
  [ 2,2,2,2,2,2,2,3,3,3,60,60,360,360,2520,20160,19958400 ],
  [ 2,2,2,2,2,2,2,3,3,3,60,60,360,360,2520,19958400 ],
  [ 2,2,2,2,2,2,2,3,3,3,60,60,360,2520,2520 ],
  [ 2,2,2,2,2,2,2,3,3,3,60,60,2520 ],
  [ 2,2,2,2,2,2,2,3,3,3,60,60,2520,2520,20160,1814400 ],
  [ 2,2,2,2,2,2,2,3,3,3,60,60,2520,2520,181440,19958400,
      239500800,3201186852864000,60822550204416000,1216451004088320000,
      25545471085854720000 ],
  [ 2,2,2,2,2,2,2,3,3,3,60,60,2520,20160,20160,181440 ],
  [ 2,2,2,2,2,2,2,3,3,3,60,168,360,360,360,20160,20160,
      1814400,19958400 ],[ 2,2,2,2,2,2,2,3,3,3,60,360 ],
  [ 2,2,2,2,2,2,2,3,3,3,60,360,360 ],
  [ 2,2,2,2,2,2,2,3,3,3,60,360,360,2520,20160 ],
  [ 2,2,2,2,2,2,2,3,3,3,60,360,2520,2520 ],
  [ 2,2,2,2,2,2,2,3,3,3,60,360,2520,20160,20160,181440 ],
  [ 2,2,2,2,2,2,2,3,3,3,60,360,2520,20160,181440,181440,
      181440,1814400,1814400,19958400 ],
  [ 2,2,2,2,2,2,2,3,3,3,60,360,2520,181440,19958400,239500800,
      239500800,3113510400,43589145600,653837184000,10461394944000 ],
  [ 2,2,2,2,2,2,2,3,3,3,60,360,20160,20160,181440,1814400,
      1814400,19958400,19958400,239500800,239500800 ],
  [ 2,2,2,2,2,2,2,3,3,3,60,360,181440,181440,19958400,
      3113510400 ],[ 2,2,2,2,2,2,2,3,3,3,60,2520 ],
  [ 2,2,2,2,2,2,2,3,3,3,60,2520,181440,181440,1814400,1814400,
      19958400 ],[ 2,2,2,2,2,2,2,3,3,3,360 ],
  [ 2,2,2,2,2,2,2,3,3,3,360,360 ],
  [ 2,2,2,2,2,2,2,3,3,3,360,360,20160,19958400,3113510400,
      3113510400,177843714048000 ],
  [ 2,2,2,2,2,2,2,3,3,3,360,2520 ],
  [ 2,2,2,2,2,2,2,3,3,3,360,2520,20160 ],
  [ 2,2,2,2,2,2,2,3,3,3,360,2520,20160,181440,1814400 ],
  [ 2,2,2,2,2,2,2,3,3,3,360,20160,20160,1814400,1814400,
      19958400,239500800 ],[ 2,2,2,2,2,2,2,3,3,3,2520 ],
  [ 2,2,2,2,2,2,2,3,3,3,2520,20160,20160 ],
  [ 2,2,2,2,2,2,2,3,3,3,2520,20160,20160,181440,181440,
      1814400,19958400 ],[ 2,2,2,2,2,2,2,3,3,3,20160 ],
  [ 2,2,2,2,2,2,2,3,3,3,20160,20160 ],
  [ 2,2,2,2,2,2,2,3,3,5,5,60,60,360,360 ],
  [ 2,2,2,2,2,2,2,3,3,60 ],[ 2,2,2,2,2,2,2,3,3,60,60 ],
  [ 2,2,2,2,2,2,2,3,3,60,60,60,360,2520,181440 ],
  [ 2,2,2,2,2,2,2,3,3,60,60,360,360,2520,20160,1814400,
      43589145600 ],[ 2,2,2,2,2,2,2,3,3,60,60,2520 ],
  [ 2,2,2,2,2,2,2,3,3,60,360 ],
  [ 2,2,2,2,2,2,2,3,3,60,360,360,2520,20160,181440,239500800,
      653837184000 ],[ 2,2,2,2,2,2,2,3,3,60,360,2520 ],
  [ 2,2,2,2,2,2,2,3,3,60,360,2520,20160 ],
  [ 2,2,2,2,2,2,2,3,3,60,360,2520,20160,20160,20160,181440,
      181440,1814400,19958400 ],
  [ 2,2,2,2,2,2,2,3,3,60,2520,2520,20160,653837184000 ],
  [ 2,2,2,2,2,2,2,3,3,60,2520,2520,181440,1814400 ],
  [ 2,2,2,2,2,2,2,3,3,168 ],[ 2,2,2,2,2,2,2,3,3,360 ],
  [ 2,2,2,2,2,2,2,3,3,360,360,20160,181440,19958400,239500800 ],
  [ 2,2,2,2,2,2,2,3,3,2520 ],
  [ 2,2,2,2,2,2,2,3,3,2520,2520,20160,20160,239500800 ],
  [ 2,2,2,2,2,2,2,3,3,2520,181440 ],
  [ 2,2,2,2,2,2,2,3,3,20160 ],[ 2,2,2,2,2,2,2,3,3,181440 ],
  [ 2,2,2,2,2,2,2,3,60 ],
  [ 2,2,2,2,2,2,2,3,60,181440,181440,1814400,19958400,
      3113510400,3113510400,43589145600,43589145600,3201186852864000,
      3201186852864000 ],[ 2,2,2,2,2,2,2,3,360 ],
  [ 2,2,2,2,2,2,2,60 ],[ 2,2,2,2,2,2,2,60,2520 ],
  [ 2,2,2,2,2,2,2,60,2520,1814400,239500800 ],
  [ 2,2,2,2,2,2,2,60,20160 ],[ 2,2,2,2,2,2,2,168 ],
  [ 2,2,2,2,2,2,2,360 ],[ 2,2,2,2,2,2,2,2520 ],
  [ 2,2,2,2,2,2,2,181440 ],[ 2,2,2,2,2,2,3 ],
  [ 2,2,2,2,2,2,3,3 ],[ 2,2,2,2,2,2,3,3,3 ],
  [ 2,2,2,2,2,2,3,3,3,3 ],[ 2,2,2,2,2,2,3,3,3,3,3 ],
  [ 2,2,2,2,2,2,3,3,3,3,3,5,60,60,360,2520 ],
  [ 2,2,2,2,2,2,3,3,3,3,5,60,60,60,168,168,20160,20160,
      20160,181440,1814400,19958400 ],
  [ 2,2,2,2,2,2,3,3,3,3,5,60,360 ],
  [ 2,2,2,2,2,2,3,3,3,3,5,60,360,360,2520,20160,20160,181440 
     ],[ 2,2,2,2,2,2,3,3,3,3,60,60 ],
  [ 2,2,2,2,2,2,3,3,3,3,60,60,60,60,181440,1814400,19958400 ],
  [ 2,2,2,2,2,2,3,3,3,3,60,60,2520,2520,181440 ],
  [ 2,2,2,2,2,2,3,3,3,3,60,360,20160,1814400,1814400,
      43589145600 ],[ 2,2,2,2,2,2,3,3,3,3,60,2520 ],
  [ 2,2,2,2,2,2,3,3,3,3,60,2520,20160,20160,181440,1814400,
      19958400,653837184000,10461394944000 ],
  [ 2,2,2,2,2,2,3,3,3,3,360,360,360,2520,20160,20160,20160 ],
  [ 2,2,2,2,2,2,3,3,3,3,360,2520 ],
  [ 2,2,2,2,2,2,3,3,3,3,360,2520,2520,20160,20160,181440 ],
  [ 2,2,2,2,2,2,3,3,3,3,360,2520,20160,20160,1814400,239500800 
     ],[ 2,2,2,2,2,2,3,3,3,3,2520,20160 ],
  [ 2,2,2,2,2,2,3,3,3,5 ],
  [ 2,2,2,2,2,2,3,3,3,5,60,60,168,360,360,360,360,2520,
      2520,20160,20160,181440 ],
  [ 2,2,2,2,2,2,3,3,3,5,60,60,360,2520,181440,1814400 ],
  [ 2,2,2,2,2,2,3,3,3,5,60,360,360,2520,2520 ],
  [ 2,2,2,2,2,2,3,3,3,5,60,360,2520,20160 ],
  [ 2,2,2,2,2,2,3,3,3,5,360,2520,2520,181440,1814400 ],
  [ 2,2,2,2,2,2,3,3,3,5,360,1814400,19958400,239500800,
      239500800,239500800,239500800,239500800,3113510400,43589145600,
      43589145600 ],[ 2,2,2,2,2,2,3,3,3,5,2520,2520,3113510400 ],
  [ 2,2,2,2,2,2,3,3,3,60 ],[ 2,2,2,2,2,2,3,3,3,60,60 ],
  [ 2,2,2,2,2,2,3,3,3,60,60,60,168,168,360,360,360,2520,
      20160,181440,1814400,19958400,3113510400 ],
  [ 2,2,2,2,2,2,3,3,3,60,60,60,360,360,360,2520,20160,181440 
     ],[ 2,2,2,2,2,2,3,3,3,60,60,60,360,360,2520,20160,
      181440,181440 ],[ 2,2,2,2,2,2,3,3,3,60,60,60,2520 ],
  [ 2,2,2,2,2,2,3,3,3,60,60,168,2520,181440,1814400,239500800 ]
    ,[ 2,2,2,2,2,2,3,3,3,60,60,360 ],
  [ 2,2,2,2,2,2,3,3,3,60,60,360,360,360,2520,2520,20160 ],
  [ 2,2,2,2,2,2,3,3,3,60,60,360,2520 ],
  [ 2,2,2,2,2,2,3,3,3,60,60,360,2520,20160,20160,181440,
      181440,1814400 ],
  [ 2,2,2,2,2,2,3,3,3,60,60,360,2520,20160,181440,1814400,
      19958400 ],
  [ 2,2,2,2,2,2,3,3,3,60,60,360,2520,1814400,43589145600,
      653837184000 ],
  [ 2,2,2,2,2,2,3,3,3,60,60,360,2520,19958400,3113510400,
      43589145600 ],[ 2,2,2,2,2,2,3,3,3,60,60,181440 ],
  [ 2,2,2,2,2,2,3,3,3,60,168,168,2520,20160,181440,1814400 ],
  [ 2,2,2,2,2,2,3,3,3,60,360 ],
  [ 2,2,2,2,2,2,3,3,3,60,360,360,2520,2520,20160 ],
  [ 2,2,2,2,2,2,3,3,3,60,360,2520,239500800,3113510400 ],
  [ 2,2,2,2,2,2,3,3,3,60,2520,20160 ],
  [ 2,2,2,2,2,2,3,3,3,60,2520,20160,20160,181440 ],
  [ 2,2,2,2,2,2,3,3,3,60,20160 ],
  [ 2,2,2,2,2,2,3,3,3,60,20160,20160,181440,3113510400,
      43589145600,60822550204416000 ],
  [ 2,2,2,2,2,2,3,3,3,60,20160,181440,181440,1814400 ],
  [ 2,2,2,2,2,2,3,3,3,60,20160,1814400,19958400,10461394944000 ],
  [ 2,2,2,2,2,2,3,3,3,60,181440,181440,653837184000,
      177843714048000 ],
  [ 2,2,2,2,2,2,3,3,3,60,181440,1814400,1814400,19958400,
      19958400,19958400,239500800,3113510400 ],
  [ 2,2,2,2,2,2,3,3,3,60,181440,1814400,239500800,43589145600 ],
  [ 2,2,2,2,2,2,3,3,3,60,1814400 ],
  [ 2,2,2,2,2,2,3,3,3,60,43589145600,653837184000,653837184000 ],
  [ 2,2,2,2,2,2,3,3,3,360 ],[ 2,2,2,2,2,2,3,3,3,360,360 ],
  [ 2,2,2,2,2,2,3,3,3,360,360,2520,2520,2520,20160,1814400,
      19958400 ],
  [ 2,2,2,2,2,2,3,3,3,360,2520,2520,2520,2520,20160,20160 ],
  [ 2,2,2,2,2,2,3,3,3,360,2520,20160 ],
  [ 2,2,2,2,2,2,3,3,3,360,2520,181440,19958400,3113510400 ],
  [ 2,2,2,2,2,2,3,3,3,2520,2520,1814400,19958400,43589145600 ],
  [ 2,2,2,2,2,2,3,3,3,20160 ],
  [ 2,2,2,2,2,2,3,3,3,20160,1814400 ],
  [ 2,2,2,2,2,2,3,3,3,181440 ],
  [ 2,2,2,2,2,2,3,3,3,239500800 ],
  [ 2,2,2,2,2,2,3,3,3,3113510400,43589145600,3201186852864000,
      7755605021665492992000000,201645730563302817792000000 ],
  [ 2,2,2,2,2,2,3,3,5,60 ],
  [ 2,2,2,2,2,2,3,3,5,60,60,360,2520,20160,181440,1814400,
      1814400,239500800,3113510400 ],
  [ 2,2,2,2,2,2,3,3,5,60,60,360,20160,181440 ],
  [ 2,2,2,2,2,2,3,3,5,360 ],[ 2,2,2,2,2,2,3,3,60 ],
  [ 2,2,2,2,2,2,3,3,60,60 ],[ 2,2,2,2,2,2,3,3,60,60,60 ],
  [ 2,2,2,2,2,2,3,3,60,60,60,168,360,20160,20160,20160,
      1814400,19958400 ],[ 2,2,2,2,2,2,3,3,60,60,60,168,20160 ],
  [ 2,2,2,2,2,2,3,3,60,60,60,360,20160,181440 ],
  [ 2,2,2,2,2,2,3,3,60,60,60,360,181440,239500800,239500800 ],
  [ 2,2,2,2,2,2,3,3,60,60,60,20160 ],
  [ 2,2,2,2,2,2,3,3,60,60,360 ],
  [ 2,2,2,2,2,2,3,3,60,60,360,360,2520,20160 ],
  [ 2,2,2,2,2,2,3,3,60,60,360,2520 ],
  [ 2,2,2,2,2,2,3,3,60,60,360,20160 ],
  [ 2,2,2,2,2,2,3,3,60,60,360,20160,181440,1814400,1814400,
      239500800,239500800,3113510400 ],
  [ 2,2,2,2,2,2,3,3,60,60,2520 ],
  [ 2,2,2,2,2,2,3,3,60,60,2520,20160,20160,181440,181440,
      653837184000 ],[ 2,2,2,2,2,2,3,3,60,60,20160 ],
  [ 2,2,2,2,2,2,3,3,60,60,20160,20160,181440,1814400,
      653837184000 ],
  [ 2,2,2,2,2,2,3,3,60,60,653837184000,10461394944000,
      10461394944000,201645730563302817792000000 ],
  [ 2,2,2,2,2,2,3,3,60,168,360,2520,1814400,1814400,
      60822550204416000,1216451004088320000 ],
  [ 2,2,2,2,2,2,3,3,60,360 ],
  [ 2,2,2,2,2,2,3,3,60,360,360 ],
  [ 2,2,2,2,2,2,3,3,60,360,360,1814400,1814400,19958400 ],
  [ 2,2,2,2,2,2,3,3,60,360,2520 ],
  [ 2,2,2,2,2,2,3,3,60,360,2520,2520,2520,20160 ],
  [ 2,2,2,2,2,2,3,3,60,360,2520,2520,181440,1814400,1814400 ],
  [ 2,2,2,2,2,2,3,3,60,360,2520,181440 ],
  [ 2,2,2,2,2,2,3,3,60,360,2520,181440,239500800,177843714048000,
      1216451004088320000 ],
  [ 2,2,2,2,2,2,3,3,60,360,2520,3113510400,653837184000 ],
  [ 2,2,2,2,2,2,3,3,60,360,20160 ],
  [ 2,2,2,2,2,2,3,3,60,360,181440 ],
  [ 2,2,2,2,2,2,3,3,60,2520,20160 ],
  [ 2,2,2,2,2,2,3,3,60,2520,20160,181440,1814400,239500800,
      239500800 ],
  [ 2,2,2,2,2,2,3,3,60,2520,181440,1814400,239500800,
      10461394944000,3201186852864000 ],
  [ 2,2,2,2,2,2,3,3,60,2520,3113510400,653837184000,
      3201186852864000,562000363888803840000,562000363888803840000,
      201645730563302817792000000 ],[ 2,2,2,2,2,2,3,3,60,20160 ],
  [ 2,2,2,2,2,2,3,3,60,181440,1814400 ],
  [ 2,2,2,2,2,2,3,3,60,1814400,1814400,1216451004088320000,
      25545471085854720000,310224200866619719680000 ],
  [ 2,2,2,2,2,2,3,3,60,1814400,19958400,10461394944000,
      3201186852864000 ],
  [ 2,2,2,2,2,2,3,3,60,19958400,239500800,43589145600,
      10461394944000 ],[ 2,2,2,2,2,2,3,3,168,360 ],
  [ 2,2,2,2,2,2,3,3,168,360,2520,2520,2520,20160,181440,
      43589145600 ],[ 2,2,2,2,2,2,3,3,168,360,2520,181440,181440 
     ],[ 2,2,2,2,2,2,3,3,360 ],[ 2,2,2,2,2,2,3,3,360,360 ],
  [ 2,2,2,2,2,2,3,3,360,2520 ],
  [ 2,2,2,2,2,2,3,3,360,181440 ],
  [ 2,2,2,2,2,2,3,3,360,1814400,19958400 ],
  [ 2,2,2,2,2,2,3,3,360,1814400,19958400,239500800,239500800,
      653837184000 ],[ 2,2,2,2,2,2,3,3,2520 ],
  [ 2,2,2,2,2,2,3,3,2520,20160 ],
  [ 2,2,2,2,2,2,3,3,2520,20160,181440,1814400,19958400,
      3201186852864000 ],[ 2,2,2,2,2,2,3,3,20160 ],
  [ 2,2,2,2,2,2,3,3,181440 ],
  [ 2,2,2,2,2,2,3,3,1814400,239500800,43589145600,43589145600,
      653837184000,653837184000 ],
  [ 2,2,2,2,2,2,3,3,19958400,19958400,239500800,239500800,
      3113510400,43589145600 ],
  [ 2,2,2,2,2,2,3,3,19958400,19958400,10461394944000 ],
  [ 2,2,2,2,2,2,3,5,5 ],[ 2,2,2,2,2,2,3,5,60 ],
  [ 2,2,2,2,2,2,3,5,20160,181440,19958400,10461394944000 ],
  [ 2,2,2,2,2,2,3,60 ],[ 2,2,2,2,2,2,3,60,60,60,360 ],
  [ 2,2,2,2,2,2,3,60,60,60,360,360,2520,2520 ],
  [ 2,2,2,2,2,2,3,60,60,60,20160,20160,20160,181440,43589145600 
     ],[ 2,2,2,2,2,2,3,60,60,360 ],
  [ 2,2,2,2,2,2,3,60,60,360,2520,2520,2520,20160,20160 ],
  [ 2,2,2,2,2,2,3,60,60,360,2520,20160,20160,1814400 ],
  [ 2,2,2,2,2,2,3,60,60,2520 ],
  [ 2,2,2,2,2,2,3,60,60,2520,2520 ],
  [ 2,2,2,2,2,2,3,60,60,2520,20160,181440 ],
  [ 2,2,2,2,2,2,3,60,360,360,2520,2520 ],
  [ 2,2,2,2,2,2,3,60,360,2520 ],
  [ 2,2,2,2,2,2,3,60,360,2520,1814400 ],
  [ 2,2,2,2,2,2,3,60,2520 ],[ 2,2,2,2,2,2,3,168,360 ],
  [ 2,2,2,2,2,2,3,360 ],
  [ 2,2,2,2,2,2,3,360,360,20160,1814400 ],
  [ 2,2,2,2,2,2,3,360,2520 ],[ 2,2,2,2,2,2,3,360,20160 ],
  [ 2,2,2,2,2,2,3,2520 ],[ 2,2,2,2,2,2,3,20160,20160 ],
  [ 2,2,2,2,2,2,60 ],[ 2,2,2,2,2,2,60,1814400 ],
  [ 2,2,2,2,2,3 ],[ 2,2,2,2,2,3,3 ],[ 2,2,2,2,2,3,3,3 ],
  [ 2,2,2,2,2,3,3,3,3,3,60,60,360,360,2520,1814400 ],
  [ 2,2,2,2,2,3,3,3,3,3,60,360,20160,20160,181440,181440 ],
  [ 2,2,2,2,2,3,3,3,3,3,60,1814400,1814400,19958400,239500800,
      3113510400 ],
  [ 2,2,2,2,2,3,3,3,3,3,2520,20160,20160,1814400,1814400,
      19958400 ],[ 2,2,2,2,2,3,3,3,3,5 ],
  [ 2,2,2,2,2,3,3,3,3,5,60,60,60,60,360,360,2520,20160 ],
  [ 2,2,2,2,2,3,3,3,3,5,60,360 ],
  [ 2,2,2,2,2,3,3,3,3,5,60,2520,2520,2520,20160,181440 ],
  [ 2,2,2,2,2,3,3,3,3,5,60,3113510400,10461394944000,
      10461394944000,1216451004088320000 ],
  [ 2,2,2,2,2,3,3,3,3,5,360,20160,181440,1814400 ],
  [ 2,2,2,2,2,3,3,3,3,60 ],
  [ 2,2,2,2,2,3,3,3,3,60,60,360,360,2520,20160,181440 ],
  [ 2,2,2,2,2,3,3,3,3,60,60,360,2520 ],
  [ 2,2,2,2,2,3,3,3,3,60,168,360,2520,20160 ],
  [ 2,2,2,2,2,3,3,3,3,60,360,360,2520,2520,2520,20160 ],
  [ 2,2,2,2,2,3,3,3,3,60,360,2520 ],
  [ 2,2,2,2,2,3,3,3,3,60,360,2520,20160,1814400,43589145600 ],
  [ 2,2,2,2,2,3,3,3,3,168,360,2520,2520,20160,20160,1814400,
      19958400,239500800 ],
  [ 2,2,2,2,2,3,3,3,3,168,360,2520,2520,20160,1814400,1814400,
      19958400,653837184000,10461394944000 ],
  [ 2,2,2,2,2,3,3,3,3,360,360,2520,2520,2520,20160,20160,
      20160,181440,181440,1814400,1814400,19958400 ],
  [ 2,2,2,2,2,3,3,3,3,360,2520,2520,20160,181440,181440 ],
  [ 2,2,2,2,2,3,3,3,3,2520 ],[ 2,2,2,2,2,3,3,3,3,20160 ],
  [ 2,2,2,2,2,3,3,3,3,20160,20160 ],
  [ 2,2,2,2,2,3,3,3,5,60,60,60,360,2520,181440 ],
  [ 2,2,2,2,2,3,3,3,5,60,60,60,360,20160,181440 ],
  [ 2,2,2,2,2,3,3,3,5,60,60,360,360,2520,20160,181440,181440,
      1814400,1814400,19958400,239500800 ],
  [ 2,2,2,2,2,3,3,3,5,60,60,360,20160,181440,19958400 ],
  [ 2,2,2,2,2,3,3,3,5,60,60,2520 ],
  [ 2,2,2,2,2,3,3,3,5,60,360 ],
  [ 2,2,2,2,2,3,3,3,5,60,360,360,360,2520 ],
  [ 2,2,2,2,2,3,3,3,5,60,360,360,20160,181440 ],
  [ 2,2,2,2,2,3,3,3,5,60,360,2520,20160,19958400,3113510400 ],
  [ 2,2,2,2,2,3,3,3,5,60,360,2520,181440,19958400 ],
  [ 2,2,2,2,2,3,3,3,5,60,20160 ],
  [ 2,2,2,2,2,3,3,3,5,60,181440 ],
  [ 2,2,2,2,2,3,3,3,5,168,360 ],
  [ 2,2,2,2,2,3,3,3,5,360,2520,2520,20160,181440,181440,
      181440,1814400,19958400,239500800 ],
  [ 2,2,2,2,2,3,3,3,5,360,20160,181440,1814400 ],
  [ 2,2,2,2,2,3,3,3,5,2520,2520,181440 ],
  [ 2,2,2,2,2,3,3,3,5,2520,2520,181440,1814400,1814400,
      19958400,19958400,239500800 ],[ 2,2,2,2,2,3,3,3,5,1814400 ],
  [ 2,2,2,2,2,3,3,3,60 ],[ 2,2,2,2,2,3,3,3,60,60,60,360 ],
  [ 2,2,2,2,2,3,3,3,60,60,60,360,360,360,2520,20160,181440 ],
  [ 2,2,2,2,2,3,3,3,60,60,60,360,20160,181440,181440 ],
  [ 2,2,2,2,2,3,3,3,60,60,60,2520 ],
  [ 2,2,2,2,2,3,3,3,60,60,60,2520,181440 ],
  [ 2,2,2,2,2,3,3,3,60,60,168,168,168,360,360,360,360,2520 ],
  [ 2,2,2,2,2,3,3,3,60,60,360 ],
  [ 2,2,2,2,2,3,3,3,60,60,360,2520,2520,20160,20160,20160,
      20160,181440,181440,1814400,1814400,19958400,19958400,19958400,
      19958400,239500800,239500800 ],
  [ 2,2,2,2,2,3,3,3,60,60,360,2520,19958400 ],
  [ 2,2,2,2,2,3,3,3,60,60,360,20160 ],
  [ 2,2,2,2,2,3,3,3,60,60,2520,2520,181440,43589145600,
      653837184000 ],[ 2,2,2,2,2,3,3,3,60,60,20160 ],
  [ 2,2,2,2,2,3,3,3,60,168 ],
  [ 2,2,2,2,2,3,3,3,60,168,168,360,360,360,20160,181440,
      181440,1814400 ],
  [ 2,2,2,2,2,3,3,3,60,168,360,360,360,2520,2520,20160,20160,
      181440,181440 ],[ 2,2,2,2,2,3,3,3,60,360,360 ],
  [ 2,2,2,2,2,3,3,3,60,360,360,360,2520,3113510400,3113510400 ],
  [ 2,2,2,2,2,3,3,3,60,360,360,2520,20160,1814400 ],
  [ 2,2,2,2,2,3,3,3,60,360,360,2520,20160,1814400,1814400,
      1814400,19958400,19958400,19958400,19958400,239500800,239500800 ],
  [ 2,2,2,2,2,3,3,3,60,360,2520 ],
  [ 2,2,2,2,2,3,3,3,60,360,2520,2520,2520,43589145600,
      10461394944000 ],
  [ 2,2,2,2,2,3,3,3,60,360,2520,2520,20160,19958400,239500800 ],
  [ 2,2,2,2,2,3,3,3,60,360,2520,2520,181440,19958400,239500800,
      3201186852864000,60822550204416000,1216451004088320000,
      25545471085854720000 ],
  [ 2,2,2,2,2,3,3,3,60,360,2520,20160,20160,181440,181440 ],
  [ 2,2,2,2,2,3,3,3,60,360,2520,20160,20160,181440,181440,
      1814400,1814400,1814400,19958400,19958400,19958400,239500800 ],
  [ 2,2,2,2,2,3,3,3,60,360,2520,20160,1814400,1814400,19958400,
      19958400,239500800,3113510400,653837184000 ],
  [ 2,2,2,2,2,3,3,3,60,360,2520,1814400,19958400,653837184000,
      10461394944000 ],
  [ 2,2,2,2,2,3,3,3,60,360,2520,239500800,3113510400 ],
  [ 2,2,2,2,2,3,3,3,60,360,20160 ],
  [ 2,2,2,2,2,3,3,3,60,2520,20160 ],
  [ 2,2,2,2,2,3,3,3,60,2520,20160,181440,181440,181440,1814400,
      19958400,239500800,3113510400,43589145600,653837184000,
      10461394944000 ],[ 2,2,2,2,2,3,3,3,60,2520,181440 ],
  [ 2,2,2,2,2,3,3,3,60,181440 ],
  [ 2,2,2,2,2,3,3,3,60,19958400,239500800,43589145600,
      653837184000 ],
  [ 2,2,2,2,2,3,3,3,60,43589145600,653837184000,60822550204416000 ]
    ,[ 2,2,2,2,2,3,3,3,168,360,360 ],
  [ 2,2,2,2,2,3,3,3,360 ],[ 2,2,2,2,2,3,3,3,360,360,2520 ],
  [ 2,2,2,2,2,3,3,3,360,360,2520,20160,181440,239500800,
      653837184000,3201186852864000 ],
  [ 2,2,2,2,2,3,3,3,360,360,20160 ],
  [ 2,2,2,2,2,3,3,3,360,360,181440,1814400,239500800,3113510400,
      653837184000 ],
  [ 2,2,2,2,2,3,3,3,360,2520,2520,1814400,19958400 ],
  [ 2,2,2,2,2,3,3,3,360,2520,20160 ],
  [ 2,2,2,2,2,3,3,3,360,2520,20160,20160,181440,1814400,
      1814400,19958400,19958400 ],
  [ 2,2,2,2,2,3,3,3,360,2520,20160,239500800,3113510400 ],
  [ 2,2,2,2,2,3,3,3,360,2520,181440 ],
  [ 2,2,2,2,2,3,3,3,360,181440 ],
  [ 2,2,2,2,2,3,3,3,360,1814400,19958400,43589145600,
      1216451004088320000,25545471085854720000 ],
  [ 2,2,2,2,2,3,3,3,2520,2520 ],
  [ 2,2,2,2,2,3,3,3,2520,20160 ],
  [ 2,2,2,2,2,3,3,3,2520,20160,181440 ],
  [ 2,2,2,2,2,3,3,3,2520,1814400 ],[ 2,2,2,2,2,3,3,3,20160 ]
    ,[ 2,2,2,2,2,3,3,3,20160,181440 ],
  [ 2,2,2,2,2,3,3,3,20160,181440,181440 ],
  [ 2,2,2,2,2,3,3,3,20160,1814400 ],
  [ 2,2,2,2,2,3,3,3,20160,1814400,653837184000,10461394944000,
      177843714048000,60822550204416000 ],
  [ 2,2,2,2,2,3,3,3,181440,181440 ],
  [ 2,2,2,2,2,3,3,3,181440,181440,19958400 ],
  [ 2,2,2,2,2,3,3,3,181440,1814400 ],
  [ 2,2,2,2,2,3,3,3,19958400,19958400 ],
  [ 2,2,2,2,2,3,3,5,60 ],
  [ 2,2,2,2,2,3,3,5,60,60,60,2520,2520,2520,19958400,
      239500800,239500800,3113510400,43589145600,653837184000 ],
  [ 2,2,2,2,2,3,3,5,60,60,360 ],
  [ 2,2,2,2,2,3,3,5,60,360,2520,2520,2520,20160,181440 ],
  [ 2,2,2,2,2,3,3,5,60,360,2520,2520,20160,181440,1814400 ],
  [ 2,2,2,2,2,3,3,5,360 ],
  [ 2,2,2,2,2,3,3,5,360,20160,181440 ],
  [ 2,2,2,2,2,3,3,5,2520,2520,1814400 ],
  [ 2,2,2,2,2,3,3,5,20160 ],
  [ 2,2,2,2,2,3,3,5,181440,1814400 ],[ 2,2,2,2,2,3,3,60 ],
  [ 2,2,2,2,2,3,3,60,60 ],[ 2,2,2,2,2,3,3,60,60,60 ],
  [ 2,2,2,2,2,3,3,60,60,168,360 ],
  [ 2,2,2,2,2,3,3,60,60,168,360,360,360 ],
  [ 2,2,2,2,2,3,3,60,60,360 ],
  [ 2,2,2,2,2,3,3,60,60,360,360 ],
  [ 2,2,2,2,2,3,3,60,60,360,360,20160 ],
  [ 2,2,2,2,2,3,3,60,60,360,2520,2520 ],
  [ 2,2,2,2,2,3,3,60,60,360,2520,20160,1814400,1814400 ],
  [ 2,2,2,2,2,3,3,60,60,360,20160,181440,19958400 ],
  [ 2,2,2,2,2,3,3,60,60,360,181440,1814400 ],
  [ 2,2,2,2,2,3,3,60,60,20160 ],
  [ 2,2,2,2,2,3,3,60,168,360 ],
  [ 2,2,2,2,2,3,3,60,168,360,360 ],
  [ 2,2,2,2,2,3,3,60,168,360,181440,1814400,1814400,1814400,
      3201186852864000 ],[ 2,2,2,2,2,3,3,60,360 ],
  [ 2,2,2,2,2,3,3,60,360,360,360,2520,20160,20160,20160 ],
  [ 2,2,2,2,2,3,3,60,360,360,2520,239500800 ],
  [ 2,2,2,2,2,3,3,60,360,2520 ],
  [ 2,2,2,2,2,3,3,60,360,2520,2520 ],
  [ 2,2,2,2,2,3,3,60,360,2520,2520,20160,20160,181440,1814400,
      1814400,1814400,19958400,3113510400,3113510400,653837184000,
      3201186852864000 ],[ 2,2,2,2,2,3,3,60,360,2520,20160,181440 
     ],[ 2,2,2,2,2,3,3,60,360,2520,20160,19958400,239500800,
      239500800,43589145600 ],
  [ 2,2,2,2,2,3,3,60,360,20160,181440 ],
  [ 2,2,2,2,2,3,3,60,2520 ],
  [ 2,2,2,2,2,3,3,60,2520,2520,20160,43589145600 ],
  [ 2,2,2,2,2,3,3,60,2520,43589145600,43589145600,653837184000,
      10461394944000,177843714048000,3201186852864000,60822550204416000 ],
  [ 2,2,2,2,2,3,3,60,20160 ],[ 2,2,2,2,2,3,3,60,181440 ],
  [ 2,2,2,2,2,3,3,60,19958400,19958400,653837184000 ],
  [ 2,2,2,2,2,3,3,60,239500800,10461394944000,1216451004088320000,
      12926008369442488320000 ],
  [ 2,2,2,2,2,3,3,168,360,360,181440,181440,1814400,19958400,
      3113510400 ],[ 2,2,2,2,2,3,3,168,360,2520 ],
  [ 2,2,2,2,2,3,3,168,2520 ],[ 2,2,2,2,2,3,3,360 ],
  [ 2,2,2,2,2,3,3,360,360,360,2520,181440,653837184000 ],
  [ 2,2,2,2,2,3,3,360,360,2520,2520,20160,20160,181440,
      3113510400 ],[ 2,2,2,2,2,3,3,360,2520 ],
  [ 2,2,2,2,2,3,3,360,2520,20160 ],
  [ 2,2,2,2,2,3,3,360,20160 ],
  [ 2,2,2,2,2,3,3,360,20160,181440 ],
  [ 2,2,2,2,2,3,3,360,20160,19958400 ],
  [ 2,2,2,2,2,3,3,360,181440 ],
  [ 2,2,2,2,2,3,3,360,19958400,19958400 ],
  [ 2,2,2,2,2,3,3,2520 ],[ 2,2,2,2,2,3,3,2520,20160 ],
  [ 2,2,2,2,2,3,3,2520,20160,20160,181440,3113510400,43589145600 ]
    ,[ 2,2,2,2,2,3,3,2520,20160,181440,1814400 ],
  [ 2,2,2,2,2,3,3,2520,181440 ],
  [ 2,2,2,2,2,3,3,2520,181440,1814400,19958400 ],
  [ 2,2,2,2,2,3,3,2520,181440,1814400,1216451004088320000,
      310224200866619719680000,310224200866619719680000 ],
  [ 2,2,2,2,2,3,3,2520,1814400,1814400,177843714048000 ],
  [ 2,2,2,2,2,3,3,20160,20160,20160,20160,20160,181440,1814400 ],
  [ 2,2,2,2,2,3,3,20160,20160,19958400 ],
  [ 2,2,2,2,2,3,3,20160,19958400,10461394944000,177843714048000,
      3201186852864000 ],
  [ 2,2,2,2,2,3,3,181440,1814400,1814400,19958400,19958400 ],
  [ 2,2,2,2,2,3,5 ],[ 2,2,2,2,2,3,5,5 ],
  [ 2,2,2,2,2,3,5,60 ],[ 2,2,2,2,2,3,5,60,360,360,360 ],
  [ 2,2,2,2,2,3,5,60,360,2520 ],
  [ 2,2,2,2,2,3,5,60,2520,2520,20160 ],
  [ 2,2,2,2,2,3,5,360,2520 ],[ 2,2,2,2,2,3,5,2520 ],
  [ 2,2,2,2,2,3,60 ],[ 2,2,2,2,2,3,60,60 ],
  [ 2,2,2,2,2,3,60,60,60,360,2520,3113510400,43589145600 ],
  [ 2,2,2,2,2,3,60,60,360 ],
  [ 2,2,2,2,2,3,60,60,360,2520,20160,3113510400,60822550204416000,
      60822550204416000 ],[ 2,2,2,2,2,3,60,60,360,20160,20160 ],
  [ 2,2,2,2,2,3,60,60,2520,19958400,239500800,3113510400,
      10461394944000 ],
  [ 2,2,2,2,2,3,60,60,20160,20160,181440,1814400,19958400,
      43589145600 ],
  [ 2,2,2,2,2,3,60,60,20160,19958400,60822550204416000,
      25545471085854720000 ],
  [ 2,2,2,2,2,3,60,168,360,360,360,360,2520,2520,19958400 ],
  [ 2,2,2,2,2,3,60,168,360,2520,20160 ],
  [ 2,2,2,2,2,3,60,360 ],[ 2,2,2,2,2,3,60,360,360 ],
  [ 2,2,2,2,2,3,60,360,360,360 ],[ 2,2,2,2,2,3,60,360,2520 ]
    ,[ 2,2,2,2,2,3,60,360,2520,2520,181440,239500800 ],
  [ 2,2,2,2,2,3,60,360,2520,20160 ],
  [ 2,2,2,2,2,3,60,360,2520,20160,653837184000,10461394944000 ],
  [ 2,2,2,2,2,3,60,360,20160,3113510400,43589145600,
      177843714048000,3201186852864000 ],[ 2,2,2,2,2,3,60,20160 ],
  [ 2,2,2,2,2,3,60,20160,20160,1814400,239500800,10461394944000,
      3201186852864000 ],[ 2,2,2,2,2,3,60,181440,1814400 ],
  [ 2,2,2,2,2,3,360 ],[ 2,2,2,2,2,3,360,360 ],
  [ 2,2,2,2,2,3,360,360,2520,2520,20160,653837184000,
      10461394944000 ],[ 2,2,2,2,2,3,360,2520 ],
  [ 2,2,2,2,2,3,360,2520,2520,20160,20160,20160,20160,1814400 ],
  [ 2,2,2,2,2,3,360,2520,20160,1814400,19958400,43589145600,
      60822550204416000 ],[ 2,2,2,2,2,3,360,20160 ],
  [ 2,2,2,2,2,3,360,181440 ],[ 2,2,2,2,2,3,360,1814400 ],
  [ 2,2,2,2,2,3,2520 ],[ 2,2,2,2,2,3,2520,20160 ],
  [ 2,2,2,2,2,3,2520,20160,19958400 ],
  [ 2,2,2,2,2,3,2520,1814400 ],
  [ 2,2,2,2,2,3,2520,3113510400,43589145600,653837184000,
      10461394944000,3201186852864000 ],[ 2,2,2,2,2,3,20160 ],
  [ 2,2,2,2,2,3,20160,181440,1814400,1814400,1814400,239500800,
      3113510400 ],[ 2,2,2,2,2,3,181440 ],
  [ 2,2,2,2,2,3,181440,181440,1814400,3113510400,43589145600,
      43589145600 ],[ 2,2,2,2,2,3,1814400,43589145600 ],
  [ 2,2,2,2,2,60,360 ],[ 2,2,2,2,2,20160 ],[ 2,2,2,2,3 ],
  [ 2,2,2,2,3,3 ],[ 2,2,2,2,3,3,3 ],[ 2,2,2,2,3,3,3,3 ],
  [ 2,2,2,2,3,3,3,3,3,60,60 ],[ 2,2,2,2,3,3,3,3,60 ],
  [ 2,2,2,2,3,3,3,3,60,60 ],
  [ 2,2,2,2,3,3,3,3,60,60,1814400,19958400,19958400,239500800,
      3113510400 ],
  [ 2,2,2,2,3,3,3,3,60,360,2520,20160,1814400,239500800,
      3113510400 ],[ 2,2,2,2,3,3,3,3,60,2520 ],
  [ 2,2,2,2,3,3,3,3,60,20160,239500800,3113510400,43589145600,
      653837184000,3201186852864000,60822550204416000 ],
  [ 2,2,2,2,3,3,3,3,60,181440,19958400,43589145600,
      10461394944000,177843714048000,177843714048000,3201186852864000 ],
  [ 2,2,2,2,3,3,3,3,2520 ],
  [ 2,2,2,2,3,3,3,5,60,2520,181440,653837184000,653837184000 ],
  [ 2,2,2,2,3,3,3,60 ],
  [ 2,2,2,2,3,3,3,60,60,360,360,360,1814400,3113510400 ],
  [ 2,2,2,2,3,3,3,60,360,2520 ],
  [ 2,2,2,2,3,3,3,60,360,2520,20160,20160,1814400,653837184000 ],
  [ 2,2,2,2,3,3,3,60,360,20160,3113510400 ],
  [ 2,2,2,2,3,3,3,60,20160 ],
  [ 2,2,2,2,3,3,3,60,19958400,239500800,653837184000,
      12926008369442488320000 ],[ 2,2,2,2,3,3,3,168,181440 ],
  [ 2,2,2,2,3,3,3,2520 ],
  [ 2,2,2,2,3,3,5,60,360,20160,19958400 ],
  [ 2,2,2,2,3,3,5,20160,20160,1814400,1814400,19958400,19958400 ],
  [ 2,2,2,2,3,3,5,181440,1814400,1814400,1814400,19958400,
      19958400,19958400,239500800 ],[ 2,2,2,2,3,3,60 ],
  [ 2,2,2,2,3,3,60,60,60,60 ],
  [ 2,2,2,2,3,3,60,60,60,60,360,20160,181440,181440,1814400,
      1814400,19958400 ],[ 2,2,2,2,3,3,60,60,360,360,2520,2520 ],
  [ 2,2,2,2,3,3,60,60,2520,20160 ],
  [ 2,2,2,2,3,3,60,60,2520,20160,181440,1814400,3113510400,
      10461394944000 ],[ 2,2,2,2,3,3,60,60,20160 ],
  [ 2,2,2,2,3,3,60,60,20160,20160,181440 ],
  [ 2,2,2,2,3,3,60,168 ],
  [ 2,2,2,2,3,3,60,168,168,20160,181440,1814400 ],
  [ 2,2,2,2,3,3,60,360 ],
  [ 2,2,2,2,3,3,60,360,360,20160,181440,181440,19958400 ],
  [ 2,2,2,2,3,3,60,360,2520 ],
  [ 2,2,2,2,3,3,60,360,19958400,10461394944000,
      562000363888803840000 ],[ 2,2,2,2,3,3,60,2520 ],
  [ 2,2,2,2,3,3,60,20160 ],
  [ 2,2,2,2,3,3,60,20160,181440,181440,19958400,3113510400 ],
  [ 2,2,2,2,3,3,60,20160,181440,43589145600,653837184000 ],
  [ 2,2,2,2,3,3,60,20160,1814400 ],[ 2,2,2,2,3,3,60,181440 ],
  [ 2,2,2,2,3,3,60,181440,1814400 ],
  [ 2,2,2,2,3,3,60,181440,1814400,3113510400,60822550204416000 ],
  [ 2,2,2,2,3,3,60,1814400,239500800,3113510400,10461394944000 ],
  [ 2,2,2,2,3,3,60,19958400,239500800,10461394944000,
      177843714048000 ],[ 2,2,2,2,3,3,168 ],
  [ 2,2,2,2,3,3,168,168 ],[ 2,2,2,2,3,3,168,168,360,20160 ],
  [ 2,2,2,2,3,3,168,239500800 ],[ 2,2,2,2,3,3,360 ],
  [ 2,2,2,2,3,3,360,360 ],[ 2,2,2,2,3,3,360,2520,2520 ],
  [ 2,2,2,2,3,3,360,20160 ],
  [ 2,2,2,2,3,3,360,20160,20160,181440,653837184000 ],
  [ 2,2,2,2,3,3,2520 ],[ 2,2,2,2,3,3,2520,181440,239500800 ],
  [ 2,2,2,2,3,3,20160 ],[ 2,2,2,2,3,3,20160,19958400 ],
  [ 2,2,2,2,3,3,181440 ],[ 2,2,2,2,3,3,1814400 ],
  [ 2,2,2,2,3,3,1814400,19958400 ],
  [ 2,2,2,2,3,3,1814400,177843714048000,3201186852864000,
      1216451004088320000,25545471085854720000 ],
  [ 2,2,2,2,3,3,653837184000,10461394944000,177843714048000,
      177843714048000,3201186852864000 ],[ 2,2,2,2,3,5 ],
  [ 2,2,2,2,3,5,60,360,2520,20160,181440 ],
  [ 2,2,2,2,3,5,60,181440,181440,19958400,19958400,
      25545471085854720000 ],[ 2,2,2,2,3,60 ],
  [ 2,2,2,2,3,60,60 ],
  [ 2,2,2,2,3,60,60,60,360,360,2520,2520,20160,181440,181440 ],
  [ 2,2,2,2,3,60,60,60,360,360,2520,177843714048000 ],
  [ 2,2,2,2,3,60,60,60,2520,20160,20160,20160,3113510400 ],
  [ 2,2,2,2,3,60,60,360 ],
  [ 2,2,2,2,3,60,60,360,360,20160,181440,181440 ],
  [ 2,2,2,2,3,60,60,360,2520 ],[ 2,2,2,2,3,60,60,2520,20160 ]
    ,[ 2,2,2,2,3,60,60,20160 ],
  [ 2,2,2,2,3,60,60,181440,1814400 ],
  [ 2,2,2,2,3,60,60,181440,1814400,19958400,239500800,239500800,
      239500800,239500800,239500800,3113510400,3113510400,653837184000,
      10461394944000 ],
  [ 2,2,2,2,3,60,60,181440,239500800,3113510400,
      132626429906095529318154240000000,4111419327088961408862781440000000 ],
  [ 2,2,2,2,3,60,60,1814400 ],[ 2,2,2,2,3,60,168 ],
  [ 2,2,2,2,3,60,360 ],
  [ 2,2,2,2,3,60,360,360,2520,181440,1814400,239500800 ],
  [ 2,2,2,2,3,60,360,20160,181440,1814400,239500800 ],
  [ 2,2,2,2,3,60,360,181440,1814400,3113510400 ],
  [ 2,2,2,2,3,60,2520 ],
  [ 2,2,2,2,3,60,2520,20160,20160,19958400,239500800 ],
  [ 2,2,2,2,3,60,2520,181440,1814400,19958400,43589145600,
      10461394944000,177843714048000,25545471085854720000,
      310224200866619719680000 ],
  [ 2,2,2,2,3,60,2520,1814400,239500800,10461394944000,
      1216451004088320000,25545471085854720000 ],
  [ 2,2,2,2,3,60,2520,19958400,19958400,3113510400,177843714048000,
      25545471085854720000 ],
  [ 2,2,2,2,3,60,20160,20160,20160,181440,181440,239500800 ],
  [ 2,2,2,2,3,60,20160,181440 ],
  [ 2,2,2,2,3,60,20160,181440,239500800,3113510400 ],
  [ 2,2,2,2,3,60,20160,181440,10461394944000 ],
  [ 2,2,2,2,3,60,181440 ],
  [ 2,2,2,2,3,60,181440,181440,19958400,239500800 ],
  [ 2,2,2,2,3,60,19958400 ],
  [ 2,2,2,2,3,60,19958400,239500800,43589145600,653837184000,
      10461394944000,177843714048000 ],
  [ 2,2,2,2,3,60,19958400,239500800,10461394944000,177843714048000 ],
  [ 2,2,2,2,3,60,43589145600,10461394944000,177843714048000,
      3201186852864000,60822550204416000,1216451004088320000 ],
  [ 2,2,2,2,3,168 ],[ 2,2,2,2,3,168,360 ],
  [ 2,2,2,2,3,168,360,2520,181440,1814400,19958400 ],
  [ 2,2,2,2,3,168,360,181440 ],
  [ 2,2,2,2,3,168,2520,181440,181440,1814400,3113510400 ],
  [ 2,2,2,2,3,168,20160 ],[ 2,2,2,2,3,168,1814400,19958400 ],
  [ 2,2,2,2,3,360 ],[ 2,2,2,2,3,360,360 ],
  [ 2,2,2,2,3,360,360,2520,2520,20160 ],
  [ 2,2,2,2,3,360,2520 ],[ 2,2,2,2,3,360,20160 ],
  [ 2,2,2,2,3,360,20160,20160,10461394944000 ],
  [ 2,2,2,2,3,360,181440 ],[ 2,2,2,2,3,2520 ],
  [ 2,2,2,2,3,2520,2520,2520,2520,20160,20160,181440,19958400 ],
  [ 2,2,2,2,3,2520,2520,19958400 ],[ 2,2,2,2,3,2520,20160 ],
  [ 2,2,2,2,3,2520,20160,20160,239500800,43589145600,653837184000,
      10461394944000,60822550204416000,60822550204416000,
      1216451004088320000 ],[ 2,2,2,2,3,2520,1814400 ],
  [ 2,2,2,2,3,20160 ],
  [ 2,2,2,2,3,20160,20160,20160,20160,20160,19958400,239500800,
      239500800,239500800,653837184000 ],
  [ 2,2,2,2,3,20160,20160,181440 ],
  [ 2,2,2,2,3,20160,20160,181440,19958400,239500800 ],
  [ 2,2,2,2,3,20160,1814400,1814400,19958400,239500800,239500800,
      3113510400,3113510400,3201186852864000 ],
  [ 2,2,2,2,3,20160,1814400,1814400,19958400,239500800,3113510400 ],
  [ 2,2,2,2,3,181440 ],
  [ 2,2,2,2,3,181440,1814400,19958400,3113510400,43589145600,
      10461394944000 ],[ 2,2,2,2,3,1814400 ],[ 2,2,2,2,5 ],
  [ 2,2,2,2,5,60,60,360,360,2520,2520,20160,19958400,19958400 ],
  [ 2,2,2,2,60 ],[ 2,2,2,2,60,60 ],[ 2,2,2,2,60,60,60,60 ],
  [ 2,2,2,2,60,60,60,360,2520,20160 ],
  [ 2,2,2,2,60,60,60,181440 ],[ 2,2,2,2,60,60,2520 ],
  [ 2,2,2,2,60,60,20160 ],[ 2,2,2,2,60,60,20160,20160 ],
  [ 2,2,2,2,60,60,20160,181440 ],[ 2,2,2,2,60,60,1814400 ],
  [ 2,2,2,2,60,168,360 ],[ 2,2,2,2,60,360 ],
  [ 2,2,2,2,60,360,360,2520 ],[ 2,2,2,2,60,360,20160 ],
  [ 2,2,2,2,60,360,20160,181440 ],[ 2,2,2,2,60,2520 ],
  [ 2,2,2,2,60,2520,20160 ],[ 2,2,2,2,60,2520,1814400 ],
  [ 2,2,2,2,60,181440 ],
  [ 2,2,2,2,60,181440,1814400,1814400,3113510400 ],
  [ 2,2,2,2,60,181440,1814400,1814400,177843714048000 ],
  [ 2,2,2,2,60,1814400,19958400 ],
  [ 2,2,2,2,60,1814400,19958400,19958400,43589145600,
      3201186852864000,25545471085854720000 ],[ 2,2,2,2,60,19958400 ],
  [ 2,2,2,2,168 ],[ 2,2,2,2,360 ],
  [ 2,2,2,2,360,360,43589145600,43589145600 ],
  [ 2,2,2,2,360,360,3201186852864000,3201186852864000,
      4420880996869850977271808000000,132626429906095529318154240000000 ],
  [ 2,2,2,2,360,2520 ],[ 2,2,2,2,360,181440,1814400 ],
  [ 2,2,2,2,360,1814400,19958400 ],[ 2,2,2,2,2520 ],
  [ 2,2,2,2,2520,2520 ],[ 2,2,2,2,2520,181440 ],
  [ 2,2,2,2,181440 ],[ 2,2,2,2,1814400,1814400 ],
  [ 2,2,2,2,3113510400,177843714048000 ],[ 2,2,2,3 ],
  [ 2,2,2,3,3 ],[ 2,2,2,3,3,3,3 ],[ 2,2,2,3,3,3,3,60,60 ],
  [ 2,2,2,3,3,3,3,60,60,60,360,20160,181440 ],
  [ 2,2,2,3,3,3,3,60,360,360,360,2520,20160 ],
  [ 2,2,2,3,3,3,3,360 ],
  [ 2,2,2,3,3,3,3,360,20160,20160,181440,1814400 ],
  [ 2,2,2,3,3,3,5,5,60,360,360,20160,20160,181440,1814400,
      19958400 ],[ 2,2,2,3,3,3,5,2520,239500800 ],
  [ 2,2,2,3,3,3,5,239500800 ],[ 2,2,2,3,3,3,60 ],
  [ 2,2,2,3,3,3,60,168,360,20160,20160,181440,239500800,
      653837184000 ],
  [ 2,2,2,3,3,3,60,360,360,360,2520,181440,1814400 ],
  [ 2,2,2,3,3,3,60,20160,181440 ],
  [ 2,2,2,3,3,3,168,2520,20160 ],
  [ 2,2,2,3,3,3,360,20160,181440 ],
  [ 2,2,2,3,3,3,360,19958400 ],
  [ 2,2,2,3,3,5,60,168,360,360,20160 ],
  [ 2,2,2,3,3,5,60,360,360 ],
  [ 2,2,2,3,3,5,60,360,360,2520,20160 ],
  [ 2,2,2,3,3,5,60,360,2520 ],[ 2,2,2,3,3,5,360 ],
  [ 2,2,2,3,3,5,360,2520,2520,20160 ],
  [ 2,2,2,3,3,5,360,181440 ],
  [ 2,2,2,3,3,5,2520,2520,20160,1814400,1814400,19958400 ],
  [ 2,2,2,3,3,5,2520,19958400 ],[ 2,2,2,3,3,5,181440 ],
  [ 2,2,2,3,3,5,43589145600,653837184000 ],[ 2,2,2,3,3,60 ],
  [ 2,2,2,3,3,60,60 ],[ 2,2,2,3,3,60,60,360,2520 ],
  [ 2,2,2,3,3,60,60,360,2520,2520,2520,181440,1814400 ],
  [ 2,2,2,3,3,60,60,2520,3113510400,10461394944000,177843714048000,
      1216451004088320000 ],[ 2,2,2,3,3,60,168,2520 ],
  [ 2,2,2,3,3,60,360 ],[ 2,2,2,3,3,60,360,360,360 ],
  [ 2,2,2,3,3,60,360,360,2520 ],
  [ 2,2,2,3,3,60,360,360,2520,20160 ],
  [ 2,2,2,3,3,60,360,360,2520,20160,653837184000,10461394944000,
      60822550204416000 ],[ 2,2,2,3,3,60,360,2520 ],
  [ 2,2,2,3,3,60,360,2520,2520,20160,20160,181440,181440,
      1814400,1814400,19958400,239500800,239500800,3113510400,
      3113510400,43589145600,43589145600,653837184000,10461394944000 ],
  [ 2,2,2,3,3,60,360,2520,2520,20160,181440,181440,1814400,
      1814400,19958400,3113510400,43589145600,653837184000,653837184000,
      10461394944000,10461394944000,177843714048000,177843714048000,
      3201186852864000 ],
  [ 2,2,2,3,3,60,360,2520,2520,20160,1814400,177843714048000 ],
  [ 2,2,2,3,3,60,360,20160 ],
  [ 2,2,2,3,3,60,360,20160,20160,181440,1814400 ],
  [ 2,2,2,3,3,60,360,20160,181440,43589145600 ],
  [ 2,2,2,3,3,60,360,20160,19958400,3113510400 ],
  [ 2,2,2,3,3,60,360,239500800 ],
  [ 2,2,2,3,3,60,2520,2520,20160,181440 ],
  [ 2,2,2,3,3,60,2520,2520,181440 ],
  [ 2,2,2,3,3,60,2520,20160 ],
  [ 2,2,2,3,3,60,2520,20160,20160 ],
  [ 2,2,2,3,3,60,2520,19958400 ],[ 2,2,2,3,3,60,20160,20160 ],
  [ 2,2,2,3,3,60,20160,181440 ],
  [ 2,2,2,3,3,60,181440,239500800 ],
  [ 2,2,2,3,3,60,1814400,19958400 ],
  [ 2,2,2,3,3,168,168,360,360,360,2520,20160,181440,181440,
      1814400,1814400,19958400,19958400 ],
  [ 2,2,2,3,3,168,20160,20160,181440,1814400,1814400,19958400,
      3113510400 ],[ 2,2,2,3,3,360 ],[ 2,2,2,3,3,360,360,2520 ],
  [ 2,2,2,3,3,360,2520,2520,2520,181440 ],
  [ 2,2,2,3,3,360,2520,2520,181440 ],
  [ 2,2,2,3,3,360,2520,20160,1814400 ],[ 2,2,2,3,3,360,20160 ],
  [ 2,2,2,3,3,360,20160,20160,1814400,19958400,19958400,
      177843714048000 ],[ 2,2,2,3,3,360,20160,20160,19958400 ],
  [ 2,2,2,3,3,360,20160,19958400,19958400 ],
  [ 2,2,2,3,3,360,181440 ],[ 2,2,2,3,3,360,1814400 ],
  [ 2,2,2,3,3,360,19958400,239500800 ],
  [ 2,2,2,3,3,2520,2520,20160 ],
  [ 2,2,2,3,3,2520,2520,20160,1814400 ],
  [ 2,2,2,3,3,2520,2520,1814400,19958400,19958400,239500800 ],
  [ 2,2,2,3,3,2520,20160,20160,181440,19958400,239500800 ],
  [ 2,2,2,3,3,2520,20160,20160,181440,239500800,3113510400 ],
  [ 2,2,2,3,3,2520,181440,1814400 ],
  [ 2,2,2,3,3,2520,3113510400 ],[ 2,2,2,3,3,20160 ],
  [ 2,2,2,3,3,20160,181440 ],[ 2,2,2,3,3,20160,181440,1814400 ],
  [ 2,2,2,3,3,20160,181440,1814400,19958400 ],
  [ 2,2,2,3,3,20160,1814400,19958400,239500800 ],
  [ 2,2,2,3,3,181440,19958400 ],
  [ 2,2,2,3,3,239500800,239500800,3113510400,3113510400,43589145600,
      653837184000,653837184000 ],[ 2,2,2,3,5 ],
  [ 2,2,2,3,5,60,360,360,2520 ],[ 2,2,2,3,5,360 ],
  [ 2,2,2,3,5,360,360,20160,239500800,10461394944000,
      177843714048000,201645730563302817792000000,
      5444434725209176080384000000 ],[ 2,2,2,3,5,360,20160,1814400 ],
  [ 2,2,2,3,5,2520,20160,181440 ],[ 2,2,2,3,5,181440 ],
  [ 2,2,2,3,5,19958400,239500800 ],[ 2,2,2,3,60 ],
  [ 2,2,2,3,60,60,60,360 ],
  [ 2,2,2,3,60,60,60,2520,19958400,239500800,653837184000 ],
  [ 2,2,2,3,60,60,360,360 ],[ 2,2,2,3,60,60,360,360,20160 ],
  [ 2,2,2,3,60,60,360,2520,2520,181440,181440,19958400,
      10461394944000,3201186852864000,60822550204416000 ],
  [ 2,2,2,3,60,60,360,20160 ],[ 2,2,2,3,60,60,360,181440 ],
  [ 2,2,2,3,60,60,2520,2520 ],
  [ 2,2,2,3,60,60,2520,181440,181440,19958400,19958400 ],
  [ 2,2,2,3,60,60,20160,239500800 ],[ 2,2,2,3,60,60,1814400 ],
  [ 2,2,2,3,60,168,360 ],[ 2,2,2,3,60,168,360,2520,20160 ],
  [ 2,2,2,3,60,168,360,2520,19958400,3113510400 ],
  [ 2,2,2,3,60,360 ],[ 2,2,2,3,60,360,360,2520 ],
  [ 2,2,2,3,60,360,360,2520,2520,20160,43589145600 ],
  [ 2,2,2,3,60,360,360,20160,20160,181440,1814400,239500800,
      239500800 ],[ 2,2,2,3,60,360,360,20160,181440 ],
  [ 2,2,2,3,60,360,2520 ],
  [ 2,2,2,3,60,360,2520,2520,2520,19958400,239500800 ],
  [ 2,2,2,3,60,360,2520,20160 ],
  [ 2,2,2,3,60,360,2520,20160,181440,181440,1814400 ],
  [ 2,2,2,3,60,360,2520,181440,181440,239500800,
      25545471085854720000 ],[ 2,2,2,3,60,360,20160 ],
  [ 2,2,2,3,60,360,20160,20160,181440 ],
  [ 2,2,2,3,60,360,20160,20160,181440,181440 ],
  [ 2,2,2,3,60,360,20160,181440,43589145600,653837184000,
      653837184000 ],[ 2,2,2,3,60,360,20160,19958400 ],
  [ 2,2,2,3,60,360,20160,19958400,653837184000 ],
  [ 2,2,2,3,60,360,181440 ],
  [ 2,2,2,3,60,360,1814400,1814400,19958400,19958400,239500800 ],
  [ 2,2,2,3,60,360,1814400,19958400 ],
  [ 2,2,2,3,60,360,19958400,239500800,43589145600,653837184000,
      653837184000 ],[ 2,2,2,3,60,2520,2520,2520 ],
  [ 2,2,2,3,60,2520,2520,20160,20160 ],
  [ 2,2,2,3,60,2520,2520,1814400 ],
  [ 2,2,2,3,60,2520,20160,20160,181440,181440,181440,1814400 ],
  [ 2,2,2,3,60,2520,20160,181440 ],
  [ 2,2,2,3,60,2520,1814400,1814400,19958400 ],
  [ 2,2,2,3,60,2520,1814400,19958400 ],
  [ 2,2,2,3,60,2520,43589145600 ],[ 2,2,2,3,60,20160 ],
  [ 2,2,2,3,60,181440 ],[ 2,2,2,3,60,1814400,19958400,19958400 ],
  [ 2,2,2,3,60,19958400,19958400 ],[ 2,2,2,3,168 ],
  [ 2,2,2,3,168,360,360,2520 ],
  [ 2,2,2,3,168,20160,181440,1814400,19958400,19958400,19958400 ],
  [ 2,2,2,3,360,360,181440,3113510400,12926008369442488320000,
      5444434725209176080384000000 ],[ 2,2,2,3,360,2520 ],
  [ 2,2,2,3,360,2520,20160,181440,1814400,10461394944000 ],
  [ 2,2,2,3,360,20160 ],[ 2,2,2,3,360,20160,181440 ],
  [ 2,2,2,3,360,20160,181440,1814400,1814400,19958400,653837184000,
      177843714048000 ],
  [ 2,2,2,3,360,20160,1814400,239500800,653837184000,
      3201186852864000,201645730563302817792000000 ],[ 2,2,2,3,2520 ],
  [ 2,2,2,3,2520,2520,2520,20160,20160,181440,1814400 ],
  [ 2,2,2,3,2520,2520,1814400 ],[ 2,2,2,3,2520,20160 ],
  [ 2,2,2,3,2520,20160,1814400,19958400 ],
  [ 2,2,2,3,2520,181440,1814400 ],[ 2,2,2,3,2520,1814400 ],
  [ 2,2,2,3,2520,19958400 ],[ 2,2,2,3,2520,239500800 ],
  [ 2,2,2,3,20160 ],[ 2,2,2,3,20160,20160,181440 ],
  [ 2,2,2,3,20160,181440,1814400 ],[ 2,2,2,3,20160,1814400 ],
  [ 2,2,2,3,20160,1814400,19958400 ],[ 2,2,2,3,181440 ],
  [ 2,2,2,3,1814400 ],[ 2,2,2,5,5 ],
  [ 2,2,2,5,360,177843714048000,3201186852864000 ],[ 2,2,2,60 ],
  [ 2,2,2,60,60 ],[ 2,2,2,60,60,60,20160,181440 ],
  [ 2,2,2,60,60,360 ],
  [ 2,2,2,60,60,360,360,2520,2520,3113510400,177843714048000 ],
  [ 2,2,2,60,60,360,2520,20160 ],[ 2,2,2,60,60,181440 ],
  [ 2,2,2,60,360,360,360,2520 ],
  [ 2,2,2,60,360,2520,2520,181440,1814400,43589145600,
      177843714048000 ],[ 2,2,2,60,360,2520,20160,20160 ],
  [ 2,2,2,60,360,20160,20160 ],[ 2,2,2,60,360,181440 ],
  [ 2,2,2,60,2520 ],[ 2,2,2,60,2520,20160 ],
  [ 2,2,2,60,2520,181440,1814400,1814400,19958400,653837184000,
      10461394944000,60822550204416000 ],[ 2,2,2,60,20160 ],
  [ 2,2,2,60,20160,181440 ],[ 2,2,2,60,20160,1814400 ],
  [ 2,2,2,60,1814400,19958400 ],[ 2,2,2,360,360 ],
  [ 2,2,2,360,360,43589145600,43589145600 ],[ 2,2,2,360,2520 ],
  [ 2,2,2,360,2520,20160 ],[ 2,2,2,360,20160,1814400 ],
  [ 2,2,2,360,20160,1814400,19958400,19958400,239500800,3113510400,
      43589145600 ],[ 2,2,2,2520,20160,1814400 ],
  [ 2,2,2,2520,20160,1814400,1814400 ],[ 2,2,2,20160 ],
  [ 2,2,3 ],[ 2,2,3,3 ],[ 2,2,3,3,3,60 ],[ 2,2,3,3,3,360 ],
  [ 2,2,3,3,5,60,360,20160,181440 ],
  [ 2,2,3,3,5,60,20160,20160,1814400 ],[ 2,2,3,3,5,181440 ],
  [ 2,2,3,3,60 ],[ 2,2,3,3,60,60 ],[ 2,2,3,3,60,360 ],
  [ 2,2,3,3,60,2520 ],[ 2,2,3,3,360 ],[ 2,2,3,3,2520 ],
  [ 2,2,3,3,20160 ],[ 2,2,3,3,181440 ],[ 2,2,3,60 ],
  [ 2,2,3,60,60 ],[ 2,2,3,60,360 ],
  [ 2,2,3,60,360,19958400,239500800 ],[ 2,2,3,60,2520 ],
  [ 2,2,3,60,20160 ],[ 2,2,3,60,1814400 ],[ 2,2,3,168,20160 ],
  [ 2,2,3,168,1814400 ],[ 2,2,3,360 ],[ 2,2,3,360,360 ],
  [ 2,2,3,360,20160 ],[ 2,2,3,2520 ],[ 2,2,3,2520,2520 ],
  [ 2,2,3,2520,2520,20160,20160 ],[ 2,2,3,2520,20160 ],
  [ 2,2,3,2520,1814400 ],[ 2,2,3,20160 ],[ 2,2,3,20160,20160 ],
  [ 2,2,3,181440 ],[ 2,2,3,1814400,1814400 ],[ 2,2,3,239500800 ],
  [ 2,2,5,2520 ],[ 2,2,60 ],[ 2,2,60,60 ],[ 2,2,60,60,2520 ],
  [ 2,2,60,60,20160 ],[ 2,2,60,60,181440 ],
  [ 2,2,60,60,1814400 ],[ 2,2,60,360 ],
  [ 2,2,60,360,181440,181440 ],[ 2,2,60,360,181440,1814400 ],
  [ 2,2,60,360,1814400 ],
  [ 2,2,60,360,1814400,19958400,19958400,239500800,239500800,
      239500800 ],[ 2,2,60,2520 ],[ 2,2,60,2520,2520 ],
  [ 2,2,60,2520,181440 ],[ 2,2,60,2520,3113510400 ],
  [ 2,2,60,20160 ],[ 2,2,60,20160,181440 ],
  [ 2,2,60,20160,181440,181440 ],[ 2,2,60,181440 ],
  [ 2,2,60,181440,1814400 ],[ 2,2,168 ],[ 2,2,360 ],
  [ 2,2,360,360 ],[ 2,2,360,2520 ],[ 2,2,360,2520,1814400 ],
  [ 2,2,360,181440 ],[ 2,2,360,181440,181440 ],[ 2,2,2520 ],
  [ 2,2,2520,20160 ],[ 2,2,2520,181440,19958400 ],[ 2,2,20160 ],
  [ 2,2,20160,20160 ],[ 2,2,20160,1814400 ],[ 2,2,20160,19958400 ],
  [ 2,2,181440 ],
  [ 2,2,181440,181440,43589145600,43589145600,
      131565418466846765083609006080000000,
      147616399519802070423809304821760000000 ],[ 2,2,653837184000 ],
  [ 2,3 ],[ 2,3,60,60 ],[ 2,3,60,60,168 ],
  [ 2,3,60,60,19958400 ],[ 2,3,60,168,2520 ],
  [ 2,3,60,2520,2520 ],[ 2,3,168 ],[ 2,3,360 ],
  [ 2,3,2520,2520 ],[ 2,60 ],[ 2,60,60 ],[ 2,60,360 ],
  [ 2,60,2520 ],[ 2,60,181440 ],[ 2,60,181440,181440 ],
  [ 2,60,19958400 ],[ 2,168 ],[ 2,168,168 ],[ 2,168,20160 ],
  [ 2,168,181440 ],[ 2,168,181440,1814400 ],[ 2,360 ],
  [ 2,360,360 ],[ 2,360,2520 ],[ 2,360,2520,20160 ],
  [ 2,360,181440,181440 ],[ 2,360,19958400 ],[ 2,2520,2520 ],
  [ 2,20160 ],[ 2,20160,181440 ],[ 2,20160,43589145600 ],
  [ 2,181440 ],[ 2,181440,181440 ],[ 2,181440,1814400 ],
  [ 2,1814400 ],[ 2,3113510400 ],[ 168,168 ],[ 2520,2520 ] ];

compfactpos :=
[ 1269,1269,590,135,940,1,590,940,1,135,1,1,582,582,133,582,
  133,202,582,133,202,16,4,1281,1281,815,1281,1281,1,1,4,815,
  1281,1,1281,1,1,1,1,1,815,815,1,4,1,1281,1,1281,1,1,300,
  300,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1269,590,135,940,1,
  590,940,1,135,1,1,582,582,133,582,133,202,582,133,202,16,
  815,4,815,815,815,4,1,1,1281,1281,1281,300,1281,1,1,1,1,1,
  4,1281,1,1281,1,1281,300,1281,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,301,431,1158,1,301,1158,1,431,1,1,134,134,
  878,134,878,18,134,878,18,1259,1281,1281,989,815,989,1281,1,
  1,1281,989,815,1,989,1,1,1,1,1,1281,989,1,1281,1,989,1,
  815,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,988,988,1,
  2,988,1,988,1,1,590,590,590,590,590,300,590,590,300,989,3,
  590,590,3,590,590,1,1,590,590,5,300,5,300,300,1,1,1,3,
  590,1,590,1,5,300,5,1,1,300,300,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,988,1,988,988,1,3,1,1,135,135,65,135,65,19,135,
  65,19,952,434,6,90,434,90,6,1,1,6,90,136,1,437,1,1,1,1,
  1,434,90,1,6,1,437,1,136,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,988,3,1,988,1,1,52,52,303,52,303,587,52,303,
  587,953,434,90,6,434,6,90,1,1,90,6,1176,1,591,1,1,1,1,1,
  434,6,1,90,1,591,1,1176,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,988,1,988,1,1,590,
  590,590,590,590,300,590,590,300,989,3,590,590,3,590,590,1,
  1,590,590,5,300,5,300,300,1,1,1,3,590,1,590,1,5,300,5,1,
  1,300,300,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,988,1,1,52,
  52,303,52,303,587,52,303,587,953,434,90,6,434,6,90,1,1,90,
  6,1176,1,591,1,1,1,1,1,434,6,1,90,1,591,1,1176,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  135,135,65,135,65,19,135,65,19,952,434,6,90,434,90,6,1,1,
  6,90,136,1,437,1,1,1,1,1,434,90,1,6,1,437,1,136,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,434,434,816,592,592,816,6,975,975,434,436,206,434,206,
  436,1,1,436,206,90,1,615,28,60,1,1,1,434,206,1,436,1,615,
  1,90,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,434,434,
  434,5,816,592,592,301,434,436,206,434,206,436,1,1,436,206,
  90,60,615,1,1,1,1,1,434,206,1,436,1,615,28,90,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,592,989,592,6,1224,1155,
  1224,434,137,140,434,140,137,1,1,137,140,34,1,616,1,1,1,1,
  1,434,140,1,137,1,616,1,34,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,434,592,434,434,5,301,434,436,206,434,206,436,
  1,1,436,206,90,1,615,1,1,1,1,1,434,206,1,436,1,615,1,90,
  1,1,60,28,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,592,592,989,
  592,1223,434,137,140,434,140,137,1,1,137,140,34,1,616,1,1,
  1,1,1,434,140,1,137,1,616,1,34,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,975,1155,1155,975,434,136,142,434,142,136,
  1,1,136,142,7,1177,20,1,1,1,1,1,434,142,1,136,1,20,977,
  7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,434,592,975,
  434,436,206,434,206,436,1,1,436,206,90,1,615,60,28,1,1,1,
  434,206,1,436,1,615,1,90,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,592,1224,434,137,140,434,140,137,1,1,137,140,34,
  1,616,1,1,1,1,1,434,140,1,137,1,616,1,34,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,975,434,136,142,434,142,136,
  1,1,136,142,7,1,20,1,1,1,1,1,434,142,1,136,1,20,1,7,1,
  1,1177,977,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,794,32,958,
  794,958,32,1,1,32,958,962,1,821,1,1,1,1,1,794,958,1,32,
  1,821,1,962,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  815,815,3,815,815,1,1,4,4,815,434,815,434,434,1,1,1,3,4,
  1,4,1,815,434,815,1,1,988,988,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,815,815,815,3,1,1,989,989,989,6,989,1,1,1,1,1,4,
  989,1,989,1,989,6,989,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,815,3,815,1,1,989,989,989,301,989,1,1,1,1,1,4,
  989,1,989,1,989,301,989,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,815,815,1,1,815,815,4,434,4,988,988,1,1,1,3,815,
  1,815,1,4,434,4,1,1,434,434,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,815,1,1,989,989,989,301,989,1,1,1,1,1,4,989,1,989,
  1,989,301,989,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,989,989,989,6,989,1,1,1,1,1,4,989,1,989,1,989,6,989,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,815,989,1,989,
  1,1,1,1,1,815,815,1,3,1,989,1,989,1,1,6,6,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,989,1,989,1,1,1,1,1,815,3,1,815,
  1,989,1,989,1,1,301,301,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,815,6,6,1,1,1,815,989,1,989,1,815,1,3,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,988,1,1,1,1,
  1,988,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,301,
  301,1,1,1,815,989,1,989,1,3,1,815,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,988,1,1,1,434,1,1,1,1,301,1,6,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,434,1,1,1,
  1,301,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,815,1,815,1,815,988,815,1,1,434,434,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,815,1,989,1,989,1,1,
  301,301,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,989,1,989,1,1,6,
  6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,815,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,988,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1260,1196,
  1196,1219,1,1196,1219,1,205,1,1,1188,1188,1210,1188,1210,818,
  1188,1210,818,1221,1186,1186,1186,1281,1281,815,1,1,1186,1281,
  815,1,1281,1,1,1,1,1,1186,1186,1,815,1,1281,1,1281,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1196,1196,1219,1,1196,
  1219,1,205,1,1,1188,1188,1210,1188,1210,818,1188,1210,818,
  1221,1186,1186,1186,1281,1281,815,1,1,1186,1281,815,1,1281,1,
  1,1,1,1,1186,1186,1,815,1,1281,1,1281,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1192,1192,1,590,934,1247,934,1147,
  1,635,635,709,635,709,196,635,709,196,103,988,1017,1017,590,
  1224,1224,1,1,988,590,1224,1,1224,1,1,1,1,1,590,590,928,
  590,1,1017,928,1017,1,1,1018,1018,1,1107,1,1,1,1,1,1,1,1,
  379,1,1,379,1,1192,1,1192,1192,1147,203,1,1,635,635,709,
  635,709,196,635,709,196,103,988,590,590,1017,1224,1224,1,1,
  988,1017,1224,1,1224,1,1,1,1,1,1017,1017,1,590,1107,1243,1,
  1243,1018,1018,1,1,1,1,1,1,1,1,1,1,1,1,1,379,1,379,1,1,
  934,940,1,934,1,1,73,73,278,73,278,83,73,278,83,86,592,
  1212,1212,1212,588,1294,1,1,592,1212,1294,1,588,1,1,1,1,1,
  707,707,550,434,772,707,550,707,1251,1251,1,1,1,1,1,1,1,1,
  1,1,1,1,508,508,1,195,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1192,1,
  934,1,1,635,635,709,635,709,196,635,709,196,103,988,1017,
  1017,590,1224,1224,928,1,988,590,1224,1,1224,1,928,1,1,1,
  590,590,1,590,1,1017,1,1017,1,1,1018,1018,1,1107,1,1,1,
  379,1,1,1,1,1,379,1,1,1,1,934,1,1,73,73,278,73,278,83,
  73,278,83,86,592,707,707,707,434,927,550,1,592,707,927,1,
  434,1,550,1,1,1,1212,1212,1,434,1,1294,1,1294,1,1,1,1,1,
  772,1,1,1,508,1,1,1,1,1,195,1,508,1,1,1,1,1,1077,1,1,
  1,1,1,1,1,1,829,1,1,1,1,1,1,1,829,1,1,1,1,1,1,1,1,1,
  1,1,1204,1,1,1,1204,1,1,1,1,1,1,1,1,1,1,1252,1,1,1,1,
  1,1,1,1,1,1,1,420,420,17,420,17,221,420,17,221,298,590,
  1257,1257,934,975,434,1154,1,590,934,434,1,975,1,1154,1,1,
  1,934,934,1154,988,974,1257,1154,1257,1216,1216,1254,1254,1,
  1,1,1,1,685,1,1,1,1,685,1,1,1,1,1,1,1,1,826,1,1,1,1,
  1,1,829,1,1,1,1,1,1204,1,829,1,1,1,1,1,1204,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1252,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1192,1192,592,508,508,592,591,920,920,989,603,
  603,603,403,891,836,1,989,603,891,1,403,1,836,1,1,1,603,
  603,493,590,1034,688,493,688,1,1,1,1,1,1032,1,1,1,366,1,
  1,1,1,164,164,1,164,1,1192,1192,1192,1157,592,508,508,886,
  989,603,603,603,403,891,1,1,989,603,891,1,403,1,1,1,1,1,
  603,603,493,590,1,688,493,688,1085,1085,1,1,1,1,1,1,1,1,
  1,1,1,1,164,366,1,366,1,508,887,508,591,1238,1169,1238,592,
  709,709,709,295,899,1,1,592,709,899,1,295,1,1,1,1,1,709,
  709,1,204,1109,1022,1,1022,1162,1162,1,1,1,1,1,1,1,1,1,1,
  1,1,281,107,1,107,1,1192,508,1192,1192,1157,886,989,603,603,
  603,403,891,836,1,989,603,891,1,403,1,836,1,1,1,603,603,
  836,590,1032,688,836,688,1,1,1085,1085,1,1034,1,1,1,366,1,
  1,1,1,366,1,1,1,1,508,508,887,508,590,592,709,709,709,295,
  899,1,1,592,709,899,1,295,1,1,1,1,1,709,709,553,204,1,
  1022,553,1022,1123,1123,1123,1123,1,1109,1,1,1,1,1,1,1,1,
  107,1,1,1,1,920,1169,816,920,590,775,775,775,65,303,1268,1,
  590,775,303,1,65,1,1268,1,1,1,775,775,1268,5,1052,1097,
  1268,1097,1093,1093,1226,1226,1,1052,1,1,1,1,1,1,1,1,362,
  455,1,455,1,1192,508,920,989,603,603,603,403,891,493,1,989,
  603,891,1,403,1,493,1,1,1,603,603,1,590,1,688,1,688,1,1,
  1,1,1,1034,1,1,1,164,1,1,1,1,1,366,1,366,1,508,1238,592,
  709,709,709,295,899,553,1,592,709,899,1,295,1,553,1,1,1,
  709,709,1,204,1,1022,1,1022,1,1,1162,1162,1,132,1,1,1,107,
  1,1,1,1,1,1,1,1,1,920,590,775,775,775,65,303,556,1,590,
  775,303,1,65,1,556,1,1,1,775,775,556,5,964,1097,556,1097,
  1226,1226,1093,1093,1,1,1,1,1,455,1,1,1,1,455,1,1,1,1,
  300,1113,1113,1113,431,123,1,1,300,1113,123,1,431,1,1,1,1,
  1,1113,1113,1208,434,1,791,1208,791,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,573,1,1,1,1,1185,1185,1185,988,988,1186,1,2,1185,
  988,1,988,1,1186,1,1,1,1185,1185,1186,3,989,1185,1186,1185,
  1185,1185,1185,1185,1,989,1,1,1,989,1,1,1,1,989,989,1,989,
  1,1185,1269,1269,1269,1,1,1185,1269,1269,1,1269,1,1,1,1,1,
  1186,1186,816,815,1200,815,816,815,1200,1200,1,1,1,1,1,1,1,
  1,1,1,1,1,302,302,1,1,1,1269,1269,1269,1,1,1185,1269,1269,
  1,1269,1,1,1,1,1,1186,1186,816,815,1200,815,816,815,1200,
  1200,1,1,1,1,1,1,1,1,1,1,1,1,302,302,1,1,1,1269,1269,1,
  1,1185,1185,1269,1,1269,1,1,1,1,1,815,815,816,815,1200,
  1186,816,1186,1,1,1200,1200,1,1,1,1,1,1,1,1,1,1,302,302,
  1,1,1,988,1281,1,988,1269,988,1,3,1,1281,1,1,1,1269,1269,
  1281,4,590,1269,1281,1269,1269,1269,1269,1269,1,590,1,1,1,
  1223,1,1,1,1,434,434,1,1223,1,815,1,988,1269,3,1,988,1,
  815,1,1,1,1269,1269,815,4,1244,1269,815,1269,1269,1269,1269,
  1269,1,1244,1,1,1,1224,1,1,1,1,976,976,1,1224,1,1,1186,1,
  815,1,1281,1,1260,1,1,1,816,816,988,988,1270,816,988,816,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,462,462,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1185,988,1,988,1,1186,1,1,1,1185,1185,1186,3,
  989,1185,1186,1185,1185,1185,1185,1185,1,989,1,1,1,989,1,1,
  1,1,989,989,1,989,1,1269,1,1269,1,1,1,1,1,815,815,816,
  815,1200,1186,816,1186,1,1,1200,1200,1,1,1,1,1,1,1,1,1,1,
  302,302,1,1,1,1,988,1,815,1,1,1,1269,1269,815,4,1244,1269,
  815,1269,1269,1269,1269,1269,1,1244,1,1,1,1224,1,1,1,1,976,
  976,1,1224,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1281,1,1,1,1269,1269,
  1281,4,590,1269,1281,1269,1269,1269,1269,1269,1,590,1,1,1,
  1223,1,1,1,1,434,434,1,1223,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,816,816,
  988,988,1270,816,988,816,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  462,462,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1185,1,815,1,1269,1,
  1269,1,1,1200,1200,1,1200,1,1,1,302,1,1,1,1,1,1,1,302,1,
  1,815,1,1269,1,1269,1,1,1200,1200,1,1200,1,1,1,302,1,1,1,
  1,1,1,1,302,1,988,1,1,1260,1,1,1,1,1,1,1270,1,1,1,462,
  1,1,1,1,1,1,1,462,1,1,815,988,815,590,590,590,590,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1185,1200,1200,1,1,1,1200,1,1,1,
  1017,1,1,1,1,1,1,1,1017,1,1,1,1,1,1,1,1270,1,1,1,462,
  1,1,1,1,1,1,1,462,1,1200,1200,1,1,1,1200,1,1,1,1017,1,
  1,1,1,1,1,1,1017,1,1185,1269,1269,1,1,1,1,1,1168,1,1,1,
  1,1,1168,1,1,1,1269,1269,1,1,1,1,1,1168,1,1,1,1,1,1168,
  1,1,1,1185,1,1,1,1,1,1,1,1,1,1,1,1168,1,1168,1,1,1,1,
  1,1,1,1,1,1,1,1,1168,1,1168,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,508,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,508,1,1,1,1,1,1,1,1,1,1196,1196,
  1219,1,1196,1219,1,205,1,1,1188,1188,1210,1188,1210,818,1188,
  1210,818,1221,1186,1186,1186,1281,1281,815,1,1,1186,1281,815,
  1,1281,1,1,1,1,1,1186,1186,1,815,1,1281,1,1281,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1192,1192,1,590,934,1,
  934,1,1,635,635,709,635,709,196,635,709,196,103,590,988,590,
  590,590,590,1,1,1017,1224,1224,1018,1017,928,1,1,1107,1,988,
  1017,1,1224,1,1224,1018,1017,1,928,1,1,1,1,1,1,1,1,1,1,
  379,1,1,1,1,1,379,1192,1,1192,1192,1,203,1,1147,635,635,
  709,635,709,196,635,709,196,103,1017,988,1017,1017,1017,590,
  1018,1018,590,1224,1224,1,1243,1,1,1,1,1,988,590,1,1224,1,
  1224,1,1243,1,1,1,1,1,1,1107,1,379,1,1,1,1,1,1,1,1,1,
  379,1,934,940,1,934,1,1,73,73,278,73,278,83,73,278,83,86,
  1212,592,1212,707,707,434,1,1,707,434,927,1,1294,550,1,1,
  772,1,592,707,1,927,1,434,1,1294,1,550,1,1,1,1,1,1,508,
  1,1,1,508,1,1,1,1,1,195,1147,1,1,1,1,1,1,826,1,1,1,1,
  1,1,1,1,1,829,1,1,1,1,1,1,1,1,1,1,1,1204,1,1,1,1,829,
  1,1,1,1,1,1,1,1,1204,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1252,1192,1,934,1,1247,635,635,709,635,709,196,635,709,
  196,103,590,988,590,590,590,590,1,1,1017,1224,1224,1018,1017,
  1,1,928,1107,1,988,1017,1,1224,1,1224,1018,1017,1,1,1,928,
  1,1,1,1,379,1,379,1,1,1,1,1,1,1,1,1,934,1,1,73,73,278,
  73,278,83,73,278,83,86,707,592,707,1212,1212,434,1251,1251,
  1212,588,1294,1,707,1,1,550,1,1,592,1212,1,1294,1,588,1,
  707,1,1,1,550,1,1,772,1,195,1,508,1,1,1,1,1,1,1,508,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,420,420,17,420,17,221,420,17,221,298,
  934,590,934,934,934,988,1216,1216,1257,975,434,1254,1257,1154,
  1,1154,1,1,590,1257,1,434,1,975,1254,1257,1,1154,1,1154,1,
  1,974,1,1,1,685,1,685,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1077,1,1,1,1,1,1,1,829,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1204,1,1,829,1,1,1,1,1,1,1,1,1,1,1204,1,1,1,1,1,1,1,
  1,1252,1,1,1,1,1,1,1192,1192,592,508,508,592,591,920,920,
  603,989,603,603,603,590,1,1,603,403,891,1,688,493,1,1,1034,
  1,989,603,1,891,1,403,1,688,1,493,1,1,1,1,1,1,366,1,1,
  1,164,1,1,1,1,1,366,1192,1192,1192,1157,592,508,508,886,
  603,989,603,603,603,590,1,1,603,403,891,1085,688,836,1,836,
  1034,1,989,603,1,891,1,403,1085,688,1,836,1,836,1,1,1032,
  1,1,1,366,1,366,1,1,1,1,1,1,508,887,508,591,1238,1169,
  1238,709,592,709,709,709,204,1,1,709,295,899,1162,1022,553,
  1,1,132,1,592,709,1,899,1,295,1162,1022,1,553,1,1,1,1,1,
  1,1,1,1,1,107,1,1,1,1,1,1,1192,508,1192,1192,1157,886,
  603,989,603,603,603,590,1085,1085,603,403,891,1,688,1,1,493,
  1,1,989,603,1,891,1,403,1,688,1,1,1,493,1,1,1,1,366,1,
  164,1,1,1,1,1,1,1,366,508,508,887,508,590,709,592,709,709,
  709,204,1123,1123,709,295,899,1123,1022,1,1,553,1109,1,592,
  709,1,899,1,295,1123,1022,1,1,1,553,1,1,1,1,1,1,107,1,1,
  1,1,1,1,1,1,920,1169,816,920,775,590,775,775,775,5,1226,
  1226,775,65,303,1093,1097,556,1,556,1,1,590,775,1,303,1,65,
  1093,1097,1,556,1,556,1,1,964,1,1,1,455,1,455,1,1,1,1,1,
  1,1192,508,920,603,989,603,603,603,590,1,1,603,403,891,1,
  688,836,1,493,1032,1,989,603,1,891,1,403,1,688,1,836,1,
  493,1,1,1034,1,164,1,164,1,366,1,1,1,1,1,164,508,1238,
  709,592,709,709,709,204,1162,1162,709,295,899,1,1022,1,1,1,
  1,1,592,709,1,899,1,295,1,1022,1,1,1,1,1,1,1109,1,107,1,
  281,1,1,1,1,1,1,1,107,920,775,590,775,775,775,5,1093,1093,
  775,65,303,1226,1097,1268,1,1268,1052,1,590,775,1,303,1,65,
  1226,1097,1,1268,1,1268,1,1,1052,1,455,1,362,1,1,1,1,1,1,
  1,455,1113,300,1113,1113,1113,434,1,1,1113,431,123,1,791,1,
  1,1208,1,1,300,1113,1,123,1,431,1,791,1,1,1,1208,1,1,1,
  1,1,1,573,1,1,1,1,1,1,1,1,1185,1185,815,815,815,1,1,
  1186,1269,1269,1200,1269,816,1,1,1200,1,1185,1186,1,1269,1,
  1269,1200,1269,1,816,1,1,1,1,1,1,302,1,1,1,302,1,1,1,1,
  1,1,1185,1185,1185,3,1185,1185,1185,988,988,1185,1185,1186,1,
  1186,989,1,2,1185,1,988,1,988,1185,1185,1,1186,1,1186,1,1,
  989,1,989,1,989,1,989,1,1,1,1,1,989,815,815,815,1,1,1186,
  1269,1269,1200,1269,816,1,1,1200,1,1185,1186,1,1269,1,1269,
  1200,1269,1,816,1,1,1,1,1,1,302,1,1,1,302,1,1,1,1,1,1,
  1185,815,1,1,1269,1269,1269,1200,1186,1,1,816,1,1,1185,1269,
  1,1269,1,1269,1200,1186,1,1,1,816,1,1,1200,1,1,1,302,1,1,
  1,1,1,1,1,302,815,1,1,1269,1269,1269,1200,1186,1,1,816,1,
  1,1185,1269,1,1269,1,1269,1200,1186,1,1,1,816,1,1,1200,1,
  1,1,302,1,1,1,1,1,1,1,302,590,590,815,4,4,590,815,988,1,
  988,1,1,3,815,1,4,1,4,590,815,1,988,1,988,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1185,1200,1269,1269,1269,1200,1,1,1,1,
  1,1185,1200,1,1269,1,1269,1269,1200,1,1,1,1,1,1,1,1,1,1,
  1,1,1168,1,1,1,1,1,1168,1200,1269,1269,1269,1200,1,1,1,1,
  1,1185,1200,1,1269,1,1269,1269,1200,1,1,1,1,1,1,1,1,1,1,
  1,1,1168,1,1,1,1,1,1168,1269,1269,1,815,1,1,816,1,1,1185,
  1185,1,1269,1,1269,1,815,1,1,1,816,1,1,1200,1,1,1,302,1,
  1,1,1,1,1,1,302,988,1269,1269,1281,1,1281,590,1,988,1269,
  1,988,1,3,1269,1269,1,1281,1,1281,1,1,590,1,1223,1,434,1,
  1223,1,1,1,1,1,434,1269,1269,815,1,815,1244,1,988,1269,1,
  3,1,988,1269,1269,1,815,1,815,1,1,1244,1,1224,1,976,1,
  1224,1,1,1,1,1,976,1,1,1,1,1,1,1185,1,1,1269,1,1269,
  1185,1,1,1,1,1,1,1,1,1,1168,1,1,1,1,1,1,1,1,1,1168,
  816,1,1,1200,1,1185,815,1,1269,1,1269,1,1185,1,816,1,1,1,
  1,1,1,1017,1,1,1,1017,1,1,1,1,1,1,1,988,1,1,1186,1,1,
  815,1,1281,1,816,1,1260,1,988,1,1,1270,1,1,1,462,1,1,1,
  1,1,1,1,462,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1270,1,1186,816,1,815,1,1281,1,1,
  1,988,1,1260,1,1,1,1,462,1,1,1,462,1,1,1,1,1,1,1,989,
  1,1,1244,1,590,1,1200,1,1,1,1270,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1185,1,988,1,988,1185,1185,1,1186,1,1186,1,
  1,989,1,989,1,989,1,989,1,1,1,1,1,989,1,1269,1,1269,1,
  815,1,1,1,816,1,1,1200,1,1,1,302,1,1,1,1,1,1,1,302,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  988,1269,1269,1,815,1,815,1,1,1244,1,1224,1,976,1,1224,1,
  1,1,1,1,976,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1269,1269,1,1281,1,1281,1,1,590,1,1223,1,434,1,1223,
  1,1,1,1,1,434,1,1,1,1,1,1,1,1,1,1168,1,1,1,1,1,1,1,
  1,1,1168,1,816,1,1,1,1,1,1,1017,1,1,1,1017,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,988,1,1,
  1270,1,1,1,462,1,1,1,1,1,1,1,462,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,462,1,1,1,462,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  508,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,508,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1217,1217,1,301,1129,1,1129,1,1,483,483,530,483,530,
  285,483,530,285,33,1017,1017,592,434,1229,927,1,1,1017,1229,
  434,1279,1229,1174,1,1,1,1,1017,592,1174,927,1,1229,1,434,
  1279,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1217,1,1217,
  1217,1,588,1,1,483,483,530,483,530,285,483,530,285,33,1017,
  1017,592,588,934,1294,1,1,1017,934,434,1,934,1,1,1,1,1,
  1017,592,1,1294,1,934,1,588,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1275,1129,5,1275,1129,1267,1267,128,128,582,
  128,582,129,128,582,129,87,1082,1082,4,927,815,927,1,1192,
  203,1223,590,1,1223,204,1,1,203,6,203,4,204,927,203,815,1,
  927,1,1,1192,1,88,1125,1125,1209,940,723,723,291,940,1209,
  940,940,291,723,723,1,1267,1267,1,1,1,1,1,838,1,1190,1,1,
  1189,1,932,1,1,1200,1,886,1,1,1082,1,1288,1148,1,1288,1,1,
  1,1,1,1,1200,1,1,1,886,1,1,1,1,1082,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1217,1,1129,1,1,483,483,530,483,530,285,
  483,530,285,33,1017,1017,592,434,1229,927,1,1279,1017,1229,
  434,1,1229,1,1174,1174,1,1,1017,592,1,927,1,1229,1,434,1,
  1,1279,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1267,1129,1275,
  1275,128,128,582,128,582,129,128,582,129,87,203,203,4,927,
  1223,927,1,1,1082,815,590,1192,815,1,204,204,1125,88,1082,4,
  1,927,1125,1223,1,927,1192,1,1,1,6,203,203,291,723,940,940,
  1209,723,291,723,723,1209,940,940,1,1,1,1,1258,848,1,833,1,
  1,1189,1,913,1,1,1200,1,1291,1,1,1,1,1288,1148,1,1288,1,
  1,1,1,1,1,1200,1,1,1,1291,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,47,47,296,47,296,51,47,296,51,1280,
  1229,1229,815,815,1229,4,1,1297,1229,1229,5,1297,1229,1228,
  1228,1228,1,1184,1229,815,1228,4,1,1229,1,815,1297,1,1297,1,
  1184,1,1,1,1,1,1,1202,1,1202,1,1,1,1,1,1267,1,1,1189,1,
  1190,1,1,838,1,932,1,1,1200,1,1288,1,1,1,1,886,1148,1082,
  886,1,1,1,1,1,1,1200,1,1,1,1288,1,1,1082,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1189,1258,833,1,1,848,1,
  913,1,1,1200,1,1288,1,1,1,1,1291,1148,1,1291,1,1,1,1,1,
  1,1200,1,1,1,1288,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1201,1201,1067,934,934,1067,434,1153,1153,991,991,
  592,295,407,899,1,1,991,407,434,502,407,1214,1,1,1,1,991,
  592,1214,899,1,407,1,295,502,1,1,1,1,1,1,1,30,1,1,1,1,
  1,1,11,1,11,30,1201,1201,1201,135,1067,934,934,874,991,991,
  592,295,407,899,1,1,991,407,434,868,407,1159,1,1,1,1,991,
  592,1159,899,1,407,1,295,868,1,1,1,1,1,1,1,1,1,1,1,30,
  1,11,1,1,1,1,934,592,934,434,1192,1212,1192,403,403,989,
  952,994,953,1,1,403,994,301,836,994,1085,1,1,677,583,403,
  989,1085,953,677,994,1,952,836,1,1,1,583,1056,1056,374,230,
  248,248,373,405,374,182,99,1102,99,230,1201,934,1201,1201,
  135,874,991,991,592,295,407,899,1,868,991,407,434,1,407,1,
  1159,1159,1,1,991,592,1,899,1,407,1,295,1,1,868,1,1,1,1,
  1,1,30,11,1,1,1,1,1,1,1,1,934,934,592,934,591,403,403,
  989,952,994,953,1,493,403,994,301,493,994,1,1,1,395,585,
  403,989,1,953,395,994,1,952,493,1,493,1,585,395,395,373,
  248,230,99,374,230,374,99,248,373,248,248,1153,1212,1158,
  1153,804,804,301,430,756,50,1,879,804,756,815,879,756,1146,
  1151,1151,1,1,804,301,1146,50,1,756,1,430,879,1,879,1,1,1,
  1,630,1,1,1,630,1,1,1,1,75,1,1,1201,934,1153,991,991,592,
  295,407,899,1,502,991,407,434,1,407,1,1214,1214,1,1,991,
  592,1,899,1,407,1,295,1,1,502,1,1,1,1,1,11,1,1,1,1,1,
  1,30,1,30,11,934,1192,403,403,989,952,994,953,1,836,403,
  994,301,1,994,1,1085,1085,1056,583,403,989,1,953,1056,994,1,
  952,1,1,836,1,583,677,677,1102,99,405,182,374,248,373,248,
  230,374,230,99,1153,804,804,301,430,756,50,1,879,804,756,
  815,879,756,1151,1146,1146,1,1,804,301,1151,50,1,756,1,430,
  879,1,879,1,1,1,1,75,1,1,1,1,1,630,1,1,630,1,1,268,268,
  591,946,870,1285,1,1,268,870,434,1,870,965,965,965,759,23,
  268,591,965,1285,759,870,1,946,1,1,1,1,23,759,759,274,375,
  910,910,253,910,253,910,375,274,375,375,1185,1185,1269,1269,
  1269,1,1,1186,815,815,816,815,1200,1,1,1212,1,1186,1185,
  1200,1269,1212,1269,1,1269,816,1,1,1,434,1,1,1,1201,1,1,
  592,1201,1,1201,1201,592,1,1,1185,1269,1269,1269,1,1,1186,
  815,815,816,815,1200,1,1,1212,1,1186,1185,1200,1269,1212,
  1269,1,1269,816,1,1,1,434,1,1,1,1201,1,1,592,1201,1,1201,
  1201,592,1,1,988,1185,988,1,1186,1185,1185,3,1186,1185,1185,
  1185,1185,815,4,1185,2,1185,988,815,1185,1,988,1186,1,1186,
  1,4,815,815,988,816,816,816,988,816,988,816,816,988,816,816,
  1269,988,1,1281,1269,1269,4,1281,1269,1269,1269,1269,1,1244,
  1269,988,1269,988,1,1269,1,3,1281,1,1281,1,1244,1,1,1224,1,
  1,1,1224,1,1224,1,1,1224,1,1,1269,1,1,815,1186,815,816,
  1186,1,1200,1200,300,300,815,1185,1,1269,300,1185,1,1269,816,
  1,1,1,816,818,818,886,886,1234,1234,772,886,886,886,886,772,
  1234,1234,1,815,1269,1269,4,815,1269,1269,1269,1269,1,1244,
  1269,988,1269,3,1,1269,1,988,815,1,815,1,1244,1,1,1224,1,
  1,1,1224,1,1224,1,1,1224,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,816,816,988,988,816,1,1,1,946,1,816,1186,1,815,946,1,1,
  1281,988,1,1260,1,592,1,1,1,550,1,1,301,550,1,550,550,
  1261,1292,1292,1269,815,1,1269,1,1200,1200,1,434,1185,1185,1,
  1269,1,815,1,1269,1,1,816,1,1,1212,1212,592,1,1201,1201,1,
  1,592,1,1,1,1201,1201,815,1,1185,1200,1,1,818,816,1269,
  1185,1200,1269,818,1186,1,1269,1,1,816,1,300,300,300,772,
  1234,886,886,886,1234,772,1234,1234,886,886,886,988,815,590,
  590,590,591,1,815,3,590,4,591,815,1,4,988,1,988,1,1,591,
  591,1,434,434,434,1,434,1,434,434,1,434,434,1,1,1,1,1,
  592,1,1186,1,815,1,816,1,1281,1260,1,988,1,1,946,946,1261,
  1292,550,550,1,1,301,1,1292,1,550,550,1200,1,1,818,816,
  1269,1185,1200,1269,818,1186,1,1269,1,1,816,1,300,300,300,
  772,1234,886,886,886,1234,772,1234,1234,886,886,886,1269,1269,
  1,89,1,1185,1185,1269,1,1,1,1269,1,1,1,1,1,827,827,772,1,
  1225,1225,1,1,772,1,1,1,1225,1225,1185,827,1,1200,1185,1269,
  1269,827,1200,1,1269,1,1,1,1,89,1,1,1,1225,1,1,772,1225,
  1,1225,1225,772,1,1,827,1,1200,1185,1269,1269,827,1200,1,
  1269,1,1,1,1,89,1,1,1,1225,1,1,772,1225,1,1225,1225,772,
  1,1,300,1,815,1,1,815,300,1,1,1,1,946,1,1,1,1,752,1,1,
  1,1,1,752,1,1,1,1,1,434,4,89,1244,300,300,1,1244,592,1,
  1,1,1,1,1,1,794,1,1,1,794,1,794,794,1,1,1,1185,1,1269,
  1,815,1,1269,1,1,816,1,1,1212,1212,592,1,1201,1201,1,1,
  592,1,1,1,1201,1201,1185,988,815,1185,1,988,1186,1,1186,1,
  4,815,815,988,816,816,816,988,816,988,816,816,988,816,816,
  1269,1,1,1,1269,1,1,1,1,1,827,827,772,1,1225,1225,1,1,
  772,1,1,1,1225,1225,1,1269,1,988,815,1,815,1,1244,1,1,
  1224,1,1,1,1224,1,1224,1,1,1224,1,1,300,1,1,1,1,946,1,1,
  1,1,752,1,1,1,1,1,752,1,1,1,1,1,1,1269,816,1,1,1,816,
  818,818,886,886,1234,1234,772,886,886,886,886,772,1234,1234,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1281,1,1281,
  1,1244,1,1,1224,1,1,1,1224,1,1224,1,1,1224,1,1,1,988,1,
  1,946,946,1261,1292,550,550,1,1,301,1,1292,1,550,550,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,592,1,1,1,550,1,1,
  301,550,1,550,550,1261,1292,1292,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,300,300,1,1,794,794,1,1,1,1,1,1,794,794,815,1,
  1,1,1,752,1,1,1,1,752,1,1,1,1,1,1,752,1,1,1,1,752,1,
  1,886,1,1,1,1082,1209,1082,886,1,1,1,1,1,1,940,1082,1184,
  816,1,1,1,816,886,1,1,1,1,1082,940,1184,886,1,1,1,1,1082,
  1184,940,1,1,1,1,1209,1082,1082,886,816,1184,1,1,1,886,
  1082,1,1,1,940,1,1,1,1,1,1,886,886,816,1260,1,988,988,
  1269,988,1,1,436,436,927,436,927,560,436,927,560,205,816,
  816,1209,816,816,927,1,1,816,1209,927,1,990,1,1,1,1,1,816,
  816,905,927,1,815,1,1266,1,905,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,436,436,436,1,988,988,1269,988,1,1,436,436,927,436,927,
  560,436,927,560,205,816,816,1209,816,816,927,1,1,816,1209,
  927,1,990,1,1,1,1,1,816,816,905,927,1,815,1,1266,1,905,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,436,436,436,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,988,1,988,1,1,590,590,590,590,590,300,590,590,300,
  989,3,590,590,3,590,590,1,1,590,590,5,300,5,300,300,1,1,
  1,3,590,1,590,1,5,300,5,1,1,300,300,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1260,1269,1,550,550,865,550,865,1194,550,
  865,1194,818,816,927,816,816,1209,816,1,1,927,816,1266,752,
  815,1,752,1,1,1,816,1209,1,816,1,990,1,927,1205,1,1,752,
  1,1,1,1,1,1,1,1,436,436,436,1,1,1,1,1,1,1,1,1060,1,
  1104,1,1,1,1128,1,916,841,1,1082,841,1,1,1,1,1160,1082,
  962,1170,434,937,1,1,1,1,1,1173,1160,1125,1,1238,1160,940,
  1,1237,1290,580,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1269,1,
  550,550,865,550,865,1194,550,865,1194,818,816,927,816,816,
  1209,816,1,1,927,816,1266,752,815,1,752,1,1,1,816,1209,1,
  816,1,990,1,927,1205,1,1,752,1,1,1,1,1,1,1,1,436,436,
  436,1,1,1,1,1,1060,1,1,847,1128,1124,1,1167,963,1146,841,
  1,1,841,1082,1,1,1,1125,1173,940,1,1238,969,1126,1,1,1,1,
  1082,1,1160,1,434,1179,962,1160,967,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,435,435,592,508,508,592,591,874,
  874,591,303,151,591,151,188,1,1,303,151,509,110,467,470,227,
  1,858,1,591,151,1,188,1,467,1,905,950,950,231,1,1,480,1,
  1,1,1,1,1,324,211,604,1,324,604,108,435,435,435,434,592,
  508,508,1139,591,303,151,591,151,188,1,1,303,151,509,227,
  467,231,1,1,1,1,591,151,950,188,1,467,470,905,1,1,1,1,1,
  1,1,1,1,1,1,1,211,1,324,1,604,108,1,508,592,508,591,940,
  302,940,591,358,335,591,335,343,1,1,358,335,62,781,710,387,
  1,1,1,1,591,335,1,343,1,710,1,131,1,730,1,1,1,1,1,1,1,
  1,1,1,172,1,740,1,740,181,377,435,508,435,435,434,1139,591,
  303,151,591,151,188,1,1,303,151,509,1,467,1,1,1,1,1,591,
  151,1,188,1,467,231,905,369,1,21,37,1,1,1,1,1,1,1,1,1,
  108,211,1,108,1,211,508,508,592,508,204,591,358,335,591,335,
  343,1,1,358,335,62,1,710,1,1,1,1,1,591,335,730,343,1,710,
  387,131,526,722,548,58,1,1,1,1,1,1,1,1,1,377,172,1,181,
  377,1,874,302,1067,874,205,43,163,205,163,117,1,1,43,163,
  930,237,382,1,1,1,1,1,205,163,1027,117,1,382,539,956,1047,
  1,342,378,1,1181,1,1,1,1,1,1,111,1,160,1,319,465,1,435,
  508,874,591,303,151,591,151,188,1,1,303,151,509,1,467,21,
  37,1,480,1,591,151,1,188,1,467,1,905,1,369,1,110,1,858,1,
  1,1,1,1,1,108,604,1,1,1,211,324,508,940,591,358,335,591,
  335,343,1,1,358,335,62,1,710,548,58,1,1,1,591,335,722,343,
  1,710,1,131,1,1,406,364,1,1,1,1,1,1,1,1,377,181,1,1,
  377,1,172,874,205,43,163,205,163,117,1,1,43,163,930,1,382,
  342,378,1,1181,1,205,163,1,117,1,382,1,956,674,1,656,396,
  1,1,1,1,1,1,1,1,1,465,111,1,465,1,111,550,125,761,550,
  761,130,1,1,125,761,901,1,819,1,1,1,563,1,550,761,1,130,
  1,819,1,813,1,1,1,683,1,563,1,1,1,1,1,1,1065,1051,1117,
  1,1038,1051,1065,815,815,3,815,815,1,1,988,988,815,302,815,
  817,817,1,841,1,3,988,1158,988,1,815,302,815,949,949,435,
  435,1,841,1,1,1,1,1,1,592,1,592,1,592,592,1,815,815,815,
  815,1,1,592,886,886,707,1082,783,1,1,1125,1,988,592,1245,
  886,1,886,707,1082,1245,783,1,1,1,1,1,1,1,1,1,1,416,1,
  635,1,635,1,416,815,815,815,1,1,592,886,1082,1229,886,772,
  1,1,1,1,988,592,927,886,1,1082,1229,886,1245,783,1,1,1,1,
  1,1,1,1,1,1,1,1,707,1,989,435,435,815,815,1,1,815,815,4,
  817,4,435,435,1,1,1,3,815,949,815,1,4,817,4,1158,1,302,
  302,1,1,1,1,1,1,1,1,1,592,592,1,592,1,592,815,1,1,886,
  592,886,869,1082,1,783,1,1,1,988,886,1245,592,1,886,869,
  1082,927,925,925,302,1,1,1,1,1,1,1,1,435,435,989,1,707,1,
  1,1,1,886,592,1082,1282,886,1,772,1,1,1,988,886,927,592,1,
  1082,1282,886,927,925,302,925,1,1125,1,1,1,1,1,1,1,416,
  635,1,635,416,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,815,886,1,886,1,1,1,1,1,815,815,783,815,
  1,1082,783,1082,1,1,707,707,1,1125,1,1,1,1,1,1,1,635,416,
  1,1,416,635,886,1,886,1,1,1,1,1,815,815,783,815,1,1082,
  772,1082,1,1172,1229,1229,1,1,1,1,1,1,1,1,1,707,1,1,435,
  435,989,1,815,1272,1272,1,962,1,815,1082,1,1082,1,815,1,4,
  1207,982,1207,803,1,962,1,1,1,1,1,1,436,1,1097,1,1,436,
  1097,1,1,1,1,1,1,435,783,708,772,1,1,435,1,1279,1136,421,
  1,1,408,1,1,1,1,1,1,1,786,1,1,1,462,712,934,934,1,135,
  1,815,1082,1,1082,1,4,1,815,1207,982,803,1207,1,434,1,1,1,
  1,1,1,886,1169,1169,1,1200,815,1200,435,1,1,1,302,925,925,
  302,1,1197,750,1139,1,928,750,421,1,428,1,1,1,1,1,1,1,
  527,732,1,289,127,1,1,1,1,302,302,925,925,1,1197,421,1139,
  1,708,1,1,1,1,1,1,1,1,1,1,1,1,732,1,712,1,462,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,841,1,956,1125,1,434,1180,962,1,1,806,1183,1,1,1,1,1,
  1,1,1,1,1204,1204,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,815,1,815,1,815,435,815,1,
  1158,817,817,1,841,1,1,1,1,1,1,592,592,1,1,1,592,592,925,
  815,1,886,1,886,1172,1,869,869,1,1,1,1,1,1,1,1,435,989,
  435,1,1,1,707,925,1,1,928,1,1,1175,1,1136,1,972,1,1,1,1,
  1,1,454,853,1,1,1,393,1,1,886,1,886,1,1,1282,1282,1,1,1,
  1,1,1,1,1,416,635,1,1,416,1,635,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,815,1133,1234,1,1133,1,135,1,
  1,1,1,1,1,815,1200,1200,1,1169,886,1169,1,1211,1,750,1,1,
  1,1,1,1,1,1,1,527,732,1,1,127,1,85,1133,1234,1133,1,1,
  962,1,1,1,1,1,1,436,1097,1,1,1097,436,1,1,1207,1207,1,1,
  1,1,1,1,1,1,805,266,1,1,1,853,454,925,925,1,1,1,1,1,1,
  1,1,1,454,853,1,805,1,393,435,1,1,1,1,1,1,1,1,732,1,
  527,1,288,289,127,1,1,1,1,1,1,1,1,732,1,1,1,462,712,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1204,1,1204,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,435,435,1,1,1,1,1200,1,1,1,1,
  1,1,1,1,1,1,1,435,1200,435,1,988,988,1269,988,1,1,436,
  436,927,436,927,560,436,927,560,205,816,816,1209,816,816,927,
  1,1,816,1209,927,1,990,1,1,1,1,1,816,816,905,927,1,815,1,
  1266,1,905,1,1,1,1,1,1,1,1,1,1,1,1,1,1,436,436,436,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1260,1,988,1,1269,436,436,927,436,
  927,560,436,927,560,205,816,816,816,816,1209,927,905,1,816,
  816,927,1,815,1,1,905,1,1,816,1209,1,927,1,990,1,1266,1,
  1,1,1,1,1,1,436,436,1,1,1,1,1,1,436,1,1,1,1,988,1,
  1269,436,436,927,436,927,560,436,927,560,205,816,816,816,816,
  1209,927,905,1,816,816,927,1,815,1,1,905,1,1,816,1209,1,
  927,1,990,1,1266,1,1,1,1,1,1,1,436,436,1,1,1,1,1,1,436,
  1,1,1,1,1,1,1,1104,1128,1060,1,1,1,1,1,916,1125,1,1082,
  1160,1173,1,1170,1160,841,1082,1125,1,434,1,1,580,1,1,1,1,
  1126,962,1,1238,1,1215,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,434,434,301,434,301,434,434,301,434,815,590,4,
  590,590,590,4,582,582,4,590,590,1,5,1,1,582,1,1,590,590,
  582,4,1,5,1,590,582,582,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1060,1,1104,1,1,1,1128,1,916,1,841,
  1,1160,1082,962,1,1,1,1173,1125,1,1238,1,1,1126,1,1,1125,
  1082,580,1,1,434,1,1215,1160,1170,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,435,435,592,508,508,592,591,874,874,303,591,
  151,303,151,509,1,1,591,151,188,1,467,1,1,1,1,1,303,151,
  37,509,858,467,1,42,1,110,1,1,1,1,1,1,108,1,1,1,1,1,1,
  604,604,324,211,435,435,435,434,592,508,508,1139,303,591,151,
  303,151,509,1,231,591,151,188,1,467,1,1,227,1,1,303,151,
  110,509,1,467,1,42,470,227,1,1,858,1,480,211,1,1,1,1,1,
  1,1,108,324,211,1,508,592,508,591,940,302,940,358,591,335,
  358,335,62,1,1,591,335,343,1,710,1,1,1,1,1,358,335,364,
  62,789,710,1,920,1,781,1,1,789,1,1,1,377,1,1,1,1,1,1,
  181,740,172,1,435,508,435,435,434,1139,303,591,151,303,151,
  509,227,470,591,151,188,1,467,1,1,110,1,858,303,151,227,
  509,480,467,1,42,231,1,1,1,1,1,1,324,211,1,1,1,1,1,1,1,
  211,1,108,508,508,592,508,204,358,591,335,358,335,62,1,387,
  591,335,343,1,710,1,1,781,1,1,358,335,781,62,754,710,1,
  920,387,1,1,1,1,1,754,172,1,1,1,1,1,1,1,377,172,1,377,
  874,302,1067,874,43,205,163,43,163,930,1,1,205,163,117,1,
  382,1,1,237,1,1,43,163,389,930,1,382,1,800,539,237,1,1,1,
  1,796,111,1,1,1,1,1,1,1,465,160,111,1,435,508,874,303,
  591,151,303,151,509,110,1,591,151,188,1,467,1,1,37,1,1,
  303,151,1,509,1,467,1,42,1,1,1,1,1,1,858,604,324,1,1,1,
  1,1,1,211,1,108,604,508,940,358,591,335,358,335,62,781,1,
  591,335,343,1,710,1,1,364,1,789,358,335,1,62,1,710,1,920,
  1,1,1,1,1,1,789,740,172,1,1,1,1,1,1,1,1,377,181,874,43,
  205,163,43,163,930,237,539,205,163,117,1,382,1,1,389,1,1,
  43,163,237,930,796,382,1,800,1,1,1,1,1,1,1,160,111,1,1,
  1,1,1,1,1,111,1,465,125,550,761,125,761,901,1,1,550,761,
  130,1,819,1,1,503,1,737,125,761,503,901,563,819,1,299,1,1,
  1,1,737,1,563,1117,1065,1,1,1,1,1,1,1051,1117,1065,1051,
  815,815,592,886,886,1,1,988,592,886,1,886,1,1,1,1,1,592,
  592,1,590,1125,1276,1,1276,707,707,1,1,586,1,1,1,635,1,1,
  1,1,1,1,416,635,416,1,815,815,815,4,435,435,3,815,815,1,
  4,1,1,817,1,1,988,988,302,815,841,815,1,4,817,817,1,1,
  841,1,841,1,592,1,1,1,1,1,1,592,592,1,592,886,592,886,1,
  1,988,886,592,1,886,1,1,1,1,1,592,592,302,1276,1,590,1,
  1276,869,869,1,1,434,1,1,1,707,1,1,1,1,1,1,1,989,435,
  435,815,886,1,783,815,815,815,1,1082,1,1,707,1,1125,592,
  886,707,886,586,1082,1,815,783,1,1,1,1125,1,586,416,1,1,1,
  1,1,1,1,635,416,1,635,886,783,1,815,815,815,1,1082,1,1,
  869,1,1,592,886,1229,1082,434,886,1,815,772,1,1,1,1,1,982,
  435,435,1,1,1,1,1,1,989,1,1,707,1272,1272,815,1082,1082,1,
  815,1,1,1,1,962,590,1276,803,816,1142,816,1,1276,1,1,1,1,
  1142,1,1,436,1,1,1,1,1,1,1,1097,1097,436,1,435,817,1,772,
  1,934,1,1,1,1,1,707,869,1,1,1183,1,1,1217,736,1,1,1,408,
  1,1,1,1,1,1,1,1,1,1,786,462,1,712,817,772,1,1,934,1,1,
  1,1,1,707,869,1,1,806,1,1,1217,808,736,1,1,1,1,1,1,527,
  1,1,1,1,1,1,732,288,577,85,815,815,1,815,1,1,302,1,841,
  815,815,817,4,841,4,1,4,435,435,1,1,1,1,841,592,1,1,1,1,
  1,1,1,592,1,592,592,815,1,886,1,1,1229,1,1,886,592,869,
  886,982,1082,1,815,1,783,1,1,1,1,434,1,1,1,1,1,1,1,1,
  707,435,435,989,1,886,1,1,1282,1,1,886,592,1282,1082,586,
  886,1,815,1,772,1,1,1,1,586,1,416,1,1,1,1,1,1,635,1,
  416,635,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,135,1276,590,1133,816,
  200,816,1,1276,1,1,1,1,946,1,946,886,1169,1,1,1,1,1,1,
  1169,1200,815,1200,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,302,
  1296,803,1,1133,1,1296,1,1,1,1,1,1,1,1,786,1,1,1,1,1,1,
  1,712,462,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,586,434,1,1142,946,946,1,1148,1,408,1,1,
  1,1,1,1,1204,1,1,1,1,1,1,1204,1,1,1,815,1,886,1,886,1,
  1276,1,1,1,1,1,1,1125,635,416,1,1,1,1,1,1,1,1,635,416,
  1,886,1,886,1,1276,1,1,1,1,1,1,1,989,435,1,1,1,1,1,1,
  435,1,707,1,1,1,1,1,1296,1,1,1,1,1,1,1,712,462,1,1,1,
  1,1,1,1,1,786,1,1,815,1,1276,1272,1272,1,1,962,1,1142,
  1097,436,1,1,1,1,1,1,1,436,1,1097,946,1,1,1,1,1,1,1,1,
  1,1204,1204,1,1,1,1,1,1,1,1,1,1,1,1276,934,934,1,1,135,
  1,200,1200,815,1,1,1,1,1,1,1200,886,1169,1169,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1217,1217,1,1,1148,1,1,
  1202,1202,1,1,1,1,1,1,1,1202,1202,1,435,1,1,1,1,806,288,
  577,1,1,1,1,1,1,85,1,527,732,1,1,1,1,1183,462,1,1,1,1,
  1,1,1,712,1,1,786,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,946,1,1,1,1,1,1,1,1,
  1,1,1204,1204,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1204,1204,1,435,1,1,1,1,1,1,1200,1,1,1,1,1,1,1,
  1,1,435,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  435,1200,435,1269,815,815,1269,1,1,1,1,960,1,960,1295,987,
  1227,1,50,1,1,6,1,772,1,1,887,1,6,1,1,591,887,1,1,1,1,
  422,772,1,1,1,6,948,1,1,1293,1241,1,1,1,1,1,1,1,1,1,1,
  1,1,1,951,951,951,988,1,1260,1,1,550,550,865,550,865,1194,
  550,865,1194,818,816,927,1209,816,816,816,1,1205,927,1209,
  1266,1,990,752,1,1,1,1,816,816,1,816,1,815,752,927,1,1,
  752,1,1,1,1,1,1,436,436,436,1,1,1,1,1,1,1,815,988,815,
  815,590,590,5,590,5,808,590,5,808,5,590,590,4,590,4,590,1,
  976,590,4,590,1,988,1,1,1,590,590,590,4,1,590,590,988,1,
  590,976,1,1,1,590,590,590,815,815,815,815,815,815,815,815,
  815,815,815,815,1,1,1,1,1,1227,1,294,1,1,1227,1,8,422,1,
  6,1,772,1,1,1,1,6,1,1,591,589,1,1,1,1,1,772,887,1,1,6,
  1,1,1,948,1,1,1,1,1,1,1,951,951,951,1,1,1,1,1,1,1,1,
  1,550,550,865,550,865,1194,550,865,1194,818,816,927,1209,816,
  816,816,1,1205,927,1209,1266,1,990,752,1,1,1,1,816,816,1,
  816,1,815,752,927,1,1,752,1,1,1,1,1,1,436,436,436,1,1,1,
  1,1,1,1,1260,1,1,1196,1249,1199,1,1,1202,1,818,1,1,1209,
  1282,815,1,1,1,1,1209,1282,1,990,1,1,1,1,1,1,815,1,1,1,
  815,1248,1282,1271,1248,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1196,1249,1199,1,1,1202,1,818,1,1,1209,1282,815,1,
  1,1,1,1209,1282,1,990,1,1,1,1,1,1,815,1,1,1,815,1248,
  1282,1271,1248,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,886,
  886,592,920,920,592,590,900,900,315,315,723,315,591,348,1,1,
  315,723,348,1,293,165,1,1,971,1,315,591,326,348,971,301,
  351,695,1,338,1,1,1,1,1,1,549,1,1,1,549,1,1,1,334,334,
  1,886,886,886,435,592,920,920,772,315,315,723,315,591,348,1,
  1,315,723,348,1,293,1,1,1,1,1,315,591,338,348,1,301,165,
  695,1,177,1,1,1,1,1,1,1,1,1,1,1,1,549,549,334,1,1,920,
  816,920,590,434,886,434,732,732,582,732,815,410,1,1,732,582,
  410,1,134,519,1,1,294,960,732,815,355,410,960,590,355,425,
  566,476,1,1,719,1043,1043,927,865,732,732,410,865,927,920,
  920,425,410,732,886,920,886,886,435,772,315,315,723,315,591,
  348,1,165,315,723,348,1,293,1,1,1,1,971,315,591,177,348,
  970,301,1,695,1233,1,79,1,1,1,1,549,1,1,1,1,1,549,1,1,
  1,1,1,920,920,816,920,6,732,732,582,732,815,410,1,519,732,
  582,410,1,134,1,1,1,960,294,732,815,476,410,1227,590,519,
  425,297,354,354,1,403,719,1043,865,927,732,410,732,927,865,
  865,865,410,732,732,900,886,302,900,321,321,527,321,397,264,
  1,653,321,527,264,1,293,653,1,1,1,1,321,397,1033,264,1,
  358,352,394,1,1,1,1,1,1116,1110,1,1,1,1,1,1,1,850,850,
  892,1,1,886,920,900,315,315,723,315,591,348,1,351,315,723,
  348,1,293,79,1,1,970,1,315,591,1,348,1,301,1,695,1,361,
  351,1,1,1,1,1,549,1,1,1,549,1,1,1,1,1,334,920,434,732,
  732,582,732,815,410,1,355,732,582,410,1,134,354,1,1,1227,
  960,732,815,354,410,1227,590,1,425,1,1,476,1,719,403,719,
  920,865,410,425,732,865,920,927,927,732,732,410,900,321,321,
  527,321,397,264,1,352,321,527,264,1,293,1,1,1,1,1,321,397,
  1,264,1,358,653,394,1,663,680,1,1,1,1,850,1,1,59,1,1,
  850,1,1,1,1,1,714,714,133,714,590,721,1,1008,714,133,721,
  1,878,1006,1,1,986,810,714,590,512,721,1242,815,1008,1094,1,
  1,1,1,1163,1092,1115,556,1213,1086,1111,1086,1213,556,556,
  556,1111,1086,1086,1200,1200,592,815,815,1,1,592,590,1288,1,
  1288,707,1,1,951,1,592,988,707,592,951,815,590,815,794,592,
  1,1,1135,1,1,1,436,1,1,723,436,1,436,436,1,723,1,1200,
  815,815,592,1,1,592,1200,1200,1,300,707,1,1,951,1,592,988,
  707,815,951,815,592,592,1229,590,1,1,1,1,1,1,436,1,1,723,
  436,1,436,436,1,1,723,1200,4,1200,1,1082,590,1269,590,1,
  1269,590,1,1,6,6,590,4,590,1200,6,4,1082,1200,1,1082,1082,
  1,590,1200,1200,1209,1209,1200,1200,590,1209,1209,1209,1209,
  590,1200,1200,815,1200,1,707,1200,1200,592,1,300,1,1,1,1,
  951,592,815,592,815,951,988,707,592,1229,1,590,1,1135,1,
  1135,436,1,1,723,1,1,436,436,436,723,1,1,815,1,1,815,4,
  815,1,988,1,1,1,815,815,988,1185,989,988,4,1185,989,988,
  949,816,816,1,590,590,590,988,988,591,591,591,988,988,1185,
  1185,591,591,591,1,1223,1288,590,592,1,1288,1,1,1,1,951,
  592,815,592,592,951,988,1223,815,794,1,592,1,1,1135,1,436,
  1,723,1,1,1,436,436,436,723,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,707,590,1,1,1253,1,1,1,803,1,592,989,635,592,951,816,
  816,590,794,635,1192,1,1,1,1,1,887,1,1,746,887,1,436,436,
  388,388,286,1200,815,1,1288,1,1,1,1,951,815,815,590,592,
  951,988,707,592,1272,1272,592,1,1,1135,1,436,1,1,723,1,1,
  436,436,436,1,723,1,1200,1,1269,1082,1,1,6,6,1200,4,1082,
  1200,6,4,590,590,1,1082,1082,1,1200,1200,590,1209,1209,1200,
  590,1200,1209,1209,1209,1209,1200,1200,590,1,1288,1223,1,1,
  951,1,815,988,1223,592,951,815,592,592,1272,592,1272,1,1,1,
  1135,1,436,723,1,1,436,1,436,436,1,1,723,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1253,1,1,591,591,1288,988,1253,300,591,988,1253,1288,1,
  203,203,1,1288,300,1288,990,990,300,1288,1288,990,990,990,
  990,1288,300,1288,1,1,1,803,590,816,816,592,951,989,635,592,
  1234,550,635,1,1,287,287,887,1,1,746,1,1,887,436,436,286,
  114,114,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,815,951,815,951,951,815,4,803,
  951,433,1,951,1,1,1,1,1269,1,1,1,1,1,1269,1269,1269,1,1,
  1,951,4,803,951,815,815,951,951,433,951,1,1,1,1,1,1,1269,
  1,1,1,1269,1,1269,1269,1,1,1,815,1,1200,1,815,1,1288,1,
  707,707,1,1,1,1135,436,436,723,1,1,436,436,1,1,1,1,723,
  816,815,815,1185,1,815,976,1,989,1,590,590,590,1185,988,591,
  591,591,988,1185,988,988,591,591,591,1,1,1,550,1,1,635,1,
  1,1,1,1,887,436,114,114,286,436,887,1,1,1,1,746,1,815,1,
  1200,1,1223,1223,1,1,1,1,436,436,1,1,723,436,436,1,1,1,1,
  723,815,1,1,1,803,803,1,1,1,1,1269,1269,1,1,1,1269,1269,
  1,1,1,1,1,816,815,976,989,1,1,590,590,590,988,1185,590,
  590,590,1185,988,988,988,590,590,590,1,1,1,635,1,1,1,1,
  436,887,746,1,1,887,436,1,1,114,114,286,1,707,707,1,1135,
  1,1,436,436,1,1,723,436,436,1,1,1,723,1,1272,1272,1,1,1,
  1,1283,1283,1,1,1,1283,1283,1,1,1,1,1,816,1,1,1,287,436,
  1,286,114,388,1,436,887,887,1,1,1,1,287,1,1,1,436,1,1,1,
  436,1,887,887,388,286,114,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1200,1288,1,1,1229,1,1,1,1,1,1,1,1,1229,1200,1,1,1,1,
  1229,1,1,1,1,1,1,1229,1,1,1,1,1229,1,1,1,1,1,1229,1,
  988,1,1,1,988,1260,988,988,1,1,1,1,1,1,1260,988,988,988,
  1,1,1,1200,1200,1,1,1,1,592,815,592,1288,1,1,1,1,592,592,
  815,1,1,1,1,815,592,592,988,988,988,1,1,1,988,988,1,1,1,
  1260,1,1,1,1,1,1,1200,1288,1200,1,1,1269,1,1,1,847,1167,
  1,1128,963,1060,1,1124,1146,1,1125,1082,841,1173,1160,967,
  1160,1,1082,940,1,434,1126,969,1,1,1,841,1,1,1,1,1238,1,
  962,1,1,1,1179,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1260,1,
  1,1,1,1249,1202,1,1199,1,1,1196,1,818,1,1,815,1282,1209,1,
  1248,1271,1,815,1282,1,815,1,1,1,1,1,1,1209,1,1,1,990,1,
  1282,1,1,1,1248,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1249,1202,1,1199,1,1,1196,1,818,1,1,815,1282,1209,1,1248,
  1271,1,815,1282,1,815,1,1,1,1,1,1,1209,1,1,1,990,1,1282,
  1,1,1,1248,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,955,
  1152,1,1,847,1144,1,1060,1151,1,962,1082,1160,1,841,964,1,
  1,1082,1215,1,434,1,957,1,1,1,1125,1173,1,1,1,1238,1182,
  1125,1145,1256,1256,1145,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1239,1239,1,
  1,638,1,638,1164,162,1,112,1,1,162,1,1,112,1,1,1,1,594,
  514,399,1,1,1,1,1,10,832,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  906,954,1,1,1176,1,770,934,1191,934,1,1,894,1099,645,535,1,
  1,1,894,1,1,1121,729,1,1,1,1,774,645,1,1,1,579,1,1,1,
  780,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1076,1,
  1222,1,1099,894,1,645,1,1,729,1,894,535,1,1121,1,1,1,1,1,
  873,645,1031,1,1,579,904,1,26,1134,1156,738,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1166,1,914,559,1,914,1,466,372,466,1,669,
  1,1,1,372,669,1,1,1,1,1,1,1,444,716,1137,1,1,371,807,
  304,484,778,811,670,1,1,1,1,1,1,1,1,1,1,1,1,954,943,1,
  1,1,914,1,823,1,91,760,908,938,701,1,885,646,1,1084,1020,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1140,1062,1239,934,1,1063,1090,903,639,1,779,718,1,
  1090,1,1,936,1037,1,1,1,1,1,639,1064,1,1,777,1,1,1,1,1,
  758,1,1,1,1,1,1,1,1,1,1,1,1,1,1127,1143,1,1,561,890,
  244,1,828,1,1013,1,258,839,1,1,1013,1171,1,1,1,233,762,1,
  1,1,570,1,881,1138,1132,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,596,1,1,821,1,761,524,1,632,1,821,1,1,842,1011,1,1,1,
  1,1,761,1,1,1,819,461,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1141,1141,1141,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1270,1270,829,508,508,1,1017,1017,1,817,772,1,1,1,1,
  829,707,592,1,1,1,1,1,265,1133,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,886,1,1169,1017,1200,1017,1,591,1,989,817,1,989,1157,
  1,1,1,1,817,1200,1,1,1,4,591,1,205,1212,1157,1,1,1,1,1,
  1,1,1,1,1,1,1,1,815,1223,1223,1270,1017,1,772,1,1,829,1,
  817,508,508,1,1,1,1,1,772,1,1,841,1246,829,1,1,1178,265,
  1,1,1,1,1,1,1,1,1,1,1,1,1169,1,886,1,1234,1,1,1200,1,
  1,590,1,1234,1,1,1,707,886,1229,1,1,886,927,707,204,940,
  940,204,1,1,1,1,1,1,1,1,1,1,1,1,1,1200,1,432,886,1,817,
  1,1,1,1,423,1,1,1,829,1270,1204,1,1,841,1246,1270,1082,
  1273,1178,1273,1,1,1,1,1,1,1,1,1,1,1,1,1169,886,1,508,1,
  1,423,1,205,418,1,1,1,1,1,1,204,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,966,1,966,1,1157,1,1,1157,1,418,
  1,1,1,772,435,416,1,1,435,435,592,203,934,1082,591,1,1,1,
  1,1,1,1,1,1,1,1,1,1,772,772,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1017,1,989,591,1,1,1,1,1,590,1246,1,1,816,1250,817,1,1,
  1250,205,1,1,1,1,1,1,1,1,1,1,1,1,1223,1223,815,1,1,886,
  432,1,1,1,592,707,1246,1,1,592,934,829,1153,934,1153,1082,
  1,1,1,1,1,1,1,1,1,1,1,1,1,886,1169,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1157,205,1,1,1,1017,1200,1212,1,1,816,1250,1017,1223,1234,
  1250,1223,1,1,1,1,1,1,1,1,1,1,1,1,1223,815,1223,508,1,1,
  1,592,886,886,1,1,1200,1048,772,591,1204,1212,203,1,1,1,1,
  1,1,1,1,1,1,1,1,772,772,1,1,1,1,1,403,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,966,1,966,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,592,1,1017,1,1082,934,271,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1169,886,886,1,1,886,1,1270,1,1,927,1234,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1200,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1234,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,435,1,90,934,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,434,426,426,1,1,1,707,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,427,427,271,1234,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  886,1169,1,1,1153,1223,1,1,1,1,1,1,1,1,1,1,1,1,1,614,
  1017,940,1273,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1204,1,1,1,
  1,1,1,1,1,1,1,1,1,1,934,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1017,614,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1223,1223,1223,1,988,1,1269,436,436,927,
  436,927,560,436,927,560,205,816,816,816,816,1209,927,905,1,
  816,816,927,1,815,1,1,905,1,1,816,1209,1,927,1,990,1,1266,
  1,1,1,1,1,1,1,436,436,1,1,1,1,1,1,436,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,550,550,865,550,865,1194,550,865,1194,818,816,
  927,1209,816,816,816,1,1205,927,1209,1266,1,990,752,1,1,1,
  1,816,816,1,816,1,815,752,927,1,1,752,1,1,1,1,1,1,436,
  436,436,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1104,1128,1060,1,1,
  1,1,1,916,1,1160,1173,841,1082,1125,1237,1,1,1,962,1290,
  1238,1,937,1160,1,1,841,1082,1,1,1,434,580,940,1,1,1170,
  1160,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,435,435,592,508,508,
  592,591,874,874,591,303,151,591,151,188,369,1,303,151,509,1,
  467,37,21,1,858,1,591,151,1,188,1,467,110,905,1,1,1,1,1,
  480,1,1,211,108,1,604,1,1,1,324,1,1,1,435,435,435,434,
  592,508,508,1139,591,303,151,591,151,188,1,369,303,151,509,
  21,467,1,1,1,1,1,591,151,1,188,1,467,37,905,1,1,1,231,1,
  1,1,108,1,1,211,108,1,1,1,211,1,1,1,508,592,508,591,940,
  302,940,591,358,335,591,335,343,1,1,358,335,62,406,710,58,
  548,722,1,1,591,335,1,343,1,710,364,131,1,1,1,1,1,1,1,
  377,1,377,1,181,1,1,1,172,1,1,1,435,508,435,435,434,1139,
  591,303,151,591,151,188,1,1,303,151,509,1,467,1,231,950,1,
  1,591,151,1,188,1,467,1,905,1,1,227,470,1,1,1,604,108,
  211,324,1,1,1,1,1,1,1,1,508,508,592,508,204,591,358,335,
  591,335,343,722,526,358,335,62,548,710,1,1,730,1,1,591,335,
  1,343,1,710,58,131,1,1,1,387,1,1,1,181,377,1,172,377,1,
  1,1,1,1,1,1,874,302,1067,874,205,43,163,205,163,117,1,674,
  43,163,930,656,382,378,342,1,1,1,205,163,1,117,1,382,396,
  956,1,1,1,1,1,1181,1,465,1,1,111,465,1,1,1,111,1,1,1,
  435,508,874,591,303,151,591,151,188,950,950,303,151,509,231,
  467,227,470,1,480,1,591,151,1,188,1,467,1,905,1,1,110,1,
  1,858,1,324,604,324,604,211,1,1,1,108,1,1,1,508,940,591,
  358,335,591,335,343,730,1,358,335,62,1,710,1,387,1,1,1,
  591,335,1,343,1,710,1,131,1,1,781,1,1,1,1,740,181,172,
  740,1,1,1,1,377,1,1,1,874,205,43,163,205,163,117,1,1047,
  43,163,930,342,382,1,1,1027,1181,1,205,163,1,117,1,382,378,
  956,1,1,237,539,1,1,1,319,465,111,160,1,1,1,1,1,1,1,1,
  550,125,761,550,761,130,1,1,125,761,901,1,819,1,1,1,563,1,
  550,761,1,130,1,819,683,813,1,1,1,1,1,563,1,1038,1051,
  1065,1117,1051,1,1,1,1065,1,1,1,815,815,3,815,815,1158,1,
  988,988,815,817,815,302,302,1,841,1,3,988,1,988,1,815,817,
  815,1,1,435,435,1,841,1,1,592,592,1,592,1,1,1,592,1,1,1,
  815,815,815,815,1,1,592,886,886,707,1082,1,1,783,1125,1,
  988,592,1,886,1,886,707,1082,1,1,1,783,1,1,1,1,416,1,416,
  635,1,1,1,635,1,1,1,815,815,815,1,1172,592,886,1082,869,
  886,302,925,925,1,1,988,592,1,886,1,1082,869,886,1,1,783,
  1,1,1,1,1,1,435,435,989,1,1,1,707,1,1,1,815,815,1,1158,
  815,815,4,302,4,435,435,949,1,1,3,815,1,815,1,4,302,4,1,
  1,817,817,1,1,1,592,1,1,592,592,1,1,1,592,1,1,1,815,
  1172,1,886,592,886,1229,1082,1,1,783,1,1,988,886,1,592,1,
  886,1229,1082,1,1,1,772,1,1,1,435,435,1,1,707,1,1,1,989,
  1,1,1,1,1,886,592,1082,1282,886,925,302,925,1,1,988,886,1,
  592,1,1082,1282,886,1,1,772,1,1,1125,1,416,1,416,1,635,1,
  1,1,635,1,1,1,1,783,925,982,925,1234,708,928,1175,1,1,949,
  783,1,925,1,982,925,1234,1,1,1136,1,1,1,1,805,1,1,853,
  454,1,1,1,393,1,1,1,1245,927,1207,1207,1133,1,1,1,1,1,
  949,1245,1,927,1,1207,1207,1133,1,1,1279,1211,1,1,1,1,853,
  805,1,266,1,1,1,454,1,1,1,815,886,1,886,1,783,1245,1,1,
  815,815,1,815,1,1082,1,1082,1,1,707,707,1,1125,1,635,1,
  416,635,1,1,1,1,416,1,1,1,886,925,886,783,1,1245,1,1,815,
  815,1,815,1,1082,302,1082,1,1,869,869,1,1,1,707,1,435,989,
  435,1,1,1,1,1,1,1,1207,815,1272,1272,1,962,1,815,1082,1,
  1082,1,815,803,4,1,1,1,1,1,962,1,1,436,436,1097,1,1,1,1,
  1097,1,1,1,1,1,750,1,1,1,435,1,1,302,1,803,435,1133,1,1,
  421,750,1,806,1,288,289,732,527,1,1,1,1,127,1,1,1,1197,
  1197,1,135,1,815,1082,1,1082,1,4,1133,815,1,1,1,1,1,434,
  1,1169,886,815,1200,1200,1,1,1,1169,1,1,1,435,925,1,1,817,
  1,1,772,1,934,1,1139,1,1,1,421,1,1,1,712,1,1,732,1,1,1,
  1,462,1,1,1,925,428,1,817,772,1,1,1,934,421,1139,1,1,1,
  750,1,1,1,289,127,1,732,527,1,1,1,1,1,1,1,972,1,1158,
  927,1,927,1,1,1136,1,1,1,708,928,1,956,1,1,393,454,1,853,
  1,1,1,1,1,1,1,1,841,1,1,1125,1,434,1,962,1,1,408,1,1,
  1,1,1204,1,1,1,1,1,1,1,1204,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,815,1,815,1,815,
  435,815,1,1,302,302,1,841,1,592,592,592,592,1,1,1,1,1,1,
  1,1,1,815,1,886,1,886,1,1,1229,1229,1,1,1,989,435,1,707,
  1,1,1,1,435,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,886,925,886,1,1,1282,1282,1,1,1,635,
  416,1,635,416,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1207,815,1,1,1,1,1,135,1,1200,815,
  886,1169,1169,1,1,1,1200,1,1,1,1,1,1,1,1,1,1183,1,462,
  712,732,1,1,1,1,1,1,1,1,1,1,1,1,1,1,962,1,1097,436,436,
  1,1097,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,435,1,1,1,
  1,462,1,1,786,1,1,1,712,1,1,1,1,1180,1,127,1,527,1,732,
  1,1,1,85,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1204,1204,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,435,
  1,1,1,1,1,1,1200,1,1,1,1,1,1,1,1,1,435,1,1,1,435,435,
  1,1,1,1,1,1,1,1200,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1249,
  1202,1,1199,1,1,1196,1,818,1,1,815,1282,1209,1,1248,1271,1,
  815,1282,1,815,1,1,1,1,1,1,1209,1,1,1,990,1,1282,1,1,1,
  1248,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1269,1,550,550,865,
  550,865,1194,550,865,1194,818,816,927,816,816,1209,816,1,1,
  927,816,1266,752,815,1,752,1,1,1,816,1209,1,816,1,990,1,
  927,1205,1,1,752,1,1,1,1,1,1,1,1,436,436,436,1,1,1,1,
  815,987,1,1227,1,960,1,1,960,1295,50,422,1,772,1,6,1,1293,
  1,1,772,1,1241,6,1,887,1,1,1,1,6,1,1,1,591,1,1,887,1,
  1,948,1,1,1,951,951,1,1,1,1,1,1,951,1,1,1,1,1,1227,1,
  294,1,1,1227,1,8,1,1,772,1,6,1,948,1,1,772,1,1,6,1,589,
  887,1,1,422,6,1,1,1,591,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  951,951,951,1,1,1,1,886,886,592,920,920,592,590,900,900,
  315,315,591,315,723,348,361,1,315,591,348,351,301,1,79,1,1,
  1,315,723,1,348,1,293,1,695,351,1,1,1,1,970,1,1,1,549,1,
  1,1,1,1,334,1,549,1,886,886,886,435,592,920,920,772,315,
  315,591,315,723,348,1,1233,315,591,348,79,301,1,1,177,1,1,
  315,723,1,348,1,293,1,695,165,1,1,1,971,1,970,1,1,1,1,
  549,1,1,1,1,549,1,1,920,816,920,590,434,886,434,732,732,
  815,732,582,410,1,1,732,815,410,476,590,1,354,354,403,719,
  732,582,1,410,719,134,1,425,355,1,1,1,960,1227,1227,732,
  732,865,927,920,410,732,425,410,920,865,927,886,920,886,886,
  435,772,315,315,591,315,723,348,177,1,315,591,348,1,301,1,
  1,338,1,1,315,723,1,348,1,293,1,695,1,1,1,165,1,1,1,334,
  1,1,549,1,1,1,1,1,1,1,549,920,920,816,920,6,732,732,815,
  732,582,410,354,297,732,815,410,354,590,1,1,476,719,403,732,
  582,1,410,1043,134,1,425,519,1,1,519,294,960,1227,410,732,
  927,865,865,732,732,410,732,865,927,865,900,886,302,900,321,
  321,397,321,527,264,663,1,321,397,264,680,358,1,1,1,1,1,
  321,527,1,264,1,293,1,394,352,1,1,653,1,1,1,1,1,1,1,850,
  1,1,59,1,850,1,1,886,920,900,315,315,591,315,723,348,338,
  1,315,591,348,1,301,1,165,326,1,1,315,723,1,348,1,293,1,
  695,1,1,1,351,1,971,971,334,334,549,1,1,1,1,1,1,1,549,1,
  920,434,732,732,815,732,582,410,476,566,732,815,410,1,590,1,
  519,355,1043,719,732,582,1,410,1043,134,1,425,1,1,1,355,
  960,294,960,425,410,865,920,927,732,410,732,732,927,865,920,
  900,321,321,397,321,527,264,1,1,321,397,264,1,358,1,653,
  1033,1116,1,321,527,1,264,1110,293,1,394,653,1,1,352,1,1,
  1,892,1,1,850,1,1,1,1,1,1,1,850,714,714,590,714,133,721,
  1,1,714,590,721,1,815,1,1006,512,1092,1163,714,133,1,721,
  1115,878,1,1094,1008,1,1,1008,810,986,1242,1111,1086,1213,
  556,556,1086,1086,1111,1086,556,1213,556,815,815,592,1200,
  1200,707,1,592,988,815,707,815,1,590,1,1,1,592,590,1,592,
  1135,1288,1,1288,592,1,1,1,951,951,1,1,1,436,1,436,723,1,
  1,723,436,436,1,815,1200,1200,592,1272,1272,592,815,815,592,
  988,1,1,590,1135,1,592,590,1,1288,1,1288,1,592,707,1,1,
  707,951,1,951,1,723,1,436,436,1,1,723,1,436,1,436,815,4,
  815,1,976,988,1185,988,989,1185,1,816,816,590,590,988,4,1,
  815,590,988,1,815,989,1,1,1,4,815,815,591,591,988,988,1185,
  591,591,591,591,1185,988,988,1200,815,1,1229,815,815,592,590,
  988,1,1,592,1,1135,592,1200,1,1200,1135,300,1,592,707,1,1,
  707,951,1,951,723,1,1,436,436,1,1,723,1,436,1,436,1200,
  1082,1,1200,4,1200,1082,4,1,1082,1082,1200,1200,590,1269,1,
  590,590,1269,1,590,590,1,1,590,6,6,6,1200,1200,1209,1209,
  1209,1200,1200,590,590,1209,1209,1209,1223,1,815,988,592,1223,
  815,1,592,1,1,1,592,1200,1,592,1,300,1,1200,592,1,1,1,
  951,951,1,1,1,436,1,436,1,723,1,723,436,436,1,1272,590,
  816,592,816,989,1,550,635,1,1,592,1082,1,1,287,203,1,707,
  635,1,1,1,951,1,803,1,1,1,887,436,286,388,114,1,436,1,
  887,1229,949,1272,1272,976,1,1234,1,1,1,794,1,1,794,1,1,1,
  1,794,1,1,1,433,433,1,1,1,1283,1,1283,1,1,1,1,1283,1283,
  1,815,1200,1,815,1,707,707,1,1,1200,1200,1,592,1,300,1,
  592,1,1,1,592,1,951,951,1,1,436,436,1,1,723,1,723,1,436,
  436,815,816,1185,1,1,989,590,590,815,4,1,815,590,988,1,988,
  1,1,1,989,815,815,4,591,591,988,1185,988,591,591,591,591,
  988,988,1185,1272,815,1,1223,1223,1,1,1288,590,1,592,1135,
  1288,1,592,1,1,1,592,1,951,951,1,1,436,436,1,723,1,1,723,
  1,436,436,1,1,635,1,1,287,1,1082,1,592,1,203,1,707,1192,
  1,1,635,1,951,803,388,286,436,887,1,1,1,1,114,1,436,887,
  1,989,1,590,590,815,4,1,988,590,988,1,815,816,1,1,816,815,
  4,815,590,590,1185,988,988,590,590,590,590,988,1185,988,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,816,287,1,707,590,1,1,287,1253,1,592,1,1,1,635,
  803,1,951,286,114,1,436,887,1,1,746,114,887,1,436,1,1,707,
  590,1,592,1,1253,1,1,635,1,1,550,803,951,1,1,1,436,1,887,
  114,286,114,746,887,436,1,1200,1,1200,1,1135,1200,300,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1229,1,1229,1,1,1,1135,590,
  1,1,1288,1288,1,1135,1,1,1,1,1,1,1,1,1,1,1,1,1229,1,1,
  1229,1,1,1,1200,1,815,1,1288,1,815,1,1,1,590,1,951,951,1,
  723,436,436,1,1,723,1,1,1,436,436,1,1200,1200,1269,1,1200,
  1082,1,1,1082,6,6,6,590,1200,1209,1209,1209,1200,590,1200,
  1200,1209,1209,1209,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1288,1,815,1223,1,1,1223,951,1,951,723,
  1,1,436,436,723,1,1,1,436,1,436,1288,1,1,1,1,1,1,1,1,1,
  1,1229,1,1,1,1,1229,1,1,1,1,1,1,1288,1253,1,1,1253,591,
  591,591,1288,300,990,990,990,300,1288,1288,1288,990,990,990,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,590,1,1,1,
  951,951,1,1,723,436,1,436,1,723,1,1,436,436,1,1,1,816,1,
  803,951,388,388,887,436,1,1,746,1,286,1,887,436,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,951,803,1,114,114,887,1,436,746,1,1,286,436,887,
  1,815,815,1,1,1269,1269,1,1,1,1,1,1,1269,1269,815,1,1,1,
  1269,1269,1,1,1,1,1269,1,1269,1,1,1269,1,1269,1,1,1,1,
  1269,1269,1,1200,1,1,1,592,815,592,1288,1,1,1,1,1,1,815,
  592,592,1200,1,1,1,988,988,1,1,1,1,988,1260,988,988,1,1,
  1,1,988,988,1260,1,1,1,1,1260,988,988,1200,1200,592,1,1,1,
  1288,592,1,1,1,815,1,1,1,1,1,1,988,988,988,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1274,1274,1,1,1,1,
  1169,91,1,885,1,1,1,1,1,888,909,522,1087,261,191,1,1,1,1,
  1,1120,701,852,1,973,1100,882,1,898,1,1,1,1,1,1,1,1,1140,
  1035,1,1,1,1,1,1,1,1,1097,1,1,1238,1,1238,903,1,1090,1,
  639,1,1,1,1105,1090,864,792,936,924,1,525,1,1,1,639,718,1,
  1,777,1091,1,1,743,1,1,1,1,1,1,1,1,1127,1,1,1,1,1,1,1,
  1,1274,1,1,1,1,1169,823,1,1,888,1120,1,1087,1100,1,909,
  852,1,1,1,1,919,1,1,1,1,1020,522,1,973,1,1,1,1,978,1,1,
  1,1,1,1,1035,1,1,1,1,1,1,1,1,1,1,1,1097,1,434,1,1,905,
  830,179,1,1,1161,830,905,1,1,200,1,1,1,1,1,1,179,70,1,1,
  584,1161,498,1,787,1,776,1,1,1,1,1,959,1,959,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1238,1063,1,1090,1105,639,1,792,1091,1,1090,1,1,936,1064,1,
  917,1,1,1,639,1037,864,1,777,1,1,1,1,1,544,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,242,1,138,1,404,1,1,1,1,138,1,1,64,1131,1,1,
  1,1,1,404,518,1,1,139,1,49,1,1,1,941,1,1,1,1,1,899,957,
  899,1,1,1,1,1,1,1,1,1,1,1,1,1,1,829,817,1017,265,1017,
  592,1,1,1,1,1,707,772,829,1,592,1133,592,1,1,1289,1289,1,
  1,1,1,1,1169,1,886,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,590,1,1,1,817,989,817,205,989,1,1,
  1,1,1,1,1200,1157,1017,1,816,1212,1017,1,591,1246,1,1,1,1,
  1,1,1223,1223,815,1,1,1,1,1,1,1,1,1,1,1082,1017,1017,829,
  271,817,1,1,1,1,1,1,1270,772,1270,1,841,1234,829,1,1,1282,
  1,1,1,1,1,1,1,1169,886,1,1,1,1,1,1,1,1,1,1,1270,1200,
  1270,1234,1200,1,1,1,1,1,1,886,435,707,1,886,1229,707,1,
  1278,1278,403,1,1,1,1,1,1,1,1200,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,271,1223,1082,1223,205,1,1,1,1,
  1,1,1234,203,1273,1,1157,1273,265,1,1,1286,1,1,1,1,1,1,1,
  614,1017,1,1,1,1,1,1,1,1234,1234,1273,1273,1212,1,1,1,1,
  1,1,1229,934,1229,1,1238,1238,1133,1,1,1,1,1,1,1,1,1,1,
  1,1204,1,1,1,1,1,1,1,1017,1270,1,1,1,1,1,1,1,1,1,592,
  829,1,841,1082,1,1,1,979,1,1,1,1,1,1,886,1169,1,1,1,1,
  1,1,1,1,1,1223,989,1212,1,205,1,1,1,1200,1157,1,1,4,1234,
  817,1,1250,1,205,1,1,1,1,1,1223,815,1223,1,1,1,1,1,1,1,
  1273,1017,1246,1,432,1,1,1,707,886,1,1,1,1229,829,1,934,1,
  423,1,1,1,1,1,1169,886,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,591,1082,1,1157,1,1,1,1,202,1,1,1,1,1,1,1017,614,1,1,
  1,1,1,1,1,1,1246,1,1,1,1,1,590,591,817,1,816,1,1,1,
  1250,982,1,1,1,1,1,1,815,1223,1223,1,1,1,1,1,1,1,1,1,1,
  1,1,886,886,1204,1,934,1,934,1,1,1255,429,1,1,1,1,1,1234,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,403,508,423,1,90,1,
  508,1,1,1256,1,1,1,1,1,1,966,1,966,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,886,1270,1,886,1,1,1,1,1282,1,1,1,1,1,1,1200,1,
  1,1,1,1,1,1,1,1,1,1,1,1204,508,1,1048,1,418,1,1,1,1,1,
  1,772,772,1,1,1,1,1,1,1,1,1,1273,1017,1,1246,886,432,1,
  1,1,1,1,1,886,1169,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1238,592,1,1212,1,90,1,1,1,
  1,1,426,434,426,1,1,1,1,1,1,1,1,1,1,1286,1,1,1,1,1,1,
  1204,1,1,1,1,1,1,1,1,1,1,1246,1246,1,1,1,1,1,1,886,1,
  1169,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1278,1,1,1,1,1,1,427,427,1,1,1,1,1,1,1,1,1289,1,1,
  1,1,1,1,283,1,1,1,1,1,1,1,1,1,1,1,1,1,966,1,966,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1223,1223,1,1,1,1,1,1,
  1,1223,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1144,1,1,955,1,1060,1,
  1152,847,1151,1125,1,1173,1160,1082,1,1256,1145,962,1,1215,
  1256,1238,957,1,1,1,1,1,1082,1,841,1,434,1145,1125,1,964,
  1,1182,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,559,
  559,773,1202,1202,773,435,508,508,151,580,320,151,320,205,
  337,1,580,320,193,409,715,1,739,1,1,1,151,320,1000,205,1,
  715,409,29,1,601,1,1,1,1,1,1,1,319,1,243,217,152,243,1,
  1,1,1,559,559,559,591,773,1202,1202,1169,151,580,320,151,
  320,205,1,331,580,320,193,739,715,1,1,1,1,809,151,320,601,
  205,1,715,1,29,846,1,1,1,1,1,790,1,1,1,152,319,152,1,
  217,1,1,1,1,1202,302,1202,435,1277,436,1277,103,275,168,103,
  168,508,1,1,275,168,747,744,711,357,1,676,1,1,103,168,692,
  508,1,711,392,282,1054,1,1,1,1,1,1,1,1,157,147,649,1,147,
  1,1,1,1,1,559,1202,559,559,591,1169,151,580,320,151,320,
  205,1,846,580,320,193,1,715,1,1,601,1,1,151,320,1,205,790,
  715,1,29,331,1,739,1,809,1,1,1,1,152,217,1,1,319,152,1,
  1,1,1,1202,1202,302,1202,951,103,275,168,103,168,508,676,1,
  275,168,747,1,711,1,1,1,1,1,103,168,1,508,1,711,357,282,
  1,676,1,357,1,1,1,1,1,147,1,157,147,157,1,1,1,1,1,508,
  436,592,508,614,117,608,614,608,590,993,593,117,608,135,617,
  720,593,618,995,1,1,614,608,626,590,1,720,992,1023,618,995,
  618,593,1,1,491,1,1,1,607,1001,607,1,222,1,1,1,1,559,
  1202,508,151,580,320,151,320,205,601,1,580,320,193,1,715,
  739,1,1000,1,1,151,320,1,205,1,715,1,29,1,337,409,409,1,
  1,1,1,1,217,243,152,319,243,1,1,1,1,1,1202,1277,103,275,
  168,103,168,508,1,1054,275,168,747,1,711,1,357,692,1,1,103,
  168,676,508,1,711,1,282,1,1,744,392,1,1,1,1,1,1,1,147,
  157,649,147,1,1,1,1,508,614,117,608,614,608,590,995,618,
  117,608,135,618,720,618,593,626,1,1,614,608,995,590,491,720,
  593,1023,593,993,617,992,1,1,1,1,1,607,222,1,1,1001,607,1,
  1,1,1,784,90,788,784,788,434,1,1,90,788,581,1,141,540,540,
  534,1,419,784,788,534,434,413,141,1021,1094,1,1,1,1021,419,
  1,413,1,1,893,855,845,893,845,855,1,1,1,1,886,886,592,815,
  815,869,1,590,592,1276,1,1276,1,869,1,1,1,592,592,869,988,
  586,886,869,886,742,742,559,559,1125,1,1,1,1,635,1,416,416,
  1,635,1,1,1,1,886,886,886,4,1205,1205,816,1276,1276,1169,
  816,934,1,934,1,1,590,1082,1,815,1142,815,1169,1082,1,934,
  1,934,1142,1,962,1,1,1,436,1097,436,1,1097,1,1,1,1,815,
  592,815,1,869,1082,886,815,1229,886,742,559,559,1,982,592,
  815,742,815,1,1082,1172,815,1229,1,869,1,434,1,1,1,1,435,
  435,989,1,707,1,1,1,1,1,886,815,1,1229,886,886,815,869,
  1082,559,559,742,1,586,592,815,742,815,1125,1082,1,815,1229,
  1,869,1,586,1,1125,1,1,1,416,635,1,635,416,1,1,1,1,815,
  1229,1,1276,592,1276,1172,590,1,869,1,1,1,592,886,869,988,
  434,886,1229,592,742,559,559,742,1,1,1,1,1,707,1,1,435,
  435,989,1,1,1,1,1224,1224,815,988,4,1224,815,1192,1074,1192,
  1,841,988,815,1074,3,841,4,1224,815,1074,1192,1074,1192,841,
  1,1,1,1,592,1,592,1,592,592,1,1,1,1,1205,934,559,883,559,
  1197,802,1154,1057,1,201,742,1,808,1192,1,1169,1192,1172,802,
  1,1057,1,983,1,812,1,1,1,1107,697,1,723,292,1,1,1,1,1,
  742,1282,1282,1,1,1057,1,1,1,742,1229,1057,1074,580,1205,
  1205,869,1245,802,1297,1057,1,1,1,1,1,379,1,1,786,1,597,1,
  1,1,1,886,1276,1,815,1,934,1,1,1142,886,886,934,4,962,816,
  934,1082,1205,1205,1169,1169,1,1,1142,1,1,436,1097,1,1,1097,
  436,1,1,1,1,1276,559,886,869,1,869,1,1,815,592,1,815,1,
  590,742,592,1,1229,1172,1229,1,1,434,1,1,435,989,435,707,1,
  1,1,1,1,1,1282,1276,1294,1294,1294,1,1,1276,815,1294,4,
  1148,1276,883,815,1282,883,1282,883,1,1,1148,1,1,1202,1202,
  1,1202,1,1202,1,1,1,1,1,1,802,1,1,1,559,869,802,1074,968,
  1169,559,1229,1297,1057,1245,802,1,1,1,1,1,597,786,1,1,1,
  379,1,1,1,1,1,934,1,1,200,886,1082,934,4,135,816,1197,886,
  1205,1169,1169,1205,946,1,946,1,1,815,1200,1200,1169,1169,
  886,1,1,1,1,559,1192,1,1,869,559,559,1074,580,934,802,742,
  1057,1154,802,808,1,1,1,1,1,379,1,1,1,786,597,1,1,1,1,
  559,1,1,1,742,1192,1192,1,1,808,742,1,802,1,802,1,1,580,
  1,1,1,597,786,379,1,1,1,1,1,1,1,1,869,742,559,1074,201,
  934,1057,559,1057,808,802,1154,812,1,1,1,1,697,1,1107,292,
  1,855,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1125,434,812,841,946,946,580,586,1,
  983,1,968,1,1,1,1,1,1,1,1,1204,1,1204,1,1,1,1,886,1,
  815,1,1276,559,886,1,869,1,869,1,1,586,1,1,416,635,1,635,
  416,1,1,1,1,1,559,815,1,886,1,815,869,1,1229,1172,982,1,
  1,1,1,1,1,707,435,989,435,1,1,1,1,1192,1,1,1154,559,1,
  1057,1,1057,1,1,201,1,1,292,855,1,697,1107,1,1,1,1,1,1,
  815,1192,815,1224,1224,1224,1224,841,1,841,1,1,1,592,592,
  592,592,1,1,1,1,1,946,1,1,1,812,1,1,1,1,1,1,1,1,1,1,
  1204,1204,1,1,1,1,1,1205,886,1,1197,1,1197,200,1,135,1,1,
  1169,886,1169,815,1200,1200,1,1,1,1,1,1057,1,802,1,968,1,
  1,1,1,1,1,379,786,597,1,1,1,1,1,869,1172,1229,1,586,1,1,
  1,1,416,1,635,416,635,1,1,1,1,1,1205,1282,1205,1,1,580,1,
  1,786,597,1,379,1,1,1,1,1,1,559,1192,201,1,1,1,1,1,292,
  723,1,697,1107,1,1,1,1,559,1,1,968,1,1,1,379,1,597,1,
  786,1,1,1,1,580,1,1,1,1,786,1,597,1,379,1,1,1,1,1,1,
  946,1,1,1204,1204,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1204,1,1204,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,435,435,1,1,1,1,1,1,1,
  1200,1,1,1,1,1,1,1,1,1,1,1,1,1,1,435,435,1,1,1,1,1200,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1196,1249,1199,1,1,
  1202,1,818,1,1,1209,1282,815,1,1,1,1,1209,1282,1,990,1,1,
  1,1,1,1,815,1,1,1,815,1248,1282,1271,1248,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,770,914,914,1,1,1,91,
  885,1,1,1,823,760,646,1,1,1,1020,1,1,1,1,1,1,908,1,1084,
  1,1,701,938,1,1,1,1,1,1,1140,1,1,1,1,1,1,1062,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1239,1076,1239,1,934,559,934,1,1,639,903,1090,1,1,1,
  1063,639,1,1,777,1,1037,1064,1,1,1,1090,1,1,1,936,758,1,
  718,779,1,1,1,1,1,1,1127,1,1,1,1,1,1,1143,1,1,1,1,1239,
  1,1,1,1,594,1,514,638,1,1,832,10,638,1164,162,1,1,1,112,
  399,1,1,1,1,1,162,1,1,1,1,112,1,1,1,1,1,1,906,954,1,1,
  1,1,1,1,1,1,1,1,1,1,1176,1,1222,873,1,645,1,894,1,1134,
  26,1099,645,535,1156,579,1,1,1031,1,1,1,894,1,1,1,1121,
  738,1,729,1,1,904,1,1,1,1,1166,1,1,1,1,1,1,1,1,1,1,1,
  1191,1,1,233,1,762,244,258,1,1132,1138,561,1,839,1,570,
  1171,1013,1,1,1,1,890,1,828,1,1,1,881,1013,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,596,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,934,774,1,645,1099,894,1,780,1,
  1,645,1,1,579,1,729,1,1,1,1,894,1,535,1,1121,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,914,444,1,716,466,372,
  1,778,484,466,1,669,811,371,1,1,1137,1,1,1,372,1,669,1,1,
  670,304,1,1,1,807,1,1,1,954,943,1,1,1,1,1,1,1,1,1,1,1,
  1,761,1,821,1,1,1,1,761,1,1,819,1,1011,1,1,1,1,821,1,
  524,1,842,1,1,632,1,1,461,1,1,1,1141,1141,1,1,1,1,1,1,
  1141,1,1,1,1,1,1,1,1,1082,1,829,707,592,934,592,1,592,1,
  1,1,1,817,1,829,1,1017,271,1017,772,1,1,1,1,1,1,1,1169,
  1,1,1,1,1,1,886,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,590,1,1,1,707,886,707,927,886,403,886,886,1,1,
  1,1200,1,1270,1,1200,1234,1270,435,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1200,1,1,1,1,1,1,1,1270,1270,829,1178,841,508,
  508,772,1,1,1,1017,1,1017,1,817,265,829,772,1,1,1246,1,1,
  1,1169,1,1,1,1,1,1,1,886,1,1,1,1,1,1,1017,1200,1017,
  1250,816,1,591,1246,1,1,1,989,1,817,1,989,205,817,1157,1,
  1,1250,1,1,1,1223,1223,1,1,1,1,1,1,815,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1133,940,934,940,934,1,1204,1,1,
  1,1,1212,1,1273,1,1234,1273,1234,934,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1204,1,1,1,265,204,1153,1153,90,1,591,1,1,1,1,
  205,1,1082,1,1223,1223,271,203,1,1,1,1,1,1,1,614,1,1,1,
  1,1,1,1017,1,1,1,1270,1017,1,1,1,772,592,1,1,1,1,1,829,
  1,817,1,1,508,508,1,1,1,1,1,886,1,1,1,1,1,1,1,1169,1,
  1,1,1,940,886,1234,1,1229,1,1,1,1200,1,1,1,590,204,707,1,
  1234,1,927,1,1,1,1,1200,1,1,1,1,1,1,1,1,1,1,1153,592,
  432,886,1246,1,1,1,817,1,1,1,1,1082,829,1,423,1,934,1,1,
  1,1,886,1,1,1,1,1,1,1169,1,1,1,1,1,1212,1,1,1,1,1157,
  1,1178,1,1250,1,1,1082,1,1,707,1,1,1,934,1,1,1,1,1,1,1,
  1,1,1,1,1,1200,1,1,1,1,4,1,841,1,816,1,1,435,1,1,435,
  1,1,1,434,426,1,1,1,1,1,1,426,1,1,1,508,1,1,1,1,1,1,
  423,1,205,1,1,418,1,1,1,1,1,1,966,1,1,1,1,1,1,1,966,1,
  1,1,886,1,1,1,1157,1,1,1,1157,203,772,1,418,1,1048,1,1,
  1,772,772,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1204,1,1212,1,
  1,416,204,1,1,1,1,1,1,1,1,1,1,1,1,1,1234,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1017,1,989,1,1,591,1,1,591,1,1,1,815,1223,1,1,
  1,1,1,1,1223,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1273,1270,886,432,1,1246,1,1,1,1169,
  886,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1223,1017,1157,205,1,1250,1,1,1,1223,
  815,1,1,1,1,1,1,1223,1,1,1,1,591,1,1,1,1,1,1,1017,614,
  1,1,1,1,1,1,1,1,1,1,592,1,1,1,1,1,1,886,1169,1,1,1,1,
  1,1,1,1,1,1,508,1,435,1,1,1,1,772,1,1,1,1,1,1,772,1,
  1,1,1,1,1,1,1,966,1,1,1,1,1,1,1,966,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,427,1,1,1,1,1,1,427,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1223,1,1,1,1,1,1,
  1223,1,1,1,1,1,1,1,1,1,1223,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1274,1274,1,1,1,1,
  1169,1,1,1,888,909,522,1,1,1,1120,852,978,973,1,1,1020,1,
  1,823,1,919,1,1,1,1,1,1100,1087,1,1,1,1,1,1,1,1,1,1,
  1035,1,1,1,1,1,1,1,1097,1,1,1238,1,1238,1,1,639,1105,
  1090,864,1,1,1,639,1,1,777,1,1064,1037,1,1,1063,1090,917,
  1,1,936,544,1,1091,792,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1274,1,1,1,1,1169,1,888,1120,1,909,852,898,1,1,1,522,
  1,973,1,191,701,1,1,91,885,1,1,1,261,1,882,1,1,1087,1100,
  1,1,1,1,1,1,1,1,1,1035,1140,1,1,1,1,1,1,1097,1,434,1,
  830,179,830,905,1,787,1,1,179,1,1,584,1,1,70,1,1,1,905,
  1,1,1,200,776,498,1161,1,1,1161,1,1,1,1,1,1,1,1,959,959,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1238,1,1105,639,1,1090,1,743,1,1,639,864,1,777,1,
  924,718,1,1,903,1090,525,1,1,936,1,1,1,1,792,1091,1,1,1,
  1,1,1,1,1,1,1,1127,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,404,1,138,1,1,1,1,404,1,1,139,
  1,1131,518,1,1,242,138,1,1,1,64,941,49,1,1,1,1,1,1,1,1,
  1,1,1,1,899,899,957,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1017,1017,829,1,1,1,1270,1270,979,841,1,
  1,592,1,1,829,817,1,1,1,1,1,1,1234,271,1,1082,1,1,1,1,
  1,1,1,1,886,1,1169,1,1,1,1,1270,1200,1270,1,1,1,886,707,
  1282,886,1,886,886,1,1,707,1200,403,1,1,590,1,1,1229,1234,
  1,1,1,1,1,1,1,1,1,1,1200,1,1,1,1,1,1,1017,1270,1,1,1,
  1,829,1282,841,1,1,772,1,1,1,1,1,1,1,817,1,829,1082,1,
  271,1234,1,1,1,1,1,1,1,1,1,886,1169,1,1,1,1,1,1250,1,1,
  1200,1,1,4,1,1212,1157,1,1,817,989,205,1,1,989,205,817,
  1234,1223,1223,1234,1,1,1,1,1,1,1,1,1223,1223,815,1,1,1,
  1,1246,1,1,707,1,886,1,1,1204,1,1,1,829,1017,423,1,1,817,
  432,1017,1229,1273,1082,1273,1,1,1,1,1,1,1,1,1,1169,886,1,
  1,1,1,1,1,1278,934,1278,1212,1,1,1048,1,1,1,591,1,1,1,
  1250,1,1246,1,1,1,1,1,1,1,1,1,1,1,1,427,1,427,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1270,
  1278,886,1,1,435,1,1,1,590,1,1,1,1200,403,707,1,1,1234,
  1229,1,1,1,1,1,1,1,1,1,1200,1,1,1,1,1,1,1,1,1246,886,
  1,1,1017,817,432,1,1,1017,423,829,1273,1082,1273,1229,1,1,
  1,1,1,1,1,1,1169,1,886,1,1,1,1,1,1,1255,1,1,1,1289,
  1246,1256,1,1,982,1289,1246,1,1286,202,1286,1,1,1,1,1,1,1,
  1,1,1,283,1,1,1,1,1,934,1,1,1,592,816,90,1,1,816,90,
  592,1238,1157,1157,1238,1,1,1,1,1,1,1,1,426,426,434,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,886,1,1,592,1,1,1,1,1246,429,934,1,1,
  1,1,1,1,1,1,1,1,1,1,1234,1,1,1,1,1,1,1,1,772,1157,508,
  1,1,591,418,508,934,203,591,1204,1,1,1,1,1,1,1,1,1,772,
  772,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1017,1289,592,1,1,265,
  1133,1,1,1,1,1,1,1,1,1169,886,1,1,1,1,1,1,1,1,989,1,
  1017,1,1,205,1212,1,1,1,1,1,1,1,1,1223,815,1223,1,1,1,1,
  1,1,1,1,508,1,1,1,1,1,1,1,1,1,1,1,1,966,966,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1212,
  205,1,1,1,1,1,1,1,1,1,1,815,1223,1223,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,966,966,1,1,1,1,1,1133,265,1,1,1,1,
  1,1,1,1,1,1,886,1169,1,1,1,1,1,1,1273,1238,1,1,1,1,1,
  1,1,1,1,1204,1,1,1,1,1,1223,1273,1,1,1,1,1,1,1,1,1,
  1017,614,1,1,1,1,1,1,1,1,1,1,1,1,1,1017,1,614,1,1,1,1,
  1,1,1,1,1,1,1,1,1204,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1223,1223,1,1,1,1,1223,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1260,988,988,988,1185,988,988,988,436,436,205,436,205,282,1,
  1,436,205,282,538,501,926,1,1,1240,1,436,205,1,282,1,501,
  1,205,1,538,1,1,1,1,1,1,1,1,1,80,80,1,1,80,1,80,1,988,
  988,988,1185,988,988,988,436,436,205,436,205,282,1,1,436,
  205,282,538,501,926,1,1,1240,1,436,205,1,282,1,501,1,205,
  1,538,1,1,1,1,1,1,1,1,1,80,80,1,1,80,1,80,1,988,988,
  1185,1185,1185,1185,592,592,592,592,592,592,416,1,592,592,
  592,1,302,1,416,1,1,1,592,592,797,592,1,302,400,989,400,1,
  416,1,1,1,1,1,1,1,1,1,1,1,190,1,190,1,1,1260,988,1185,
  988,988,205,205,492,205,492,865,856,1,205,492,865,939,478,1,
  1,1,1,1,205,492,1284,865,1,478,1206,818,1206,939,856,1,1,
  911,1,1,1,1,1,61,61,1,80,61,80,61,1,988,1185,988,988,205,
  205,492,205,492,865,856,1,205,492,865,939,478,1,1,1,1,1,
  205,492,1284,865,1,478,1206,818,1206,939,856,1,1,911,1,1,1,
  1,1,61,61,1,80,61,80,61,1,1185,988,988,592,592,592,592,
  592,592,400,1,592,592,592,400,302,797,797,1,1,1,592,592,1,
  592,1,302,1,989,1,400,400,1,1,1,1,1,190,190,1,190,190,
  190,1,190,1,190,190,988,988,591,591,591,591,591,435,421,1,
  591,591,435,1,300,855,766,1,1015,1,591,591,855,435,1015,300,
  1,815,1,1,421,1,1,195,1,1,508,508,1,192,192,508,192,192,
  192,192,508,1260,492,492,262,492,262,841,1,1,492,262,841,1,
  492,1284,1265,1,1,1,492,262,1206,841,911,492,542,818,542,1,
  1,1,1,1,1,1,482,482,1,1,1,482,254,1,254,1,482,492,492,
  262,492,262,841,1,1,492,262,841,1,492,1284,1265,1,1,1,492,
  262,1206,841,911,492,542,818,542,1,1,1,1,1,1,1,482,482,1,
  1,1,482,254,1,254,1,482,436,436,592,204,204,453,1,989,592,
  462,312,462,851,450,1,1005,1,592,592,528,591,1026,874,344,
  874,702,702,1,1,1,831,1,1,55,225,1,306,95,1,219,637,95,
  219,1,436,436,436,591,1,1,592,204,204,702,436,528,1,1,1026,
  1,989,592,851,462,1005,462,702,1139,312,344,1,1,1,1,1,1,
  225,1,1,95,219,1,95,306,306,1,119,204,592,204,1,1,592,271,
  592,348,271,271,1,1,245,1,592,592,271,876,245,302,673,876,
  348,673,1,1,1,1,1,1,226,1,1,622,238,1,238,167,622,276,
  276,436,204,1,1,436,436,591,344,436,551,551,1,1,1,592,204,
  567,204,621,436,312,989,699,1,648,1,1,1,1,1,1,1,1,219,1,
  119,306,95,637,1,100,204,1,1,204,592,204,673,435,1,749,1,
  1,1,592,271,528,592,742,271,348,1139,702,284,284,1,1,1,1,
  1,1,1,1,238,276,276,622,622,167,1,1,1230,1,462,592,592,
  980,462,1,723,1,1,1,591,876,435,592,1061,591,980,876,672,1,
  436,1,1,518,1,1,1,106,1,102,1,213,102,169,169,310,1,1,
  648,284,436,284,469,1095,836,1,1,1,435,365,136,552,115,205,
  552,483,411,1,1,1,1,1,1,1,1,1,1,228,1,1,155,35,232,1,
  511,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,436,204,1,462,1,1003,1,1,
  1,436,436,251,591,997,436,699,1139,1,1,435,1,1,831,1,1,1,
  119,1,1,1,100,637,219,1,637,55,204,284,271,1045,1,1,1,1,
  204,592,568,204,269,435,702,1139,1,1041,365,1,1,1,1,1,1,
  276,1,276,1,1,167,238,1,1,436,1,462,277,1,1,704,1,462,
  592,277,592,769,462,672,204,552,672,552,1,1,518,1,1,106,
  213,1,1,310,1,169,102,1,116,214,1,1,1122,1,1,1,1,1041,1,
  672,1073,705,1,1081,502,1071,582,1,1,576,1,1,728,209,1,1,
  1,97,654,460,1,309,505,642,441,1,270,1,874,302,1068,591,1,
  1067,1072,874,1,705,205,1,1,204,1,1,27,462,1,1,161,92,1,
  1,477,439,477,551,1,1,1,251,1262,1262,435,1112,895,1203,985,
  1,493,554,1,1,1106,1,1,1,611,1,1,1,76,448,843,1,1,1,1,
  1,1,150,390,1264,1264,947,1025,795,1080,1,636,1,1,1,1,1,1,
  1,1,1,661,660,1,612,619,386,1,146,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,997,1,1112,
  1118,1,747,1,1014,1073,1,733,1,1,1,1,1,1,1,1,1,1,724,
  679,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,436,1,204,1,462,1,874,1,699,443,1,1,
  447,1,1,119,100,1,1,637,55,1,1,1,306,225,1262,204,1,271,
  1,876,1041,1,510,1,1,640,1,1,276,1,1,1,1,436,1,276,1,
  167,226,1264,1,1,493,1,1,1203,1,1,1,36,1,1,74,12,1,1,
  448,153,1,1,1,316,610,1,462,552,876,972,972,1,1,1,1,1,1,
  213,1,1,310,116,214,1,1,116,1,223,1,1,1,1,1,124,1,1,1,
  1,1,652,1,1,1,679,652,1,1,1,1,1,1,874,664,655,1,1,1,1,
  1,1,462,92,1,161,439,477,477,1,1,1,272,1,1071,1,1,1,1,1,
  1,1,239,98,1,654,330,442,1,1,460,93,897,1,634,861,1,1,
  860,1,1,481,481,1,1,96,485,1,1,840,459,1,1,552,1,1,198,
  1,1,1,239,1,1,654,98,1,256,1,330,442,284,1,1,1,1,1,1,
  728,1,460,1,209,330,698,654,1,97,1,1,1,1,1,156,1,1,35,
  228,1,1,1,155,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,475,1,1,1,1,494,1,
  517,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,549,302,240,276,1,1,1,1,276,1,1,1,1,240,549,302,1,
  1,1,1,1,1,1,1,1,1,1,1,1,402,240,276,1,402,1,1,1,477,
  240,1,1,1,1,1,1,1,1,1,1,1,477,276,988,988,988,1185,988,
  988,988,436,436,205,436,205,282,1,1,436,205,282,538,501,926,
  1,1,1240,1,436,205,1,282,1,501,1,205,1,538,1,1,1,1,1,1,
  1,1,1,80,80,1,1,80,1,80,1,1260,988,988,988,988,1185,436,
  436,205,436,205,282,1,926,436,205,282,1,501,1,1,538,1,1240,
  436,205,538,282,1,501,926,205,926,1,1,926,1240,1,1,80,1,1,
  80,1,1,1,80,1,80,1,1,988,988,988,988,1185,436,436,205,436,
  205,282,1,926,436,205,282,1,501,1,1,538,1,1240,436,205,538,
  282,1,501,926,205,926,1,1,926,1240,1,1,80,1,1,80,1,1,1,
  80,1,80,1,1,1185,1185,1185,1185,591,591,435,591,435,590,1,
  808,591,435,590,564,435,808,1,564,1,1,591,435,702,590,1,
  435,874,815,874,564,1,808,1,1,1,190,1,1,190,190,190,1,190,
  190,190,190,1,988,988,1185,592,592,592,592,592,592,1,400,
  592,592,592,416,302,416,1,797,1,1,592,592,1,592,1,302,1,
  989,1,416,1,400,1,1,1,190,1,1,190,1,1,1,1,1,1,1,1,1260,
  988,205,205,492,205,492,865,1,557,205,492,865,1,478,856,1,
  1216,1,1,205,492,939,865,1,478,1,818,1,1,1,557,1,1,911,
  867,1,1,867,1,1,1,61,1,61,1,1,988,205,205,492,205,492,
  865,1,557,205,492,865,1,478,856,1,1216,1,1,205,492,939,865,
  1,478,1,818,1,1,1,557,1,1,911,867,1,1,867,1,1,1,61,1,
  61,1,1,436,436,707,436,707,592,1,550,436,707,592,1,436,931,
  1,931,770,750,436,707,550,592,1,436,504,815,504,1,1,550,
  750,1,559,81,1,1,81,726,726,1,533,726,533,726,1,436,436,
  592,204,204,1,1,989,592,462,150,462,443,1,1,621,1,592,592,
  699,591,1,874,251,874,567,697,1,1,621,1,1,1,1,1,1,100,55,
  1,637,119,306,225,1,436,436,436,591,1,1,592,204,204,697,
  436,453,1,450,997,1,989,592,312,462,1,462,567,1139,851,450,
  1,453,1005,1,831,1,1,1,225,55,225,1,306,100,95,1,1,204,
  592,204,1,1,592,271,592,356,271,436,1,1,269,1,592,592,702,
  876,1,302,568,876,528,349,1,1,742,1,1,1,1,1,1,436,226,1,
  167,1,622,1,1,436,204,1,453,436,436,591,450,436,1,1,697,1,
  997,592,204,702,204,1,436,851,989,528,1,1,443,1026,1,447,
  225,1,1,55,225,1,1,95,55,219,1,1,204,1,1,204,592,204,349,
  435,1,1,349,1,1,592,271,348,592,1,271,528,1139,271,1,1,
  436,245,1,640,1,1,1,226,226,1,1,622,436,238,1,1,1,1230,
  462,592,592,972,462,741,1,741,1,1118,591,876,672,592,1,591,
  277,876,435,741,1,741,1061,1,1,106,1,1,1,223,1,1,169,214,
  102,106,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,443,436,741,741,647,
  1,1,1,1165,1,435,510,411,436,1,490,490,695,136,929,1,1,
  115,1,1,1,1,1,1,13,120,1,232,158,155,68,1,436,204,1,462,
  1,1,150,1,621,436,436,344,591,1,436,528,1139,551,551,1,435,
  1,1,447,55,1,1,100,1,1,1,219,225,1,119,1,204,1,271,1,1,
  356,1,269,204,592,673,204,1,435,271,1139,1,749,1,510,1,1,
  434,226,1,1,436,1,1,1,238,226,276,276,1,741,462,1230,1,
  972,1118,1,462,592,980,592,1,462,435,204,1,723,1,436,1,1,
  515,1,1,1,223,1,106,1,102,223,1,213,1,1,1,1,1,1,595,551,
  749,636,723,1,1053,551,1,868,751,1,782,1,1,48,66,1,1,235,
  1,1,1,660,1,1,146,1,647,1,1,1,1,874,302,1072,591,1,1067,
  1068,874,490,1053,1,490,875,1,875,27,1,1,280,280,27,1,1,
  272,1,462,1,1,741,1,1165,648,284,284,436,1,469,554,136,
  1095,836,1,300,1,1,78,120,1,1,13,1,1,1,228,156,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,595,1,1003,390,1,723,1,1,696,1,1,1,1,836,1,1,1,
  1,1,1,1,235,66,1,1,1,386,317,1,1,1026,1,1,704,1,747,1,
  1066,1,1,1,1,1,1,1,700,1,1,1,1,1,1,633,625,1,1,1,1005,
  742,1,769,1,1,763,1,31,187,1,1,1,1,1,1,1,1,1,1,700,1,
  1,700,1,1,1,436,1,204,1,462,551,874,1,1003,1,648,1,1,831,
  100,1,1,119,1,119,1,1,1,1,100,1,284,204,1,271,1,876,1045,
  1,1,365,1,1,640,436,1,1,1,1,276,1,276,1,1,1,1,1,1,1,
  493,1,1,1122,1,1,1,1,825,239,1,1,1,728,209,1,1,1,1,97,
  1,1,462,1,876,277,1,1,1,704,1,515,223,1,1,214,106,213,1,
  1,1,310,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,490,874,642,441,1,691,270,1,186,280,1,1,272,27,462,
  1,1,280,161,92,1,1,1059,1,1,1,1,1,1,74,1,1,1,611,76,1,
  1,1,1,1,1,880,1012,1,1,1016,1,1,485,1,1,1,485,481,1,1,
  1,1,481,1,551,1,490,1,1,255,12,1,1,74,1,611,1,1,1,1,76,
  1,1,741,1,1,935,317,1,1,66,1,1,1,661,1,660,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,725,1,1,1,1,1,1,158,13,1,
  1,9,232,120,1,1,875,1,1,1,652,1,1,1,1,1,1,724,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,513,1,1,1,1,494,513,1,1,
  1,1,1,302,1,240,280,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,280,1,1,1,1,240,302,1,1,1,1,1,549,302,1,1,
  276,302,1,1,1,1,1,1,1,1,549,1,1,1,1,1,1,276,1,1,988,
  1260,988,988,1185,988,205,205,492,205,492,865,1,1,205,492,
  865,1,478,1,856,939,1,1,205,492,1216,865,911,478,557,818,
  557,1,1,1,1,1,1,61,1,1,61,1,1,1,867,1,867,1,1,988,1185,
  1185,1185,1185,592,592,592,592,592,302,1,1,592,592,302,400,
  1067,1,1,400,1097,1097,592,592,416,302,1076,1067,797,5,797,
  400,1,1,1097,1076,1176,435,590,590,435,435,435,590,590,435,
  590,435,590,988,988,1185,988,205,205,492,205,492,865,1,1,
  205,492,865,1,478,1,856,939,1,1,205,492,1216,865,911,478,
  557,818,557,1,1,1,1,1,1,61,1,1,61,1,1,1,867,1,867,1,1,
  988,1185,988,591,591,591,591,591,435,1,1,591,591,435,421,
  300,766,855,855,195,1,591,591,1,435,1,300,1,815,1,421,1,1,
  1,1015,1015,192,192,192,192,508,508,192,1,508,1,508,192,988,
  1260,282,282,1187,282,1187,551,1,1,282,1187,551,1,1193,1,1,
  538,948,559,282,1187,538,551,948,1193,1,434,1,1,1,1,559,
  948,948,921,752,752,921,752,752,752,921,752,921,752,752,988,
  592,592,436,592,436,886,1,1,592,436,886,550,302,565,723,
  1010,750,1,592,436,876,886,559,302,556,5,556,550,1,1,1,1,
  770,301,192,192,301,1,1,192,764,1,764,1,192,282,282,1187,
  282,1187,551,1,1,282,1187,551,1,1193,1,1,538,948,559,282,
  1187,538,551,948,1193,1,434,1,1,1,1,559,948,948,921,752,
  752,921,752,752,752,921,752,921,752,752,204,204,592,462,462,
  1,1,592,591,279,380,279,523,1,1,530,1,592,591,536,591,1040,
  849,1,849,390,436,1,1,1,1,1,1,170,1,1,69,105,1,246,39,
  246,210,1,204,204,204,435,1,1,592,462,462,436,435,713,1,1,
  521,1,592,591,675,279,398,279,390,434,675,578,1,1,398,1,1,
  1,1,1,1,105,210,1,246,69,246,1,170,462,989,462,1,1,591,
  1188,707,1002,1188,567,1,1,905,894,591,989,697,508,894,816,
  150,508,1004,443,1,1,794,1198,1198,335,335,301,301,707,168,
  335,783,168,1157,462,462,204,462,1,1,204,204,435,578,435,
  859,859,702,1,767,592,462,390,462,1,435,675,1082,536,1,1,1,
  1040,1,1075,1,1,1,170,210,1,170,246,105,246,1,1,462,1,1,
  462,989,462,443,816,1,149,312,837,837,591,1188,1004,707,794,
  1188,1004,1157,697,1,1,1,894,1090,1090,301,301,335,335,168,
  462,462,1157,707,783,168,335,1,1,279,707,438,1231,279,872,
  745,872,1,1075,591,508,753,1018,1078,508,1232,508,753,1,1,1,
  1078,1075,1,318,1,318,1,1,1,180,1,215,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,204,462,1,
  279,1,1039,1019,1,1,204,204,1,435,767,435,536,434,530,530,
  1,1,1,690,1040,170,1,170,1,1,1,1,246,210,1,39,170,462,1,
  1188,117,1,1024,905,894,462,989,150,462,894,816,697,1157,1,
  234,1,1,462,462,794,335,335,462,591,462,168,335,783,168,508,
  508,591,1,279,1,1242,1,1,1,279,707,1232,438,1,279,753,300,
  1,508,1,1,1,686,1,1,318,180,71,1,1,1,1,1,1,322,40,1,1,
  731,1,1,1,530,234,782,508,1,301,530,665,836,1,1,1,1,572,
  1,109,290,247,41,1,1,1,273,224,1,101,54,571,1036,1,200,
  1121,849,816,628,508,1121,591,628,849,1,301,1,1,879,582,879,
  710,710,435,415,415,711,710,961,711,849,508,849,859,872,1,1,
  82,551,551,556,915,1044,1,984,543,553,1,1,1,1,863,118,1,
  368,370,1,1,1,1,121,15,446,113,1,822,1,1019,702,1218,1218,
  862,629,795,771,1,1,1,1,1,1,1,1,173,1,1,56,383,1,1096,
  148,1,1,336,1,1,1039,702,877,1053,1,313,1122,877,636,582,1,
  1,918,1,1,1,175,1,1,1,529,1,854,332,1,178,1,837,521,837,
  572,1,837,300,63,496,1,1,1,1,1,1,1,1083,1,1,1,1,1,1,
  678,1025,1,1,1,398,794,1,1,492,492,1,1,1,531,1,1,1,1,1,
  1,1098,1,1,1,1,1,1,1,1,1,1,204,1,462,1,279,530,849,1,
  184,1,1,1,1040,690,1,170,1,170,1,39,170,1,1,1,69,1,551,
  462,837,1188,1,508,599,1,1,1,894,1090,1090,591,462,335,335,
  168,508,591,508,462,783,168,335,1218,1,1,1,877,1,1070,1,1,
  1,1,487,252,174,340,360,944,1,1,1,1,1,341,171,1,279,1,
  508,1236,793,1,1,1069,1,703,71,180,1,40,1,322,40,1,1,327,
  1,71,492,1,1,1,798,1,1,1,1,1,693,785,1,1,1,748,401,1,1,
  1,1,1,1,849,314,1,1,1,1121,936,936,415,435,710,710,711,
  508,849,849,415,961,711,710,1,755,1,1,1,1103,558,1,174,252,
  77,1,350,384,1,1,1,922,659,734,1150,671,1,1,1079,1079,1,
  367,367,367,1,1,1,367,1,1,1,339,1,530,1,1,1,562,1,340,
  360,252,174,1,350,77,1,541,1,384,1,1,1,857,1,197,247,1,
  290,109,224,1,247,250,1,273,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,462,879,1,1,
  693,785,1,1,1,1,1,1,1,1098,1198,1,1,1,1,689,1,1,1,1,1,
  1,1098,1,1,1,1,1,1,1,1,1,1,1098,1,301,1,1,1,707,927,
  772,415,1,1,1,1,1,1,865,592,772,462,1,1,1,301,462,1,1,1,
  1,772,865,592,415,1,1,1,1,772,707,927,1,1,1,1,920,707,
  302,462,508,707,1,1,1,849,302,1,1,1,920,1,1,1,1,1,1,508,
  849,462,988,988,988,988,1185,436,436,205,436,205,282,1,926,
  436,205,282,1,501,1,1,538,1,1240,436,205,538,282,1,501,926,
  205,926,1,1,926,1240,1,1,80,1,1,80,1,1,1,80,1,80,1,1,
  988,988,1185,988,205,205,492,205,492,865,1,1,205,492,865,1,
  478,1,856,939,1,1,205,492,1216,865,911,478,557,818,557,1,1,
  1,1,1,1,61,1,1,61,1,1,1,867,1,867,1,1,1260,988,988,436,
  436,205,436,205,282,538,1,436,205,282,1,501,1,926,1,1,1,
  436,205,1,282,1,501,1,205,1,1,538,1,1,1240,1,1,80,80,1,
  1,1,80,1,1,1,1,80,988,988,436,436,205,436,205,282,538,1,
  436,205,282,1,501,1,926,1,1,1,436,205,1,282,1,501,1,205,
  1,1,538,1,1,1240,1,1,80,80,1,1,1,80,1,1,1,1,80,1185,
  591,591,435,591,435,590,564,874,591,435,590,1,435,1,808,702,
  1,1,591,435,564,590,1,435,808,815,808,1,564,874,1,1,1,190,
  190,190,190,1,1,190,190,1,190,1,190,436,436,707,436,707,
  592,1,504,436,707,592,1,436,1,931,550,1,750,436,707,931,
  592,559,436,550,815,550,1,1,504,750,770,1,533,726,726,533,
  1,1,726,81,1,81,1,726,436,436,592,204,204,1003,1,989,592,
  462,1,462,1,648,1,1,1,592,592,1003,591,831,874,648,874,435,
  1,551,551,1005,1026,1,1,100,119,1,1,1,1,119,1,100,1,1,
  436,436,436,591,551,551,592,204,204,1,436,1,1,344,1,1,989,
  592,150,462,447,462,435,1139,443,1,1,528,621,1,1,1,119,1,
  219,1,1,1,100,1,55,1,225,204,592,204,1,1045,592,271,592,1,
  271,1,284,284,1,1,592,592,390,876,640,302,365,876,510,1,
  749,1,742,1,1,1,1,276,276,1,1,1,1,1,436,1,1,436,204,1,
  528,436,436,591,1,436,1,1,702,1,1026,592,204,697,204,447,
  436,443,989,453,1,450,851,997,1,1,219,1,1,95,1,1,225,55,
  1,225,1,55,204,749,1,204,592,204,1,435,1,1,673,1,1,592,
  271,356,592,434,271,510,1139,436,1,1,271,269,1,1,276,276,1,
  238,1,1,1,436,1,226,1,226,1,277,462,592,592,1,462,1,436,
  1,1,704,591,876,723,592,515,591,1,876,436,1,723,1,769,704,
  1,310,1,213,1,1,1,106,214,1,223,1,1,551,450,1,723,1,441,
  1,836,1122,1,1,697,349,1,741,935,1053,741,1012,929,1,751,1,
  187,1,1,660,1,1,661,1,1,1,66,1,317,1,1,851,271,1,1,642,
  1,1095,1,1,1,567,528,1,435,255,490,490,880,136,1,868,1059,
  31,1,1,1,76,611,1,1,1,1,74,1,12,1,1,436,204,1,462,1,
  453,312,1,1005,436,436,450,591,831,436,453,1139,1,1,697,567,
  1,997,1,95,1,225,306,1,1,55,225,1,1,1,100,204,1,271,1,1,
  348,1,245,204,592,349,204,640,435,436,1139,1,1,349,528,1,1,
  1,238,1,1,622,1,1,226,226,1,1,1,436,1,462,1,1230,980,1,
  1,462,592,972,592,515,462,436,204,741,1,741,435,1,1118,1,1,
  213,106,102,1,1,1,223,1,1,1,223,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,469,
  1,1,270,874,302,1,591,186,1067,691,874,490,1,1053,490,1,
  747,1,161,92,462,1,1,1,27,272,1,280,1,280,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  284,1,1,443,436,741,741,78,647,300,136,1,1,1,554,1165,1,1,
  1,1,1,228,1,1,1,13,1,120,1,156,1,1,699,702,1,672,825,
  1072,1,1,411,1,636,493,1,1,1,1,97,209,1,1,1,728,1,1,239,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,621,742,1,1061,875,875,725,1016,115,1,1,1,1,1,
  1,1,724,1,1,1,1,1,652,1,1,1,1,436,1,204,1,462,1,874,1,
  1,150,251,1,621,1,306,225,55,637,1,1,100,1,1,1,1,119,1,
  204,1,271,1,876,1,1,356,568,1,269,1,622,1,226,167,1,1,
  436,1,1,1,1,1,741,1,1,836,1,1,1,1,696,1,595,1,386,317,
  66,1,1,1,235,1,1,1,1,1,1,462,741,876,1230,1,972,277,1118,
  1,1,102,106,1,169,1,1,223,1,1,106,1,214,875,1,1,1,1,48,
  1,1,1,1,494,513,1,1,1,1,513,1,1,1,1,1,490,874,647,1,1,
  1068,1,1,1,1,462,27,1,1,1,280,280,1,27,1,272,1,1,1,782,
  1,1,1,1,232,120,13,1,1,1,158,1,1,1,1,9,695,1,1,1,1,
  1066,1,1,481,481,1,1,1,485,1,1,485,1,1,1,741,490,1,1165,
  1,155,68,120,232,1,1,13,1,1,1,1,158,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,551,595,1,1,1,146,1,660,1,1,1,235,1,
  66,1,1,763,1,1,1,1,76,1,1,1,611,1,1,74,1,1,1,1,1,1,
  700,1,1,1,1,1,1,1,1,700,1,1,1,1,633,1,1,1,1,1,700,1,
  625,1,1,1,1,1,1,1,1,1,1,1,1,276,1,1,1,1,549,240,1,1,
  1,1,1,1,1,1,302,302,1,1,1,1,276,1,1,1,1,1,302,1,302,1,
  1,1,1,1,240,1,549,1,1,1,1,1,1,1,1,1,1,1,1,1,280,1,1,
  1,1,1,1,1,1,1,1,1,1,280,1,988,1185,988,988,205,205,492,
  205,492,865,856,1,205,492,865,939,478,1,1,1,1,1,205,492,
  1284,865,1,478,1206,818,1206,939,856,1,1,911,1,1,1,1,1,61,
  61,1,80,61,80,61,1,988,1260,988,205,205,492,205,492,865,
  939,1206,205,492,865,856,478,1,1,1284,911,1,205,492,1,865,
  1,478,1,818,1,856,939,1206,1,1,1,80,61,61,80,1,1,61,1,1,
  1,1,61,988,1185,592,592,592,592,592,302,400,797,592,592,302,
  1,1067,1,1,416,1076,1097,592,592,400,302,1176,1067,1,5,1,1,
  400,797,1097,1097,1076,590,435,435,590,590,590,435,435,590,
  435,590,435,988,205,205,492,205,492,865,939,1206,205,492,865,
  856,478,1,1,1284,911,1,205,492,1,865,1,478,1,818,1,856,
  939,1206,1,1,1,80,61,61,80,1,1,61,1,1,1,1,61,435,435,
  591,435,591,435,1,855,435,591,435,1,434,1,1,421,1076,301,
  435,591,421,435,1076,434,855,5,855,1,1,855,301,1076,1076,
  508,742,742,508,742,742,742,508,742,508,742,742,204,204,592,
  462,462,1039,1,592,591,279,1019,279,1,1,1,1,1,592,591,184,
  591,1,849,82,849,271,702,859,859,530,1040,1,1,1,170,1,1,
  170,1,39,170,69,1,1,204,204,204,435,859,859,592,462,462,
  702,435,1,1,578,767,1,592,591,380,279,1075,279,271,434,523,
  1,1,713,530,1,690,1,170,1,210,170,1,1,69,1,105,1,1,462,
  989,462,1,117,591,1188,707,1024,1188,1,1,1,894,905,591,989,
  435,508,1090,816,851,508,1024,312,149,1,434,462,462,168,335,
  462,462,591,335,335,168,335,707,301,301,204,462,1,713,204,
  204,435,1,435,1,1,436,1,521,592,462,436,462,1040,435,523,
  1082,713,1,1,523,521,1,1040,210,1,1,105,1,1,1,105,170,210,
  1,170,462,149,1,462,989,462,312,816,1,1,443,837,837,591,
  1188,1002,707,794,1188,1024,1157,567,1,1,567,905,894,1090,
  462,462,335,168,335,301,301,707,591,168,335,335,1242,1,279,
  707,438,1,279,1,1,1,1,1,591,508,205,1018,1,508,981,508,1,
  872,745,872,845,1069,1,1,1,180,1,71,1,318,215,40,1,318,1,
  859,1,1,745,1,1036,1,1,731,1,822,702,312,582,872,486,507,
  872,687,1,1,757,1,569,1,1,383,1,1,56,1,1,173,529,175,178,
  1,473,523,567,872,872,571,1,1,1,1,1,271,1024,1101,1,912,
  1220,1220,1,814,1,493,896,84,1,1,1,1,368,1,370,118,1,1,
  22,263,176,1,204,462,1,279,1,1,380,1,530,204,204,578,435,
  690,435,713,434,859,859,702,271,1,767,1075,105,1,1,69,1,1,
  170,210,1,1,170,1,462,1,1188,1,1,1002,894,905,462,989,443,
  462,1090,816,567,1157,1,149,312,1024,837,837,794,168,335,301,
  707,301,335,335,168,335,462,462,591,872,279,1,1,1231,1075,1,
  279,707,1231,438,703,279,1,300,872,745,872,1,1,1075,703,1,
  180,318,1,1,318,1,1,71,1,180,71,1,1,1,1,1,1,859,149,1,
  745,1,507,859,1,493,757,808,1,1,717,546,529,1,1,1,1,1,
  175,383,173,1,336,472,1,1,1,1121,200,849,816,516,508,936,
  591,547,849,1220,507,507,1220,930,582,930,711,710,435,415,
  415,710,710,711,710,415,435,415,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,184,435,866,205,197,516,554,866,1101,582,1,553,1,532,1,1,
  1,247,1,41,109,290,449,1,650,247,1,837,1040,462,532,1069,
  462,582,1114,1,1,1,717,489,1,1,1,1,1,1,1,1,1,1098,689,
  401,1,1,1,530,434,1,845,930,930,414,496,84,569,1,14,1,1,
  1,1,1,1,1,1,1083,1,667,1,1,1,1,204,1,462,1,279,859,849,
  1,1039,1019,82,1,1,1,69,1,170,39,1,170,1,1,1,1,1,170,1,
  462,462,1188,1,508,117,1,1024,851,905,894,1090,707,301,335,
  168,335,462,591,462,301,168,335,335,1,1,1,553,866,1,731,1,
  554,1,1,197,650,247,109,449,290,247,41,1,1,1,1,1,1,279,
  872,508,1,1242,1,981,1,1,1,1,318,1,215,318,180,71,1,1,1,
  1,40,930,1,1,1,1,546,1,1,1,1,748,693,1,1,1,1042,1098,1,
  1,1,1,1,1220,849,571,1036,1,547,200,1121,936,415,435,710,
  711,710,435,415,415,415,711,710,710,1,896,1,1,1,14,489,1,
  1,118,370,1,368,1,22,1,1,446,113,45,1,687,1,1,496,1,1,1,
  367,367,1,367,367,367,1,1,1,367,1,859,872,1220,1,1,912,
  263,176,118,1,1,368,370,1,1,1,1,22,1,872,822,1,486,178,1,
  1,529,173,1,1,56,473,383,1,175,859,1,1,1,1,336,1,383,175,
  1,1,1,472,529,1,173,414,1114,1,446,113,1,1,22,370,368,1,
  45,1,118,1,837,930,1,1,1083,667,1,1,1,1,1,1,1,1,462,1,
  1,1,689,1098,1,1,1,1,1,1,401,1,1,1042,1,1098,1,1,1,1,
  748,693,1,462,1,1,1,707,865,436,415,1,1,1,1,1,1,927,592,
  707,301,1,1,1,462,301,1,1,1,1,707,927,592,415,1,1,1,1,
  436,707,865,1,1,1,1,865,592,592,301,462,592,1,1,1,415,592,
  1,1,1,865,1,1,1,1,1,1,462,415,301,988,988,1260,492,492,
  262,492,262,841,1,542,492,262,841,1,492,1265,1284,1206,1,1,
  492,262,1,841,1,492,1,818,1,1,1,542,1,1,911,254,1,1,254,
  482,482,1,1,482,1,482,1,1185,988,592,592,436,592,436,886,
  550,556,592,436,886,1,302,723,565,876,1,1,592,436,1010,886,
  770,302,1,5,1,1,550,556,1,750,559,764,1,1,764,192,192,1,
  301,192,301,192,1,988,592,592,302,592,302,816,1076,1097,592,
  302,816,1076,592,1097,1097,1176,1,1,592,302,1176,816,1,592,
  1097,5,1097,1076,1076,1097,1,1,1,190,1,1,190,1,1,1,190,1,
  190,1,1,492,492,262,492,262,841,1,542,492,262,841,1,492,
  1265,1284,1206,1,1,492,262,1,841,1,492,1,818,1,1,1,542,1,
  1,911,254,1,1,254,482,482,1,1,482,1,482,1,271,271,592,865,
  865,651,1,590,635,927,1128,927,1,651,1,1,1,592,635,651,815,
  727,841,651,841,742,742,752,752,1,727,1,1,1,1,1,328,325,1,
  216,598,329,72,1,271,271,271,815,752,752,592,865,865,742,
  592,359,1,391,1,1,590,635,1167,927,1055,927,742,1082,1128,
  391,1,359,1,1,574,1,1,1,72,325,72,1,329,328,606,1,1,865,
  438,865,1,642,635,463,590,346,463,508,499,499,1,1,635,301,
  752,920,1,635,1152,920,346,1,346,1,1,875,875,94,1,1,1,458,
  1,1,641,1046,137,1,1,271,865,1,359,271,271,815,391,592,752,
  752,742,1,1,592,865,742,865,1108,592,1128,590,651,1,651,1,
  1,1,1088,72,1,1,325,72,1,1,606,325,57,1,1,865,346,1,865,
  438,865,1,301,1,346,1,1,1,635,463,1028,590,747,463,346,829,
  752,499,499,508,1,267,1,1,1,1,1,1,1,1,137,458,333,94,1,
  1227,294,927,590,5,960,927,1199,883,1199,1,1,815,920,883,5,
  1009,815,1227,920,883,1199,883,1199,1,1009,1,457,1,1,1,457,
  1,1,471,506,510,457,1,752,651,499,883,499,651,391,1268,1058,
  1,1,742,1,1245,1196,1,742,1196,1,682,1,682,1,1,1,199,145,
  1,1,666,144,1,1,1,1,208,1,1,1,508,1199,1199,1,1,391,1,1,
  1,435,642,1049,590,644,752,752,672,582,735,879,241,1,497,1,
  1,1,1,1,1,1,1,154,207,104,440,1,271,865,1,927,1,651,1128,
  1,1,271,271,651,815,681,592,651,1082,499,499,742,435,1,681,
  1088,325,1,1,328,1,1,1,57,72,1,598,1,865,499,463,642,1,
  346,1,1,865,438,1152,865,1,301,752,829,1,346,1,642,1,1,
  204,1,1,1,458,1,94,1,333,1,468,468,1,1199,927,294,1227,
  960,1,1,927,590,960,5,998,927,883,5,1196,883,1196,590,1,
  998,834,1,1,1,457,1,457,1,510,457,1,506,1,1,1,1058,1,1,
  1,499,346,682,883,122,742,499,684,879,682,808,1049,1,694,1,
  1,1,1,658,1,1,1,212,53,1,996,1,1,651,1,1,1,841,635,391,
  815,260,592,651,841,752,742,742,752,1,742,1,1,1,1,1,1,1,
  1,605,220,1,622,1,752,1199,1,1,359,855,855,590,644,359,391,
  951,668,556,668,300,1,497,1,1,1,1,1,1,1,1,154,207,1,440,
  1,499,1,1,1,1097,1202,1202,1,1128,1245,1169,1,682,1,668,1,
  1,575,1,1,1,144,666,145,1,643,1030,520,1,1,1,1,391,1097,
  1205,883,236,651,1058,1205,1058,808,682,556,1,1050,1,1,1,1,
  1,658,1,1,143,307,412,305,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,271,1,865,1,927,
  499,841,1,391,1,359,1,1108,574,328,1,1,598,1,598,1,1,1,1,
  328,1,855,865,1,463,1,920,346,1,346,1123,1,1,1,458,1,1,
  1046,94,468,1,468,1,108,1046,1,1202,1,1,1268,1205,1,682,1,
  735,1,25,183,1,1,1,53,24,305,1,1,1,1,1,1,1,927,1196,920,
  1227,960,1227,294,1,1,834,457,1,1,506,457,506,1,1,1,510,1,
  1,1,1,1,1,46,1,1,1,1,1,1,1,1,1,1,633,1,1,1,1,1,1,
  752,841,1,651,1,359,1,889,427,1,1,1,220,1,622,1,1,1,1,
  464,1,1,682,1,682,1,1,1,1,144,1,1,1,145,385,1,1,1,67,
  1029,1,684,1,684,1,1,1,1,308,1,1,1,308,1,1,1,1,363,1,1,
  499,1196,752,1,1,575,1,1,1,144,1,145,1,1,259,1,385,1,499,
  1199,1,1,424,305,1,1,1,53,1,1,1,907,212,1,1,752,1,1,166,
  1,1,1,145,1,144,1,1,376,1,1,1,1,799,1,440,1,1,1,207,1,
  1,1,1,154,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,875,1,1,1,
  679,1,1,1,1,1,652,1,1,1,1,1,1,474,1,1,1,1,513,475,1,1,
  1,1,1,1,1,240,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,240,1,1,1,1,1,1,850,402,1,1,468,
  402,1,1,1,1,1,1,1,1,850,1,1,1,1,1,1,468,1,1,988,988,
  436,436,205,436,205,282,538,1,436,205,282,1,501,1,926,1,1,
  1,436,205,1,282,1,501,1,205,1,1,538,1,1,1240,1,1,80,80,
  1,1,1,80,1,1,1,1,80,988,205,205,492,205,492,865,939,1206,
  205,492,865,856,478,1,1,1284,911,1,205,492,1,865,1,478,1,
  818,1,856,939,1206,1,1,1,80,61,61,80,1,1,61,1,1,1,1,61,
  492,492,262,492,262,841,1,542,492,262,841,1,492,1265,1284,
  1206,1,1,492,262,1,841,1,492,1,818,1,1,1,542,1,1,911,254,
  1,1,254,482,482,1,1,482,1,482,1,436,436,592,204,204,699,1,
  989,592,462,443,462,150,251,1,447,1,592,592,1,591,1,874,1,
  874,1,435,1,1,1,997,1,1,306,637,1,55,100,1,1,225,1,119,
  1,436,436,436,591,1,1,592,204,204,435,436,1003,1,251,831,1,
  989,592,1,462,1,462,1,1139,1,648,1,699,1,1,997,1,637,1,
  637,100,119,1,1,55,1,1,219,204,592,204,1,1041,592,271,592,
  510,271,390,1262,1262,640,1,592,592,1,876,1,302,1,876,1,
  365,1041,1,1,1,1,1,167,1,1,436,1,1,1,226,1,276,276,436,
  204,1,699,436,436,591,648,436,551,551,567,1,1,592,204,1,
  204,1,436,1,989,1,1,344,312,1,1,621,637,1,1,306,119,1,
  219,1,100,1,1,95,204,1041,1,204,592,204,365,435,1,1045,568,
  1,1,592,271,1,592,1,271,1,1139,1,284,284,702,1,1,269,1,1,
  1,167,1,276,276,1,436,1,1,238,972,972,462,592,592,1,462,
  1264,435,1264,1,1,591,876,1,592,1,591,1,876,1,552,672,552,
  1,1118,1,116,1,116,1,214,1,310,1,223,1,213,1,1,344,284,
  672,284,655,636,493,1203,1,1,702,673,1,1,1,705,1,634,1,1,
  1071,1,1,1,1,654,1,1,330,209,728,460,1,97,1,1,698,312,
  702,552,552,664,1,1,1,198,1,702,348,1,672,1,1,1,1,1,411,
  502,1071,1,1073,1,1,330,654,1,98,239,1,1,442,1,1,256,436,
  204,1,462,1,528,851,1,1,436,436,1,591,1,436,1,1139,1,1,
  702,702,1,1026,1005,306,1,219,95,1,1,95,1,119,1,225,306,
  204,284,271,749,1,528,1,1,204,592,1,204,1,435,1,1139,1,1,
  673,348,1,1,742,167,1,276,622,276,1,238,1,1,1,1,622,552,
  462,1,277,277,518,1,462,592,1,592,1,462,1,204,1,436,1,672,
  1,704,769,1,116,310,169,1,213,1,1,214,1,106,102,1,1,554,
  1,1,1,1,1,1,436,1,205,1,861,1,1,582,1,1,733,124,155,1,
  228,1,1,1,35,1,1,1,156,1,1025,895,1,1,1,874,302,1,591,1,
  1067,1,874,1,205,705,1,1,747,1,1,1,439,477,477,92,161,1,
  272,1,462,1,551,1264,1,1,450,1,1,723,1,441,1,1080,1,836,
  1122,795,1,1,947,386,1,660,612,1,1,661,1,146,1,1,619,1262,
  1106,1,851,271,1,1,1,642,1,985,1,1095,1,1203,1,1,1112,1,
  1,1,448,76,611,1,1,1,1,1,843,36,1,528,271,1,435,1,1068,
  1,1,1,136,1,493,1,1112,1,1,316,448,1,153,12,1,1,610,1,
  74,1,1,831,1,1,518,1,204,1,860,1,1,576,1,1,1,1,494,1,1,
  1,1,1,475,1,517,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,436,1,204,1,462,1,874,1,453,
  312,344,1,1005,1026,95,219,95,219,1,225,306,1,1,1,55,637,
  1,204,1,271,1,876,1,1,348,673,1,245,245,622,276,238,238,1,
  1,622,1,276,1,226,167,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,462,1,876,1,1230,980,980,1,1,1061,
  169,310,1,102,213,106,102,1,1,1,1,169,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,874,1,469,1,1072,1,270,
  1,477,439,161,1,92,462,1,1,477,1,27,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,483,1081,1,1,1014,1,840,459,
  96,1,485,481,1,1,1,1,481,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,284,552,1,1,115,232,1,1,155,1,1,228,1,511,1,
  1,35,1,1,1,1073,1,309,1,654,97,209,1,1,505,1,728,460,1,
  1,1,460,93,330,1,442,98,654,1,897,1,239,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,679,724,1,1,1,1,1,1,1,1,1,
  679,1,652,1,1,1,1,1,652,1,1,1,1,1,240,1,1,477,1,1,1,1,
  1,1,549,402,1,276,1,1,1,1,276,1,1,1,1,1,549,402,477,1,
  1,1,1,1,240,1,1,1,1,1,1,302,240,276,1,302,1,1,1,1,240,
  1,1,1,1,1,1,1,1,1,1,1,1,276,988,205,205,492,205,492,865,
  1,557,205,492,865,1,478,856,1,1216,1,1,205,492,939,865,1,
  478,1,818,1,1,1,557,1,1,911,867,1,1,867,1,1,1,61,1,61,
  1,1,282,282,1187,282,1187,551,1,1,282,1187,551,1,1193,1,1,
  538,948,559,282,1187,538,551,948,1193,1,434,1,1,1,1,559,
  948,948,921,752,752,921,752,752,752,921,752,921,752,752,204,
  204,592,462,462,184,1,592,591,279,1,279,1019,82,1,1040,1,
  592,591,1039,591,690,849,1,849,1,1,530,530,398,521,1,1,69,
  39,1,170,1,1,170,1,1,170,1,204,204,204,435,530,530,592,
  462,462,1,435,1039,1,1,690,1,592,591,1019,279,1040,279,1,
  434,1,1,1,536,1,1,767,1,39,1,246,1,170,1,1,170,170,1,
  210,462,989,462,1,599,591,1188,707,1,1188,702,551,551,1090,
  894,591,989,702,508,1090,816,1,508,1,1,234,1,794,837,837,
  783,168,508,508,591,335,168,335,335,591,462,462,204,462,1,
  536,204,204,435,1,435,859,859,390,1,1040,592,462,702,462,
  1075,435,1,1082,1,1,578,675,767,1,1,246,1,1,246,170,1,210,
  170,1,1,1,105,462,234,1,462,989,462,1,816,1,117,150,462,
  462,591,1188,1024,707,794,1188,1,1157,1,1,1,697,894,905,894,
  508,508,168,783,335,462,462,591,591,335,335,168,793,1236,279,
  707,438,1,279,1218,556,1218,1,1069,591,508,1053,1018,703,508,
  1,508,1,1,508,1,1,1,1,327,1,322,1,40,1,1,40,71,71,180,
  1,530,578,1,508,1,1,1,553,1070,1,857,436,443,582,1,197,
  301,1,671,1,1,1,1,531,1,798,273,1,1,250,247,290,224,109,
  1,247,1,1,675,697,1,1,314,1,543,1,562,1,390,1004,636,753,
  1,1,1,1150,1,1,836,755,1,1,1,1,384,350,1,77,252,1,174,1,
  340,360,541,204,462,1,279,1,713,675,1,398,204,204,1,435,1,
  435,1,434,1,1,436,390,1,521,398,246,1,210,246,1,1,105,1,
  170,1,1,69,462,1,1188,149,1,1004,1090,894,462,989,312,462,
  1090,816,1,1157,1,1,443,1004,837,837,794,783,168,462,1157,
  462,335,168,335,335,301,301,707,1,279,1242,1,1232,686,1,279,
  707,1,438,1,279,1,300,1,1,1,753,1,1,1,1,322,1,1,1,180,
  1,71,40,1,318,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,629,1044,1,936,1121,849,
  816,313,508,936,591,1,849,1,1,301,1,492,300,492,961,711,
  508,849,849,710,711,710,710,415,435,415,859,1218,1,1,1,1,1,
  745,1,1036,1,771,1,1,731,795,1,822,862,1,1,383,1096,1,1,
  56,1,336,1,173,148,551,1,1,523,567,872,872,863,571,1,984,
  1,1,1,1,1,1,915,15,446,1,1,1,368,1,370,113,118,1,121,1,
  1,536,697,877,753,487,628,1,877,1,1,782,1,1,572,1,1,341,
  1,1,1,340,944,360,171,252,174,1,462,1,1198,1,1075,1198,582,
  1,1079,1,1,572,558,1,1,1,1,1,1,1,1,1,689,1,1098,1,1,1,
  1,794,918,1078,879,879,1,1079,1,1,1,1103,1,1,1,1,1,1,1,
  1,693,1,785,1098,1,1,1,204,1,462,1,279,1,849,1,1,380,1,
  1,530,1040,246,210,105,246,1,1,69,1,1,1,170,39,1,462,1198,
  1188,1,508,1,1,1002,150,894,905,894,1157,462,168,783,335,
  301,707,301,462,335,335,168,872,1,1,1,877,1,1,1,1122,1,1,
  1,1,178,529,854,1,1,1,1,1,1,175,332,1,279,1,508,1,1,
  1231,1232,1075,1,1078,1,1,1,1,180,318,1,1,1,318,1,215,879,
  1,1,1,1,1,1,1,1,1,1,1098,1,1,1,1,1,1,1,1,1,1,1,849,
  1,1,1,628,1121,200,1121,849,508,711,961,710,435,415,415,849,
  710,710,711,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,665,1,1,496,1,1,339,1,1,367,367,1,1,1,367,367,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,530,1,1,1,1,101,1,273,1,247,1,41,54,
  109,290,224,1,63,1,922,659,384,1,1,77,350,1,734,174,252,1,
  837,492,1,1,1,1,1,1,1,1,1,1,1098,1,837,1,1,1,678,1,1,
  1,1,1,1083,1,1025,1,1,748,1,401,1,1,1,1,693,785,1,508,1,
  1,1,772,920,772,849,1,1,1,1,1,1,865,707,707,462,1,1,1,
  508,462,1,1,1,1,707,865,707,849,1,1,1,1,772,772,920,1,1,
  1,1,927,592,302,462,301,592,1,1,1,415,302,1,1,1,927,1,1,
  1,1,1,1,301,415,462,492,492,262,492,262,841,1,1,492,262,
  841,1,492,1284,1265,1,1,1,492,262,1206,841,911,492,542,818,
  542,1,1,1,1,1,1,1,482,482,1,1,1,482,254,1,254,1,482,271,
  271,592,865,865,391,1,590,635,927,1,927,1,359,1,1108,1,592,
  635,391,815,574,841,359,841,435,742,499,499,1,1,1,1,328,
  598,1,1,1,1,598,1,328,1,1,271,271,271,815,499,499,592,865,
  865,742,592,651,1,651,681,1,590,635,1128,927,1088,927,435,
  1082,1,651,1,651,1,1,681,1,598,1,57,1,1,1,328,1,325,1,
  72,865,438,865,1,346,635,463,590,346,463,1097,855,855,1,1,
  635,301,1097,920,1,635,1123,920,642,1,346,1,1,1,1,108,1046,
  468,468,1,1,94,1046,1,458,1,1,271,865,1,651,271,271,815,
  651,592,752,752,742,1,1,592,865,742,865,1088,592,1,590,359,
  1,391,1128,1,1,1108,57,1,1,606,1,1,72,325,1,72,1,325,865,
  346,1,865,438,865,1,301,1,642,1152,1,1,635,463,346,590,204,
  463,642,829,508,499,499,752,1,1,1,468,468,94,333,1,1,1,
  458,1,1,1,1,960,1227,927,590,5,1227,927,1202,590,1202,1,1,
  815,920,883,5,834,815,294,920,590,1196,883,1196,1,1,1,510,
  1,506,1,1,1,457,506,1,457,1,1,499,391,499,883,499,651,682,
  556,682,1,1,742,1,808,1199,424,742,1199,1,735,1,682,1,1,1,
  46,212,1,1,1,1,1,53,1,1,305,1,907,1128,752,1196,1196,1,1,
  668,1,1,1,742,346,1058,883,575,752,752,684,582,682,879,682,
  1,1,1,1,385,145,1,1,1,1,144,1,1,1,259,271,865,1,927,1,
  359,1167,1,1,271,271,391,815,574,592,359,1082,752,752,742,
  742,1,1,1055,606,1,72,329,1,1,325,72,1,1,1,328,865,499,
  463,346,1,1028,267,1,865,438,1,865,1,301,508,829,1,346,1,
  346,1,1,747,333,94,1,137,1,1,1,1,1,1,1,458,1196,927,1227,
  294,960,998,1,927,590,960,5,834,927,590,5,1199,883,1199,883,
  1,1,998,1,506,457,510,1,1,1,457,1,1,1,457,1,1,668,1,1,
  1,752,346,682,883,166,742,752,684,879,682,808,682,1,1,1,1,
  1,144,1,1,1,1,145,1,1,1,376,1128,359,1,889,1,841,635,651,
  815,427,592,359,841,752,742,742,752,1,1,1,1,464,622,1,1,1,
  1,220,1,1,1,1,752,1202,1,1,651,499,499,883,575,651,668,
  1169,391,1268,1058,1245,1,1,1,520,1,145,643,1,1,666,144,1,
  1,1,1030,855,497,1,1,508,1199,1199,1,1,300,951,1,391,1,
  391,1,1,644,1,440,1,154,1,1,1,1,1,1,1,207,25,1,651,752,
  1205,883,183,391,735,1205,1049,1245,682,1268,1,1,1,1,1,305,
  1,1,1,24,53,1,1,1,1,1,727,875,1050,1009,875,742,799,1,
  497,1,694,1,1,1,1,652,1,1,1,1,1,1,679,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  271,1,865,1,927,752,841,1,651,1128,651,1,1,727,329,72,325,
  216,1,1,328,1,1,1,1,598,499,865,875,463,1,920,642,1,346,
  1152,1,1,1,137,1,1,641,1,1,458,1,1,94,1,1046,1199,1,1,
  556,1205,1,1058,1,1058,1,1,236,412,305,1,143,1,1,658,1,1,
  1,1,307,1,927,1199,920,294,1227,960,1227,1,1,1009,510,457,
  1,471,1,1,457,1,1,457,1,506,1,1,1,1,199,1,1,1,1,1,513,
  475,1,1,1,1,474,1,1,1,1,1,752,841,1,651,1,651,1,1,260,
  1,622,1,605,1,1,1,1,1,1,1,220,1,241,1,1049,1,1,1,1,154,
  1,1,1,1,1,207,1,1,440,1,1,672,1,684,1,1,1,1,363,1,1,1,
  1,1,308,1,1,308,1,1,752,1199,752,1,1,644,104,440,1,154,1,
  1,1,1,1,1,1,207,499,1196,1,1,1,208,1,1,1,1,1,144,666,1,
  145,1,1,499,1,1,122,1,996,1,212,1,1,1,658,1,1,1,53,1,1,
  1,67,1029,385,1,1,1,145,1,1,144,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,633,1,1,1,
  1,1,1,1,1,1,468,1,1,1,1,850,240,1,1,1,1,1,1,1,1,402,
  1,1,1,1,1,468,1,1,1,1,1,1,1,402,1,1,1,1,1,240,1,850,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,499,499,1018,527,527,1,1,300,508,462,1,462,1025,1,1,
  686,1,1018,508,671,591,1078,508,1130,508,705,1,1,1,1,703,1,
  1,1,624,1,1,451,1,445,624,159,1,1,499,499,499,591,1,1,
  1018,527,527,1,707,538,1,537,1,1,300,508,647,462,1075,462,
  705,934,664,1,1,689,1,1,1,1,624,1,230,451,1,1,159,1,323,
  1,1,527,591,527,1,627,508,1210,435,1,1210,504,923,923,942,
  117,508,591,301,849,1119,816,1007,849,1,1,1,1,300,879,879,
  374,345,930,930,582,345,345,374,345,300,492,492,499,527,1,
  689,499,499,591,1,707,1263,1263,205,1,845,1018,527,205,527,
  1069,707,664,951,689,1,1,664,845,1,1069,230,1,1,323,1,1,1,
  323,451,230,1,451,527,1,1,527,591,527,1,816,1,1009,249,560,
  560,508,1210,1089,435,582,1210,1,951,507,1,1,507,117,942,
  1119,930,930,345,374,345,492,492,300,582,374,345,345,1,972,
  462,435,592,1,462,741,723,741,1,521,591,849,436,592,398,591,
  980,849,672,1,1,1,530,1,1,1,1,623,1,353,1,347,229,613,1,
  347,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,664,507,1,1,312,1,
  1122,1,1,1,705,1,1,672,717,1,1,1149,808,1,1,757,1,555,1,
  1,662,631,1,1,1,1,456,620,218,835,257,499,527,1,462,1,538,
  647,1,1,499,499,537,591,1,707,689,934,1,1,1,705,1,1,1075,
  323,1,1,159,1,1,451,230,1,1,624,1,527,1,1210,1009,1,1089,
  942,117,527,591,249,527,1119,816,507,951,1,1,1,1,560,560,
  582,374,345,492,300,492,345,345,374,345,930,930,582,1,462,1,
  1,1,690,1,462,435,1,592,1,462,672,1082,1,1,1,672,1,690,1,
  1,623,347,1,1,347,1,1,353,1,623,353,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  150,1004,1,1090,905,508,816,234,591,894,989,149,508,1,1,1,
  1,837,794,837,447,845,794,837,837,845,845,447,845,837,794,
  837,1263,741,1,44,1,923,923,723,1,1004,636,1,1122,1,1,795,
  1,487,945,1,1,602,600,1,1,488,1,1,1,417,657,923,487,1,
  1025,504,741,741,945,150,795,1,1,1,1,636,44,1,1,1,417,1,
  1,488,602,1,600,657,1,1,1,185,1,671,301,866,436,1,234,411,
  866,1,1,1,1208,1,569,1,1,844,1,1,1,452,194,38,479,189,
  495,1,560,703,879,569,1,879,794,545,1079,555,1,1,902,1,1,
  1,691,1,1,1,1,1,1,1,706,1,1,1,1,300,1,530,837,837,569,
  496,1,1,1,822,1,1,1,1,871,1,1,1,500,1,1,871,1,1,1,499,
  1,527,1,462,1,508,1,1,1,1130,1,686,1078,159,1,451,445,1,
  624,1,1,1,1,1,624,923,527,879,1210,1,849,627,1,1,1007,117,
  942,1119,300,492,345,374,345,930,582,930,492,374,345,345,741,
  1,1,1208,866,1,1,1,411,1,185,1,189,495,452,38,194,1,1,1,
  1,1,844,479,1,462,1,849,972,1,1,980,521,1,398,1,347,1,
  229,347,623,353,1,1,1,1,613,837,1,1,1,1,1,1,1,1,1,768,
  1,1,1,1,687,1,1,1,1,1,1,1,508,312,1,1,149,905,1090,894,
  837,794,845,447,845,794,837,837,837,447,845,845,1,757,1,1,
  1,822,902,1,456,1,1,1,631,662,620,1,1,1,609,1,1149,1,1,
  1,496,1079,1,381,1,884,1,884,884,884,1,1,381,1,1,1,1,1,
  1,1,717,218,835,1,456,1,631,1,1,257,1,662,620,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,569,545,1,1,609,662,1,620,1,631,1,1,456,1,1,560,
  837,1,1,500,1,1,1,1,1,1,1,871,871,879,1,1,1,1,1,1,1,1,
  1,691,1,706,1,1,687,1,1,1,1,1,1,768,1,1,930,1,1,1,869,
  556,302,837,1,1,1,1,1,1,1213,1076,869,492,1,1,1,930,492,
  1,1,1,1,869,1213,1076,837,1,1,1,1,302,869,556,1,1,1,1,
  556,1076,765,492,930,1076,1,1,1,837,765,1,1,1,556,1,1,1,
  1,1,1,930,837,492,1260,988,988,988,1,1,1185,988,988,815,
  988,815,1,1,1223,1,1185,1185,815,988,1223,988,815,988,815,
  815,1,1,815,1,1,1,435,1,1,816,435,1,435,435,816,1,1,988,
  988,988,1,1,1185,988,988,815,988,815,1,1,1223,1,1185,1185,
  815,988,1223,988,815,988,815,815,1,1,815,1,1,1,435,1,1,
  816,435,1,435,435,816,1,1,988,988,1,1,1185,1185,1185,1186,
  1185,816,816,1,1,1,3,1185,988,1185,989,1185,1186,1185,988,1,
  816,816,989,1,1,1,1,1,1,989,1,1,989,989,989,1,1,1260,
  1269,1,988,1185,988,1269,988,1,815,1,1,1,1185,988,815,1185,
  815,988,1269,988,1185,988,988,988,1223,1223,1,1,1,435,1,435,
  1,1,816,816,435,435,1,1269,1,988,1185,988,1269,988,1,815,1,
  1,1,1185,988,815,1185,815,988,1269,988,1185,988,988,988,1223,
  1223,1,1,1,435,1,435,1,1,816,816,435,435,1,1,1186,816,815,
  816,815,1200,1186,1,1,1,988,1186,590,816,1082,815,816,815,
  591,1,1,1,591,1,1,1,1,1,1,592,1204,1,772,592,592,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1185,988,1,988,1,1186,1,1,1,1185,
  1185,1186,3,989,1185,1186,1185,1185,1185,1185,1185,1,989,1,1,
  1,989,1,1,1,1,989,989,1,989,1,988,816,988,1186,1,1,815,1,
  1185,3,1186,1185,815,1185,988,1185,1,988,816,816,816,816,1,
  1,989,816,1,816,989,1,989,989,816,816,1,1,1260,1269,1269,1,
  1223,1,988,1185,1269,1185,1223,988,815,988,988,1185,988,988,
  1,815,1,1,1200,816,1,1,1200,1,1200,1200,1,816,1,1,1,1200,
  1,1,1,816,1186,1200,988,1082,815,816,815,816,1186,815,815,1,
  591,1,1,1204,592,1,1,1,1,592,772,1,592,1,1269,1269,1,1223,
  1,988,1185,1269,1185,1223,988,815,988,988,1185,988,988,1,815,
  1,1,1200,816,1,1,1200,1,1200,1200,1,816,1,816,1,1,1,1186,
  816,816,988,591,815,1200,815,1186,816,815,815,1,1082,1,1,1,
  592,1,1,1,1,592,592,1204,772,1,1,951,1,1186,988,816,816,
  951,815,590,815,1,591,1,1,1200,1,1,1,436,1,1,1192,707,1,
  707,436,1192,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,989,816,591,989,816,815,1200,
  815,816,1,886,886,1,1,1,1,1,1,1,1,1,1,592,592,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1185,1,1185,1,988,816,988,1,988,816,816,1,989,1,1,989,
  989,1,1,989,1,1,1,1,989,1,816,1185,816,988,1,988,988,1,
  816,816,815,815,1,1,816,989,1,989,816,1,816,816,989,989,1,
  816,1,1,1186,1,1,591,1,1,1,1082,1,1,592,772,1,1204,592,1,
  1,1,1,592,1,1,988,816,988,4,4,815,815,989,1,1,1,989,1,1,
  989,989,1,1,1,989,1,1,1,1,1,1,435,1,1,1,1,1,1,592,1,1,
  1,592,1,1,1,1,1,1,1,1260,815,815,1,1,1223,1223,1,1,816,
  1200,1,1200,816,1,1,1,1200,1200,1,1,591,1,1,1,951,951,1,
  1,1192,707,1,707,1192,1,1,1,436,436,1,815,815,1,1,1223,
  1223,1,1,816,1200,1,1200,816,1,1,1,1200,1200,1,1185,988,
  988,1,435,1,1,816,435,1,1,989,1,1,435,1,435,1,988,988,
  816,1,1,1,1,435,1,816,1,1,435,435,989,1,1,1260,886,1,1,
  1,841,1,1,436,436,1,1,933,841,933,1,886,1,1,1,841,1,1,
  436,436,1,1,933,841,933,1,816,1,1,1,592,1,1,1,1,1,1,1,
  592,1,1,1,1,1,1,592,1,1,1,1,592,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,436,1,989,816,1,
  1,1,1,816,1,1,1,1,989,436,1,1,1,1,1,1,1,1,1,1,1,1,1,
  436,989,1,1,816,989,1,1,1,1,1,1,1,1,436,1,1,1,1,1,1,
  816,1,1,988,988,988,1,1,1185,988,988,815,988,815,1,1,1223,
  1,1185,1185,815,988,1223,988,815,988,815,815,1,1,815,1,1,1,
  435,1,1,816,435,1,435,435,816,1,1,1260,988,1,1,988,988,
  988,815,1185,1,1,815,1,1,1185,988,815,988,815,988,815,1185,
  815,1,1,815,1223,1,1223,1,1,1,435,435,1,1,816,816,435,1,
  435,988,1,1,988,988,988,815,1185,1,1,815,1,1,1185,988,815,
  988,815,988,815,1185,815,1,1,815,1223,1,1223,1,1,1,435,435,
  1,1,816,816,435,1,435,815,815,1185,1185,1185,4,1185,816,1,
  816,1,1,3,1185,988,1185,989,1185,4,1185,988,816,1,816,989,
  1,1,1,1,1,1,989,1,1,989,989,989,1,1,1260,816,988,988,988,
  816,1,1,1,1,1,1185,816,815,988,886,988,988,816,815,1,1,1,
  886,1,1,1,1,1,1,436,933,1,841,436,841,1,933,816,988,988,
  988,816,1,1,1,1,1,1185,816,815,988,886,988,988,816,815,1,
  1,1,886,1,1,1,1,1,1,436,933,1,841,436,841,1,933,988,988,
  1,1185,1,1,1186,1,1,1185,1185,1186,1185,989,1185,988,3,816,
  816,1,988,1,1,989,1,1,1,989,1,1,1,989,989,1,1,989,1260,
  988,988,1269,1,1269,1223,1,988,1185,1269,988,1223,988,1185,
  1185,1,815,1,815,1,1,815,1,435,1,816,1,435,1,435,435,1,1,
  816,988,988,1269,1,1269,1223,1,988,1185,1269,988,1223,988,
  1185,1185,1,815,1,815,1,1,815,1,435,1,816,1,435,1,435,435,
  1,1,816,1,1,1,1,1,1,1185,988,1186,1185,816,1185,1185,988,
  816,591,1,591,1,1,435,1,435,1,435,1,1,1,989,816,1,1,435,
  1186,1,1,815,1,1185,3,1186,1185,815,1185,988,1185,816,988,1,
  816,816,1,816,1,815,1,816,816,815,1,815,815,816,1,816,1,
  816,1,1,1186,816,816,815,591,815,591,988,1200,1186,1,590,1,
  1,1082,1,1,1,592,1,1,1,592,592,1204,1,772,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  951,1,1186,988,816,815,951,815,591,816,1200,590,1,1186,1200,
  1,1,1,707,1,1,1192,436,1,436,707,1192,1,1,1,989,816,591,
  815,816,815,435,989,1082,1,1,1082,1,1,1,1,1,1,1,1,1,1,
  592,592,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1185,1,988,1,988,1185,1185,1,1186,1,1186,
  1,1,989,1,989,1,989,1,989,1,1,1,1,1,989,816,988,816,988,
  1,1185,1186,1,1,1186,815,1,815,1,816,1,989,989,816,1,816,
  816,989,1,989,1,1,1,816,816,1,1200,1,1200,1,1,1082,1,592,
  1,772,1204,592,1,1,1,1,1,592,1,1260,988,988,1269,1269,1,
  1269,1223,1,1223,1,816,1,1200,1200,816,1,1,1,1200,1,1200,1,
  1,1,1,1200,1,1,1,1,1,1,592,1,1,1,592,1,1,1,1,1,1,988,
  988,1269,1269,1,1269,1223,1,1223,1,816,1,1200,1200,816,1,1,
  1,1200,1,1200,1,1186,1,1,1,816,1,1,1,435,1,1,989,435,1,
  1,1,816,1,435,1186,1186,1,1,989,1,1,1,989,1,1,989,989,1,
  1,1,989,1,1,816,1,816,1,1,591,1,772,1,592,1,592,1,1,
  1204,1,1,592,1,816,951,1,951,1,1,1,436,436,1,1,1192,1192,
  707,1,707,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,591,1,1,1,
  772,1,1,592,592,1,1,1204,592,1,1,1,816,1,1,1,592,1,1,1,
  1,1,1,1,592,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,592,1,
  1,1,1,592,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,436,1,989,
  816,1,1,1,1,1,1,1,1,1,1,1,1,816,1,1,1,1,989,1,436,1,
  1,1,1,436,1,989,1,816,989,1,1,1,1,1,1,1,1,436,1,1,1,1,
  1,1,1,816,1,988,1260,1,1269,988,988,1185,1269,988,988,988,
  988,1,1223,1185,988,1185,988,1223,1185,1269,988,815,1,815,1,
  815,1,1,435,1,1,1,816,1,435,435,435,816,1,1,988,1,1,1185,
  1185,1185,1186,1185,1,816,816,815,815,3,1185,988,1185,4,1185,
  1186,1185,988,816,816,1,4,815,815,816,816,816,816,988,816,
  816,988,988,988,816,816,1,1269,988,988,1185,1269,988,988,988,
  988,1,1223,1185,988,1185,988,1223,1185,1269,988,815,1,815,1,
  815,1,1,435,1,1,1,816,1,435,435,435,816,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1186,815,816,816,815,1,1,1,1212,1,988,
  1186,591,815,1157,816,816,815,590,1200,1186,1,434,1,1,1,
  1201,1,1,591,1201,1,301,301,816,423,423,988,1185,1,988,1,
  816,816,1,815,1185,1185,988,1185,815,3,1186,1185,816,816,988,
  1,1,816,816,989,1,816,816,1,1,989,989,989,1,816,816,988,1,
  1260,815,1,1,989,989,988,1185,815,988,989,1185,815,988,1,
  815,815,1,988,988,988,886,886,988,988,988,886,886,886,886,
  988,988,988,816,988,4,815,815,815,1,1185,3,4,1185,815,1185,
  988,1185,816,988,816,1,1,816,816,1,989,816,816,1,989,1,989,
  989,1,816,816,1,1,1,1,1,817,816,1186,591,815,817,988,816,
  815,1186,1200,590,1,1,886,886,1224,1287,886,886,1,1,436,436,
  1224,1,886,886,815,1,1,989,989,988,1185,815,988,989,1185,
  815,988,1,815,815,1,988,988,988,886,886,988,988,988,886,886,
  886,886,988,988,988,988,988,1,434,988,1185,1185,1185,815,988,
  1186,1185,591,816,591,1,1,435,435,434,1,816,816,1,1,434,
  989,989,815,435,435,1260,1017,1,816,1185,988,988,1017,816,
  815,988,1,815,1,1,435,1,1,1,508,1,1,435,508,1,508,508,
  435,1,1,1017,1,816,1185,988,988,1017,816,815,988,1,815,1,1,
  435,1,1,1,508,1,1,435,508,1,508,508,435,1,1,815,815,815,
  815,1223,815,4,1212,1223,817,1,1157,1,1,1,1,1082,1,1,1,1,
  1,1082,1082,1082,1,1,1,815,4,434,1223,815,815,1157,1223,817,
  1157,1,1,1,1,1,1,1082,1,1,1,1082,1,1082,1082,1,1,1,1185,
  1,988,1,1185,816,988,1,1186,1186,1,1,816,816,989,989,816,
  816,1,989,989,1,1,1,816,816,1185,988,815,1185,1,988,1186,1,
  1186,1,4,815,815,988,816,816,816,988,816,988,816,816,988,
  816,816,988,1,1,816,988,1,1186,1,1,1,435,435,434,989,435,
  435,815,989,434,1,1,1,816,816,1,988,1,1260,1269,1269,1269,
  1,815,1,1,435,435,1,1,816,435,435,1,1,816,1,1,815,1,1,1,
  1212,1212,1,1,1,1,1082,1082,1,1,1,1082,1082,1,1,1,1,1,
  816,988,1186,1186,1,1,4,815,815,816,988,815,815,4,988,816,
  816,816,4,815,815,1,1200,1,1200,1,434,1,1,301,1201,1,1,
  591,1201,301,1,1,816,423,423,1269,1269,1269,1,815,1,1,435,
  435,1,1,816,435,435,1,1,816,1,1,816,816,1,1,886,886,1224,
  1224,886,886,1,436,436,1,1287,1,886,886,816,1,434,1,1,301,
  1,423,423,816,1,301,1201,1201,591,1,1,1,434,1,1,1,301,1,
  1,591,301,1,1201,1201,816,423,423,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,988,988,1,1,815,815,1,1,1,1,1,1,815,815,1260,1,
  1,1,1,816,1,1,1,1,816,1,1,1,1,1,1,816,1,1,1,1,816,1,
  1,816,1,1,1,590,1209,590,816,1,1,1,1,1,1,1209,590,590,
  816,1,1,1,1260,988,1,1,1,1,1185,988,988,988,1,1,1,1,1185,
  988,988,1,1,1,1,1185,1185,1185,816,816,590,1,1,1,816,590,
  1,1,1,1209,1,1,1,1,1,1,988,988,1260,988,1,1,988,988,988,
  815,1185,1,1,815,1,1,1185,988,815,988,815,988,815,1185,815,
  1,1,815,1223,1,1223,1,1,1,435,435,1,1,816,816,435,1,435,
  1,1269,988,988,1185,1269,988,988,988,988,1,1223,1185,988,
  1185,988,1223,1185,1269,988,815,1,815,1,815,1,1,435,1,1,1,
  816,1,435,435,435,816,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  815,815,816,816,1186,1,1,1,1,1,988,815,591,815,591,816,816,
  1186,590,1,1281,1200,1082,1,1,1,1,1,1,592,1,1,592,592,772,
  1,1204,1260,988,1,988,1,1,815,1,1223,988,988,815,988,1223,
  1185,815,1185,1,1,815,815,1,1,815,435,1,1,816,1,1,435,435,
  435,1,1,816,988,1,988,1,1,815,1,1223,988,988,815,988,1223,
  1185,815,1185,1,1,815,815,1,1,815,435,1,1,816,1,1,435,435,
  435,1,1,816,816,1185,815,815,4,1,1,1185,1185,4,1185,989,
  1185,988,3,816,1,816,988,1,1,989,1,1,1,989,1,1,1,989,989,
  1,1,989,1,1,1,1,1,951,816,815,591,815,951,988,816,1186,
  1281,1,590,1200,1,1,1200,436,1,1,1192,1,1,707,707,436,1,1,
  1192,816,816,1,1,815,1185,1185,988,1185,815,3,1186,1185,816,
  1,988,816,816,1,816,815,1,1,816,816,1,815,815,815,816,1,
  816,1260,988,1,1,816,988,988,988,886,816,815,1185,1,1,1,
  815,1,1,886,933,1,1,436,1,1,1,436,841,933,1,841,988,1,1,
  816,988,988,988,886,816,815,1185,1,1,1,815,1,1,886,933,1,
  1,436,1,1,1,436,841,933,1,841,1,1,988,1185,1185,1185,816,
  988,1186,1185,591,1,591,816,435,1,1,1,1,1,1,435,1,435,816,
  989,435,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,989,815,435,815,816,816,591,989,1082,1,1,
  1082,1,1,1,1,1,1,1,1,1,1,592,592,1,1,1,988,1,988,1,
  1185,816,1185,1,1,1186,1186,1,1,989,989,1,1,989,1,1,989,1,
  1,1,1,989,988,1260,1,988,1,988,1269,1,1269,1269,1223,1,
  1223,816,1,1,435,435,1,816,1,1,435,1,435,988,1,1,816,1185,
  1,1,1,1186,1,1,816,435,1,1,816,435,1,435,1,1,1,1,989,1,
  988,1,988,1269,1,1269,1269,1223,1,1223,816,1,1,435,435,1,
  816,1,1,435,1,435,816,1,1,1,1,1200,1,1,1,1,592,1,1,1,1,
  1,592,1,1,1,1,1,816,1185,1186,1,1,1186,815,1,815,816,1,1,
  815,815,1,816,816,816,815,1,815,1,1200,1,1200,1,1082,1,1,
  592,1,1,1,592,1,592,1,1,772,1,1204,1186,1,1186,1,989,1,1,
  989,1,1,1,989,1,989,1,1,989,1,1,1,816,816,1,1,591,772,1,
  1,592,1,1,592,1,1204,1,1,592,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,816,951,1,951,1,1,1,707,707,1,1,1192,1192,436,
  1,436,591,1,1,772,1,1,1,592,1,592,1,1204,592,1,1,1,816,
  1,1,1,592,1,1,1,1,1,1,1,592,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,592,1,1,1,1,592,1,1,1,1,1,1,1,436,989,816,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,816,1,1,
  1,1,989,1,436,1,1,1,1,436,1,989,1,1,1,1,1,1,816,989,1,
  1,1,436,1,1,1,1,1,1,1,816,1,1269,1,988,1185,988,1269,988,
  1,815,1,1,1,1185,988,815,1185,815,988,1269,988,1185,988,988,
  988,1223,1223,1,1,1,435,1,435,1,1,816,816,435,435,1,1,815,
  816,815,816,1186,1,1281,1200,1,1,988,815,590,816,434,815,
  816,1186,591,1,1,1,1157,1,1212,1,1,1,1201,301,423,423,816,
  591,301,1,1201,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,988,1260,1,988,1,
  1269,1269,1,1,988,988,1269,1185,815,988,815,1185,988,988,988,
  1185,1,1223,1223,1,1,435,435,1,1,1,816,816,1,435,435,988,
  816,1185,1,1,1186,815,815,1185,1185,1186,1185,4,1185,988,3,
  1,816,816,988,815,815,4,816,816,816,988,816,816,816,988,988,
  816,816,988,1,988,1,1269,1269,1,1,988,988,1269,1185,815,988,
  815,1185,988,988,988,1185,1,1223,1223,1,1,435,435,1,1,1,
  816,816,1,435,435,1,1,1200,1,1,1,816,815,1200,988,434,815,
  816,1186,816,815,815,1186,1,1157,1212,423,423,301,1201,1,1,
  1,591,816,1,301,1201,1,1186,1,815,815,1185,1185,1186,3,4,
  1185,1186,1185,1185,1185,1185,1185,815,4,815,815,815,988,816,
  816,815,815,4,4,816,988,816,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,816,1,1,1186,815,
  816,816,434,815,590,988,1,1,1,591,1212,1,1157,423,423,1,
  301,1201,1,1,591,816,1201,1,301,1,1,1186,815,816,988,434,
  815,1200,816,1186,815,815,816,1212,1157,1,1,1,301,1,1201,
  423,423,816,591,1201,301,1,1260,816,988,886,816,988,988,886,
  816,435,1,1,435,1,1,1,1,1,1,1,1,1,1,816,816,1,1,1,816,
  988,886,816,988,988,886,816,435,1,1,435,1,1,1,1,1,1,1,1,
  1,1,816,816,1,1,1,988,1,1185,1,988,816,1185,1,816,816,988,
  1,815,815,816,816,989,989,1,816,816,1,1,1,989,989,1,988,
  988,1260,1,988,815,1,1,815,989,989,989,988,988,886,886,886,
  988,988,988,988,886,886,886,816,1,1,1281,816,1,1,1,591,1,
  817,817,886,886,1224,1224,1287,886,886,1,1,1,436,436,1,988,
  816,1185,4,815,815,4,815,1,815,816,816,1,989,989,816,816,1,
  1,989,1,989,988,1,1,1,435,435,1,1,1,1,815,815,1,1,1,815,
  815,1,1,1,1,1,1,988,815,1,1,815,989,989,989,988,988,886,
  886,886,988,988,988,988,886,886,886,1,591,1,1,1,817,817,1,
  886,886,436,1,436,886,886,1,1,1224,1224,1287,988,816,816,1,
  815,815,1,816,816,989,1,989,816,816,1,1,989,989,1,988,988,
  1185,1,434,815,435,435,434,989,1,816,816,1,815,1,434,989,
  1260,988,1017,1,1017,1,1,1,508,508,1,1,435,435,508,1,508,
  988,1017,1,1017,1,1,1,508,508,1,1,435,435,508,1,508,815,
  434,1,435,435,434,1,989,816,816,1,815,989,434,1,815,815,1,
  1,1082,1082,1,1,1,1,1,1,1082,1082,815,1,1,1,1082,1082,1,
  1,1,1,1082,1,1082,1,1,1082,1,1082,1,1,1,1,1082,1082,1,
  1260,1,1,1,988,988,1185,988,1,1,1,1,1,1,988,988,1185,988,
  1,1,1,816,816,1,1,1,1,590,1209,590,816,1,1,1,1,590,590,
  1209,1,1,1,1,1209,590,590,1260,988,1185,1,1,1,988,1185,1,
  1,1,1185,1,1,1,1,1,1,816,816,816,815,1269,815,4,815,1269,
  1269,815,1269,1,1250,4,1269,4,815,1250,4,815,1269,590,1,590,
  1,1223,1,1,1229,1,1,1,951,1,1229,1229,1229,951,1,1,1269,4,
  815,815,1269,1,590,1,1,1,4,1269,590,4,1223,815,815,1269,4,
  1269,815,1269,1250,1250,1,1,1,1229,1,1229,1,1,951,951,1229,
  1229,1,988,988,1,1260,1,815,1,1,1223,988,988,815,1185,1223,
  1185,1269,988,988,988,1185,988,1,815,1,1200,1,816,1,1,1,
  1200,1200,1200,1,816,1,1185,815,988,816,1,816,1,815,1185,
  1185,988,1185,815,3,4,1185,1,816,988,816,816,816,1,989,1,
  816,1,816,1,989,989,989,816,816,1,815,988,815,4,815,1,1,
  1185,1185,4,3,989,1185,4,1185,1185,1185,1185,1185,1,989,1,1,
  1,989,1,1,1,1,989,989,1,989,1,1,1,590,1,1,1250,815,1269,
  590,4,1250,4,815,1269,815,1269,4,1269,1,1223,1,1229,1,951,
  1,1,1,1229,1229,1229,1,951,1,1,815,1,1,1223,988,988,815,
  1185,1223,1185,1269,988,988,988,1185,988,1,815,1,1200,1,816,
  1,1,1,1200,1200,1200,1,816,1,988,1260,1,1,816,988,988,1185,
  886,816,1269,988,816,988,816,988,1,886,1,1,1,436,1,1,1,
  933,841,436,933,841,1,988,1,1,988,1185,1185,1185,816,988,4,
  1185,1,816,1,816,435,1,1,435,1,1,1,435,1,1,989,816,435,1,
  1,1,1,816,988,988,1185,886,816,1269,988,816,988,816,988,1,
  886,1,1,1,436,1,1,1,933,841,436,933,841,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,989,815,
  435,989,816,816,1223,815,816,886,1,886,1,1,1,1,1,1,1,1,1,
  1,592,592,1,1,1,988,1,1185,1,1185,815,988,1,816,988,816,1,
  989,1,989,1,989,1,1,1,989,1,1,1,989,1,988,988,1,988,1,
  1260,815,1,815,1,1223,1223,1,816,1,435,1,435,1,816,1,1,
  435,435,1,1185,1,1,815,988,1,816,1,816,1,816,1,435,1,816,
  1,435,1,435,1,1,1,989,1,1,1185,815,988,4,815,4,815,989,1,
  1,989,1,1,1,989,1,989,1,1,989,1,1,816,1,1,1,1,435,1,1,
  1,1,592,1,1,1,1,1,592,1,1,1,1,1,815,988,988,816,1,816,
  815,815,1,816,1,815,1,815,1,816,816,816,815,815,1,1,590,1,
  590,1,1250,1250,1,951,1,1229,1,1229,1,951,1,1,1229,1229,1,
  815,1,815,1,1223,1223,1,816,1,435,1,435,1,816,1,1,435,435,
  1,988,1185,988,1,435,1,816,1,435,1,1,1,989,1,435,1,435,1,
  988,1260,886,1,1,841,1,933,1,841,1,436,1,933,436,1,1,988,
  816,1,1,1,1,1,1,989,1,1,435,435,816,435,1,886,1,1,841,1,
  933,1,841,1,436,1,933,436,1,1,816,1,1,1,592,1,1,1,1,1,
  1,1,592,1,1,1,1,1,1,592,1,1,1,1,592,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,436,989,816,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,816,1,1,1,1,989,436,1,1,1,1,1,1,1,1,1,1,1,
  1,1,436,989,1,1,1,1,1,1,1,816,989,1,1,1,436,1,1,1,1,1,
  1,816,1,1,816,988,988,988,816,1,1,1,1,1,1185,816,815,988,
  886,988,988,816,815,1,1,1,886,1,1,1,1,1,1,436,933,1,841,
  436,841,1,933,1,815,1,1269,1,1186,1200,1,951,815,815,590,
  816,951,988,816,1186,1,1,591,1,1,1,1200,707,1,1,1192,1,1,
  436,436,707,1,1,1192,988,1260,1,1,1,1,1,1017,988,816,815,
  988,1017,1185,988,816,1,1,815,1,1,1,435,508,1,1,435,1,1,
  508,508,508,1,1,435,988,815,590,815,590,1,1,1185,988,4,
  1185,816,1185,1185,988,816,1,816,1,1,1,435,1,1,1,435,1,
  435,1,816,989,1,1,435,1,1,1,1,1,1017,988,816,815,988,1017,
  1185,988,816,1,1,815,1,1,1,435,508,1,1,435,1,1,508,508,
  508,1,1,435,1200,1281,1,1,817,815,1186,590,816,817,988,816,
  815,1,1,591,1,886,1,886,1192,1,1,886,886,820,436,436,1192,
  886,1,886,1,1269,1,1,591,815,815,816,567,591,816,1186,1,1,
  1,1,1,1,1204,1,1,1,1193,1,1,126,436,707,801,1,1195,1,1,
  1,816,816,988,988,1270,816,988,816,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,462,462,1,1,1,1,1,591,1186,815,816,829,591,816,
  815,1,1,1,1,403,1,1,1,1,1,1,403,824,1,462,303,403,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,816,434,204,886,435,435,886,1082,829,1,1,1,1,1,1,1,
  1,1,1,1,427,1,707,508,1,1,1,815,1,988,1,1185,988,815,1,
  1,1186,1,1,1,435,989,1,1,435,1,435,816,1,1,1,1,435,815,
  1,1,815,1,1269,1200,1,1200,1,1157,1,1212,591,1,1,1201,301,
  423,816,423,1,301,1,1201,988,1,1,988,815,1,1,1,1,1,1,204,
  434,1,1,204,435,435,204,1,1,1,1,434,1,988,1260,1,1269,1,
  1269,1,886,1,1,436,1,1,1,436,933,841,1,1,841,1,933,435,1,
  1,1,1,1204,1,1,1,1,508,1,1,1,1,427,707,1,1,1,1,1,988,
  815,1186,1,1,1,815,1,434,816,1,1,434,815,815,435,435,816,
  815,1,434,1,1269,1,1269,1,886,1,1,436,1,1,1,436,933,841,
  1,1,841,1,933,1200,1,1200,1,591,1,1,592,1,1,1,592,1204,
  772,1,1,592,1,1,1,816,1,1,1,403,773,1,1,403,1,1168,635,
  1,1235,1,1,403,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  567,1,1,1,1,1,1,707,801,1,1195,1193,436,1,126,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,886,1,1,1,707,1,1,1,1,1,1,1,
  707,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,508,1,1,1,1,
  508,1,1,1,1,1,1,89,1,435,816,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,886,1,1,1,1,816,1,887,1,1,1,1,
  436,1,816,423,423,89,1,1,1,435,435,1,1,1,1,1,1,1,1,1,1,
  1,886,1,815,1,1,1269,1,1200,1,1,1,815,815,1200,988,591,
  816,816,1186,815,815,816,1186,1,1082,1,1,1,592,1,1,1,1,
  592,592,1,772,1204,988,988,815,1,1,1,434,1,1185,988,1186,
  1185,815,1185,1185,988,1,591,816,591,435,435,1,1,434,816,1,
  816,434,1,989,989,435,435,815,1260,1,1,1269,1,1,1,988,816,
  1269,1185,886,988,988,816,988,816,988,816,1,886,1,1,933,436,
  1,1,1,1,436,841,1,841,933,1,1,1269,1,1,1,988,816,1269,
  1185,886,988,988,816,988,816,988,816,1,886,1,1,933,436,1,1,
  1,1,436,841,1,841,933,1,1200,1,1212,1,815,1186,1200,988,
  1157,816,816,815,815,1186,816,815,1,434,1,1,1197,591,1,1,
  1197,1,1082,1082,423,816,423,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1186,591,
  816,816,567,815,815,591,1,1,1,1,1204,1,1,1,126,1,1,1193,
  1,1,707,436,1195,1,801,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,435,886,403,435,886,435,
  435,1200,204,1,946,1204,1,1,1,1,1,1,1,1,1,1,508,508,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,815,1,1185,1,988,988,815,1,591,816,591,1,816,1,1,
  435,989,1,1,435,1,1,1,1,816,435,1,815,886,1,1,1269,590,1,
  1186,1200,817,817,1,1,886,436,1,436,886,1,886,886,1224,1224,
  1287,816,1,1,1,1,1,1,1,1,1,829,1,1,403,773,1,1235,403,1,
  1,1,1,635,1168,1,988,988,815,4,590,815,590,816,1,1,1,435,
  1,1,989,435,1,1,1,816,1,435,1,1,1,1,403,946,1,1,1,1,1,
  707,1,1,1,707,1,1,1,1,1,1,1260,1,815,1,1,1,1017,1017,1,
  1,435,841,1,841,435,1,1,1,999,999,311,1,815,1,1,1,1017,
  1017,1,1,435,841,1,841,435,1,1,1,999,999,311,590,1200,1281,
  1,951,951,1,1,1192,707,1,707,1192,1,1,1,436,436,1,815,988,
  815,1,204,1,1,204,434,1,1,434,1,1,435,1,204,435,1,1269,
  829,1,1,1,1,1168,1,635,1,1,403,403,773,1,1235,1,592,1,1,
  1,550,1,1,301,550,1,550,550,1261,1292,1292,567,1,1,1,1195,
  1,1,707,1193,1,1,801,436,126,1,435,1,1,1,508,1,1,1,1,1,
  1,1,707,427,1,1,1,1,1,508,1,1,1,1,707,1,427,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,887,1,816,
  886,1,1,1,1,816,1,1,1,1,435,1283,89,1,1,1,1,1,1,1,1,1,
  1,1,1,1283,435,89,1,886,816,1,1,1,1,1,1,1,1,436,1,1,1,
  1,1,1,435,423,423,988,1,988,1,1,815,1,1223,988,988,815,
  988,1223,1185,815,1185,1,1,815,815,1,1,815,435,1,1,816,1,
  1,435,435,435,1,1,816,1,988,1,1269,1269,1,1,988,988,1269,
  1185,815,988,815,1185,988,988,988,1185,1,1223,1223,1,1,435,
  435,1,1,1,816,816,1,435,435,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,815,1,1,
  1223,988,988,815,1185,1223,1185,1269,988,988,988,1185,988,1,
  815,1,1200,1,816,1,1,1,1200,1200,1200,1,816,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,816,1,1,815,815,816,816,1082,1186,590,988,1,1,1,591,1,1,
  591,1204,1,1,592,1,1,1,592,772,1,1,592,1,1,815,815,816,
  988,1082,1186,1200,816,815,815,1186,816,1,591,1,1,1,592,1,
  1,1,1204,772,592,1,592,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,815,815,1200,989,816,816,
  591,989,886,886,1,816,1,1,1,1,1,1,1,1,1,1,592,592,1,1,
  1,1260,1,988,1,988,1,988,1,1,815,815,1,1223,1223,816,1,
  435,435,1,1,816,1,1,1,435,435,1,988,1,988,1,988,1,1,815,
  815,1,1223,1223,816,1,435,435,1,1,816,1,1,1,435,435,816,1,
  1,1186,816,1,1,1,591,1,951,951,1192,1,436,436,1,1,1192,1,
  1,1,707,707,1,1185,816,1185,815,815,4,4,1,1,989,989,1,1,
  989,1,1,989,1,1,1,1,989,816,1,1,1,1,435,1,1,1,1,592,1,
  1,1,1,1,592,1,1,1,1,1,816,1185,816,816,1,988,1,815,815,
  816,1,815,815,1,1,816,816,816,1,815,815,1,1,1,591,1,1,
  1082,1,592,1,592,1,1,1,592,1,1,1,772,1204,816,816,988,1,
  1,989,1,989,1,989,1,1,1,989,1,1,1,989,1,1260,988,988,1,
  1,886,841,1,933,841,1,1,436,1,933,1,1,436,988,988,1,1,
  886,841,1,933,841,1,1,436,1,933,1,1,436,1185,1,1,816,1,1,
  1,989,1,1,1,435,435,1,435,816,1,435,1,816,1,435,1,1,1,
  989,1,435,1,435,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,816,1,
  1,1,592,1,1,1,1,1,1,1,592,1,1,592,1,1,1,1,1,1,1,592,
  1,1,1,1,1,1,436,989,816,1,1,1,1,1,1,1,1,1,1,1,1,1,
  816,1,1,1,1,1,1,436,989,1,1,1,1,1,1,989,436,1,1,1,1,1,
  1,1,1,1,1,1,1,1,816,989,1,1,1,436,1,1,1,1,1,1,1,1,
  816,988,988,1269,1,1269,1223,1,988,1185,1269,988,1223,988,
  1185,1185,1,815,1,815,1,1,815,1,435,1,816,1,435,1,435,435,
  1,1,816,1,1,1,1,1,1017,988,816,815,988,1017,1185,988,816,
  1,1,815,1,1,1,435,508,1,1,435,1,1,508,508,508,1,1,435,
  815,1,1,989,989,988,1185,815,988,989,1185,815,988,1,815,815,
  1,988,988,988,886,886,988,988,988,886,886,886,886,988,988,
  988,1,816,1,1212,815,816,816,815,1157,1186,591,988,1,1281,
  1200,590,1,1,434,1201,1,1,591,1,1,1201,301,301,423,423,816,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,817,1,815,988,816,815,817,1186,591,816,1,590,
  1200,1281,886,886,1,1,436,886,1,886,1224,1287,1224,436,886,
  886,1,815,1223,815,1157,1223,815,4,434,815,1,1,1157,817,1,
  1,1,1082,1,1,1,1,1,1082,1082,1082,1,1,1,1223,4,1212,1223,
  815,815,815,815,1,1157,1,817,1,1,1,1,1082,1,1,1,1082,1,
  1082,1082,1,1,1,988,1,1260,1,988,988,988,1,1269,1269,1269,
  1,1,815,435,435,1,816,1,435,435,1,1,1,1,816,816,988,815,
  1185,1,1185,1,1,1186,1186,815,815,4,988,816,816,988,816,816,
  988,816,816,816,816,988,1,1,1,816,816,1,1200,1,1200,1,1,
  434,1201,301,423,816,423,301,1201,1,1,1,1,591,1,988,988,
  988,1,1269,1269,1269,1,1,815,435,435,1,816,1,435,435,1,1,
  1,1,816,815,1,1,1,1212,1212,1,1,1,1,1082,1082,1,1,1,1082,
  1082,1,1,1,1,1,1185,1185,1,1186,1,1186,815,815,4,816,988,
  815,4,815,988,816,816,816,815,815,4,1,1,1,1186,1,435,435,
  1,989,434,816,1,816,434,989,1,1,435,435,815,1,1186,1186,1,
  816,816,1,989,989,816,1,816,989,989,1,1,816,816,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,816,816,1,1,434,301,1,
  423,816,423,1,301,1201,1201,1,1,591,816,1,1,434,1,301,1,
  591,1,301,1,1201,1201,423,423,816,886,886,1,1224,1224,886,1,
  886,436,436,1,1287,886,886,1,1260,988,1,1,1,816,1,1,1,1,
  1,1,1,816,988,1,1,1,816,1,1,1,1,1,1,1,816,1,1,815,1,
  815,1,1,1,1,815,815,1,816,1,1,1,590,1209,590,816,1,1,1,
  1,1,1,1209,590,590,816,1,1,1,988,1260,1,1,1,1,988,988,
  1185,988,1,1,1,1,1185,1185,1185,1,1,1,1,988,988,1185,816,
  816,590,1,1,1,816,590,1,1,1,1209,1,1,1,1,1,1,1260,988,
  988,1,1,1269,1,1,1,988,816,1269,1185,886,988,988,816,988,
  816,988,816,1,886,1,1,933,436,1,1,1,1,436,841,1,841,933,
  1269,1269,1,1223,1,988,1185,1269,1185,1223,988,815,988,988,
  1185,988,988,1,815,1,1,1200,816,1,1,1200,1,1200,1200,1,816,
  1,815,815,1,1,1269,815,815,4,1223,1269,590,4,1269,815,1269,
  4,1,1250,1250,1,1,1229,1229,1,1,1,951,951,1,1229,1229,815,
  1250,1,1269,4,815,815,1250,1269,4,4,1,590,1,590,1,1,1223,
  1,1229,1,951,1,1229,1,1229,1229,1,1,951,1250,1,1269,4,815,
  4,1250,1269,590,815,1269,4,1269,815,1,1223,1,1,1229,951,1,
  1,1229,1,1229,1229,1,951,1,1,815,816,1223,989,816,815,435,
  989,886,1,886,816,1,1,1,1,1,1,1,1,1,1,592,592,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,988,1,988,1,1260,988,988,1,815,1,815,1,1223,1223,1,816,
  1200,1200,1,816,1,1,1,1,1200,1200,815,1185,816,988,1,1185,
  816,1,816,988,1,815,815,1,816,989,989,1,816,1,816,816,1,
  989,989,815,1,1,815,815,1,590,1,590,1,1250,1250,1,951,1229,
  1229,1,951,1,1,1,1,1229,1229,1,988,1185,1185,815,4,815,4,
  1,1,989,1,989,1,989,1,989,1,1,1,1,1,989,1,1,1,1,435,1,
  1,1,1,1,1,592,1,1,1,592,1,1,1,1,1,1,988,988,1,815,1,
  815,1,1223,1223,1,816,1200,1200,1,816,1,1,1,1,1200,1200,1,
  816,1,816,1,1,816,1,1,435,989,1,1,435,1,1,1,1,816,435,
  816,988,816,1,1,989,1,1,989,989,1,1,989,1,1,1,1,989,1,
  988,1260,988,1,1,886,1,841,1,436,1,436,1,1,933,1,933,841,
  988,1185,1,1,816,1,1,435,816,1,1,1,435,435,1,1,989,988,1,
  1,886,1,841,1,436,1,436,1,1,933,1,933,841,1,435,1,1,816,
  435,1,1,989,1,1,435,1,435,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,816,1,1,1,592,1,1,1,1,1,1,1,592,1,1,592,1,1,1,1,
  1,1,1,592,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,436,1,989,
  816,1,1,1,816,1,1,1,1,1,1,436,989,1,1,1,1,1,1,989,436,
  1,1,1,1,1,1,1,1,816,989,1,1,1,1,1,1,1,1,436,1,1,1,1,
  1,1,1,1,816,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,815,591,
  816,816,829,1186,815,591,1,1,1,1,1,1,403,824,1,1,403,1,1,
  1,303,462,1,1,403,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,886,434,1204,816,435,435,
  886,1082,592,567,1,829,1,1,1,1,427,1,1,1,1,1,508,707,1,
  1,1,1,1,988,1,988,1260,1,1,1,815,1,1,886,1,841,933,436,
  1,1,1,436,1,1,1,841,933,1,815,1,815,1,1269,1186,1,590,
  1200,1,1157,1212,816,423,301,1201,1,1,591,1,423,1,301,1201,
  816,1,1,1,1,1,1,1,1,1,567,1,1195,801,436,126,1,1,1193,1,
  1,1,707,1,1,1185,988,815,815,590,4,590,1,1,435,816,435,1,
  435,1,1,989,1,1,1,1,435,435,1,1,1,1,204,1,1,1,1,707,
  427,1,1,1,1,508,1,1,1,1,1,988,815,816,591,1,591,1,815,
  434,435,815,815,434,1,1,816,816,435,1,815,434,1,1,1,815,1,
  1,886,1,841,933,436,1,1,1,436,1,1,1,841,933,1281,1200,590,
  1,1,591,1,772,1204,592,1,1,1,592,1,1,1,592,1,1,988,1,1,
  946,946,1261,1292,550,550,1,1,301,1,1292,1,550,550,815,1269,
  1,1,1204,436,1,801,1195,1,1,707,1,126,1,1,1193,815,1,1,
  204,1,435,1,434,1,1,1,434,204,1,435,204,1,403,1,462,824,
  403,1,1,1,303,1,1,1,403,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,886,1,1,1,707,1,1,1,1,1,1,1,707,1,1,508,1,1,1,1,1,
  1,1,508,1,423,1,1,1,1,1,435,435,1,1,1,1,1,1,1,89,89,
  423,1,1,1,886,1,1,1,1,1,1,436,816,1,1,1,1,1,1,816,887,
  1,1,1,1,1,1,1,1,1,1,1,1,1,816,435,1,1,1,1,1,1,1,1,1,
  1,1,1,886,816,1,1,1212,815,816,816,988,1157,1186,1200,815,
  815,816,1186,815,1,434,1,1197,1,591,1,1,1,1197,1082,1082,
  423,816,423,1,817,1,815,988,816,816,817,1186,590,815,1,591,
  1,1,886,1,886,820,436,1,886,886,1192,1,1192,436,886,1,886,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,815,1223,815,1157,815,815,4,1212,1223,1017,1,815,
  1017,1,1,1,434,1,1,1,1,1,434,434,434,1,1,1,1223,4,1212,
  815,815,815,1157,1223,1017,815,1,1017,1,1,1,1,434,1,1,1,
  434,1,434,434,1,1,1,988,1,988,1,988,1,1260,1,815,815,1,1,
  815,1,1200,1200,816,1,1,1200,1200,1,1,1,816,1,816,1185,815,
  1185,1,988,816,1,988,816,815,4,815,4,815,988,816,816,815,4,
  815,815,816,988,816,816,1,1,1281,1,1,591,1,1,1,434,1,1197,
  1082,816,423,423,1082,1197,1,1,1,591,1,1,1185,816,988,815,
  4,4,815,816,1,816,815,815,1,816,816,815,815,1,1,816,1,816,
  815,1,1,1,434,434,1,1,1,1,434,434,1,1,1,434,434,1,1,1,
  1,1,816,988,816,988,1,816,815,4,815,815,4,4,815,815,4,815,
  815,815,815,4,815,1,1,1,591,1,1,434,1,1082,1197,591,1,1,
  1197,1082,1,1,423,816,423,1,815,815,1,1,815,1,1200,1200,
  816,1,1,1200,1200,1,1,1,816,1,988,988,1260,1,435,1,999,
  999,435,1,1,841,841,1,311,1,435,1,1185,988,435,1,435,815,
  1,815,435,435,1,815,434,434,816,1,816,988,435,1,435,1,815,
  1,816,816,815,1,434,434,435,815,435,1,435,1,999,999,435,1,
  1,841,841,1,311,1,435,1,988,1260,1,1,816,1,1,1,1,1,1,1,
  816,1,988,1,1,1,815,815,1,1,1,1,815,1,815,1,1,816,1,1,
  1,1,1,1,1,816,1,815,1,1,1,5,990,5,815,1,1,1,1,1,1,990,
  5,5,815,1,1,1,988,988,1,1,1,1,1185,1185,1185,1260,1,1,1,
  1,988,1185,988,1,1,1,1,988,1185,988,815,815,5,1,1,1,815,
  5,1,1,1,990,1,1,1,1,1,1,988,1260,988,988,1,1,816,988,
  988,988,886,816,815,1185,1,1,1,815,1,1,886,933,1,1,436,1,
  1,1,436,841,933,1,841,1,1,816,988,988,1185,886,816,1269,
  988,816,988,816,988,1,886,1,1,1,436,1,1,1,933,841,436,933,
  841,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1200,435,435,435,886,886,403,435,1204,1,1,204,
  1,1,1,1,1,1,1,1,1,1,508,508,1,1,1,1,1,815,1,1269,1,
  815,1,1186,1200,590,1,951,951,1192,1,707,707,1,1,1192,1,1,
  1,436,436,1260,988,1,1,1,988,1,1,1,815,1,1017,1017,435,1,
  508,508,1,1,435,1,1,1,508,508,988,1,1,1,988,1,1,1,815,1,
  1017,1017,435,1,508,508,1,1,435,1,1,1,508,508,1,815,816,
  1185,590,815,590,4,1,1,816,435,1,1,989,1,1,435,1,1,435,1,
  816,886,1,1,1,1,403,1,1,1,1,707,1,1,1,1,1,707,1,1,1,1,
  1,1,815,1200,1281,1,590,1,817,817,886,1,1192,1192,1,1,886,
  886,886,820,436,436,1,1,1,1,1,1,829,1,403,1,303,1,1,1,
  403,1,1,1,462,824,591,816,591,1,1,816,1,435,1,989,1,1,1,
  435,1,1,435,816,1,1,1269,815,1,1,567,1195,1,1,707,1,1,
  1193,1,801,1,126,436,1,988,1,1,1270,1,1,1,462,1,1,1,1,1,
  1,1,462,815,1,1,829,1,1,1,303,1,1,1,403,403,824,1,462,1,
  204,1,204,1,434,1,1,1,434,1,435,435,204,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,435,1,1,1,508,1,1,1,1,1,427,1,707,1,
  1,508,1,1,1,1,1,1,427,707,1,1,1,1,1,1,887,816,886,1,1,
  1,1,1,1,1,1,1,1,1,1,1,816,1,1,1,1,1,89,1,435,1,1,1,
  1,1,89,435,1,1,1,1,1,1,1,1,1,1,1,1,1,1,886,816,1,1,1,
  436,1,1,1,1,1,1,423,423,435,1017,1,816,1185,988,988,1017,
  816,815,988,1,815,1,1,435,1,1,1,508,1,1,435,508,1,508,
  508,435,1,1,1,1082,435,886,886,435,434,204,816,1,1,1,829,
  1,1,1,427,1,1,1,1,1,1,508,707,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,815,1,1,1,
  1269,815,815,1,1200,1,1200,1,1,591,1204,772,1,592,1,592,1,
  1,1,1,1,592,988,988,435,815,1,1185,1,1,1,1186,434,1,815,
  815,435,1,989,434,816,1,816,435,434,1,989,1260,1,1,988,988,
  1,1269,1,1269,1,1,886,933,841,1,841,933,436,1,1,1,1,1,
  436,1,1,988,988,1,1269,1,1269,1,1,886,933,841,1,841,933,
  436,1,1,1,1,1,436,1,1,1,1,1204,1,1,1,1,1,427,707,1,1,
  1,508,1,1,1,1,1,1,815,815,1,1200,1,1200,1212,1,1157,423,
  816,1,1082,1197,591,1,1,423,1197,1,1082,1,1,1,1,1,204,1,
  1,435,204,1,1,434,434,1,1,1,204,1,435,1,1186,1,1,435,1,
  1,435,816,1,1,435,989,1,1,1,435,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,816,1,1,567,801,1,1,436,126,1,1,
  1193,1195,1,1,707,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,403,
  1,1,1,462,1,1,403,303,1,1,824,403,1,1,1,886,1,1,1,508,
  1,1,1,1,1,1,1,508,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,707,1,1,1,1,707,1,1,423,1,1,1,89,1,89,423,1,1,1,1,1,
  1,1,1,435,435,1,1,1,1,1,1,1,1,1,1,1,1,886,1,1,1,1,
  816,1,436,1,1,1,1,887,1,816,1,816,435,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,886,1,1,1082,435,886,816,435,434,1204,
  886,829,1,567,1270,1,1,1,1,1,1,1,1,1,427,707,508,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,815,1,815,1,1269,1,1,1,590,1200,1186,1,591,1,1,592,
  592,1,1,772,1204,1,1,1,592,1,988,1185,435,815,1,988,591,1,
  591,816,434,815,1,1,816,989,1,434,435,815,435,816,434,989,
  1,988,1,1,1,1260,1,815,1,1,1,886,1,1,436,841,1,933,841,
  933,1,1,1,436,1,1,815,816,988,590,4,590,815,435,1,1,1,
  989,1,1,435,816,435,1,1,435,1,1,1,1,1,1,204,1,1,1,1,1,
  1,508,1,1,1,707,427,1,1,1,1,1,1,1,1200,590,1,1281,1212,
  1157,1,1,591,1082,1,1197,816,423,423,1,1197,1082,1,1,1,1,
  1,1,1,567,1,1,1193,707,1,1,1195,801,1,1,126,436,1,1,815,
  1,1,1,886,1,1,436,841,1,933,841,933,1,1,1,436,1,815,1269,
  1,1,403,1,1,635,403,1,1,773,1235,1,1168,1,403,1,815,988,
  204,1,1,1,1,435,1,204,1,435,204,434,434,1,1,1,1204,1,1,
  1,707,1,1,1193,436,1,126,1,1195,801,1,1,1,1,1,462,1,1,1,
  462,1,1,1,1,1,1,886,1,1,1,508,1,1,1,1,1,1,1,508,1,1,
  1,1,1,1,707,1,1,1,1,707,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,89,435,816,1,1,1,1,886,
  1,1,1,1,816,436,1,1,1,1,1,1,1,1,1,1,1,1,1,887,816,1,
  423,435,435,1,1,1,423,89,1,1,1,1,1,1,1,1,1,1,886,1,1,
  816,988,886,816,988,988,886,816,435,1,1,435,1,1,1,1,1,1,
  1,1,1,1,816,816,1,1,1,1,1,1223,1,815,1,1223,1,1,591,951,
  1,1,1,592,1,1,1,1,1,592,1,1,1,1,1,1,1,1260,988,1,1,1,
  1,886,1,1,1,1,816,1,1,1,1,1,816,1,1,1,1,1,886,1,1,1,
  886,1,1,1,567,1,1,1,707,1,1,1,1,1,707,1,1,1,1,1,1,815,
  1,1223,1250,1,1223,1250,1,1,1,592,1,1,1,1,1,592,1,1,1,1,
  1,988,1,1,1,1,886,1,1,1,1,816,1,1,1,1,1,816,1,1,1,1,
  1,435,815,434,1,1,434,1,1,1,815,1,1,1,1,1,815,815,815,1,
  1,1,1,1,1,403,1,1,1,1,508,1,1,1,1,1,508,1,1,1,1,1,
  951,1,591,1,1,1,1,592,1,1,1,1,1,592,1,1,1,1,1,1,886,
  1017,1,1,1,707,1,1,1,1,1,508,1,427,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,886,1,1,1,1,1,1,1,1,1,1,707,
  707,1,1,1,1,1,1,707,1,1,1,1,1,508,1,427,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1269,1186,815,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,815,1186,1,1,1,1269,1,
  1,1,1,1,1,1,1,1,815,1,1223,1,1,886,1223,1,591,1,951,1,
  1,1,1,592,1,1,1,592,1,1,1,1,1,1,435,815,988,988,1,815,
  434,1,1,434,1,1,1,1,815,1,1,1,815,1,815,815,1,1,1,1,1,
  1,1,1,1,403,1,1,1,1,1,1,508,1,1,1,508,1,1,1,1,1,1,1,
  1,886,1223,1250,1223,1,1250,1,1,1,1,592,1,1,1,592,1,1,1,
  1,1,1,1260,1,1,1,886,1,1,1,1,1,1,816,1,1,1,816,1,1,1,
  1,1,1,1,1,1,886,1,1,1,1,1,1,816,1,1,1,816,1,1,1,1,1,
  1,1,567,1,1,1,1,1,1,1,707,1,1,1,707,1,1,1,1,1,1,951,
  591,1,1,1,1,1,1,592,1,1,1,592,1,1,1,1,1,1,886,1,1017,
  1,1,1,1,707,1,1,1,508,1,1,427,1,1,1,1,886,1,1,1,1,1,
  1,1,1,1,1,707,707,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,707,1,1,1,508,1,1,427,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1269,1,
  1186,815,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,815,1186,1,1,1,1,1,1,1,1,1269,1,1,1,1,
  1,1,1,1,1,1,988,1,988,1,988,1,1,815,815,1,1223,1223,816,
  1,435,435,1,1,816,1,1,1,435,435,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,988,988,988,1,1269,1269,
  1269,1,1,815,435,435,1,816,1,435,435,1,1,1,1,816,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,988,988,1,815,
  1,815,1,1223,1223,1,816,1200,1200,1,816,1,1,1,1,1200,1200,
  1,1,1,815,1,1,886,1,841,933,436,1,1,1,436,1,1,1,841,933,
  1,815,815,1,1,815,1,1200,1200,816,1,1,1200,1200,1,1,1,816,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,816,816,1,1,
  1082,592,1,1204,772,1,1,592,1,1,1,1,592,816,1,1,1082,1,
  592,1,592,1,592,1,1,1,1,1204,772,1,1200,1,436,436,1192,1,
  1,707,707,1,1,1,1192,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  816,1,1,1,592,1,1,1,1,1,1,1,592,1,1,592,1,1,1,1,1,1,
  1,592,1,816,1,1,1,989,436,1,1,1,1,1,1,1,1,436,989,1,1,
  1,1,1,816,1,1,1,1,1,1,436,989,1,1,1,1,1,1,989,436,1,1,
  1,1,1,1,1,816,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,816,988,1,1,1,988,1,1,1,815,1,1017,1017,435,1,508,508,
  1,1,435,1,1,1,508,508,1,988,1,988,1269,1,1269,1269,1223,1,
  1223,816,1,1,435,435,1,816,1,1,435,1,435,988,1,1,1,1,886,
  1,1,1,1,816,1,1,1,1,1,816,1,1,1,1,1,1,988,815,1,1,815,
  989,989,989,988,988,886,886,886,988,988,988,988,886,886,886,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,815,1,815,1,
  1223,1223,1,816,1,435,1,435,1,816,1,1,435,435,1,1,816,816,
  1,1212,1157,816,423,1201,301,1,1,591,1,423,1,1201,301,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,816,817,1,817,1,886,1,
  436,436,886,1,886,886,1224,1287,1224,1157,1212,1,816,423,
  1201,1,301,1,591,1,423,301,1201,1,815,815,1,1,1082,1082,1,
  1,1,1,1,1,1082,1082,815,1,1,1,1082,1082,1,1,1,1,1082,1,
  1082,1,1,1082,1,1082,1,1,1,1,1082,1082,1,988,1,1,1,1185,
  1185,1185,988,1,1,1,1,1,1,988,1185,988,1260,1,1,1,816,816,
  1,1,1,1,590,1209,590,816,1,1,1,1,590,590,1209,1,1,1,1,
  1209,590,590,988,1260,988,1,1,1,988,1185,1,1,1,988,1,1,1,
  1,1,1,816,816,816,1,1,988,988,1,1269,1,1269,1,1,886,933,
  841,1,841,933,436,1,1,1,1,1,436,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1270,1,1,1,462,1,1,1,1,1,
  1,1,462,1,1,815,1,1,1,886,1,1,436,841,1,933,841,933,1,1,
  1,436,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,816,1,
  1,829,403,1,824,462,1,1,403,1,1,1,1,303,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1204,1,126,436,1195,1,801,707,1,1,
  1,1,1193,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,435,1,1,1,707,
  427,1,1,1,1,1,1,508,1,1,707,1,427,1,1,1,1,1,508,1,886,
  1,1,1,816,887,1,1,1,1,1,1,1,1,436,816,1,1,1,1,1,435,
  423,1,1,1,1,1,1,435,423,1,1,1,1,1,435,1,1,1,1,1,1,89,
  89,886,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,816,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,988,988,
  1269,1269,1,1269,1223,1,1223,1,816,1,1200,1200,816,1,1,1,
  1200,1,1200,1,1269,1,1269,1,886,1,1,436,1,1,1,436,933,841,
  1,1,841,1,933,1269,1269,1269,1,815,1,1,435,435,1,1,816,
  435,435,1,1,816,1,1,815,815,815,1,1,1223,1229,1229,1,951,
  1,1229,1229,1,1,1,1,951,815,815,1250,1,1250,951,1,1,1229,
  1229,1,951,1,1,1229,1,1229,815,1250,1,1250,1,951,1,1229,
  1229,951,1,1,1,1229,1,1229,1223,1,1,1229,1229,1,1,951,1229,
  1229,1,1,951,1,1,1,816,1,1,1,592,1,1,1,1,1,1,1,592,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,592,1,1,1,1,592,1,1,
  816,1,1,1,989,436,1,1,1,1,1,1,1,1,436,989,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,816,1,1,1,1,989,1,436,1,1,1,1,436,1,
  989,816,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,816,1,1,
  1,1,886,1,1,1,1,1,1,816,1,1,1,816,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,435,1,1,1,1,508,1,1,1,1,1,508,1,1,1,1,1,1,1,
  1,1,1,508,1,1,1,508,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,815,1,1,1,
  1186,1269,1,1,1,1,1,1,1,1,1269,1186,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,815,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,815,1,1,1,1017,
  1017,1,1,435,841,1,841,435,1,1,1,999,999,311,815,815,1,1,
  1223,1223,1,1,816,1200,1,1200,816,1,1,1,1200,1200,1,816,1,
  816,1,1212,1157,423,816,1197,1082,1,591,1,1,423,1,1197,1082,
  1,816,817,1,817,886,1,820,436,436,1,886,886,886,1192,1,
  1192,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1157,1212,1,423,
  816,1197,1,1082,591,1,1,423,1082,1197,1,815,815,1,1,434,
  434,1,1,1,1,1,1,434,434,815,1,1,1,434,434,1,1,1,1,434,
  1,434,1,1,434,1,434,1,1,1,1,434,434,1,988,1,1,1,1185,
  988,988,1260,1,1,1,1,1,1,1185,1185,1185,988,1,1,1,815,815,
  1,1,1,1,5,990,5,815,1,1,1,1,5,5,990,1,1,1,1,990,5,5,
  988,988,1185,1,1,1,1260,988,1,1,1,988,1,1,1,1,1,1,815,
  815,815,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,816,
  1,1,1204,1,436,126,1193,1,1,1,707,1,1,1,1195,801,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,829,1,1,1,403,1,1,303,
  403,1,1,1,462,824,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  435,1,1,1,508,1,1,1,1,1,1,1,707,427,1,1,1,1,1,508,1,1,
  1,1,707,1,427,1,1,1,1,1,1,1,1,1,1,1,1,886,1,1,1,816,
  436,1,1,1,1,1,1,1,1,887,816,1,1,1,1,1,1,816,1,1,1,1,
  435,1,89,1,1,1,1,1,1,1,1,1,1,1,1,1,435,89,886,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,435,423,423,816,816,1,1,
  1200,1,436,436,1192,1,1,707,707,1,1,1,1192,1,816,1,1082,1,
  1,592,1,1204,1,772,1,592,1,1,592,1,1,1,1082,1,1,1,592,1,
  1,592,592,1,1,1,772,1204,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,816,1,1,1,592,1,1,1,1,1,1,1,592,1,1,1,1,1,1,592,
  1,1,1,1,592,1,1,1,1,1,1,1,1,1,1,1,1,1,1,816,1,1,1,
  989,436,1,1,1,1,1,1,1,1,436,989,1,1,1,1,1,1,816,1,1,1,
  1,989,436,1,1,1,1,1,1,1,1,1,1,1,1,1,436,989,1,816,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,816,1,1,988,988,1,1,
  886,841,1,933,841,1,1,436,1,933,1,1,436,988,1,1,886,1,
  841,1,436,1,436,1,1,933,1,933,841,1,435,1,999,999,435,1,
  1,841,841,1,311,1,435,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  886,1,1,1,508,1,1,1,1,1,1,1,508,1,1,707,1,1,1,1,1,1,
  1,707,1,435,1,1,1,435,1283,1,423,1,1,1,1,1,1,1283,435,1,
  423,1,1,1,886,1,1,1,1,1,1,887,816,1,1,1,1,1,1,816,436,
  1,1,1,1,1,1,1,816,1,89,1,1,1,1,89,1,1,1,1,1,1,1,1,1,
  1,1,1,886,988,1017,1,1017,1,1,1,508,508,1,1,435,435,508,
  1,508,886,1,1,841,1,933,1,841,1,436,1,933,436,1,1,1,435,
  1,1,427,707,1,1,1,1,1,1,1,508,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,427,1,707,1,1,1,1,508,1,1,1,1,1,1,1,436,816,
  886,1,1,1,1,1,1,1,1,1,1,1,1,1,423,423,1,1,1,1,89,1,
  89,435,1,1,1,1,435,1,1,1,1,1,1,1,1,435,1,1,1,1,1,1,
  886,816,1,1,1,887,1,1,1,1,1,1,1,816,1,886,1,1,1,841,1,
  1,436,436,1,1,933,841,933,1,1,435,1,1,1,508,1,1,1,1,1,
  1,427,707,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,508,1,1,
  1,1,707,427,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,436,1,816,
  886,1,1,1,1,1,1,1,1,1,1,1,1,816,1,1,1,1,435,89,1,1,1,
  1,1,1,89,435,1,886,816,1,1,1,1,1,1,1,1,887,1,1,1,1,1,
  1,423,435,423,886,1,1,1,707,1,1,1,1,1,1,1,707,1,1,1,1,
  1,1,508,1,1,1,1,508,1,1,1,1,1,1,1,1,1,1,1,1,1,1,435,
  1,1,1,435,1,1,423,1,1,1,1,1,1,1,435,1,423,1,1,1,1,886,
  1,1,1,1,816,887,1,1,1,1,1,1,1,1,1,1,1,1,1,436,816,1,
  816,1,89,1,1,1,1,89,1,1,1,1,1,1,1,1,1,1,886,1,1,988,
  1,1,1,816,1,1,1,1,1,1,1,816,1,1,816,1,1,1,1,1,1,1,
  816,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,815,
  1,1,1,1,1,1,1269,1186,1,1,1,1,1,1,1186,1269,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,815,1,
  1,1,1,816,1,1,1,1,816,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,815,1,1,1,1,1186,
  1,1269,1,1,1,1,1269,1,1186,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,815,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,815,1,1,1,1,1186,1269,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1269,1186,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,815,1,1,1,1,1,988,988,1185,988,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,988,1185,1185,1,
  1,1,988,988,1,1,1,988,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,988,988,988,1,1,
  1,1185,1185,1,1,1,988,1,1,1,1,1,1,1,1,1,988,1,1,1,1,
  1185,988,988,1,1,1,1,988,988,1185,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,988,1185,988,1,1,1,1,988,1185,988,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1185,988,988,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,988,988,1185,988,1185,1,1,
  1,988,1,1,1,1,1,1,1,1,1,988,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,988 ];

compositionfactors := compfactset{compfactpos};

return compositionfactors;

#############################################################################
##
#E  compositionfactors.g . . . . . . . . . . . . . . . . . . . . .  ends here
