/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.svg;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.ListValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import io.sf.carte.echosvg.css.engine.value.svg.ColorManager;
import io.sf.carte.echosvg.css.engine.value.svg.SVGValueConstants;
import org.w3c.dom.DOMException;

public class SVGColorManager
extends ColorManager {
    protected String property;
    protected Value defaultValue;

    public SVGColorManager(String prop) {
        this(prop, ValueConstants.BLACK_RGB_VALUE);
    }

    public SVGColorManager(String prop, Value v) {
        this.property = prop;
        this.defaultValue = v;
    }

    @Override
    public boolean isInheritedProperty() {
        return false;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return true;
    }

    @Override
    public int getPropertyType() {
        return 6;
    }

    @Override
    public String getPropertyName() {
        return this.property;
    }

    @Override
    public Value getDefaultValue() {
        return this.defaultValue.clone();
    }

    @Override
    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && lu.getStringValue().equalsIgnoreCase("currentcolor")) {
            return SVGValueConstants.CURRENTCOLOR_VALUE;
        }
        Value v = super.createValue(lu, engine);
        if ((lu = lu.getNextLexicalUnit()) == null) {
            return v;
        }
        throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
    }

    @Override
    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value) {
        if (value.isIdentifier("currentcolor")) {
            sm.putColorRelative(idx, true);
            int ci = engine.getColorIndex();
            return engine.getComputedStyle(elt, pseudo, ci);
        }
        if (value.getCssValueType() == CSSValue.CssType.LIST) {
            Value v = value.item(0);
            Value t = super.computeValue(elt, pseudo, engine, idx, sm, v);
            if (t != v) {
                ListValue result = new ListValue(' ');
                result.append(t);
                result.append(value.item(1));
                return result;
            }
            return value;
        }
        return super.computeValue(elt, pseudo, engine, idx, sm, value);
    }
}

