/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.GlyfTable;
import jogamp.graph.font.typecast.ot.table.GlyphDescription;
import jogamp.graph.font.typecast.ot.table.Program;

public abstract class GlyfDescript
extends Program
implements GlyphDescription {
    public static final byte ON_CURVE_POINT = 1;
    public static final byte X_SHORT_VECTOR = 2;
    public static final byte Y_SHORT_VECTOR = 4;
    public static final byte REPEAT_FLAG = 8;
    public static final byte X_IS_SAME_OR_POSITIVE_X_SHORT_VECTOR = 16;
    public static final byte Y_IS_SAME_OR_POSITIVE_Y_SHORT_VECTOR = 32;
    public static final byte OVERLAP_SIMPLE = 64;
    final GlyfTable _parentTable;
    private final int _glyphIndex;
    private final int _numberOfContours;
    private final short _xMin;
    private final short _yMin;
    private final short _xMax;
    private final short _yMax;

    GlyfDescript(GlyfTable glyfTable, int n, short s, DataInput dataInput) throws IOException {
        this._glyphIndex = n;
        this._parentTable = glyfTable;
        this._numberOfContours = s;
        this._xMin = dataInput.readShort();
        this._yMin = dataInput.readShort();
        this._xMax = dataInput.readShort();
        this._yMax = dataInput.readShort();
    }

    public GlyfTable getParentTable() {
        return this._parentTable;
    }

    @Override
    public int getGlyphIndex() {
        return this._glyphIndex;
    }

    @Override
    public int getNumberOfContours() {
        return this._numberOfContours;
    }

    @Override
    public short getXMinimum() {
        return this._xMin;
    }

    @Override
    public short getYMinimum() {
        return this._yMin;
    }

    @Override
    public short getXMaximum() {
        return this._xMax;
    }

    @Override
    public short getYMaximum() {
        return this._yMax;
    }

    public String toString() {
        return "          numberOfContours: " + this._numberOfContours + "\n          xMin:             " + this._xMin + "\n          yMin:             " + this._yMin + "\n          xMax:             " + this._xMax + "\n          yMax:             " + this._yMax;
    }
}

