/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSMediaException;
import io.sf.carte.doc.style.css.CSSRule;
import io.sf.carte.doc.style.css.CSSStyleSheet;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.AbstractErrorHandler;
import java.util.WeakHashMap;
import org.w3c.dom.Node;

class StandAloneErrorHandler
extends AbstractErrorHandler {
    private static final long serialVersionUID = 1L;
    private static final WeakHashMap<AbstractCSSStyleSheet, StandAloneErrorHandler> handlerMap = new WeakHashMap(4);
    private boolean errors = false;
    private boolean warnings = false;

    static StandAloneErrorHandler getInstance(AbstractCSSStyleSheet sheet) {
        StandAloneErrorHandler handler = handlerMap.get(sheet);
        if (handler == null) {
            handler = new StandAloneErrorHandler();
            handlerMap.put(sheet, handler);
        }
        return handler;
    }

    private StandAloneErrorHandler() {
    }

    @Override
    public boolean hasComputedStyleErrors(CSSElement element) {
        return false;
    }

    @Override
    public boolean hasErrors() {
        return this.errors || super.hasErrors();
    }

    @Override
    public boolean hasWarnings() {
        return this.warnings || super.hasWarnings();
    }

    @Override
    public void linkedStyleError(Node node, String message) {
        this.errors = true;
    }

    @Override
    public void mediaQueryError(Node node, CSSMediaException exception) {
        this.errors = true;
        throw new IllegalStateException("Media query error.", exception);
    }

    @Override
    public void linkedSheetError(Exception e, CSSStyleSheet<? extends CSSRule> sheet) {
        this.errors = true;
        throw new IllegalStateException(e);
    }

    @Override
    public StyleDeclarationErrorHandler getInlineStyleErrorHandler(CSSElement owner) {
        return null;
    }

    @Override
    public void inlineStyleError(CSSElement owner, Exception e, String context) {
        this.errors = true;
        IllegalStateException ex = new IllegalStateException("Error in context: " + context, e);
        throw ex;
    }

    @Override
    public void reset() {
        this.errors = true;
        this.warnings = false;
        super.reset();
    }

    @Override
    protected AbstractCSSStyleSheetFactory getStyleSheetFactory() {
        return null;
    }
}

