/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.db;

import db.DBRecord;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.LanguageID;

public class LibraryRecord {
    final DBRecord record;

    public LibraryRecord(DBRecord record) {
        if (record == null) {
            throw new IllegalArgumentException("null record");
        }
        this.record = record;
    }

    public long getLibraryID() {
        return this.record.getKey();
    }

    public String getLibraryFamilyName() {
        return this.record.getString(0);
    }

    public String getLibraryVersion() {
        return this.record.getString(1);
    }

    public String getLibraryVariant() {
        return this.record.getString(2);
    }

    public String getGhidraVersion() {
        return this.record.getString(3);
    }

    public LanguageID getGhidraLanguageID() {
        return new LanguageID(this.record.getString(4));
    }

    public int getGhidraLanguageVersion() {
        return this.record.getIntValue(5);
    }

    public int getGhidraLanguageMinorVersion() {
        return this.record.getIntValue(6);
    }

    public CompilerSpecID getGhidraCompilerSpecID() {
        return new CompilerSpecID(this.record.getString(7));
    }

    public String toString() {
        return this.getLibraryFamilyName() + " " + this.getLibraryVersion() + " " + this.getLibraryVariant();
    }
}

