/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.info;

import docking.widgets.tree.GTreeNode;
import generic.theme.GIcon;
import ghidra.bitpatterns.info.FunctionBitPatternsGTree;
import ghidra.bitpatterns.info.PercentageFilter;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Icon;

public class FunctionBitPatternsGTreeNode
extends GTreeNode {
    private static final Icon DISABLED_ICON = new GIcon("icon.bytepatterns.function.bit.patterns.disabled");
    private static final Icon ENABLED_ICON = new GIcon("icon.bytepatterns.function.bit.patterns.enabled");
    private String name;
    private String instruction;
    private int numBytes;
    private int count;
    private boolean isLeaf;
    private double percentage;

    public FunctionBitPatternsGTreeNode(String name, String instruction, Integer numBytes) {
        this.name = name;
        this.instruction = instruction;
        this.numBytes = numBytes;
        this.count = 0;
        this.getIcon(true);
        this.isLeaf = false;
    }

    public void sortAndSetFields() {
        for (GTreeNode node : this.getChildren()) {
            ((FunctionBitPatternsGTreeNode)node).sortAndSetFields();
        }
        ArrayList children = new ArrayList(this.getChildren());
        Collections.sort(children);
        this.setChildren(children);
        if (this.getChildren().isEmpty()) {
            this.isLeaf = true;
        }
        this.percentage = this.getTree() == null ? 0.0 : 100.0 * (double)this.count / (double)((FunctionBitPatternsGTree)this.getTree()).getTotalNum();
    }

    public int compareTo(GTreeNode other) {
        if (other instanceof FunctionBitPatternsGTreeNode) {
            return -Integer.compare(this.count, ((FunctionBitPatternsGTreeNode)other).getCount());
        }
        return this.getName().compareToIgnoreCase(other.getName());
    }

    public int getCount() {
        return this.count;
    }

    public void incrementCount(int amount) {
        this.count += amount;
    }

    public String getName() {
        return this.name;
    }

    public Icon getIcon(boolean expanded) {
        if (this.getChildren() == null || this.getChildren().isEmpty()) {
            return DISABLED_ICON;
        }
        return ENABLED_ICON;
    }

    public String getToolTip() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.count);
        sb.append(" (");
        sb.append(Double.toString((double)Math.round(this.percentage * 10.0) * 1.0 / 10.0));
        sb.append("%)");
        String tip = sb.toString();
        return tip;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public Integer getNumBytes() {
        return this.numBytes;
    }

    public double getPercentage() {
        return this.percentage;
    }

    public void filterByPercentage(PercentageFilter filter) {
        for (GTreeNode node : this.getChildren()) {
            FunctionBitPatternsGTreeNode fspNode = (FunctionBitPatternsGTreeNode)node;
            if (filter.allows(fspNode.getPercentage())) {
                fspNode.filterByPercentage(filter);
                continue;
            }
            this.removeNode(fspNode);
        }
    }
}

