/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.signature;

import ghidra.app.decompiler.signature.DebugSignature;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import ghidra.program.model.pcode.AddressXML;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.SequenceNumber;
import ghidra.program.model.pcode.Varnode;

public class VarnodeSignature
extends DebugSignature {
    public Varnode vn;
    public SequenceNumber seqNum;
    public String opcode;

    @Override
    public void decode(Decoder decoder) throws DecoderException {
        int el = decoder.openElement(ElementId.ELEM_VARSIG);
        this.hash = (int)decoder.readUnsignedInteger(AttributeId.ATTRIB_HASH);
        int subel = decoder.openElement();
        Address vnAddr = AddressXML.decodeFromAttributes((Decoder)decoder);
        int vnSize = 0;
        if (vnAddr.getAddressSpace().isVariableSpace()) {
            decoder.rewindAttributes();
            Varnode.Join join = Varnode.decodePieces((Decoder)decoder);
            vnSize = join.logicalSize;
        } else {
            vnSize = (int)decoder.readSignedInteger(AttributeId.ATTRIB_SIZE);
        }
        this.vn = new Varnode(vnAddr, vnSize);
        decoder.closeElement(subel);
        if (decoder.peekElement() != 0) {
            subel = decoder.openElement();
            int opc = (int)decoder.readSignedInteger(AttributeId.ATTRIB_CODE);
            this.opcode = PcodeOp.getMnemonic((int)opc);
            this.seqNum = SequenceNumber.decode((Decoder)decoder);
            decoder.closeElementSkipping(subel);
        } else {
            this.seqNum = null;
            this.opcode = null;
        }
        decoder.closeElement(el);
    }

    @Override
    public void printRaw(Language language, StringBuffer buf) {
        buf.append(Integer.toHexString(this.hash));
        buf.append(" - var ");
        buf.append(this.vn.toString(language));
        if (this.seqNum != null) {
            buf.append(" - op=");
            buf.append(this.opcode).append(" ").append(this.seqNum.toString());
        }
    }
}

