/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.breakpoint;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import db.Transaction;
import ghidra.app.plugin.core.debug.service.breakpoint.DebuggerLogicalBreakpointServicePlugin;
import ghidra.debug.api.breakpoint.LogicalBreakpoint;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ConcurrentModificationException;
import java.util.Objects;
import java.util.Set;

public class ProgramBreakpoint {
    private static final Gson GSON = new GsonBuilder().create();
    private final Program program;
    private final Address address;
    private final ProgramLocation location;
    private final long length;
    private final Set<TraceBreakpointKind> kinds;
    private Bookmark eBookmark;
    private Bookmark dBookmark;
    private String name;
    private String sleigh;

    public static Set<TraceBreakpointKind> kindsFromBookmark(Bookmark mark) {
        String[] parts = mark.getCategory().split(";");
        TraceBreakpointKind.TraceBreakpointKindSet result = TraceBreakpointKind.TraceBreakpointKindSet.decode((String)parts[0], (boolean)false);
        if (result.isEmpty()) {
            Msg.warn(TraceBreakpointKind.class, (Object)"Decoded empty set of kinds from bookmark. Assuming SW_EXECUTE");
            return Set.of(TraceBreakpointKind.SW_EXECUTE);
        }
        return result;
    }

    public static long lengthFromBookmark(Bookmark mark) {
        String[] parts = mark.getCategory().split(";");
        if (parts.length < 2) {
            Msg.warn(DebuggerLogicalBreakpointServicePlugin.class, (Object)"No length for bookmark breakpoint. Assuming 1.");
            return 1L;
        }
        try {
            long length = Long.parseLong(parts[1]);
            if (length <= 0L) {
                Msg.warn(DebuggerLogicalBreakpointServicePlugin.class, (Object)"Non-positive length for bookmark breakpoint? Using 1.");
                return 1L;
            }
            return length;
        }
        catch (NumberFormatException e) {
            Msg.warn(DebuggerLogicalBreakpointServicePlugin.class, (Object)("Ill-formatted bookmark breakpoint length: " + String.valueOf(e) + ". Using 1."));
            return 1L;
        }
    }

    public ProgramBreakpoint(Program program, Address address, long length, Set<TraceBreakpointKind> kinds) {
        this.program = program;
        this.address = address;
        this.location = new ProgramLocation(program, address);
        this.length = length;
        this.kinds = kinds;
    }

    public String toString() {
        Bookmark eBookmark = this.eBookmark;
        Bookmark dBookmark = this.dBookmark;
        if (eBookmark != null) {
            return String.format("<enabled %s(%s) at %s in %s>", eBookmark.getTypeString(), eBookmark.getCategory(), eBookmark.getAddress(), this.program.getName());
        }
        if (dBookmark != null) {
            return String.format("<disabled %s(%s) at %s in %s>", dBookmark.getTypeString(), dBookmark.getCategory(), dBookmark.getAddress(), this.program.getName());
        }
        return String.format("<absent at %s in %s>", this.address, this.program.getName());
    }

    public ProgramLocation getLocation() {
        return this.location;
    }

    private void syncProperties(Bookmark bookmark) {
        if (bookmark == null) {
            this.name = "";
            this.sleigh = null;
            return;
        }
        String comment = bookmark.getComment();
        if (comment == null || !comment.startsWith("{")) {
            this.name = comment;
            this.sleigh = null;
            return;
        }
        try {
            BreakpointProperties props = (BreakpointProperties)GSON.fromJson(comment, BreakpointProperties.class);
            this.name = props.name;
            this.sleigh = props.sleigh;
            return;
        }
        catch (JsonSyntaxException e) {
            Msg.error((Object)this, (Object)"Could not parse breakpoint bookmark properties", (Throwable)e);
            this.name = "";
            this.sleigh = null;
            return;
        }
    }

    private String computeComment() {
        if ((this.name == null || "".equals(this.name)) && (this.sleigh == null || "".equals(this.sleigh))) {
            return null;
        }
        return GSON.toJson((Object)new BreakpointProperties(this.name, this.sleigh));
    }

    private void writeProperties(Bookmark bookmark) {
        try (Transaction tx = this.program.openTransaction("Rename breakpoint");){
            bookmark.set(bookmark.getCategory(), this.computeComment());
        }
        catch (ConcurrentModificationException e) {
            Msg.error((Object)this, (Object)("Could not update breakpoint properties: " + String.valueOf(e)));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        Bookmark bookmark = this.getBookmark();
        if (bookmark == null) {
            throw new IllegalStateException("Must save breakpoint to program before naming it");
        }
        this.name = name;
        this.writeProperties(bookmark);
    }

    public String getEmuSleigh() {
        return this.sleigh;
    }

    public void setEmuSleigh(String sleigh) {
        this.sleigh = sleigh;
        Bookmark bookmark = this.getBookmark();
        if (bookmark == null) {
            return;
        }
        this.writeProperties(bookmark);
    }

    public LogicalBreakpoint.ProgramMode computeMode() {
        if (this.eBookmark != null) {
            return LogicalBreakpoint.ProgramMode.ENABLED;
        }
        if (this.dBookmark != null) {
            return LogicalBreakpoint.ProgramMode.DISABLED;
        }
        return LogicalBreakpoint.ProgramMode.MISSING;
    }

    public boolean isEmpty() {
        return this.eBookmark == null && this.dBookmark == null;
    }

    public void deleteFromProgram() {
        Bookmark eBookmark = this.eBookmark;
        Bookmark dBookmark = this.dBookmark;
        try (Transaction tx = this.program.openTransaction("Clear breakpoint");){
            BookmarkManager bookmarkManager = this.program.getBookmarkManager();
            if (eBookmark != null) {
                bookmarkManager.removeBookmark(eBookmark);
            }
            if (dBookmark != null) {
                bookmarkManager.removeBookmark(dBookmark);
            }
        }
    }

    public boolean canMerge(Program candProgram, Bookmark candBookmark) {
        if (this.program != candProgram) {
            return false;
        }
        if (!this.address.equals((Object)candBookmark.getAddress())) {
            return false;
        }
        if (this.length != ProgramBreakpoint.lengthFromBookmark(candBookmark)) {
            return false;
        }
        return Objects.equals(this.kinds, ProgramBreakpoint.kindsFromBookmark(candBookmark));
    }

    public Program getProgram() {
        return this.program;
    }

    public boolean add(Bookmark bookmark) {
        if ("BreakpointEnabled".equals(bookmark.getTypeString())) {
            if (this.eBookmark == bookmark) {
                return false;
            }
            this.eBookmark = bookmark;
            this.syncProperties(bookmark);
            return true;
        }
        if ("BreakpointDisabled".equals(bookmark.getTypeString())) {
            if (this.dBookmark == bookmark) {
                return false;
            }
            this.dBookmark = bookmark;
            this.syncProperties(bookmark);
            return true;
        }
        return false;
    }

    public boolean remove(Bookmark bookmark) {
        if (this.eBookmark == bookmark) {
            this.eBookmark = null;
            return true;
        }
        if (this.dBookmark == bookmark) {
            this.dBookmark = null;
            return true;
        }
        return false;
    }

    public Bookmark getBookmark() {
        Bookmark eBookmark = this.eBookmark;
        if (eBookmark != null) {
            return eBookmark;
        }
        return this.dBookmark;
    }

    protected String getComment() {
        Bookmark bookmark = this.getBookmark();
        return bookmark == null ? this.computeComment() : bookmark.getComment();
    }

    public boolean isEnabled() {
        return this.computeMode() == LogicalBreakpoint.ProgramMode.ENABLED;
    }

    public boolean isDisabled() {
        return this.computeMode() == LogicalBreakpoint.ProgramMode.DISABLED;
    }

    public String computeCategory() {
        return TraceBreakpointKind.TraceBreakpointKindSet.encode(this.kinds) + ";" + Long.toUnsignedString(this.length);
    }

    public void toggleWithComment(boolean enabled, String comment) {
        String addType = enabled ? "BreakpointEnabled" : "BreakpointDisabled";
        String delType = enabled ? "BreakpointDisabled" : "BreakpointEnabled";
        try (Transaction tx = this.program.openTransaction("Toggle breakpoint");){
            BookmarkManager manager = this.program.getBookmarkManager();
            String catStr = this.computeCategory();
            manager.setBookmark(this.address, addType, catStr, comment);
            manager.removeBookmarks((AddressSetView)new AddressSet(this.address), delType, catStr, TaskMonitor.DUMMY);
        }
        catch (CancelledException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void enable() {
        if (this.isEnabled()) {
            return;
        }
        this.toggleWithComment(true, this.getComment());
    }

    public void disable() {
        if (this.isDisabled()) {
            return;
        }
        this.toggleWithComment(false, this.getComment());
    }

    static class BreakpointProperties {
        public String name;
        public String sleigh;

        public BreakpointProperties(String name, String sleigh) {
            this.name = name;
            this.sleigh = sleigh;
        }
    }
}

