/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.xml.XmlParseException;

public enum StorageClass {
    GENERAL(0, "general"),
    FLOAT(1, "float"),
    PTR(2, "ptr"),
    HIDDENRET(3, "hiddenret"),
    VECTOR(4, "vector"),
    CLASS1(100, "class1"),
    CLASS2(101, "class2"),
    CLASS3(102, "class3"),
    CLASS4(103, "class4");

    private int value;
    private String name;

    private StorageClass(int val, String nm) {
        this.value = val;
        this.name = nm;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.name;
    }

    public static StorageClass getClass(String val) throws XmlParseException {
        switch (val) {
            case "general": {
                return GENERAL;
            }
            case "float": {
                return FLOAT;
            }
            case "ptr": {
                return PTR;
            }
            case "hiddenret": {
                return HIDDENRET;
            }
            case "vector": {
                return VECTOR;
            }
            case "class1": {
                return CLASS1;
            }
            case "class2": {
                return CLASS2;
            }
            case "class3": {
                return CLASS3;
            }
            case "class4": {
                return CLASS4;
            }
        }
        throw new XmlParseException("Unknown type class: " + val);
    }
}

