/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.DelimiterState;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import java.util.ArrayList;
import java.util.List;

public class VirtualFunctionTableMsType
extends AbstractMsType {
    public static final int PDB_ID = 5405;
    private RecordNumber ownerRecordNumber;
    private RecordNumber baseVirtualFunctionTableRecordNumber;
    private int vfptrOffsetRelToObjectLayout;
    private int namesArrayLength;
    private String vftableName;
    private List<String> names = new ArrayList<String>();

    public VirtualFunctionTableMsType(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.ownerRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        this.baseVirtualFunctionTableRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        this.vfptrOffsetRelToObjectLayout = reader.parseInt();
        this.namesArrayLength = reader.parseInt();
        PdbByteReader namesReader = reader.getSubPdbByteReader(this.namesArrayLength);
        boolean first = true;
        while (namesReader.hasMore()) {
            String name = namesReader.parseNullTerminatedString(pdb.getPdbReaderOptions().getOneByteCharset());
            if (first) {
                first = false;
                this.vftableName = name;
                continue;
            }
            this.names.add(name);
        }
        reader.skipPadding();
    }

    @Override
    public int getPdbId() {
        return 5405;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        builder.append("VFTable for [");
        builder.append(this.pdb.getTypeRecord(this.ownerRecordNumber));
        builder.append("<vfptr_offset=");
        builder.append(this.vfptrOffsetRelToObjectLayout);
        builder.append(">");
        if (this.baseVirtualFunctionTableRecordNumber != RecordNumber.NO_TYPE) {
            builder.append(" : ");
            builder.append(this.pdb.getTypeRecord(this.baseVirtualFunctionTableRecordNumber));
        }
        builder.append("] ");
        builder.append(this.vftableName);
        builder.append(": {");
        DelimiterState ds = new DelimiterState("", ",");
        for (String name : this.names) {
            builder.append(ds.out(true, name));
        }
        builder.append("}");
    }
}

